/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.ObjectFactory;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.ui.dialog.edit.MeasurementContextmenu;
import gde.ui.dialog.edit.MeasurementTypeTabItem;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DesktopPropertyTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(DesktopPropertyTypeTabItem.class.getName());
    final CTabFolder parentTabFolder;
    final MeasurementTypeTabItem measurementTypeTabItem;
    Composite propertyTypeComposite;
    Label nameLabel;
    Label typeLabel;
    Label valueLabel;
    Label descriptionLabel;
    Text descriptionText;
    Label attributeLabel;
    CCombo valueCombo;
    CCombo attributeCombo;
    KeyAdapter valueKeyListener;
    VerifyListener valueVerifyListener;
    DeviceConfiguration deviceConfig;
    Menu popupMenu;
    MeasurementContextmenu contextMenu;
    String tabName;
    DesktopPropertyType propertyType;
    final DevicePropertiesEditor propsEditor;

    public DesktopPropertyTypeTabItem(CTabFolder parent, int style, String useTabName, MeasurementTypeTabItem useMeasurementTypeTabItem2CreatePopupMenu) {
        super(parent, style);
        this.parentTabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.tabName = useTabName;
        this.measurementTypeTabItem = useMeasurementTypeTabItem2CreatePopupMenu;
        this.propertyType = new ObjectFactory().createDesktopPropertyType();
        this.propertyType.setName(DesktopPropertyTypes.values()[0]);
        this.propertyType.setValue(false);
        this.propertyType.setDescription(Messages.getString("GDE_MSGT0474"));
        this.initGUI();
    }

    void enableContextMenu(boolean enable) {
        if (enable && this.measurementTypeTabItem != null) {
            this.popupMenu = new Menu((Decorations)this.measurementTypeTabItem.channelConfigMeasurementPropertiesTabFolder.getShell(), 8);
            this.contextMenu = new MeasurementContextmenu(this.popupMenu, this.measurementTypeTabItem, this.measurementTypeTabItem.channelConfigMeasurementPropertiesTabFolder);
            this.contextMenu.create();
        } else if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.propertyTypeComposite.setMenu(this.popupMenu);
        this.nameLabel.setMenu(this.popupMenu);
        this.typeLabel.setMenu(this.popupMenu);
        this.valueLabel.setMenu(this.popupMenu);
        this.descriptionLabel.setMenu(this.popupMenu);
    }

    public void setProperty(DeviceConfiguration useDeviceConfig, DesktopPropertyType useProperty) {
        this.deviceConfig = useDeviceConfig;
        this.propertyType = useProperty;
        this.tabName = this.propertyType.getLocalizedName();
        this.setText(this.tabName);
        this.valueCombo.setVisible(true);
        this.valueCombo.select(this.propertyType.isValue() ? 0 : 1);
        this.descriptionText.setText(this.propertyType.getDescription() != null ? this.propertyType.getDescription() : "");
        this.enableContextMenu(true);
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(this.tabName);
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeevent) {
                    log.log(java.util.logging.Level.FINEST, "statisticsTypeTabItem.widgetDisposed, event=" + disposeevent);
                    DesktopPropertyTypeTabItem.this.enableContextMenu(false);
                }
            });
            this.propertyTypeComposite = new Composite((Composite)this.parentTabFolder, 0);
            this.setControl((Control)this.propertyTypeComposite);
            this.propertyTypeComposite.setLayout(null);
            this.propertyTypeComposite.setSize(300, 160);
            this.propertyTypeComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "propertyTypeComposite.helpRequested " + evt);
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A.html");
                }
            });
            this.nameLabel = new Label(this.propertyTypeComposite, 131072);
            this.nameLabel.setText(Messages.getString("GDE_MSGT0549"));
            this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.nameLabel.setBounds(5, 12, 80, 20);
            this.typeLabel = new Label(this.propertyTypeComposite, 131072);
            this.typeLabel.setText(Messages.getString("GDE_MSGT0552"));
            this.typeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.typeLabel.setBounds(5, 38, 80, 20);
            this.valueLabel = new Label(this.propertyTypeComposite, 131072);
            this.valueLabel.setText(Messages.getString("GDE_MSGT0553"));
            this.valueLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.valueLabel.setBounds(5, 65, 80, 20);
            this.descriptionLabel = new Label(this.propertyTypeComposite, 131072);
            this.descriptionLabel.setText(Messages.getString("GDE_MSGT0554"));
            this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionLabel.setBounds(5, 92, 80, 20);
            if (this.tabName.equals(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB.value())) {
                this.attributeLabel = new Label(this.propertyTypeComposite, 131072);
                this.attributeLabel.setText(Messages.getString("GDE_MSGT0598"));
                this.attributeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                this.attributeLabel.setBounds(5, 135, 80, 40);
            }
            this.valueCombo = new CCombo(this.propertyTypeComposite, 2048);
            this.valueCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.valueCombo.setBounds(90, 65, 120, 20);
            this.valueCombo.setEditable(false);
            this.valueCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
            this.valueCombo.setItems(GDE.STRING_ARRAY_TRUE_FALSE);
            this.valueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "valueCombo.widgetSelected, event=" + evt);
                    if (DesktopPropertyTypeTabItem.this.deviceConfig != null) {
                        DesktopPropertyTypeTabItem.this.deviceConfig.setTableTabRequested(Boolean.parseBoolean(DesktopPropertyTypeTabItem.this.valueCombo.getText()));
                        DesktopPropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        DesktopPropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    } else {
                        DesktopPropertyTypeTabItem.this.propertyType.setValue(Boolean.parseBoolean(DesktopPropertyTypeTabItem.this.valueCombo.getText()));
                    }
                }
            });
            this.descriptionText = new Text(this.propertyTypeComposite, 18496);
            this.descriptionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionText.setBounds(90, 92, 200, 45);
            this.descriptionText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "descriptionText.keyReleased, event=" + evt);
                    }
                    DesktopPropertyTypeTabItem.this.propertyType.setDescription(DesktopPropertyTypeTabItem.this.descriptionText.getText());
                    if (DesktopPropertyTypeTabItem.this.deviceConfig != null) {
                        DesktopPropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        DesktopPropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }

                public void keyPressed(KeyEvent e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "descriptionText.keyPressed , event=" + e);
                    }
                    if (e.keyCode == 97 && (e.stateMask & SWT.MOD1) != 0) {
                        DesktopPropertyTypeTabItem.this.descriptionText.selectAll();
                    }
                }
            });
            if (this.tabName.equals(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB.value())) {
                this.attributeCombo = new CCombo(this.propertyTypeComposite, 2048);
                this.attributeCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                this.attributeCombo.setBounds(90, 145, 120, 20);
                this.attributeCombo.setEditable(false);
                this.attributeCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.attributeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "attributeCombo.widgetSelected, event=" + evt);
                        }
                        if (DesktopPropertyTypeTabItem.this.deviceConfig != null) {
                            DesktopPropertyTypeTabItem.this.propertyType.setTargetReferenceOrdinal(DesktopPropertyTypeTabItem.this.attributeCombo.getSelectionIndex());
                        }
                        if (DesktopPropertyTypeTabItem.this.deviceConfig != null) {
                            DesktopPropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                            DesktopPropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                        }
                    }
                });
            }
            this.propertyTypeComposite.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

