/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import gde.comm.DeviceJavaSerialCommPortImpl;
import gde.comm.DeviceSerialPortImpl;
import gde.comm.DeviceSerialPortSimulatorImpl;
import gde.comm.DeviceUsbPortImpl;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.ui.DataExplorer;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import org.usb4java.DeviceHandle;

public class DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = DeviceCommPort.class.getName();
    protected final Settings settings;
    protected final IDevice device;
    protected final DeviceConfiguration deviceConfig;
    protected final DataExplorer application;
    protected final IDeviceCommPort port;
    public static final int ICON_SET_OPEN_CLOSE = 0;
    public static final int ICON_SET_START_STOP = 1;
    public static final int ICON_SET_IMPORT_CLOSE = 2;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte ACK = 6;
    public static final byte NAK = 21;
    public static final String STRING_NAK = "<NAK>";
    public static final String STRING_ACK = "<ACK>";
    public static final String STRING_CR = "<CR>";
    public static final String STRING_FF = "<FF>";
    public static final String FORMAT_2_CHAR = "%c%c";
    public static final String FORMAT_4_CHAR = "%c%c%c%c";
    public static final String FORMAT_16_CHAR = "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c";
    public static final String[] STRING_ARRAY_BAUDE_RATES = new String[]{"2400", "4800", "7200", "9600", "14400", "19200", "28800", "38400", "57600", "115200", "128000", "230400"};
    public boolean isInterruptedByUser = false;
    static IDeviceCommPort staticPort = null;
    protected static final TreeMap<String, String> availablePorts = new TreeMap();
    protected static final TreeMap<Integer, String> windowsPorts = new TreeMap();

    public DeviceCommPort(IDevice currentDevice, DataExplorer currentApplication) {
        this.device = currentDevice;
        this.deviceConfig = currentDevice.getDeviceConfiguration();
        this.application = currentApplication;
        this.settings = Settings.getInstance();
        this.port = Boolean.parseBoolean(System.getProperty("GDE_IS_SIMULATION")) ? new DeviceSerialPortSimulatorImpl(this.device, this.application, this.device.getTimeStep_ms() > 0.0, this.device.getTimeStep_ms() < 0.0 ? (System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC") != null ? Integer.parseInt(System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC")) : 100) : (System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC") != null ? Integer.parseInt(System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC")) : (int)this.device.getTimeStep_ms())) : (this.deviceConfig.getSerialPortType() != null ? (this.settings.isRXTXcommToBeUsed() ? new DeviceSerialPortImpl(this.deviceConfig, this.application) : new DeviceJavaSerialCommPortImpl(this.deviceConfig, this.application)) : (this.deviceConfig.getUsbPortType() != null ? new DeviceUsbPortImpl(this.deviceConfig, this.application) : null));
        staticPort = this.port;
    }

    public DeviceCommPort(DeviceConfiguration deviceConfiguration) {
        this.device = null;
        this.deviceConfig = deviceConfiguration;
        this.application = null;
        this.settings = Settings.getInstance();
        this.port = Boolean.parseBoolean(System.getProperty("GDE_IS_SIMULATION")) ? new DeviceSerialPortSimulatorImpl(null, this.application, this.deviceConfig.getTimeStep_ms() > 0.0, this.deviceConfig.getTimeStep_ms() < 0.0 ? (System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC") != null ? Integer.parseInt(System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC")) : 100) : (System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC") != null ? Integer.parseInt(System.getProperty("GDE_SIMULATION_TIME_STEP_MSEC")) : (int)this.deviceConfig.getTimeStep_ms())) : (this.deviceConfig.getSerialPortType() != null ? new DeviceJavaSerialCommPortImpl(this.deviceConfig, this.application) : (this.deviceConfig.getUsbPortType() != null ? new DeviceUsbPortImpl(this.deviceConfig, this.application) : null));
        staticPort = this.port;
    }

    public static TreeMap<String, String> listConfiguredSerialPorts(boolean doAvialabilityCheck, String portBlackList, Vector<String> portWhiteList) {
        if (staticPort != null && staticPort instanceof DeviceSerialPortImpl) {
            return DeviceSerialPortImpl.listConfiguredSerialPorts(doAvialabilityCheck, portBlackList, portWhiteList);
        }
        if (staticPort != null && staticPort instanceof DeviceJavaSerialCommPortImpl) {
            return DeviceJavaSerialCommPortImpl.listConfiguredSerialPorts(doAvialabilityCheck, portBlackList, portWhiteList);
        }
        availablePorts.clear();
        return availablePorts;
    }

    public static String[] prepareSerialPortList() {
        if (staticPort != null && staticPort instanceof DeviceSerialPortImpl) {
            return DeviceSerialPortImpl.prepareSerialPortList();
        }
        if (staticPort != null && staticPort instanceof DeviceJavaSerialCommPortImpl) {
            return DeviceJavaSerialCommPortImpl.prepareSerialPortList();
        }
        return new String[0];
    }

    public static TreeMap<String, String> getAvailableports() {
        return availablePorts;
    }

    public static TreeMap<Integer, String> getWindowsPorts() {
        return windowsPorts;
    }

    @Override
    public Object open() throws ApplicationConfigurationException, SerialPortException {
        return this.port.open();
    }

    @Override
    public void close() {
        if (this.port != null) {
            this.port.close();
        }
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        return this.port.read(readBuffer, timeout_msec);
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        return this.port.read(readBuffer, timeout_msec, checkFailedQuery);
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        return this.port.read(readBuffer, timeout_msec, stableIndex);
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        return this.port.read(readBuffer, timeout_msec, stableIndex, minCountBytes);
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        return this.port.read(readBuffer, timeout_msec, waitTimes);
    }

    @Override
    public void write(byte[] writeBuffer) throws IOException {
        this.port.write(writeBuffer);
    }

    @Override
    public void write(byte[] writeBuffer, long gap_ms) throws IOException {
        this.port.write(writeBuffer, gap_ms);
    }

    @Override
    public int cleanInputStream() throws IOException {
        return this.port.cleanInputStream();
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        return this.port.wait4Bytes(timeout_msec);
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        return this.port.wait4Bytes(numBytes, timeout_msec);
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        return this.port.waitForStableReceiveBuffer(expectedBytes, timeout_msec, stableIndex);
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        return this.port.waitForStableReceiveBuffer(expectedBytes, timeout_msec, stableIndex, minCount);
    }

    @Override
    public boolean isConnected() {
        return this.port != null ? this.port.isConnected() : false;
    }

    @Override
    public int getXferErrors() {
        return this.port.getXferErrors();
    }

    @Override
    public void addXferError() {
        this.port.addXferError();
    }

    @Override
    public int getTimeoutErrors() {
        return this.port.getTimeoutErrors();
    }

    @Override
    public void addTimeoutError() {
        this.port.addTimeoutError();
    }

    @Override
    public boolean isMatchAvailablePorts(String newSerialPortStr) {
        return this.port.isMatchAvailablePorts(newSerialPortStr);
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return this.port.getAvailableBytes();
    }

    public synchronized void setInterruptedByUser(boolean setInterruptedByUser) {
        this.isInterruptedByUser = setInterruptedByUser;
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        return this.port.findUsbDevices(vendorId, productId);
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        return this.port.findDevices(hub, vendorId, productId);
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
        this.port.dumpUsbDevices(vendorId, productId);
    }

    @Override
    public UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        return this.port.openUsbPort(activeDevice);
    }

    @Override
    public DeviceHandle openLibUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        return this.port.openLibUsbPort(activeDevice);
    }

    @Override
    public void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
        this.port.closeUsbPort(usbInterface);
    }

    @Override
    public void closeLibUsbPort(DeviceHandle libUsbHandle, boolean cacheSelectedUsbDevice) throws UsbClaimException, UsbException {
        this.port.closeLibUsbPort(libUsbHandle, cacheSelectedUsbDevice);
    }

    @Override
    public int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return this.port.write(iface, endpointAddress, data);
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return this.port.read(iface, endpointAddress, data);
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return this.port.read(iface, endpointAddress, data, timeout_msec);
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        this.port.write(handle, outEndpoint, data, timeout_ms);
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        return this.port.read(handle, inEndpoint, data, timeout_ms);
    }
}

