/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.junsi.iChargerUsb;
import gde.device.junsi.iChargerX6;
import gde.device.junsi.modbus.ChargerInfo;
import gde.device.junsi.modbus.ChargerMemory;
import gde.device.junsi.modbus.ChargerMemoryHead;
import gde.device.junsi.modbus.ChargerStatus;
import gde.device.junsi.modbus.ChargerSystem;
import gde.device.junsi.modbus.ChargerUsbPort;
import gde.exception.TimeOutException;
import gde.io.DataParser;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.ParameterConfigControl;
import gde.ui.SWTResourceManager;
import gde.utils.WaitTimer;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.usb.UsbException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ChargerDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(ChargerDialog.class.getName());
    static Handler logHandler;
    static Logger rootLogger;
    final iChargerUsb device;
    static final Channels channels;
    static final Settings settings;
    private ChargerUsbPort usbPort = null;
    private boolean isPortOpenedByDialog = false;
    private ChargerMemory selectedProgramMemory = null;
    private ChargerMemory copiedProgramMemory = null;
    private int lastSelectedProgramMemoryIndex;
    private int lastSelectedComboIndex = 0;
    byte[] memoryHeadIndex;
    private CCombo combo;
    private int comboHeight = GDE.IS_LINUX ? 24 : (GDE.IS_MAC ? 20 : 22);
    private boolean isComboSetEdit = false;
    private Button btnCopy;
    private Button btnEdit;
    private Button btnWrite;
    private Button btnDelete;
    private Button btnSystemSave;
    private Button btnCharge;
    private Button btnStorage;
    private Button btnDischarge;
    private Button btnCycle;
    private Button btnBalance;
    private Button btnPower;
    private Button btnStop;
    private Group grpProgramMemory;
    private Group grpBalancerSettings;
    private Group grpAdvancedRestoreSettings;
    private Group grpChargeSaftySettings;
    private Group grpDischargeSaftySettings;
    private Group grpRunProgram;
    private CTabFolder tabFolderProgrMem;
    private CTabItem tbtmCharge;
    private CTabItem tbtmDischarge;
    private CTabItem tbtmStorage;
    private CTabItem tbtmCycle;
    private CTabItem tbtmOption;
    private CTabItem tbtmPower;
    private Composite memoryComposite;
    private Composite chargeComposite;
    private Composite dischargeComposite;
    private Composite storageComposite;
    private Composite cycleComposite;
    private Composite optionComposite;
    private Composite powerComposite;
    private Composite sysComposite;
    private CLabel powerLabel;
    private Group grpTemperature;
    private Group grpFans;
    private Group grpBeepTone;
    private Group grpLcdScreen;
    private Group grpChargeDischargePower;
    private Group grpInputDischargePowerLimits;
    private Group grpInputPowerLimits;
    private Group grpRegInputPowerLimits;
    private Group grpLanguage;
    private Group grpDuoInputPowerLimits;
    private Group grpDcInputPowerLimits;
    private Group grpBatInputPowerLimits;
    private Group grpDuoRegInputPowerLimits;
    private Group regToChannelSettings;
    private CLabel regToInputWarningLable;
    private ParameterConfigControl[] memoryParameters = new ParameterConfigControl[53];
    private ParameterConfigControl[] systemParameters = new ParameterConfigControl[50];
    private final String cellTypeNames;
    private final String[] cellTypeNamesArray;
    private int[] memoryValues = new int[this.memoryParameters.length];
    private int[] systemValues = new int[this.systemParameters.length];
    private final boolean isDuo;
    private final boolean isDx;
    final Listener memoryParameterChangeListener;
    final Listener systemParameterChangeListener;
    private ChargerInfo systemInfo = null;
    private ChargerSystem systemSettings = null;
    private boolean isRetryReadMem = false;
    static final short REG_INPUT_INFO_START = 0;
    static final short REG_INPUT_CH1_START = 256;
    static final short REG_INPUT_CH1_NREGS = 256;
    static final short REG_INPUT_CH2_START = 512;
    static final short REG_INPUT_CH2_NREGS = 256;
    static final short REG_INPUT_STATUS_CH1 = 256;
    static final short REG_INPUT_STATUS_CH2 = 512;
    static final short REG_HOLDING_CTRL_START = Short.MIN_VALUE;
    static final short REG_HOLDING_SYS_START = -31744;
    static final short REG_HOLDING_MEM_HEAD_START = -30720;
    static final short REG_HOLDING_MEM_START = -29696;
    static final short VALUE_ORDER_KEY = 21930;

    public static void main(String[] args) {
        try {
            ChargerDialog.initLogger();
            iChargerX6 device = new iChargerX6("c:\\Users\\Winfried\\AppData\\Roaming\\DataExplorer\\Devices\\iCharger S6.xml");
            boolean isDuo = device.getName().endsWith("DUO");
            boolean isDx = device.getName().contains(" DX");
            ChargerUsbPort usbPort = new ChargerUsbPort(device, null);
            if (!usbPort.isConnected()) {
                usbPort.openUsbPort();
            }
            if (usbPort.isConnected()) {
                short sizeInfo = (short)((ChargerInfo.getSize() + 1) / 2);
                byte[] infoBuffer = new byte[sizeInfo * 2];
                usbPort.masterRead((byte)1, (short)0, sizeInfo, infoBuffer);
                ChargerInfo systemInfo = new ChargerInfo(infoBuffer);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, systemInfo.toString());
                }
                short sizeSystem = (short)(((systemInfo != null ? systemInfo.getSystemMemoryLength() : ChargerSystem.getSize(isDuo, isDx)) + 1) / 2);
                byte[] systemBuffer = new byte[sizeSystem * 2];
                usbPort.masterRead((byte)0, (short)-31744, sizeSystem, systemBuffer);
                log.log(Level.INFO, new ChargerSystem(systemBuffer, isDuo, isDx).toString(isDuo, isDx));
                short sizeMemHead = (short)((ChargerMemoryHead.getSize(isDuo || isDx) + 1) / 2);
                byte[] memHeadBuffer = new byte[sizeMemHead * 2];
                usbPort.masterRead((byte)0, (short)-30720, sizeMemHead, memHeadBuffer);
                ChargerMemoryHead memHead = new ChargerMemoryHead(memHeadBuffer, isDuo || isDx);
                log.log(Level.INFO, memHead.toString());
                for (int i = 0; i < memHead.getCount(); ++i) {
                    byte[] index = new byte[2];
                    index[0] = memHead.getIndex()[i];
                    log.log(Level.INFO, String.format("select mem index %d", DataParser.parse2Short((byte)index[0], (byte)index[1])));
                    usbPort.masterWrite(Register.REG_SEL_MEM.value, (short)1, index);
                    short sizeMemory = (short)(((systemInfo != null ? systemInfo.getProgramMemoryLength() : ChargerMemory.getSize(isDuo)) + 1) / 2);
                    byte[] memoryBuffer = new byte[sizeMemory * 2];
                    usbPort.masterRead((byte)0, (short)-29696, sizeMemory, memoryBuffer);
                    log.log(Level.INFO, String.format("%02d %s", memHead.getIndex()[i], new ChargerMemory(memoryBuffer, isDuo).getUseFlagAndName(isDuo)));
                    log.log(Level.INFO, new ChargerMemory(memoryBuffer, isDuo).toString(isDuo));
                }
            }
            if (usbPort.isConnected()) {
                usbPort.closeUsbPort(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChargerInfo readInfo() {
        ChargerInfo chargerInfo = null;
        try {
            short sizeInfo = (short)((ChargerInfo.getSize() + 1) / 2);
            byte[] infoBuffer = new byte[sizeInfo * 2];
            if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterRead((byte)1, (short)0, sizeInfo, infoBuffer)) {
                throw new IllegalStateException();
            }
            chargerInfo = new ChargerInfo(infoBuffer);
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, chargerInfo.toString());
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
        return chargerInfo;
    }

    public ChargerStatus readStatus(int channelNumber) {
        ChargerStatus chargerStatus = null;
        try {
            short sizeStatus = (short)((ChargerStatus.getSize() + 1) / 2);
            byte[] statusBuffer = new byte[sizeStatus * 2];
            if (channelNumber == 2) {
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterRead((byte)1, (short)512, sizeStatus, statusBuffer)) {
                    throw new IllegalStateException();
                }
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterRead((byte)1, (short)256, sizeStatus, statusBuffer)) {
                    throw new IllegalStateException();
                }
            }
            chargerStatus = new ChargerStatus(statusBuffer);
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, chargerStatus.toString());
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
        return chargerStatus;
    }

    public void readSystem(boolean isDuo, boolean isDx) {
        try {
            short sizeSystem = (short)(((this.systemInfo != null && this.systemInfo.getDeviceID() != 0 ? (int)this.systemInfo.getSystemMemoryLength() : ChargerSystem.getSize(isDuo, isDx)) + 1) / 2);
            byte[] systemBuffer = new byte[sizeSystem * 2];
            if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterRead((byte)0, (short)-31744, sizeSystem, systemBuffer)) {
                throw new IllegalStateException();
            }
            this.systemSettings = new ChargerSystem(systemBuffer, isDuo, isDx);
            this.systemValues = this.systemSettings.getSystemValues(this.systemValues);
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, new ChargerSystem(systemBuffer, isDuo, isDx).toString(isDuo, isDx));
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    public ChargerDialog(Shell parent, iChargerUsb useDevice) {
        super(parent, 34912);
        this.device = useDevice;
        this.usbPort = this.device.getUsbPort();
        this.setText(this.device.getName());
        this.isDuo = this.device.getName().toLowerCase().endsWith("duo") && !this.device.getName().toLowerCase().contains("45");
        this.isDx = this.device.getName().toLowerCase().contains(" dx") || this.device.getName().toLowerCase().endsWith("duo") && this.device.getName().toLowerCase().contains("45");
        String[] tmpNamesArray = this.isDuo ? iChargerUsb.BatteryTypesDuo.getValues() : iChargerX6.BatteryTypesX.getValues();
        this.cellTypeNamesArray = new String[tmpNamesArray.length - (this.isDuo ? 2 : 4)];
        System.arraycopy(tmpNamesArray, 1, this.cellTypeNamesArray, 0, this.cellTypeNamesArray.length);
        this.cellTypeNames = String.join((CharSequence)", ", this.cellTypeNamesArray);
        this.memoryParameterChangeListener = this.addProgramMemoryChangedListener();
        this.systemParameterChangeListener = this.addSystemValuesChangedListener();
        this.memoryHeadIndex = new byte[ChargerMemoryHead.getMaxListIndex(this.isDuo)];
    }

    private Listener addProgramMemoryChangedListener() {
        return new Listener(){

            public void handleEvent(Event evt) {
                if (ChargerDialog.this.selectedProgramMemory != null && ChargerDialog.this.selectedProgramMemory.getUseFlag() == 21930) {
                    ChargerDialog.this.btnWrite.setEnabled(true);
                    ChargerDialog.this.btnCharge.setEnabled(false);
                    ChargerDialog.this.btnStorage.setEnabled(false);
                    ChargerDialog.this.btnDischarge.setEnabled(false);
                    ChargerDialog.this.btnCycle.setEnabled(false);
                    ChargerDialog.this.btnBalance.setEnabled(false);
                    ChargerDialog.this.btnPower.setEnabled(false);
                    ChargerDialog.this.btnStop.setEnabled(false);
                    String changedProgramMemoryText = ChargerDialog.this.combo.getText().trim();
                    if (changedProgramMemoryText.contains(" - ")) {
                        changedProgramMemoryText = changedProgramMemoryText.substring(changedProgramMemoryText.lastIndexOf(" - ") + 3);
                    }
                    ChargerDialog.this.combo.setText(ChargerDialog.this.lastSelectedProgramMemoryIndex + Messages.getString((String)"GDE_MSGT2625") + changedProgramMemoryText);
                    ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_RED);
                    block0 : switch (evt.index) {
                        default: {
                            break;
                        }
                        case 1: {
                            if (ChargerDialog.this.isDuo) {
                                switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 7: {
                                        ChargerDialog.this.selectedProgramMemory.setLiCell((byte)ChargerDialog.this.memoryValues[1]);
                                        break block0;
                                    }
                                    case 3: 
                                    case 4: {
                                        ChargerDialog.this.selectedProgramMemory.setNiCell((byte)ChargerDialog.this.memoryValues[1]);
                                        break block0;
                                    }
                                    case 6: {
                                        ChargerDialog.this.selectedProgramMemory.setNiZnCell((byte)ChargerDialog.this.memoryValues[1]);
                                        break block0;
                                    }
                                    case 5: {
                                        ChargerDialog.this.selectedProgramMemory.setPbCell((byte)ChargerDialog.this.memoryValues[1]);
                                        break block0;
                                    }
                                }
                                break;
                            }
                            switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    ChargerDialog.this.selectedProgramMemory.setLiCell((byte)ChargerDialog.this.memoryValues[1]);
                                    break block0;
                                }
                                case 7: {
                                    ChargerDialog.this.selectedProgramMemory.setNiZnCell((byte)ChargerDialog.this.memoryValues[1]);
                                    break block0;
                                }
                                case 5: 
                                case 6: {
                                    ChargerDialog.this.selectedProgramMemory.setNiCell((byte)ChargerDialog.this.memoryValues[1]);
                                    break block0;
                                }
                                case 8: {
                                    ChargerDialog.this.selectedProgramMemory.setPbCell((byte)ChargerDialog.this.memoryValues[1]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 2: {
                            ChargerDialog.this.selectedProgramMemory.setCapacity(ChargerDialog.this.memoryValues[2]);
                            break;
                        }
                        case 3: {
                            ChargerDialog.this.selectedProgramMemory.setChargeCurrent((short)ChargerDialog.this.memoryValues[3]);
                            break;
                        }
                        case 4: {
                            if (ChargerDialog.this.isDuo) {
                                switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 6: 
                                    case 7: {
                                        ChargerDialog.this.selectedProgramMemory.setLiModeC((byte)ChargerDialog.this.memoryValues[4]);
                                        break block0;
                                    }
                                    case 3: 
                                    case 4: {
                                        ChargerDialog.this.selectedProgramMemory.setNiModeC((byte)ChargerDialog.this.memoryValues[4]);
                                        break block0;
                                    }
                                    case 5: {
                                        ChargerDialog.this.selectedProgramMemory.setPbModeC((byte)ChargerDialog.this.memoryValues[4]);
                                        break block0;
                                    }
                                }
                                break;
                            }
                            switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 7: {
                                    ChargerDialog.this.selectedProgramMemory.setLiModeC((byte)ChargerDialog.this.memoryValues[4]);
                                    break block0;
                                }
                                case 5: 
                                case 6: {
                                    ChargerDialog.this.selectedProgramMemory.setNiModeC((byte)ChargerDialog.this.memoryValues[4]);
                                    break block0;
                                }
                                case 8: {
                                    ChargerDialog.this.selectedProgramMemory.setPbModeC((byte)ChargerDialog.this.memoryValues[4]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 5: {
                            ChargerDialog.this.selectedProgramMemory.setLiBalEndMode((byte)ChargerDialog.this.memoryValues[5]);
                            break;
                        }
                        case 6: {
                            ChargerDialog.this.selectedProgramMemory.setEndCharge((short)ChargerDialog.this.memoryValues[6]);
                            break;
                        }
                        case 7: {
                            if (ChargerDialog.this.isDuo) {
                                switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                    case 0: {
                                        ChargerDialog.this.selectedProgramMemory.setLiPoChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                        break block0;
                                    }
                                    case 1: {
                                        ChargerDialog.this.selectedProgramMemory.setLiIoChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                        break block0;
                                    }
                                    case 2: {
                                        ChargerDialog.this.selectedProgramMemory.setLiFeChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                        break block0;
                                    }
                                    case 6: {
                                        ChargerDialog.this.selectedProgramMemory.setNiZnChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                        break block0;
                                    }
                                }
                                break;
                            }
                            switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                case 0: {
                                    ChargerDialog.this.selectedProgramMemory.setLiPoChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                    break block0;
                                }
                                case 1: {
                                    ChargerDialog.this.selectedProgramMemory.setLiIoChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                    break block0;
                                }
                                case 2: {
                                    ChargerDialog.this.selectedProgramMemory.setLiFeChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                    break block0;
                                }
                                case 7: {
                                    ChargerDialog.this.selectedProgramMemory.setNiZnChgCellVolt((short)ChargerDialog.this.memoryValues[7]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 8: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyTempC((short)(ChargerDialog.this.memoryValues[8] * 10));
                            break;
                        }
                        case 9: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyCapC((short)ChargerDialog.this.memoryValues[9]);
                            break;
                        }
                        case 10: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyTimeC((short)ChargerDialog.this.memoryValues[10]);
                            break;
                        }
                        case 11: {
                            ChargerDialog.this.selectedProgramMemory.setBalSpeed((byte)ChargerDialog.this.memoryValues[11]);
                            break;
                        }
                        case 12: {
                            ChargerDialog.this.selectedProgramMemory.setBalStartMode((byte)ChargerDialog.this.memoryValues[12]);
                            break;
                        }
                        case 13: {
                            ChargerDialog.this.selectedProgramMemory.setBalDiff((byte)ChargerDialog.this.memoryValues[13]);
                            break;
                        }
                        case 14: {
                            ChargerDialog.this.selectedProgramMemory.setBalSetPoint((byte)ChargerDialog.this.memoryValues[14]);
                            break;
                        }
                        case 15: {
                            ChargerDialog.this.selectedProgramMemory.setBalOverPoint((byte)ChargerDialog.this.memoryValues[15]);
                            break;
                        }
                        case 16: {
                            ChargerDialog.this.selectedProgramMemory.setBalDelay((byte)ChargerDialog.this.memoryValues[16]);
                            break;
                        }
                        case 17: {
                            ChargerDialog.this.selectedProgramMemory.setDischargeCurrent((short)ChargerDialog.this.memoryValues[17]);
                            break;
                        }
                        case 19: {
                            ChargerDialog.this.selectedProgramMemory.setEndDischarge((short)ChargerDialog.this.memoryValues[19]);
                            break;
                        }
                        case 20: {
                            ChargerDialog.this.selectedProgramMemory.setRegDchgMode((short)ChargerDialog.this.memoryValues[20]);
                            if (ChargerDialog.this.regToInputWarningLable != null) {
                                boolean isToInput = ChargerDialog.this.memoryValues[20] == 1;
                                ChargerDialog.this.regToInputWarningLable.setEnabled(isToInput);
                                ChargerDialog.this.regToInputWarningLable.setForeground(isToInput ? SWTResourceManager.getColor((int)3) : SWTResourceManager.getColor((int)22));
                            }
                            if (ChargerDialog.this.regToChannelSettings == null) break;
                            boolean isToChannel = ChargerDialog.this.memoryValues[20] == 2;
                            ChargerDialog.this.regToChannelSettings.setEnabled(isToChannel);
                            ChargerDialog.this.memoryParameters[50].setEnabled(isToChannel);
                            boolean isResOrBulb = ChargerDialog.this.memoryValues[50] == 0;
                            ChargerDialog.this.memoryParameters[51].setEnabled(isToChannel && isResOrBulb);
                            ChargerDialog.this.memoryParameters[52].setEnabled(isToChannel && isResOrBulb);
                            break;
                        }
                        case 18: 
                        case 21: 
                        case 22: {
                            if (ChargerDialog.this.isDuo) {
                                switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                    case 0: {
                                        ChargerDialog.this.selectedProgramMemory.setLiPoDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 1: {
                                        ChargerDialog.this.selectedProgramMemory.setLiIoDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 2: {
                                        ChargerDialog.this.selectedProgramMemory.setLiFeDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 3: 
                                    case 4: {
                                        ChargerDialog.this.selectedProgramMemory.setNiDischargeVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setNiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 5: {
                                        ChargerDialog.this.selectedProgramMemory.setPbDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setPbModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 6: {
                                        ChargerDialog.this.selectedProgramMemory.setNiZnDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                    case 7: {
                                        ChargerDialog.this.selectedProgramMemory.setLiHVDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                        ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                        break block0;
                                    }
                                }
                                break;
                            }
                            switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                case 0: {
                                    ChargerDialog.this.selectedProgramMemory.setLiPoDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 1: {
                                    ChargerDialog.this.selectedProgramMemory.setLiIoDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 2: {
                                    ChargerDialog.this.selectedProgramMemory.setLiFeDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 3: {
                                    ChargerDialog.this.selectedProgramMemory.setLiHVDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 4: {
                                    ChargerDialog.this.selectedProgramMemory.setLtoDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 5: 
                                case 6: {
                                    ChargerDialog.this.selectedProgramMemory.setNiDischargeVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setNiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 7: {
                                    ChargerDialog.this.selectedProgramMemory.setNiZnDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setLiModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                                case 8: {
                                    ChargerDialog.this.selectedProgramMemory.setPbDchgCellVolt((short)ChargerDialog.this.memoryValues[18]);
                                    ChargerDialog.this.selectedProgramMemory.setPbModeD((byte)(ChargerDialog.this.memoryValues[21] + (ChargerDialog.this.memoryValues[22] << 1)));
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 23: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyTempD((short)(ChargerDialog.this.memoryValues[23] * 10));
                            break;
                        }
                        case 24: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyCapD((short)ChargerDialog.this.memoryValues[24]);
                            break;
                        }
                        case 25: {
                            ChargerDialog.this.selectedProgramMemory.setSafetyTimeD((short)ChargerDialog.this.memoryValues[25]);
                            break;
                        }
                        case 26: {
                            ChargerDialog.this.selectedProgramMemory.setNiPeak((short)ChargerDialog.this.memoryValues[26]);
                            break;
                        }
                        case 27: {
                            ChargerDialog.this.selectedProgramMemory.setNiPeakDelay((short)ChargerDialog.this.memoryValues[27]);
                            break;
                        }
                        case 28: {
                            ChargerDialog.this.selectedProgramMemory.setNiZeroEnable((short)ChargerDialog.this.memoryValues[28]);
                            break;
                        }
                        case 29: {
                            ChargerDialog.this.selectedProgramMemory.setNiTrickleEnable((short)ChargerDialog.this.memoryValues[29]);
                            break;
                        }
                        case 30: {
                            ChargerDialog.this.selectedProgramMemory.setNiTrickleCurrent((short)ChargerDialog.this.memoryValues[30]);
                            break;
                        }
                        case 31: {
                            ChargerDialog.this.selectedProgramMemory.setNiTrickleTime((short)ChargerDialog.this.memoryValues[31]);
                            break;
                        }
                        case 32: {
                            ChargerDialog.this.selectedProgramMemory.setRestoreVolt((short)ChargerDialog.this.memoryValues[32]);
                            break;
                        }
                        case 33: {
                            ChargerDialog.this.selectedProgramMemory.setRestoreTime((short)ChargerDialog.this.memoryValues[33]);
                            break;
                        }
                        case 34: {
                            ChargerDialog.this.selectedProgramMemory.setRestoreCurent((short)ChargerDialog.this.memoryValues[34]);
                            break;
                        }
                        case 35: {
                            ChargerDialog.this.selectedProgramMemory.setKeepChargeEnable((byte)ChargerDialog.this.memoryValues[35]);
                            break;
                        }
                        case 36: {
                            if (ChargerDialog.this.isDuo) {
                                switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                    case 0: {
                                        ChargerDialog.this.selectedProgramMemory.setLiPoStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                        break block0;
                                    }
                                    case 1: {
                                        ChargerDialog.this.selectedProgramMemory.setLiLoStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                        break block0;
                                    }
                                    case 2: {
                                        ChargerDialog.this.selectedProgramMemory.setLiFeStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                        break block0;
                                    }
                                    case 7: {
                                        ChargerDialog.this.selectedProgramMemory.setLiHVStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                        break block0;
                                    }
                                }
                                break;
                            }
                            switch (ChargerDialog.this.selectedProgramMemory.getType()) {
                                case 0: {
                                    ChargerDialog.this.selectedProgramMemory.setLiPoStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                    break block0;
                                }
                                case 1: {
                                    ChargerDialog.this.selectedProgramMemory.setLiLoStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                    break block0;
                                }
                                case 2: {
                                    ChargerDialog.this.selectedProgramMemory.setLiFeStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                    break block0;
                                }
                                case 3: {
                                    ChargerDialog.this.selectedProgramMemory.setLiHVStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                    break block0;
                                }
                                case 4: {
                                    ChargerDialog.this.selectedProgramMemory.setLtoStoCellVolt((short)ChargerDialog.this.memoryValues[36]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 37: {
                            ChargerDialog.this.selectedProgramMemory.setStoCompensation((short)ChargerDialog.this.memoryValues[37]);
                            break;
                        }
                        case 38: {
                            ChargerDialog.this.selectedProgramMemory.setFastSto((byte)ChargerDialog.this.memoryValues[38]);
                            break;
                        }
                        case 39: {
                            ChargerDialog.this.selectedProgramMemory.setCycleMode((byte)ChargerDialog.this.memoryValues[39]);
                            break;
                        }
                        case 40: {
                            ChargerDialog.this.selectedProgramMemory.setCycleCount((short)ChargerDialog.this.memoryValues[40]);
                            break;
                        }
                        case 41: {
                            ChargerDialog.this.selectedProgramMemory.setCycleDelay((short)ChargerDialog.this.memoryValues[41]);
                            break;
                        }
                        case 42: {
                            ChargerDialog.this.selectedProgramMemory.setDigitPowerVolt((short)(ChargerDialog.this.memoryValues[42] * 100));
                            break;
                        }
                        case 43: {
                            ChargerDialog.this.selectedProgramMemory.setDigitPowerCurrent((short)(ChargerDialog.this.memoryValues[43] * 10));
                            break;
                        }
                        case 44: 
                        case 45: 
                        case 46: {
                            ChargerDialog.this.selectedProgramMemory.setDigitPowerSet((byte)(ChargerDialog.this.memoryValues[44] + (ChargerDialog.this.memoryValues[45] << 1) + (ChargerDialog.this.memoryValues[46] << 2)));
                            break;
                        }
                        case 47: {
                            ChargerDialog.this.selectedProgramMemory.setChannelMode((byte)ChargerDialog.this.memoryValues[47]);
                            log.log(Level.OFF, "channel async/sync = " + ChargerDialog.this.memoryValues[47]);
                            break;
                        }
                        case 48: {
                            ChargerDialog.this.selectedProgramMemory.setLogInterval((short)(ChargerDialog.this.memoryValues[48] - ChargerDialog.this.memoryValues[48] % 5));
                            break;
                        }
                        case 49: {
                            ChargerDialog.this.selectedProgramMemory.setSaveToSD((byte)ChargerDialog.this.memoryValues[49]);
                            break;
                        }
                        case 50: {
                            ChargerDialog.this.selectedProgramMemory.setRegChMode((byte)ChargerDialog.this.memoryValues[50]);
                            if (ChargerDialog.this.memoryParameters[51] == null || ChargerDialog.this.memoryParameters[52] == null) break;
                            ChargerDialog.this.memoryParameters[51].setEnabled(ChargerDialog.this.memoryValues[50] == 0);
                            ChargerDialog.this.memoryParameters[52].setEnabled(ChargerDialog.this.memoryValues[50] == 0);
                            break;
                        }
                        case 51: {
                            ChargerDialog.this.selectedProgramMemory.setRegChVolt((short)(ChargerDialog.this.memoryValues[51] * 100));
                            break;
                        }
                        case 52: {
                            ChargerDialog.this.selectedProgramMemory.setRegChCurrent((short)ChargerDialog.this.memoryValues[52]);
                        }
                    }
                    ChargerDialog.access$1302(ChargerDialog.this, ChargerDialog.this.selectedProgramMemory.getMemoryValues(ChargerDialog.this.memoryValues, ChargerDialog.this.isDuo));
                    ChargerDialog.this.updateMemoryParameterControls();
                }
            }
        };
    }

    private Listener addSystemValuesChangedListener() {
        return new Listener(){

            public void handleEvent(Event evt) {
                ChargerDialog.this.btnSystemSave.setEnabled(true);
                switch (evt.index) {
                    case 0: {
                        ChargerDialog.this.systemSettings.setTempUnit((short)ChargerDialog.this.systemValues[0]);
                        break;
                    }
                    case 1: {
                        ChargerDialog.this.systemSettings.setTempStop((short)ChargerDialog.this.systemValues[1]);
                        break;
                    }
                    case 2: {
                        ChargerDialog.this.systemSettings.setTempReduce((short)ChargerDialog.this.systemValues[2]);
                        break;
                    }
                    case 3: {
                        ChargerDialog.this.systemSettings.setTempFansOn((short)ChargerDialog.this.systemValues[3]);
                        break;
                    }
                    case 4: {
                        ChargerDialog.this.systemSettings.setFansOffDelay((short)ChargerDialog.this.systemValues[4]);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        short[] beepEnable = new short[]{(short)(ChargerDialog.this.systemValues[5] != 0 ? 1 : 0), (short)(ChargerDialog.this.systemValues[6] != 0 ? 1 : 0), (short)(ChargerDialog.this.systemValues[7] != 0 ? 1 : 0), (short)(ChargerDialog.this.systemValues[8] != 0 ? 1 : 0)};
                        ChargerDialog.this.systemSettings.setBeepEnable(beepEnable);
                        short[] beepVolume = new short[]{(short)(ChargerDialog.this.systemValues[5] == 0 ? ChargerDialog.this.systemSettings.getBeepVOL()[0] : ChargerDialog.this.systemValues[5]), (short)(ChargerDialog.this.systemValues[6] == 0 ? ChargerDialog.this.systemSettings.getBeepVOL()[1] : ChargerDialog.this.systemValues[6]), (short)(ChargerDialog.this.systemValues[7] == 0 ? ChargerDialog.this.systemSettings.getBeepVOL()[2] : ChargerDialog.this.systemValues[7]), (short)(ChargerDialog.this.systemValues[8] == 0 ? ChargerDialog.this.systemSettings.getBeepVOL()[3] : ChargerDialog.this.systemValues[8])};
                        ChargerDialog.this.systemSettings.setBeepVOL(beepVolume);
                    }
                    case 9: {
                        short[] beepType = new short[4];
                        beepType[3] = (short)ChargerDialog.this.systemValues[9];
                        ChargerDialog.this.systemSettings.setBeepType(beepType);
                    }
                    case 10: 
                    case 11: {
                        ChargerDialog.this.systemSettings.setLightValue((short)ChargerDialog.this.systemValues[10]);
                        ChargerDialog.this.systemSettings.setLcdContraste((short)ChargerDialog.this.systemValues[11]);
                        break;
                    }
                    case 12: 
                    case 13: {
                        ChargerDialog.this.systemSettings.setChargePower(new short[]{(short)ChargerDialog.this.systemValues[12], (short)ChargerDialog.this.systemValues[13]});
                        break;
                    }
                    case 14: 
                    case 15: {
                        ChargerDialog.this.systemSettings.setDischargePower(new short[]{(short)ChargerDialog.this.systemValues[14], (short)ChargerDialog.this.systemValues[15]});
                        break;
                    }
                    case 16: {
                        ChargerDialog.this.systemSettings.setProPower((short)ChargerDialog.this.systemValues[16]);
                        break;
                    }
                    case 17: {
                        ChargerDialog.this.systemSettings.setSelInputSource((short)ChargerDialog.this.systemValues[17]);
                        break;
                    }
                    case 18: {
                        ChargerDialog.this.systemSettings.setxDischargePower((short)ChargerDialog.this.systemValues[18]);
                        break;
                    }
                    case 19: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setInputLowVolt((short)ChargerDialog.this.systemValues[19]);
                        break;
                    }
                    case 20: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setInputCurrentLimit((short)ChargerDialog.this.systemValues[20]);
                        break;
                    }
                    case 21: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setChargePower((short)ChargerDialog.this.systemValues[21]);
                        break;
                    }
                    case 22: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setRegEnable((short)ChargerDialog.this.systemValues[22]);
                        if (ChargerDialog.this.grpRegInputPowerLimits == null) break;
                        ChargerDialog.this.grpRegInputPowerLimits.setEnabled(ChargerDialog.this.systemValues[22] == 1);
                        break;
                    }
                    case 23: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setRegVoltLimit((short)ChargerDialog.this.systemValues[23]);
                        break;
                    }
                    case 24: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setRegCurrentLimit((short)ChargerDialog.this.systemValues[24]);
                        break;
                    }
                    case 25: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setRegPowerLimit((short)ChargerDialog.this.systemValues[25]);
                        break;
                    }
                    case 26: {
                        ((ChargerDialog)ChargerDialog.this).systemSettings.xInputSources[ChargerDialog.this.systemValues[17]].setRegCapLimit(ChargerDialog.this.systemValues[26]);
                        break;
                    }
                    case 27: {
                        ChargerDialog.this.systemSettings.setSelectLanguage((short)ChargerDialog.this.systemValues[27]);
                        break;
                    }
                    case 28: {
                        ChargerDialog.this.systemSettings.setDcInputLowVolt((short)ChargerDialog.this.systemValues[28]);
                        break;
                    }
                    case 29: {
                        ChargerDialog.this.systemSettings.setDcInputCurrentLimit((short)ChargerDialog.this.systemValues[29]);
                        break;
                    }
                    case 30: {
                        ChargerDialog.this.systemSettings.setBatInputLowVolt((short)ChargerDialog.this.systemValues[30]);
                        break;
                    }
                    case 31: {
                        ChargerDialog.this.systemSettings.setBatInputCurrentLimit((short)ChargerDialog.this.systemValues[31]);
                        break;
                    }
                    case 32: {
                        ChargerDialog.this.systemSettings.setRegEnable((short)ChargerDialog.this.systemValues[32]);
                        if (ChargerDialog.this.grpDuoRegInputPowerLimits == null) break;
                        ChargerDialog.this.grpDuoRegInputPowerLimits.setEnabled(ChargerDialog.this.systemValues[32] == 1);
                        break;
                    }
                    case 33: {
                        ChargerDialog.this.systemSettings.setRegVoltLimit((short)ChargerDialog.this.systemValues[33]);
                        break;
                    }
                    case 34: {
                        ChargerDialog.this.systemSettings.setRegCurrentLimit((short)ChargerDialog.this.systemValues[34]);
                        break;
                    }
                    case 35: {
                        ChargerDialog.this.systemSettings.setRegCapacityLimit(ChargerDialog.this.systemValues[35] * 100);
                        break;
                    }
                    case 36: {
                        ChargerDialog.this.systemSettings.setAntiSparkEnabl((short)ChargerDialog.this.systemValues[36]);
                        break;
                    }
                }
                ChargerDialog.access$1902(ChargerDialog.this, ChargerDialog.this.systemSettings.getSystemValues(ChargerDialog.this.systemValues));
                ChargerDialog.this.updateSystemParameterControls();
            }
        };
    }

    private static void initLogger() {
        Handler[] handlers;
        logHandler = new ConsoleHandler();
        logHandler.setFormatter((Formatter)new LogFormatter());
        logHandler.setLevel(Level.INFO);
        rootLogger = Logger.getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.setLevel(Level.ALL);
        rootLogger.addHandler(logHandler);
    }

    private String[] readProgramMemories() {
        ArrayList<String> programMemories = new ArrayList<String>();
        try {
            if (this.usbPort != null && this.usbPort.isConnected()) {
                short sizeMemHead = (short)((ChargerMemoryHead.getSize(this.isDuo || this.isDx) + 1) / 2);
                byte[] memHeadBuffer = new byte[sizeMemHead * 2];
                this.usbPort.masterRead((byte)0, (short)-30720, sizeMemHead, memHeadBuffer);
                ChargerMemoryHead memHead = new ChargerMemoryHead(memHeadBuffer, this.isDuo || this.isDx);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, memHead.toString());
                }
                byte[] index = new byte[2];
                short sizeMemory = (short)(((this.systemInfo != null && this.systemInfo.getDeviceID() != 0 ? (int)this.systemInfo.getProgramMemoryLength() : ChargerMemory.getSize(this.isDuo)) + 1) / 2);
                this.memoryHeadIndex = memHead.getIndex();
                for (int i = 0; i < memHead.getCount(); ++i) {
                    index[0] = this.memoryHeadIndex[i];
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, String.format("select mem index %d", DataParser.parse2Short((byte)index[0], (byte)index[1])));
                    }
                    this.usbPort.masterWrite(Register.REG_SEL_MEM.value, (short)1, index);
                    byte[] memoryBuffer = new byte[sizeMemory * 2];
                    this.usbPort.masterRead((byte)0, (short)-29696, sizeMemory, memoryBuffer);
                    programMemories.add(this.getFormatedListEntry(i, new ChargerMemory(memoryBuffer, this.isDuo)));
                    if (!log.isLoggable(Level.INFO)) continue;
                    log.log(Level.INFO, (String)programMemories.get(programMemories.size() - 1));
                }
                this.initProgramMemory(0);
                return programMemories.size() == 0 ? new String[]{} : programMemories.toArray(new String[1]);
            }
        }
        catch (IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
        }
        catch (TimeOutException te) {
            if (!this.isRetryReadMem) {
                log.log(Level.WARNING, te.getMessage(), te);
                WaitTimer.delay((long)1000L);
                this.isRetryReadMem = true;
                return this.readProgramMemories();
            }
            log.log(Level.SEVERE, te.getMessage(), te);
            this.application.openMessageDialogAsync(this.getDialogShell(), te.getMessage());
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
        return new String[0];
    }

    private String getFormatedListEntry(int memHeadIndex, ChargerMemory programMemory) {
        return String.format("%02d - %s", this.memoryHeadIndex[memHeadIndex], programMemory.getUseFlagAndName(this.isDuo));
    }

    private byte[] initProgramMemory(int selectedProgramMemoryIndex) {
        short sizeMemory = (short)(((this.systemInfo != null && this.systemInfo.getDeviceID() != 0 ? (int)this.systemInfo.getProgramMemoryLength() : ChargerMemory.getSize(this.isDuo)) + 1) / 2);
        byte[] memoryBuffer = new byte[sizeMemory * 2];
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "read using memory buffer length " + memoryBuffer.length);
        }
        byte[] index = new byte[2];
        index[0] = (byte)(selectedProgramMemoryIndex & 0xFF);
        try {
            this.usbPort.masterWrite(Register.REG_SEL_MEM.value, (short)1, index);
            this.usbPort.masterRead((byte)0, (short)-29696, sizeMemory, memoryBuffer);
            this.selectedProgramMemory = new ChargerMemory(memoryBuffer, this.isDuo);
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "selectedProgramMemory = " + this.selectedProgramMemory.toString(this.isDuo));
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
        return memoryBuffer;
    }

    private void writeProgramMemory(int selectedProgramMemoryIndex, ChargerMemory modifiedProgramMemory, short useFlag) {
        short sizeMemory = (short)(((this.systemInfo != null && this.systemInfo.getDeviceID() != 0 ? (int)this.systemInfo.getProgramMemoryLength() : ChargerMemory.getSize(this.isDuo)) + 1) / 2);
        byte[] index = new byte[2];
        index[0] = (byte)(selectedProgramMemoryIndex & 0xFF);
        if (this.isDuo && selectedProgramMemoryIndex < 7 || !this.isDuo && selectedProgramMemoryIndex < 10) {
            log.log(Level.SEVERE, String.format(Messages.getString((String)"GDE_MSGT2621"), selectedProgramMemoryIndex));
            this.application.openMessageDialog(this.dialogShell, Messages.getString((String)"GDE_MSGT2622"));
            return;
        }
        try {
            this.usbPort.masterWrite(Register.REG_SEL_MEM.value, (short)1, index);
            if (modifiedProgramMemory.getUseFlag() != useFlag) {
                modifiedProgramMemory.setUseFlag(useFlag);
            }
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, String.format("Program memory name = %s", new String(modifiedProgramMemory.getName()).trim()));
                log.log(Level.INFO, String.format("Program memory useFlag = 0x%04X", modifiedProgramMemory.getUseFlag()));
                log.log(Level.INFO, String.format("write memory buffer index  = %d", selectedProgramMemoryIndex));
            }
            this.usbPort.masterWrite((short)-29696, sizeMemory, modifiedProgramMemory.getAsByteArray(this.isDuo));
            this.transOrder((byte)Order.ORDER_WRITE_MEM.ordinal());
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    private boolean writeSystemMemory(boolean isDuo) {
        short sizeSystem = (short)(((this.systemInfo != null ? this.systemInfo.getSystemMemoryLength() : ChargerSystem.getSize(isDuo, this.isDx)) + 1) / 2);
        try {
            if (this.systemSettings != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, new ChargerSystem(this.systemSettings.getAsByteArray(isDuo, this.isDx), isDuo, this.isDx).toString(isDuo, this.isDx));
                }
                this.usbPort.masterWrite((short)-31744, sizeSystem, this.systemSettings.getAsByteArray(isDuo, this.isDx));
                this.transOrder((byte)Order.ORDER_WRITE_SYS.ordinal());
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
        return true;
    }

    private short addEntryMemoryHead(String batTypeName) {
        short newHeadIndex = -1;
        try {
            if (this.usbPort != null && this.usbPort.isConnected()) {
                short sizeMemHead = (short)((ChargerMemoryHead.getSize(this.isDuo || this.isDx) + 1) / 2);
                byte[] memHeadBuffer = new byte[sizeMemHead * 2];
                this.usbPort.masterRead((byte)0, (short)-30720, sizeMemHead, memHeadBuffer);
                ChargerMemoryHead memHead = new ChargerMemoryHead(memHeadBuffer, this.isDuo || this.isDx);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("before modification: %s", memHead.toString()));
                }
                if (memHead.getCount() >= ChargerMemoryHead.getMaxListIndex(this.isDuo || this.isDx)) {
                    throw new IndexOutOfBoundsException();
                }
                newHeadIndex = memHead.getNextFreeIndex();
                byte[] updatedIndex = memHead.addIndexAfter((byte)(this.device.getBatTypeIndex(batTypeName) - 1), newHeadIndex);
                memHead.setIndex(updatedIndex);
                memHead.setCount((short)(memHead.getCount() + 1));
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("after modification: %s", memHead.toString()));
                }
                this.usbPort.masterWrite((short)-30720, sizeMemHead, memHead.getAsByteArray(this.isDuo || this.isDx));
                this.transOrder((byte)Order.ORDER_WRITE_MEM_HEAD.ordinal());
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            if (e instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
            }
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE2601"));
        }
        return newHeadIndex;
    }

    private void removeMemoryHead(byte removeProgramMemoryIndex) {
        try {
            if (this.usbPort != null && this.usbPort.isConnected()) {
                short sizeMemHead = (short)((ChargerMemoryHead.getSize(this.isDuo || this.isDx) + 1) / 2);
                byte[] memHeadBuffer = new byte[sizeMemHead * 2];
                this.usbPort.masterRead((byte)0, (short)-30720, sizeMemHead, memHeadBuffer);
                ChargerMemoryHead memHead = new ChargerMemoryHead(memHeadBuffer, this.isDuo || this.isDx);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("before modification: count %d; index.length %d", memHead.getCount(), memHead.getIndex().length));
                }
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("before modification: %s", memHead.toString()));
                }
                memHead.setIndex(memHead.removeIndex(removeProgramMemoryIndex));
                memHead.setCount((short)(memHead.getCount() - 1));
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("after modification: count %d; index.length %d", memHead.getCount(), memHead.getIndex().length));
                }
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("after modification: %s", memHead.toString()));
                }
                this.usbPort.masterWrite((short)-30720, sizeMemHead, memHead.getAsByteArray(this.isDuo || this.isDx));
                this.transOrder((byte)Order.ORDER_WRITE_MEM_HEAD.ordinal());
            }
        }
        catch (TimeOutException | IllegalStateException ex) {
            if (ex instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), ex.getMessage());
            }
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    private void transOrder(byte order) throws IllegalStateException, TimeOutException {
        byte[] temp = new byte[4];
        temp[0] = -86;
        temp[1] = 85;
        temp[2] = order;
        ChargerUsbPort.ModBusErrorCode mbErrorCode = this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp);
        if (mbErrorCode != ChargerUsbPort.ModBusErrorCode.MB_EOK) {
            throw new IllegalStateException(mbErrorCode.toString());
        }
        temp = new byte[2];
        mbErrorCode = this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp);
        if (mbErrorCode != ChargerUsbPort.ModBusErrorCode.MB_EOK) {
            throw new IllegalStateException(mbErrorCode.toString());
        }
    }

    private void startProgramExecution(byte programType, byte channel, byte programMemoryIndex) {
        try {
            if (this.usbPort != null && this.usbPort.isConnected()) {
                byte[] runOrderBuf = new byte[10];
                runOrderBuf[0] = programType;
                runOrderBuf[2] = programMemoryIndex;
                runOrderBuf[4] = channel;
                runOrderBuf[6] = -86;
                runOrderBuf[7] = 85;
                runOrderBuf[8] = (byte)Order.ORDER_RUN.ordinal();
                this.usbPort.masterWrite(Register.REG_SEL_OP.value, (short)(runOrderBuf.length / 2), runOrderBuf);
            }
        }
        catch (TimeOutException | IllegalStateException e) {
            if (e instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
            }
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    private void stopProgramExecution(byte channel) {
        try {
            boolean isConnectedByStop = false;
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    this.usbPort.openUsbPort();
                    isConnectedByStop = true;
                    WaitTimer.delay((long)500L);
                }
                byte[] runOrderBuf = new byte[6];
                runOrderBuf[0] = channel;
                runOrderBuf[2] = -86;
                runOrderBuf[3] = 85;
                runOrderBuf[4] = (byte)Order.ORDER_STOP.ordinal();
                this.usbPort.masterWrite(Register.REG_SEL_CHANNEL.value, (short)(runOrderBuf.length / 2), runOrderBuf);
                if (isConnectedByStop) {
                    this.usbPort.closeUsbPort(true);
                }
            }
        }
        catch (TimeOutException | IllegalStateException | UsbException e) {
            if (e instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
            }
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    private void stopLogTransmission() {
        try {
            boolean isConnectedByStop = false;
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    this.usbPort.openUsbPort();
                    isConnectedByStop = true;
                    WaitTimer.delay((long)500L);
                }
                byte[] temp = new byte[4];
                temp[0] = -86;
                temp[1] = 85;
                temp[2] = (byte)Order.ORDER_TRANS_LOG_OFF.ordinal();
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp)) {
                    throw new IllegalStateException();
                }
                temp = new byte[2];
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp)) {
                    throw new IllegalStateException();
                }
                if (isConnectedByStop) {
                    this.usbPort.closeUsbPort(true);
                }
            }
        }
        catch (TimeOutException | IllegalStateException | UsbException e) {
            if (e instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
            }
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    public void startLogTransmission() {
        try {
            boolean isConnectedByStop = false;
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    this.usbPort.openUsbPort();
                    isConnectedByStop = true;
                    WaitTimer.delay((long)500L);
                }
                byte[] temp = new byte[4];
                temp[0] = -86;
                temp[1] = 85;
                temp[2] = (byte)Order.ORDER_TRANS_LOG_ON.ordinal();
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp)) {
                    throw new IllegalStateException();
                }
                temp = new byte[2];
                if (ChargerUsbPort.ModBusErrorCode.MB_EOK != this.usbPort.masterWrite(Register.REG_ORDER_KEY.value, (short)(temp.length / 2), temp)) {
                    throw new IllegalStateException();
                }
                if (isConnectedByStop) {
                    this.usbPort.closeUsbPort(true);
                }
            }
        }
        catch (TimeOutException | IllegalStateException | UsbException e) {
            if (e instanceof UsbException) {
                this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
            }
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, rte.getMessage(), rte);
        }
    }

    public ChargerDialog(Shell parent, int style) {
        super(parent, style);
        this.device = (iChargerUsb)DataExplorer.getInstance().getActiveDevice();
        this.usbPort = this.device.getUsbPort();
        this.setText(this.device.getName());
        this.isDuo = this.device.getName().toLowerCase().endsWith("duo") && !this.device.getName().toLowerCase().contains("45");
        this.isDx = this.device.getName().toLowerCase().contains(" dx") || this.device.getName().toLowerCase().endsWith("duo") && this.device.getName().toLowerCase().contains("45");
        String[] tmpNamesArray = this.isDuo ? iChargerUsb.BatteryTypesDuo.getValues() : iChargerX6.BatteryTypesX.getValues();
        this.cellTypeNamesArray = new String[tmpNamesArray.length - (this.isDuo ? 2 : 4)];
        System.arraycopy(tmpNamesArray, 1, this.cellTypeNamesArray, 0, this.cellTypeNamesArray.length);
        this.cellTypeNames = String.join((CharSequence)", ", this.cellTypeNamesArray);
        this.memoryParameterChangeListener = this.addProgramMemoryChangedListener();
        this.systemParameterChangeListener = this.addSystemValuesChangedListener();
        this.memoryHeadIndex = new byte[ChargerMemoryHead.getMaxListIndex(this.isDuo)];
    }

    public void open() {
        if (256 == this.application.openOkCancelMessageDialog(Messages.getString((String)"GDE_MSGI2602"))) {
            return;
        }
        try {
            if (this.usbPort == null || this.usbPort.isConnected()) {
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2602", (Object[])new String[]{this.device.getName()}));
                return;
            }
            this.usbPort.openUsbPort();
            this.isPortOpenedByDialog = true;
            WaitTimer.delay((long)500L);
        }
        catch (UsbException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
            return;
        }
        try {
            this.usbPort.getData();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.usbPort.getData();
            WaitTimer.delay((long)100L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.stopLogTransmission();
        WaitTimer.delay((long)100L);
        this.systemInfo = this.readInfo();
        if (this.systemInfo == null || this.systemInfo.getDeviceID() == 0) {
            log.log(Level.SEVERE, "Read system info failed");
            this.application.openMessageDialogAsync(this.getDialogShell(), Messages.getString((String)"GDE_MSGW2602", (Object[])new String[]{this.device.getName()}));
            try {
                this.usbPort.closeUsbPort(true);
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
        if (this.systemInfo != null && (this.systemInfo.getStatus() & 2) != 0) {
            log.log(Level.SEVERE, this.systemInfo.getStatusString());
            this.application.openMessageDialogAsync(this.getDialogShell(), Messages.getString((String)"GDE_MSGE2603"));
            try {
                this.usbPort.closeUsbPort(true);
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
        this.createContents();
        this.dialogShell.setLocation(300, 50);
        this.dialogShell.open();
        if (this.device.isDataGathererActive()) {
            this.btnCharge.setEnabled(false);
            this.btnStorage.setEnabled(false);
            this.btnDischarge.setEnabled(false);
            this.btnCycle.setEnabled(false);
            this.btnBalance.setEnabled(false);
            this.btnStop.setEnabled(true);
            this.grpProgramMemory.setEnabled(false);
        }
        this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dialogShell.mouseEnter, event=" + evt);
                }
                ChargerDialog.this.fadeOutAplhaBlending(evt, ChargerDialog.this.getDialogShell().getClientArea(), 10, 10, 10, 15);
            }

            public void mouseHover(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dialogShell.mouseHover, event=" + evt);
                }
            }

            public void mouseExit(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dialogShell.mouseExit, event=" + evt);
                }
                ChargerDialog.this.fadeInAlpaBlending(evt, ChargerDialog.this.getDialogShell().getClientArea(), 5, 5, -5, 5);
            }
        });
        this.dialogShell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.device.isDataGathererActive() && this.isPortOpenedByDialog && this.usbPort != null && this.usbPort.isConnected()) {
            try {
                if (!this.device.isDataGathererActive()) {
                    this.startLogTransmission();
                    this.usbPort.closeUsbPort(true);
                    this.isPortOpenedByDialog = false;
                }
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private void createContents() {
        String[] stringArray;
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
        this.dialogShell = Settings.getInstance().isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (Settings.getInstance().isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
        this.dialogShell.setSize(800, 750);
        SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
        this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 1), (int)0));
        this.dialogShell.setText(this.getText());
        this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
        if (this.isAlphaEnabled) {
            this.dialogShell.setAlpha(254);
        }
        FillLayout mainTabFolderLayout = new FillLayout();
        mainTabFolderLayout.marginHeight = 5;
        mainTabFolderLayout.marginWidth = 5;
        this.dialogShell.setLayout((Layout)mainTabFolderLayout);
        final CTabFolder mainTabFolder = new CTabFolder((Composite)this.dialogShell, 0);
        mainTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        mainTabFolder.setSimple(false);
        mainTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (mainTabFolder.getSelectionIndex() == 1) {
                    ChargerDialog.this.readSystem(ChargerDialog.this.isDuo, ChargerDialog.this.isDx);
                    ChargerDialog.this.updateSystemParameterControls();
                }
            }
        });
        CTabItem tbtmProgramMemory = new CTabItem(mainTabFolder, 0);
        tbtmProgramMemory.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        tbtmProgramMemory.setText(Messages.getString((String)"GDE_MSGI2607"));
        Composite mainMemoryComposite = new Composite((Composite)mainTabFolder, 0);
        tbtmProgramMemory.setControl((Control)mainMemoryComposite);
        mainMemoryComposite.setLayout((Layout)new FormLayout());
        this.grpProgramMemory = new Group(mainMemoryComposite, 0);
        this.grpProgramMemory.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpProgramMemory.setText(Messages.getString((String)"GDE_MSGT2623"));
        RowLayout rl_grpMemory = new RowLayout(256);
        rl_grpMemory.justify = true;
        rl_grpMemory.fill = GDE.IS_WINDOWS | GDE.IS_OS_ARCH_ARM;
        this.grpProgramMemory.setLayout((Layout)rl_grpMemory);
        FormData fd_grpMemory = new FormData();
        fd_grpMemory.top = new FormAttachment(0, 10);
        fd_grpMemory.right = new FormAttachment(100, -10);
        fd_grpMemory.bottom = new FormAttachment(0, 75);
        fd_grpMemory.left = new FormAttachment(0, 10);
        this.grpProgramMemory.setLayoutData((Object)fd_grpMemory);
        this.combo = new CCombo((Composite)this.grpProgramMemory, 2048);
        this.combo.setLayoutData((Object)new RowData(350, this.comboHeight));
        this.combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 1), (int)0));
        if (this.device.isDataGathererActive()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Messages.getString((String)"GDE_MSGT2624");
        } else {
            stringArray = this.readProgramMemories();
        }
        this.combo.setItems(stringArray);
        this.combo.select(0);
        this.combo.setBackground(this.application.COLOR_WHITE);
        this.combo.setEditable(false);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_BLACK);
                if (ChargerDialog.this.combo.getSelectionIndex() >= 0 && ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    ChargerDialog.this.initProgramMemory(ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    ChargerDialog.this.lastSelectedComboIndex = ChargerDialog.this.combo.getSelectionIndex();
                    ChargerDialog.this.lastSelectedProgramMemoryIndex = ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.lastSelectedComboIndex];
                    if (ChargerDialog.this.selectedProgramMemory != null) {
                        ChargerDialog.access$1302(ChargerDialog.this, ChargerDialog.this.selectedProgramMemory.getMemoryValues(ChargerDialog.this.memoryValues, ChargerDialog.this.isDuo));
                        ChargerDialog.this.updateMemoryParameterControls();
                    }
                }
                if (ChargerDialog.this.combo.getText().contains("BUILD IN")) {
                    ChargerDialog.this.btnCopy.setEnabled(true);
                    ChargerDialog.this.btnDelete.setEnabled(false);
                    if (log.isLoggable(Level.FINEST)) {
                        ChargerDialog.this.btnDelete.setEnabled(true);
                    }
                } else {
                    ChargerDialog.this.btnCopy.setEnabled(false);
                    ChargerDialog.this.btnDelete.setEnabled(true);
                }
                ChargerDialog.this.btnEdit.setEnabled(ChargerDialog.this.combo.getText().contains("CUSTOM"));
                if (ChargerDialog.this.isDuo && ChargerDialog.this.memoryValues[0] < 8 || ChargerDialog.this.memoryValues[0] < 9) {
                    ChargerDialog.this.btnCharge.setEnabled(true);
                    ChargerDialog.this.btnStorage.setEnabled(false);
                    ChargerDialog.this.btnDischarge.setEnabled(true);
                    ChargerDialog.this.btnCycle.setEnabled(true);
                    ChargerDialog.this.btnBalance.setEnabled(false);
                    ChargerDialog.this.btnPower.setEnabled(false);
                    ChargerDialog.this.btnStop.setEnabled(false);
                    if (ChargerDialog.this.memoryValues[0] >= 0 && ChargerDialog.this.cellTypeNamesArray[ChargerDialog.this.memoryValues[0]].startsWith("L")) {
                        ChargerDialog.this.btnStorage.setEnabled(true);
                        ChargerDialog.this.btnBalance.setEnabled(true);
                    }
                } else if (!ChargerDialog.this.isDuo && ChargerDialog.this.memoryValues[0] == 9) {
                    ChargerDialog.this.btnCharge.setEnabled(false);
                    ChargerDialog.this.btnStorage.setEnabled(false);
                    ChargerDialog.this.btnDischarge.setEnabled(false);
                    ChargerDialog.this.btnCycle.setEnabled(false);
                    ChargerDialog.this.btnBalance.setEnabled(false);
                    ChargerDialog.this.btnPower.setEnabled(true);
                    ChargerDialog.this.btnStop.setEnabled(false);
                }
            }
        });
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.character == '\r') {
                    ChargerDialog.this.combo.setEditable(false);
                    String changedProgramMemoryText = ChargerDialog.this.combo.getText().trim();
                    if (changedProgramMemoryText.contains(" - ")) {
                        changedProgramMemoryText = changedProgramMemoryText.substring(changedProgramMemoryText.lastIndexOf(" - ") + 3).trim();
                    } else if (changedProgramMemoryText.contains("CUSTOM")) {
                        changedProgramMemoryText = changedProgramMemoryText.substring(changedProgramMemoryText.lastIndexOf("CUSTOM") + 6).trim();
                    }
                    ChargerDialog.this.combo.setText(ChargerDialog.this.lastSelectedProgramMemoryIndex + Messages.getString((String)"GDE_MSGT2625") + changedProgramMemoryText);
                    ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_RED);
                    if (ChargerDialog.this.selectedProgramMemory != null) {
                        ChargerDialog.this.selectedProgramMemory.setName(changedProgramMemoryText);
                    }
                    ChargerDialog.this.btnEdit.setEnabled(false);
                    ChargerDialog.this.btnWrite.setEnabled(true);
                }
            }
        });
        this.btnCopy = new Button((Composite)this.grpProgramMemory, 0);
        this.btnCopy.setLayoutData((Object)new RowData(70, this.comboHeight));
        this.btnCopy.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnCopy.setText(Messages.getString((String)"GDE_MSGT2626"));
        this.btnCopy.setToolTipText(Messages.getString((String)"GDE_MSGT2627"));
        this.btnCopy.setEnabled(false);
        this.btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.selectedProgramMemory != null) {
                    ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_RED);
                    ChargerDialog.this.copiedProgramMemory = new ChargerMemory(ChargerDialog.this.selectedProgramMemory, ChargerDialog.this.isDuo);
                    String batteryType = new String(ChargerDialog.this.copiedProgramMemory.getName()).trim();
                    ChargerDialog.this.copiedProgramMemory.setName(batteryType + Messages.getString((String)"GDE_MSGT2620"));
                    short newIndex = ChargerDialog.this.addEntryMemoryHead(batteryType);
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, String.format("memoryHead use new index: %s", newIndex));
                    }
                    if (newIndex > 0) {
                        ChargerDialog.this.writeProgramMemory(newIndex, ChargerDialog.this.copiedProgramMemory, (short)21930);
                        ChargerDialog.this.copiedProgramMemory = null;
                        ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_BLACK);
                        ChargerDialog.this.combo.setItems(ChargerDialog.this.readProgramMemories());
                        ChargerDialog.this.combo.select(ChargerDialog.this.lastSelectedComboIndex + 1);
                        ChargerDialog.this.combo.notifyListeners(13, new Event());
                    }
                }
            }
        });
        this.btnEdit = new Button((Composite)this.grpProgramMemory, 0);
        this.btnEdit.setLayoutData((Object)new RowData(70, this.comboHeight));
        this.btnEdit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnEdit.setToolTipText(Messages.getString((String)"GDE_MSGT2630"));
        this.btnEdit.setText(Messages.getString((String)"GDE_MSGT2631"));
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChargerDialog.this.combo.setEditable(true);
                ChargerDialog.this.isComboSetEdit = true;
            }
        });
        this.btnWrite = new Button((Composite)this.grpProgramMemory, 0);
        this.btnWrite.setLayoutData((Object)new RowData(70, this.comboHeight));
        this.btnWrite.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnWrite.setToolTipText(Messages.getString((String)"GDE_MSGT2632"));
        this.btnWrite.setText(Messages.getString((String)"GDE_MSGT2633"));
        this.btnWrite.setEnabled(false);
        this.btnWrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.isComboSetEdit) {
                    Event evt = new Event();
                    evt.character = (char)13;
                    ChargerDialog.this.combo.notifyListeners(1, evt);
                    ChargerDialog.this.isComboSetEdit = false;
                    WaitTimer.delay((long)400L);
                }
                if (ChargerDialog.this.selectedProgramMemory != null) {
                    ChargerDialog.this.writeProgramMemory(ChargerDialog.this.lastSelectedProgramMemoryIndex, ChargerDialog.this.selectedProgramMemory, (short)21930);
                }
                ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_BLACK);
                String updatedItemText = ChargerDialog.this.getFormatedListEntry(ChargerDialog.this.lastSelectedComboIndex, ChargerDialog.this.selectedProgramMemory);
                String[] items = ChargerDialog.this.combo.getItems();
                items[((ChargerDialog)ChargerDialog.this).lastSelectedComboIndex] = updatedItemText;
                ChargerDialog.this.combo.setItems(items);
                ChargerDialog.this.combo.setText(updatedItemText);
                ChargerDialog.this.btnWrite.setEnabled(false);
            }
        });
        this.btnDelete = new Button((Composite)this.grpProgramMemory, 0);
        this.btnDelete.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnDelete.setToolTipText(Messages.getString((String)"GDE_MSGT2634"));
        this.btnDelete.setLayoutData((Object)new RowData(70, this.comboHeight));
        this.btnDelete.setText(Messages.getString((String)"GDE_MSGT2635"));
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChargerDialog.this.removeMemoryHead((byte)ChargerDialog.this.lastSelectedProgramMemoryIndex);
                ChargerDialog.this.combo.setForeground(((ChargerDialog)ChargerDialog.this).application.COLOR_BLACK);
                ChargerDialog.this.combo.setItems(ChargerDialog.this.readProgramMemories());
                ChargerDialog.this.combo.select(0);
                ChargerDialog.this.combo.notifyListeners(13, new Event());
            }
        });
        if (this.selectedProgramMemory != null) {
            this.memoryValues = this.selectedProgramMemory.getMemoryValues(this.memoryValues, this.isDuo);
        }
        this.memoryComposite = new Composite(mainMemoryComposite, 2048);
        this.memoryComposite.setLayout((Layout)new FillLayout(512));
        FormData fdMainComposite = new FormData();
        fdMainComposite.top = new FormAttachment(0, 80);
        fdMainComposite.bottom = new FormAttachment(0, this.isDuo || this.isDx ? 210 : 190);
        fdMainComposite.right = new FormAttachment(100, -10);
        fdMainComposite.left = new FormAttachment(0, 10);
        this.memoryComposite.setLayoutData((Object)fdMainComposite);
        this.memoryComposite.setBackground(this.application.COLOR_CANVAS_YELLOW);
        this.createBaseBatteryParameters();
        this.tabFolderProgrMem = new CTabFolder(mainMemoryComposite, 2048);
        this.tabFolderProgrMem.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        FormData fdTabFolderProgrMem = new FormData();
        fdTabFolderProgrMem.top = new FormAttachment((Control)this.memoryComposite, 6);
        fdTabFolderProgrMem.left = new FormAttachment(0, 10);
        fdTabFolderProgrMem.right = new FormAttachment(100, -10);
        this.tabFolderProgrMem.setLayoutData((Object)fdTabFolderProgrMem);
        this.tabFolderProgrMem.setSimple(false);
        this.createChargeTabItem();
        this.createDischargeTabItem();
        this.createStorageTabItem();
        this.createCycleTabItem();
        this.createOptionTabItem();
        this.tabFolderProgrMem.setSelection(0);
        this.updateMemoryParameterControls();
        this.grpRunProgram = new Group(mainMemoryComposite, 0);
        fdTabFolderProgrMem.bottom = new FormAttachment((Control)this.grpRunProgram, -5);
        this.grpRunProgram.setText(Messages.getString((String)"GDE_MSGT2685"));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.justify = true;
        rowLayout.fill = GDE.IS_WINDOWS | GDE.IS_OS_ARCH_ARM;
        this.grpRunProgram.setLayout((Layout)rowLayout);
        FormData fd_grpRunProgram = new FormData();
        fd_grpRunProgram.left = new FormAttachment(0, 10);
        fd_grpRunProgram.right = new FormAttachment(100, -120);
        fd_grpRunProgram.top = new FormAttachment(100, -65);
        fd_grpRunProgram.bottom = new FormAttachment(100, -5);
        this.grpRunProgram.setLayoutData((Object)fd_grpRunProgram);
        this.grpRunProgram.setToolTipText(Messages.getString((String)"GDE_MSGT2686"));
        this.btnCharge = new Button((Composite)this.grpRunProgram, 0);
        this.btnCharge.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnCharge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnCharge.setText(Messages.getString((String)"GDE_MSGT2687"));
        this.btnCharge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    ChargerDialog.this.startProgramExecution((byte)OperationLi.Charge.ordinal(), (byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1), ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    ChargerDialog.this.systemInfo = ChargerDialog.this.readInfo();
                    if (ChargerDialog.this.systemInfo != null && (ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnStorage = new Button((Composite)this.grpRunProgram, 0);
        this.btnStorage.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnStorage.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnStorage.setText(Messages.getString((String)"GDE_MSGT2688"));
        this.btnStorage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    ChargerDialog.this.startProgramExecution((byte)OperationLi.Storage.ordinal(), (byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1), ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    ChargerDialog.this.systemInfo = ChargerDialog.this.readInfo();
                    if (ChargerDialog.this.systemInfo != null && (ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnDischarge = new Button((Composite)this.grpRunProgram, 0);
        this.btnDischarge.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnDischarge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnDischarge.setText(Messages.getString((String)"GDE_MSGT2689"));
        this.btnDischarge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    byte operationIndex = ChargerDialog.this.cellTypeNamesArray[ChargerDialog.this.memoryValues[0]].startsWith("L") ? (byte)OperationLi.Discharge.ordinal() : (byte)OperationNiPb.Discharge.ordinal();
                    ChargerDialog.this.startProgramExecution(operationIndex, (byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1), ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    if ((ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnCycle = new Button((Composite)this.grpRunProgram, 0);
        this.btnCycle.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnCycle.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnCycle.setText(Messages.getString((String)"GDE_MSGT2690"));
        this.btnCycle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    byte operationIndex = ChargerDialog.this.cellTypeNamesArray[ChargerDialog.this.memoryValues[0]].startsWith("L") ? (byte)OperationLi.Cycle.ordinal() : (byte)OperationNiPb.Cycle.ordinal();
                    ChargerDialog.this.startProgramExecution(operationIndex, (byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1), ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    ChargerDialog.this.systemInfo = ChargerDialog.this.readInfo();
                    if (ChargerDialog.this.systemInfo != null && (ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnBalance = new Button((Composite)this.grpRunProgram, 0);
        this.btnBalance.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnBalance.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnBalance.setText(Messages.getString((String)"GDE_MSGT2691"));
        this.btnBalance.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    ChargerDialog.this.startProgramExecution((byte)OperationLi.Balance.ordinal(), (byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1), ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    ChargerDialog.this.systemInfo = ChargerDialog.this.readInfo();
                    if (ChargerDialog.this.systemInfo != null && (ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnPower = new Button((Composite)this.grpRunProgram, 0);
        this.btnPower.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnPower.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnPower.setText("Power");
        this.btnPower.setEnabled(false);
        this.btnPower.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()] >= 0) {
                    ChargerDialog.this.startProgramExecution((byte)0, (byte)0, ChargerDialog.this.memoryHeadIndex[ChargerDialog.this.combo.getSelectionIndex()]);
                    WaitTimer.delay((long)400L);
                    ChargerDialog.this.systemInfo = ChargerDialog.this.readInfo();
                    if (ChargerDialog.this.systemInfo != null && (ChargerDialog.this.systemInfo.getStatus() & 2) != 0) {
                        log.log(Level.WARNING, ChargerDialog.this.systemInfo.getStatusString());
                        ChargerDialog.this.application.openMessageDialog(ChargerDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE2604"));
                    } else {
                        ChargerDialog.this.startLogTransmission();
                        ChargerDialog.this.btnCharge.setEnabled(false);
                        ChargerDialog.this.btnStorage.setEnabled(false);
                        ChargerDialog.this.btnDischarge.setEnabled(false);
                        ChargerDialog.this.btnCycle.setEnabled(false);
                        ChargerDialog.this.btnBalance.setEnabled(false);
                        ChargerDialog.this.btnPower.setEnabled(false);
                        ChargerDialog.this.btnStop.setEnabled(true);
                        ChargerDialog.this.grpProgramMemory.setEnabled(false);
                        ChargerDialog.this.memoryComposite.setEnabled(false);
                        ChargerDialog.this.removeAllListeners();
                        ChargerDialog.this.device.open_closeCommPort();
                    }
                }
            }
        });
        this.btnStop = new Button((Composite)this.grpRunProgram, 0);
        this.btnStop.setLayoutData((Object)new RowData(85, this.comboHeight));
        this.btnStop.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnStop.setToolTipText(Messages.getString((String)"GDE_MSGT2692"));
        this.btnStop.setText(Messages.getString((String)"GDE_MSGT2693"));
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChargerDialog.this.device.open_closeCommPort();
                try {
                    ChargerDialog.this.usbPort.getData();
                    WaitTimer.delay((long)100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ChargerDialog.this.stopProgramExecution((byte)(ChargerDialog.this.application.getActiveChannelNumber() - 1));
                ChargerDialog.this.dialogShell.dispose();
            }
        });
        Button btnHelp = new Button(mainMemoryComposite, 0);
        FormData fd_btnHelp = new FormData();
        fd_btnHelp.width = GDE.IS_MAC ? 50 : 40;
        fd_btnHelp.height = GDE.IS_MAC ? 33 : 30;
        fd_btnHelp.bottom = new FormAttachment(100, -35);
        fd_btnHelp.right = new FormAttachment(100, -40);
        btnHelp.setLayoutData((Object)fd_btnHelp);
        btnHelp.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
        btnHelp.setToolTipText(Messages.getString((String)"GDE_MSGT2628"));
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChargerDialog.this.application.openHelpDialog("iCharger", "HelpInfo.html");
            }
        });
        Button btnClose = new Button(mainMemoryComposite, 0);
        FormData fd_btnCancel = new FormData();
        fd_btnCancel.height = GDE.IS_MAC ? 33 : 30;
        fd_btnCancel.bottom = new FormAttachment(100, -5);
        fd_btnCancel.right = new FormAttachment(100, -10);
        fd_btnCancel.left = new FormAttachment(100, -110);
        btnClose.setLayoutData((Object)fd_btnCancel);
        btnClose.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        btnClose.setText(Messages.getString((String)"GDE_MSGT2694"));
        btnClose.setToolTipText(Messages.getString((String)"GDE_MSGI2610"));
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChargerDialog.this.dialogShell.dispose();
            }
        });
        CTabItem tbtmSystem = new CTabItem(mainTabFolder, 0);
        tbtmSystem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        tbtmSystem.setText(Messages.getString((String)"GDE_MSGI2605"));
        Composite mainSystemComposite = new Composite((Composite)mainTabFolder, 0);
        tbtmSystem.setControl((Control)mainSystemComposite);
        mainSystemComposite.setLayout((Layout)new FormLayout());
        ScrolledComposite sysScrolledComposite = new ScrolledComposite(mainSystemComposite, 2816);
        FormData fd_scrolledComposite = new FormData();
        fd_scrolledComposite.top = new FormAttachment(0);
        fd_scrolledComposite.bottom = new FormAttachment(100, -60);
        fd_scrolledComposite.right = new FormAttachment(100);
        fd_scrolledComposite.left = new FormAttachment(0);
        sysScrolledComposite.setLayoutData((Object)fd_scrolledComposite);
        sysScrolledComposite.setLayout((Layout)new FillLayout());
        this.sysComposite = new Composite((Composite)sysScrolledComposite, 0);
        sysScrolledComposite.setExpandHorizontal(true);
        sysScrolledComposite.setContent((Control)this.sysComposite);
        sysScrolledComposite.setMinSize(this.sysComposite.computeSize(-1, -1));
        this.sysComposite.setSize(800, GDE.IS_WINDOWS ? 1150 : 1300);
        this.sysComposite.setLayout((Layout)new RowLayout(512));
        this.grpTemperature = new Group(this.sysComposite, 0);
        this.grpTemperature.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpTemperature.setText(Messages.getString((String)"GDE_MSGI2603"));
        this.grpTemperature.setLayout((Layout)new RowLayout(512));
        this.systemParameters[0] = new ParameterConfigControl((Composite)this.grpTemperature, this.systemValues, 0, Messages.getString((String)"GDE_MSGI2604"), 175, "Celsius, Fahrenheit", 280, new String[]{"\u00b0C", "\u00b0F"}, 50, 200);
        this.systemParameters[1] = new ParameterConfigControl((Composite)this.grpTemperature, this.systemValues, 1, "%3.1f", Messages.getString((String)"GDE_MSGI2606"), 175, "65\u00b0C - 80\u00b0C", 280, true, 50, 200, 650, 800, -650, false);
        this.systemParameters[2] = new ParameterConfigControl((Composite)this.grpTemperature, this.systemValues, 2, "%3.1f", Messages.getString((String)"GDE_MSGI2608"), 175, "5\u00b0C - 20\u00b0C", 280, true, 50, 200, 50, 200, -50, false);
        this.grpTemperature.addListener(13, this.systemParameterChangeListener);
        this.grpTemperature.layout();
        this.grpFans = new Group(this.sysComposite, 0);
        this.grpFans.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpFans.setText(Messages.getString((String)"GDE_MSGI2609"));
        this.grpFans.setLayout((Layout)new RowLayout(512));
        this.systemParameters[3] = new ParameterConfigControl((Composite)this.grpFans, this.systemValues, 3, "%3.1f", Messages.getString((String)"GDE_MSGI2611"), 175, "30\u00b0C - 50\u00b0C", 280, true, 50, 200, 300, 500, -300, false);
        this.systemParameters[4] = new ParameterConfigControl((Composite)this.grpFans, this.systemValues, 4, "", Messages.getString((String)"GDE_MSGI2612"), 175, "0 Min - 10 Min", 280, true, 50, 200, 0, 10, 0, false);
        this.grpFans.addListener(13, this.systemParameterChangeListener);
        this.grpFans.layout();
        this.grpBeepTone = new Group(this.sysComposite, 0);
        this.grpBeepTone.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpBeepTone.setText(Messages.getString((String)"GDE_MSGI2613"));
        this.grpBeepTone.setLayout((Layout)new RowLayout(512));
        this.systemParameters[5] = new ParameterConfigControl((Composite)this.grpBeepTone, this.systemValues, 5, "", Messages.getString((String)"GDE_MSGI2614"), 175, "(off)0 - 10", 280, true, 50, 200, 0, 10, 0, false);
        this.systemParameters[6] = new ParameterConfigControl((Composite)this.grpBeepTone, this.systemValues, 6, "", Messages.getString((String)"GDE_MSGI2615"), 175, "(off)0 - 10", 280, true, 50, 200, 0, 10, 0, false);
        this.systemParameters[7] = new ParameterConfigControl((Composite)this.grpBeepTone, this.systemValues, 7, "", Messages.getString((String)"GDE_MSGI2616"), 175, "(off)0 - 10", 280, true, 50, 200, 0, 10, 0, false);
        this.systemParameters[8] = new ParameterConfigControl((Composite)this.grpBeepTone, this.systemValues, 8, "", Messages.getString((String)"GDE_MSGI2617"), 175, "(off)0 - 10", 280, true, 50, 200, 0, 10, 0, false);
        this.systemParameters[9] = new ParameterConfigControl((Composite)this.grpBeepTone, this.systemValues, 9, Messages.getString((String)"GDE_MSGI2618"), 175, "5x, 30s, 3min, " + Messages.getString((String)"GDE_MSGI2620"), 280, new String[]{"5x", "30S", "3Min", Messages.getString((String)"GDE_MSGI2620")}, 50, 200);
        this.grpBeepTone.addListener(13, this.systemParameterChangeListener);
        this.grpBeepTone.layout();
        this.grpLcdScreen = new Group(this.sysComposite, 0);
        this.grpLcdScreen.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpLcdScreen.setText(Messages.getString((String)"GDE_MSGI2621"));
        this.grpLcdScreen.setLayout((Layout)new RowLayout(512));
        this.systemParameters[10] = new ParameterConfigControl((Composite)this.grpLcdScreen, this.systemValues, 10, "", Messages.getString((String)"GDE_MSGI2622"), 175, "0 - 32", 280, true, 50, 200, 0, 32, 0, false);
        this.systemParameters[11] = new ParameterConfigControl((Composite)this.grpLcdScreen, this.systemValues, 11, "", Messages.getString((String)"GDE_MSGI2623"), 175, "0 - 32", 280, true, 50, 200, 0, 32, 0, false);
        this.grpLcdScreen.addListener(13, this.systemParameterChangeListener);
        this.grpLcdScreen.layout();
        this.grpLanguage = new Group(this.sysComposite, 0);
        this.grpLanguage.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpLanguage.setText("Language");
        this.grpLanguage.setLayout((Layout)new RowLayout(512));
        this.systemParameters[27] = new ParameterConfigControl((Composite)this.grpLanguage, this.systemValues, 27, "Language", 175, "English, Deutsch", 280, new String[]{"en", "de"}, 50, 200);
        this.grpLanguage.addListener(13, this.systemParameterChangeListener);
        this.grpLanguage.layout();
        this.btnSystemSave = new Button(mainSystemComposite, 0);
        FormData fd_btnSave = new FormData();
        fd_btnSave.bottom = new FormAttachment(100, -10);
        fd_btnSave.left = new FormAttachment(0, 100);
        fd_btnSave.right = new FormAttachment(0, 300);
        this.btnSystemSave.setLayoutData((Object)fd_btnSave);
        this.btnSystemSave.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.btnSystemSave.setText(Messages.getString((String)"GDE_MSGI2624"));
        this.btnSystemSave.setToolTipText(Messages.getString((String)"GDE_MSGI2625"));
        this.btnSystemSave.setEnabled(false);
        this.btnSystemSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ChargerDialog.this.btnSystemSave.setEnabled(!ChargerDialog.this.writeSystemMemory(ChargerDialog.this.isDuo));
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, e1.getMessage(), e);
                }
            }
        });
        Button btnSystemClose = new Button(mainSystemComposite, 0);
        FormData fd_btnSystemClose = new FormData();
        fd_btnSystemClose.bottom = new FormAttachment(100, -10);
        fd_btnSystemClose.left = new FormAttachment(100, -300);
        fd_btnSystemClose.right = new FormAttachment(100, -100);
        btnSystemClose.setLayoutData((Object)fd_btnSystemClose);
        btnSystemClose.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        btnSystemClose.setText(Messages.getString((String)"GDE_MSGT2694"));
        btnSystemClose.setToolTipText(Messages.getString((String)"GDE_MSGI2610"));
        btnSystemClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChargerDialog.this.dialogShell.dispose();
            }
        });
        this.updateSystemParameterControls();
    }

    private void createGrpDuoInputPowerLimits() {
        this.grpDuoInputPowerLimits = new Group(this.sysComposite, 0);
        this.grpDuoInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpDuoInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2626"));
        this.grpDuoInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.grpDuoInputPowerLimits.setBackground(this.application.COLOR_CANVAS_YELLOW);
        this.systemParameters[17] = new ParameterConfigControl((Composite)this.grpDuoInputPowerLimits, this.systemValues, 17, "", 175, Messages.getString((String)"GDE_MSGI2647"), 280, new String[]{"DC", "Bat"}, 50, 200);
        this.grpDuoInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpDcInputPowerLimits = new Group((Composite)this.grpDuoInputPowerLimits, 0);
        this.grpDcInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpDcInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2635"));
        this.grpDcInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.systemParameters[28] = new ParameterConfigControl((Composite)this.grpDcInputPowerLimits, this.systemValues, 28, "%3.1f", Messages.getString((String)"GDE_MSGI2631"), 175, String.format("%dV - %dV", this.device.getDcInputVoltMin() / 10, this.device.getDcInputVoltMax() / 10), 280, true, 50, 200, this.device.getDcInputVoltMin(), this.device.getDcInputVoltMax(), -1 * this.device.getDcInputVoltMin() / 10, false);
        this.systemParameters[29] = new ParameterConfigControl((Composite)this.grpDcInputPowerLimits, this.systemValues, 29, "%3.1f", Messages.getString((String)"GDE_MSGI2632"), 175, String.format("1A - %dA", this.device.getDcInputCurrentMax() / 10), 280, true, 50, 200, 10, this.device.getDcInputCurrentMax(), -1, false);
        this.grpDcInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpBatInputPowerLimits = new Group((Composite)this.grpDuoInputPowerLimits, 0);
        this.grpBatInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpBatInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2636"));
        this.grpBatInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.systemParameters[30] = new ParameterConfigControl((Composite)this.grpBatInputPowerLimits, this.systemValues, 30, "%3.1f", Messages.getString((String)"GDE_MSGI2631"), 175, String.format("%dV - %dV", this.device.getDcInputVoltMin() / 10, this.device.getDcInputVoltMax() / 10), 280, true, 50, 200, this.device.getDcInputVoltMin(), this.device.getDcInputVoltMax(), -1 * this.device.getDcInputVoltMin() / 10, false);
        this.systemParameters[31] = new ParameterConfigControl((Composite)this.grpBatInputPowerLimits, this.systemValues, 31, "%3.1f", Messages.getString((String)"GDE_MSGI2632"), 175, String.format("1A - %dA", this.device.getDcInputCurrentMax() / 10), 280, true, 50, 200, 10, this.device.getDcInputCurrentMax(), -1, false);
        this.systemParameters[32] = new ParameterConfigControl((Composite)this.grpBatInputPowerLimits, this.systemValues, 32, Messages.getString((String)"GDE_MSGT2674"), 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.grpBatInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpDuoRegInputPowerLimits = new Group((Composite)this.grpBatInputPowerLimits, 0);
        this.grpDuoRegInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpDuoRegInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2634"));
        this.grpDuoRegInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.grpDuoRegInputPowerLimits.setBackground(this.application.COLOR_GREY);
        this.grpDuoRegInputPowerLimits.setEnabled(this.systemValues[32] == 1);
        this.systemParameters[33] = new ParameterConfigControl((Composite)this.grpDuoRegInputPowerLimits, this.systemValues, 33, "%3.1f", Messages.getString((String)"GDE_MSGI2631"), 175, String.format("%dV - %dV", this.device.getRegInputVoltMin() / 10, this.device.getRegInputVoltMax() / 10), 280, true, 50, 200, this.device.getRegInputVoltMin(), this.device.getRegInputVoltMax(), -1 * this.device.getRegInputVoltMin() / 10, false);
        this.systemParameters[34] = new ParameterConfigControl((Composite)this.grpDuoRegInputPowerLimits, this.systemValues, 34, "%3.1f", Messages.getString((String)"GDE_MSGI2632"), 175, String.format("1A - %dA", this.device.getDcInputCurrentMax() / 10), 280, true, 50, 200, 10, this.device.getDcInputCurrentMax(), -1, false);
        this.systemParameters[35] = new ParameterConfigControl((Composite)this.grpDuoRegInputPowerLimits, this.systemValues, 35, "", Messages.getString((String)"GDE_MSGI2638"), 175, "(ingnore)0Ah - 999900Ah", 280, true, 50, 200, 0, 9999, 0, false);
        this.grpDuoRegInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpDuoInputPowerLimits.layout();
    }

    private void createGrpInputDischargePowerLimits() {
        this.grpInputDischargePowerLimits = new Group(this.sysComposite, 0);
        this.grpInputDischargePowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpInputDischargePowerLimits.setText(Messages.getString((String)"GDE_MSGI2627"));
        this.grpInputDischargePowerLimits.setLayout((Layout)new RowLayout(512));
        this.grpInputDischargePowerLimits.setBackground(this.application.COLOR_CANVAS_YELLOW);
        this.systemParameters[17] = new ParameterConfigControl((Composite)this.grpInputDischargePowerLimits, this.systemValues, 17, "", Messages.getString((String)"GDE_MSGI2628"), 175, "0 - 3", 280, true, 50, 200, 0, 3, 0, false);
        if (!this.isDx) {
            this.systemParameters[18] = new ParameterConfigControl((Composite)this.grpInputDischargePowerLimits, this.systemValues, 18, "", Messages.getString((String)"GDE_MSGI2629"), 175, String.format("5W - %dW", this.device.getDischargePowerMax()[0]), 280, true, 50, 200, 5, this.device.getDischargePowerMax()[0], -5, false);
        }
        this.grpInputDischargePowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpInputPowerLimits = new Group((Composite)this.grpInputDischargePowerLimits, 0);
        this.grpInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2630"));
        this.grpInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.systemParameters[19] = new ParameterConfigControl((Composite)this.grpInputPowerLimits, this.systemValues, 19, "%3.1f", Messages.getString((String)"GDE_MSGI2631"), 175, String.format("%dV - %dV", this.device.getDcInputVoltMin() / 10, this.device.getDcInputVoltMax() / 10), 280, true, 50, 200, this.device.getDcInputVoltMin(), this.device.getDcInputVoltMax(), -1 * this.device.getDcInputVoltMin() / 10, false);
        this.systemParameters[20] = new ParameterConfigControl((Composite)this.grpInputPowerLimits, this.systemValues, 20, "%3.1f", Messages.getString((String)"GDE_MSGI2632"), 175, String.format("1A - %dA", this.device.getDcInputCurrentMax() / 10), 280, true, 50, 200, 10, this.device.getDcInputCurrentMax(), -1, false);
        this.systemParameters[21] = new ParameterConfigControl((Composite)this.grpInputPowerLimits, this.systemValues, 21, "", Messages.getString((String)"GDE_MSGI2633"), 175, String.format("5W - %dW", this.device.getDeviceChargePowerMax()), 280, true, 50, 200, 5, this.device.getDeviceChargePowerMax(), -5, false);
        this.systemParameters[22] = new ParameterConfigControl((Composite)this.grpInputPowerLimits, this.systemValues, 22, Messages.getString((String)"GDE_MSGT2674"), 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.grpInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpRegInputPowerLimits = new Group((Composite)this.grpInputPowerLimits, 0);
        this.grpRegInputPowerLimits.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpRegInputPowerLimits.setText(Messages.getString((String)"GDE_MSGI2634"));
        this.grpRegInputPowerLimits.setLayout((Layout)new RowLayout(512));
        this.grpRegInputPowerLimits.setBackground(this.application.COLOR_GREY);
        this.grpRegInputPowerLimits.setEnabled(this.systemValues[22] == 1);
        this.systemParameters[23] = new ParameterConfigControl((Composite)this.grpRegInputPowerLimits, this.systemValues, 23, "%3.1f", Messages.getString((String)"GDE_MSGI2631"), 175, String.format("%dV - %dV", this.device.getRegInputVoltMin() / 10, this.device.getRegInputVoltMax() / 10), 280, true, 50, 200, this.device.getRegInputVoltMin(), this.device.getRegInputVoltMax(), -1 * this.device.getRegInputVoltMin() / 10, false);
        this.systemParameters[24] = new ParameterConfigControl((Composite)this.grpRegInputPowerLimits, this.systemValues, 24, "%3.1f", Messages.getString((String)"GDE_MSGI2632"), 175, String.format("1A - %dA", this.device.getDcInputCurrentMax() / 10), 280, true, 50, 200, 10, this.device.getDcInputCurrentMax(), -1, false);
        this.systemParameters[25] = new ParameterConfigControl((Composite)this.grpRegInputPowerLimits, this.systemValues, 25, "", Messages.getString((String)"GDE_MSGI2633"), 175, String.format("5W - %dW", this.device.getChargePowerMax()[0]), 280, true, 50, 200, 5, this.device.getChargePowerMax()[0], -5, false);
        this.systemParameters[26] = new ParameterConfigControl((Composite)this.grpRegInputPowerLimits, this.systemValues, 26, "", Messages.getString((String)"GDE_MSGI2638"), 175, "(ignore)0Ah - 999900Ah", 280, true, 50, 200, 0, 999900, 0, false);
        this.grpRegInputPowerLimits.addListener(13, this.systemParameterChangeListener);
        this.grpInputDischargePowerLimits.layout();
    }

    private void createGrpChargeDischargePower() {
        this.grpChargeDischargePower = new Group(this.sysComposite, 0);
        this.grpChargeDischargePower.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpChargeDischargePower.setText(Messages.getString((String)"GDE_MSGI2639"));
        this.grpChargeDischargePower.setLayout((Layout)new RowLayout(512));
        this.systemParameters[12] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 12, "", Messages.getString((String)"GDE_MSGI2640", (Object[])new String[]{Messages.getString((String)"GDE_MSGI2645").split(",")[1]}), 175, String.format("5W - %dW", this.device.getChargePowerMax()[0]), 280, true, 50, 200, 5, this.device.getChargePowerMax()[0], -5, false);
        this.systemParameters[14] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 14, "", Messages.getString((String)"GDE_MSGI2642", (Object[])new String[]{Messages.getString((String)"GDE_MSGI2645").split(",")[1]}), 175, String.format("5W - %dW", this.device.getDischargePowerMax()[0]), 280, true, 50, 200, 5, this.device.getDischargePowerMax()[0], -5, false);
        this.systemParameters[16] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 16, Messages.getString((String)"GDE_MSGI2644"), 175, Messages.getString((String)"GDE_MSGI2645"), 280, Messages.getString((String)"GDE_MSGI2645").split(","), 50, 200);
        this.systemParameters[13] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 13, "", Messages.getString((String)"GDE_MSGI2640", (Object[])new String[]{Messages.getString((String)"GDE_MSGI2645").split(",")[2]}), 175, String.format("5W - %dW", this.device.getChargePowerMax()[1]), 280, true, 50, 200, 5, this.device.getChargePowerMax()[1], -5, false);
        this.systemParameters[15] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 15, "", Messages.getString((String)"GDE_MSGI2642", (Object[])new String[]{Messages.getString((String)"GDE_MSGI2645").split(",")[2]}), 175, String.format("5W - %dW", this.device.getDischargePowerMax()[1]), 280, true, 50, 200, 5, this.device.getDischargePowerMax()[1], -5, false);
        if (this.isDx) {
            this.systemParameters[36] = new ParameterConfigControl((Composite)this.grpChargeDischargePower, this.systemValues, 36, Messages.getString((String)"GDE_MSGT2678"), 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        }
        this.grpChargeDischargePower.addListener(13, this.systemParameterChangeListener);
        this.grpChargeDischargePower.layout();
    }

    private void updateSystemParameterControls() {
        if (this.isDuo) {
            if (this.grpInputDischargePowerLimits != null && !this.grpInputDischargePowerLimits.isDisposed()) {
                this.grpInputDischargePowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpRegInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpInputDischargePowerLimits.dispose();
            }
            if (this.grpDuoInputPowerLimits == null || this.grpDuoInputPowerLimits.isDisposed()) {
                this.createGrpDuoInputPowerLimits();
            }
            if (this.grpChargeDischargePower == null || this.grpChargeDischargePower.isDisposed()) {
                this.createGrpChargeDischargePower();
            }
        } else if (this.isDx) {
            if (this.grpDuoInputPowerLimits != null && !this.grpDuoInputPowerLimits.isDisposed()) {
                this.grpDuoInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDcInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpBatInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDuoRegInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDuoInputPowerLimits.dispose();
            }
            if (this.grpInputDischargePowerLimits == null || this.grpInputDischargePowerLimits.isDisposed()) {
                this.createGrpInputDischargePowerLimits();
            }
            if (this.grpChargeDischargePower == null || this.grpChargeDischargePower.isDisposed()) {
                this.createGrpChargeDischargePower();
            }
        } else {
            if (this.grpDuoInputPowerLimits != null && !this.grpDuoInputPowerLimits.isDisposed()) {
                this.grpDuoInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDcInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpBatInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDuoRegInputPowerLimits.removeListener(13, this.systemParameterChangeListener);
                this.grpDuoInputPowerLimits.dispose();
            }
            if (this.grpChargeDischargePower != null && !this.grpChargeDischargePower.isDisposed()) {
                this.grpChargeDischargePower.removeListener(13, this.systemParameterChangeListener);
                this.grpChargeDischargePower.dispose();
            }
            if (this.grpInputDischargePowerLimits == null || this.grpInputDischargePowerLimits.isDisposed()) {
                this.createGrpInputDischargePowerLimits();
            }
        }
        for (int i = 0; i < this.systemParameters.length; ++i) {
            if (this.systemParameters[i] == null) continue;
            this.systemParameters[i].setSliderSelection(this.systemValues[i]);
        }
    }

    private void createBaseBatteryParameters() {
        this.memoryParameters[0] = new ParameterConfigControl(this.memoryComposite, this.memoryValues, 0, Messages.getString((String)"GDE_MSGT2636"), 175, this.cellTypeNames, 280, this.cellTypeNamesArray, 50, 200);
        this.memoryParameters[0].getSlider().setVisible(false);
        int maxNumberCells = this.device.getNumberOfLithiumCells();
        this.memoryParameters[1] = new ParameterConfigControl(this.memoryComposite, this.memoryValues, 1, "", Messages.getString((String)"GDE_MSGT2637"), 175, "0(auto) - " + maxNumberCells, 280, false, 50, 200, 0, maxNumberCells);
        this.memoryParameters[2] = new ParameterConfigControl(this.memoryComposite, this.memoryValues, 2, "", Messages.getString((String)"GDE_MSGT2638"), 175, "0(auto) ~ 999900 mAh", 280, true, 50, 200, 0, 999900, 0, true);
        if (this.isDuo || this.isDx) {
            this.memoryParameters[47] = new ParameterConfigControl(this.memoryComposite, this.memoryValues, 47, Messages.getString((String)"GDE_MSGI2649"), 175, "asynchronous, synchronous", 280, new String[]{"async", "sync"}, 50, 200);
        }
        this.memoryComposite.layout();
        this.memoryComposite.addListener(13, this.memoryParameterChangeListener);
    }

    private void createChargeTabItem() {
        this.tbtmCharge = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmCharge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmCharge.setText(Messages.getString((String)"GDE_MSGT2639"));
        ScrolledComposite scrolledChargeComposite = new ScrolledComposite((Composite)this.tabFolderProgrMem, 2816);
        this.tbtmCharge.setControl((Control)scrolledChargeComposite);
        scrolledChargeComposite.setExpandHorizontal(true);
        scrolledChargeComposite.setLayout((Layout)new FillLayout(512));
        this.chargeComposite = new Composite((Composite)scrolledChargeComposite, 0);
        this.chargeComposite.setLayout((Layout)new RowLayout(512));
        scrolledChargeComposite.setContent((Control)this.chargeComposite);
        scrolledChargeComposite.setMinSize(this.chargeComposite.computeSize(-1, -1));
        this.chargeComposite.setSize(750, GDE.IS_WINDOWS ? 880 : 1050);
        this.memoryParameters[3] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 3, "%4.2f", Messages.getString((String)"GDE_MSGT2640"), 175, String.format("0.05 ~ %d A", this.device.getChargeCurrentMax4Channel() / 10), 280, true, 50, 200, 5, this.device.getChargeCurrentMax4Channel() * 10, -5, false);
        this.memoryParameters[4] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 4, Messages.getString((String)"GDE_MSGT2641"), 175, String.join((CharSequence)", ", ChargerMemory.LiMode.VALUES), 280, ChargerMemory.LiMode.VALUES, 50, 200);
        this.memoryParameters[5] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 5, Messages.getString((String)"GDE_MSGT2642"), 175, String.join((CharSequence)", ", ChargerMemory.BalancerLiSetup.VALUES), 280, ChargerMemory.BalancerLiSetup.VALUES, 50, 200);
        this.memoryParameters[6] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 6, "", Messages.getString((String)"GDE_MSGT2643"), 175, "10% - 50%", 280, true, 50, 200, 10, 50, -10, false);
        if (this.memoryValues[5] == 0) {
            this.memoryParameters[6].setEnabled(false);
        }
        this.memoryParameters[7] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 7, "%4.3f", Messages.getString((String)"GDE_MSGT2644"), 175, "4.000 V - 4.200 V", 280, true, 50, 200, 4000, 4350, 4200, -4000, false);
        this.memoryParameters[26] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 26, "", Messages.getString((String)"GDE_MSGT2645"), 175, "1 mV - 20 mV", 280, true, 50, 200, 1, 20, -1, false);
        this.memoryParameters[27] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 27, "", Messages.getString((String)"GDE_MSGT2646"), 175, "0 Min - 20 Min", 280, true, 50, 200, 0, 20, 0, false);
        this.memoryParameters[28] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 28, Messages.getString((String)"GDE_MSGT2647"), 175, Messages.getString((String)"GDE_MSGT2648"), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGT2650")}, 50, 200);
        this.memoryParameters[29] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 29, Messages.getString((String)"GDE_MSGT2651"), 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.memoryParameters[30] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 30, "", Messages.getString((String)"GDE_MSGT2652"), 175, "20mA - 1000mA", 280, true, 50, 200, 20, 1000, -20, false);
        this.memoryParameters[31] = new ParameterConfigControl(this.chargeComposite, this.memoryValues, 31, "", Messages.getString((String)"GDE_MSGT2653"), 175, "1 Min - 999 Min", 280, true, 50, 200, 1, 999, -1, false);
        this.chargeComposite.addListener(13, this.memoryParameterChangeListener);
        this.grpChargeSaftySettings = new Group(this.chargeComposite, 0);
        this.grpChargeSaftySettings.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpChargeSaftySettings.setText(Messages.getString((String)"GDE_MSGT2654"));
        this.grpChargeSaftySettings.setBackground(this.application.COLOR_WHITE);
        this.grpChargeSaftySettings.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[8] = new ParameterConfigControl((Composite)this.grpChargeSaftySettings, this.memoryValues, 8, "", Messages.getString((String)"GDE_MSGT2655"), 175, "20\u00b0C - 80\u00b0C", 280, true, 50, 200, 20, 80, -20, false);
        this.memoryParameters[9] = new ParameterConfigControl((Composite)this.grpChargeSaftySettings, this.memoryValues, 9, "", Messages.getString((String)"GDE_MSGT2656"), 175, "50% - 200%", 280, true, 50, 200, 50, 200, -50, false);
        this.memoryParameters[10] = new ParameterConfigControl((Composite)this.grpChargeSaftySettings, this.memoryValues, 10, "", Messages.getString((String)"GDE_MSGT2657"), 175, "0(OFF) - 9999 Min", 280, true, 50, 200, 0, 9999, 0, false);
        this.grpChargeSaftySettings.addListener(13, this.memoryParameterChangeListener);
        this.grpBalancerSettings = new Group(this.chargeComposite, 0);
        this.grpBalancerSettings.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpBalancerSettings.setText(Messages.getString((String)"GDE_MSGT2658"));
        this.grpBalancerSettings.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[11] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 11, Messages.getString((String)"GDE_MSGT2659"), 175, String.join((CharSequence)", ", ChargerMemory.BalancerSpeed.VALUES), 280, ChargerMemory.BalancerSpeed.VALUES, 50, 200);
        this.memoryParameters[12] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 12, Messages.getString((String)"GDE_MSGT2660"), 175, String.join((CharSequence)", ", ChargerMemory.BalancerStart.VALUES), 280, ChargerMemory.BalancerStart.VALUES, 50, 200);
        this.memoryParameters[13] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 13, "", Messages.getString((String)"GDE_MSGT2661"), 175, "1 mV - 10 mV", 280, true, 50, 200, 1, 10, -1, false);
        this.memoryParameters[14] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2662"), 175, "1 mV - 50 mV", 280, true, 50, 200, 1, 50, -1, false);
        this.memoryParameters[15] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 15, "", Messages.getString((String)"GDE_MSGT2663"), 175, "0 mV - 50 mV", 280, true, 50, 200, 0, 50, 0, false);
        this.memoryParameters[16] = new ParameterConfigControl((Composite)this.grpBalancerSettings, this.memoryValues, 16, "", Messages.getString((String)"GDE_MSGT2664"), 175, "0 Min - 20 Min", 280, true, 50, 200, 0, 20, 0, false);
        this.grpBalancerSettings.addListener(13, this.memoryParameterChangeListener);
        this.grpAdvancedRestoreSettings = new Group(this.chargeComposite, 0);
        this.grpAdvancedRestoreSettings.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpAdvancedRestoreSettings.setText(Messages.getString((String)"GDE_MSGT2665"));
        this.grpAdvancedRestoreSettings.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[32] = new ParameterConfigControl((Composite)this.grpAdvancedRestoreSettings, this.memoryValues, 32, "%4.3f", Messages.getString((String)"GDE_MSGT2666"), 175, "0.500 - 2.500 V", 280, true, 50, 200, 500, 2500, -500, false);
        this.memoryParameters[33] = new ParameterConfigControl((Composite)this.grpAdvancedRestoreSettings, this.memoryValues, 33, "", Messages.getString((String)"GDE_MSGT2667"), 175, "1 Min - 5 Min", 280, true, 50, 200, 1, 5, -1, false);
        this.memoryParameters[34] = new ParameterConfigControl((Composite)this.grpAdvancedRestoreSettings, this.memoryValues, 34, "", Messages.getString((String)"GDE_MSGT2668"), 175, "20 mA - 500 mA", 280, true, 50, 200, 20, 500, -20, false);
        this.memoryParameters[35] = new ParameterConfigControl((Composite)this.grpAdvancedRestoreSettings, this.memoryValues, 35, Messages.getString((String)"GDE_MSGT2669"), 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.grpAdvancedRestoreSettings.addListener(13, this.memoryParameterChangeListener);
        this.chargeComposite.layout();
    }

    private void createDischargeTabItem() {
        this.tbtmDischarge = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmDischarge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmDischarge.setText(Messages.getString((String)"GDE_MSGT2670"));
        ScrolledComposite scrolledDischargeComposite = new ScrolledComposite((Composite)this.tabFolderProgrMem, 2816);
        this.tbtmDischarge.setControl((Control)scrolledDischargeComposite);
        scrolledDischargeComposite.setExpandHorizontal(true);
        scrolledDischargeComposite.setLayout((Layout)new FillLayout(512));
        this.dischargeComposite = new Composite((Composite)scrolledDischargeComposite, 0);
        this.dischargeComposite.setLayout((Layout)new RowLayout(512));
        scrolledDischargeComposite.setContent((Control)this.dischargeComposite);
        scrolledDischargeComposite.setMinSize(this.dischargeComposite.computeSize(-1, -1));
        this.dischargeComposite.setSize(750, GDE.IS_WINDOWS ? 480 : 580);
        this.memoryParameters[17] = new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 17, "%4.2f", Messages.getString((String)"GDE_MSGT2671"), 175, String.format("0.05 ~ %d A", this.device.getChargeCurrentMax4Channel() / 10), 280, true, 50, 200, 5, this.device.getChargeCurrentMax4Channel() * 10, -5, false);
        this.memoryParameters[18] = new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 18, "%4.3f", Messages.getString((String)"GDE_MSGT2672"), 175, "3.000 - 4.100 V", 280, true, 50, 200, 3000, 4100, -3000, false);
        this.memoryParameters[19] = new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 19, "", Messages.getString((String)"GDE_MSGT2673"), 175, "1% - 100%", 280, true, 50, 200, 1, 100, -1, false);
        this.memoryParameters[21] = new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 21, Messages.getString((String)"GDE_MSGT2675"), 175, Messages.getString((String)"GDE_MSGT2648"), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGT2650")}, 50, 200);
        this.memoryParameters[22] = new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 22, Messages.getString((String)"GDE_MSGT2676"), 175, Messages.getString((String)"GDE_MSGT2648"), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGT2650")}, 50, 200);
        this.dischargeComposite.addListener(13, this.memoryParameterChangeListener);
        this.grpDischargeSaftySettings = new Group(this.dischargeComposite, 0);
        this.grpDischargeSaftySettings.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.grpDischargeSaftySettings.setText(Messages.getString((String)"GDE_MSGT2654"));
        this.grpDischargeSaftySettings.setBackground(this.application.COLOR_WHITE);
        this.grpDischargeSaftySettings.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[23] = new ParameterConfigControl((Composite)this.grpDischargeSaftySettings, this.memoryValues, 23, "", Messages.getString((String)"GDE_MSGT2655"), 175, "20\u00b0C - 80\u00b0C", 280, true, 50, 200, 20, 80, -20, false);
        this.memoryParameters[24] = new ParameterConfigControl((Composite)this.grpDischargeSaftySettings, this.memoryValues, 24, "", Messages.getString((String)"GDE_MSGT2656"), 175, "50% - 200%", 280, true, 50, 200, 50, 200, -50, false);
        this.memoryParameters[25] = new ParameterConfigControl((Composite)this.grpDischargeSaftySettings, this.memoryValues, 25, "", Messages.getString((String)"GDE_MSGT2657"), 175, "0(OFF) - 9999 Min", 280, true, 50, 200, 0, 9999, 0, false);
        this.grpDischargeSaftySettings.addListener(13, this.memoryParameterChangeListener);
        this.memoryParameters[20] = this.isDuo || this.isDx ? new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 20, Messages.getString((String)"GDE_MSGT2674"), 175, String.format("%s, %s, %s", Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGI2652"), Messages.getString((String)"GDE_MSGI2653")), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGI2654"), Messages.getString((String)"GDE_MSGI2655")}, 50, 200) : new ParameterConfigControl(this.dischargeComposite, this.memoryValues, 20, Messages.getString((String)"GDE_MSGT2674"), 175, String.format("%s, %s", Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGI2652")), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGI2654")}, 50, 200);
        this.regToInputWarningLable = new CLabel(this.dischargeComposite, 0);
        this.regToInputWarningLable.setLayoutData((Object)new RowData(750, this.comboHeight));
        this.regToInputWarningLable.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.regToInputWarningLable.setText(Messages.getString((String)"GDE_MSGE2602"));
        boolean isToInput = this.memoryValues[20] == 1;
        this.regToInputWarningLable.setForeground(isToInput ? SWTResourceManager.getColor((int)3) : SWTResourceManager.getColor((int)22));
        this.regToInputWarningLable.setEnabled(isToInput);
        this.regToChannelSettings = new Group(this.dischargeComposite, 0);
        this.regToChannelSettings.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.regToChannelSettings.setText(Messages.getString((String)"GDE_MSGI2656"));
        this.regToChannelSettings.setBackground(this.application.COLOR_WHITE);
        this.regToChannelSettings.setLayout((Layout)new RowLayout(512));
        boolean isToChannel = this.memoryValues[20] == 2;
        this.regToChannelSettings.setEnabled(isToChannel);
        this.memoryParameters[50] = new ParameterConfigControl((Composite)this.regToChannelSettings, this.memoryValues, 50, Messages.getString((String)"GDE_MSGI2657"), 175, Messages.getString((String)"GDE_MSGI2658"), 280, Messages.getString((String)"GDE_MSGI2658").split(", "), 50, 200);
        this.memoryParameters[50].setEnabled(isToChannel);
        this.memoryParameters[51] = new ParameterConfigControl((Composite)this.regToChannelSettings, this.memoryValues, 51, "%.1f", Messages.getString((String)"GDE_MSGI2659"), 175, String.format("%.1fV - %.1fV", (double)this.device.getRegChannelVoltageLimits()[0] / 1000.0, (double)this.device.getRegChannelVoltageLimits()[1] / 1000.0), 280, true, 50, 200, this.device.getRegChannelVoltageLimits()[0] / 100, this.device.getRegChannelVoltageLimits()[1] / 100, 0, false);
        this.memoryParameters[51].setEnabled(isToChannel);
        this.memoryParameters[52] = new ParameterConfigControl((Composite)this.regToChannelSettings, this.memoryValues, 52, "%.2f", Messages.getString((String)"GDE_MSGI2660"), 175, String.format("%.2fA - %.2fA", (double)this.device.getRegChannelCurrentLimits()[0] / 100.0, (double)this.device.getRegChannelCurrentLimits()[1] / 100.0), 280, true, 50, 200, this.device.getRegChannelCurrentLimits()[0], this.device.getRegChannelCurrentLimits()[1], 0, false);
        this.memoryParameters[52].setEnabled(isToChannel);
        this.regToChannelSettings.addListener(13, this.memoryParameterChangeListener);
    }

    private void createStorageTabItem() {
        this.tbtmStorage = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmStorage.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmStorage.setText(Messages.getString((String)"GDE_MSGT2695"));
        this.storageComposite = new Composite((Composite)this.tabFolderProgrMem, 0);
        this.tbtmStorage.setControl((Control)this.storageComposite);
        this.storageComposite.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[36] = new ParameterConfigControl(this.storageComposite, this.memoryValues, 36, "%4.3f", Messages.getString((String)"GDE_MSGT2696"), 175, "3.700 - 3.900 V", 280, true, 50, 200, 3700, 3900, -3700, false);
        this.memoryParameters[37] = new ParameterConfigControl(this.storageComposite, this.memoryValues, 37, "", Messages.getString((String)"GDE_MSGT2697"), 175, "0mV - 200mV", 280, true, 50, 200, 0, 200, 0, false);
        this.memoryParameters[38] = new ParameterConfigControl(this.storageComposite, this.memoryValues, 38, Messages.getString((String)"GDE_MSGT2698"), 175, Messages.getString((String)"GDE_MSGT2648"), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGT2650")}, 50, 200);
        this.storageComposite.addListener(13, this.memoryParameterChangeListener);
    }

    private void createCycleTabItem() {
        this.tbtmCycle = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmCycle.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmCycle.setText(Messages.getString((String)"GDE_MSGT2681"));
        this.cycleComposite = new Composite((Composite)this.tabFolderProgrMem, 0);
        this.tbtmCycle.setControl((Control)this.cycleComposite);
        this.cycleComposite.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[39] = new ParameterConfigControl(this.cycleComposite, this.memoryValues, 39, Messages.getString((String)"GDE_MSGT2682"), 175, String.join((CharSequence)", ", ChargerMemory.CycleMode.VALUES), 280, ChargerMemory.CycleMode.VALUES, 50, 200);
        this.memoryParameters[40] = new ParameterConfigControl(this.cycleComposite, this.memoryValues, 40, "", Messages.getString((String)"GDE_MSGT2683"), 175, "1 - 99", 280, true, 50, 200, 1, 99, -1, false);
        this.memoryParameters[41] = new ParameterConfigControl(this.cycleComposite, this.memoryValues, 41, "", Messages.getString((String)"GDE_MSGT2684"), 175, "1 Min - 999 Min", 280, true, 50, 200, 1, 999, -1, false);
        this.cycleComposite.addListener(13, this.memoryParameterChangeListener);
    }

    private void createPowerTabItem() {
        this.tbtmPower = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmPower.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmPower.setText(Messages.getString((String)"GDE_MSGT2677"));
        this.powerComposite = new Composite((Composite)this.tabFolderProgrMem, 0);
        this.tbtmPower.setControl((Control)this.powerComposite);
        this.powerComposite.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[42] = new ParameterConfigControl(this.powerComposite, this.memoryValues, 42, "%3.1f", "Voltage", 175, "2.0 - 26.5 V", 280, true, 50, 200, 20, 265, -20, false);
        this.memoryParameters[43] = new ParameterConfigControl(this.powerComposite, this.memoryValues, 43, "%3.1f", "Current", 175, "1.0 - 30.0 A", 280, true, 50, 200, 10, 300, -10, false);
        this.memoryParameters[44] = new ParameterConfigControl(this.powerComposite, this.memoryValues, 44, "Lock", 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.memoryParameters[45] = new ParameterConfigControl(this.powerComposite, this.memoryValues, 45, "Auto start", 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.memoryParameters[46] = new ParameterConfigControl(this.powerComposite, this.memoryValues, 46, "Live update", 175, "off, on", 280, new String[]{"off", "on"}, 50, 200);
        this.powerComposite.layout();
        this.powerComposite.addListener(13, this.memoryParameterChangeListener);
    }

    private void createOptionTabItem() {
        this.tbtmOption = new CTabItem(this.tabFolderProgrMem, 0);
        this.tbtmOption.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.tbtmOption.setText(Messages.getString((String)"GDE_MSGI2648"));
        this.optionComposite = new Composite((Composite)this.tabFolderProgrMem, 0);
        this.tbtmOption.setControl((Control)this.optionComposite);
        this.optionComposite.setLayout((Layout)new RowLayout(512));
        this.memoryParameters[48] = new ParameterConfigControl(this.optionComposite, this.memoryValues, 48, "%3.1f", Messages.getString((String)"GDE_MSGI2650"), 175, "0.5 - 60.0 Sec", 280, true, 50, 200, 5, 600, -5, false);
        this.memoryParameters[49] = new ParameterConfigControl(this.optionComposite, this.memoryValues, 49, Messages.getString((String)"GDE_MSGI2651"), 175, Messages.getString((String)"GDE_MSGT2648"), 280, new String[]{Messages.getString((String)"GDE_MSGT2649"), Messages.getString((String)"GDE_MSGT2650")}, 50, 200);
        this.optionComposite.layout();
        this.optionComposite.addListener(13, this.memoryParameterChangeListener);
    }

    private void updateMemoryParameterControls() {
        try {
            int i;
            block129: {
                block122: {
                    boolean isToChannel;
                    boolean isToInput;
                    int i2;
                    block128: {
                        block127: {
                            block126: {
                                block125: {
                                    block124: {
                                        block123: {
                                            int maxNumberCells;
                                            if ((!this.isDuo || this.memoryValues[0] >= 8) && this.memoryValues[0] >= 9) break block122;
                                            int n = this.cellTypeNamesArray[this.memoryValues[0]].startsWith("L") ? this.device.getNumberOfLithiumCells() : (this.cellTypeNamesArray[this.memoryValues[0]].startsWith("N") ? ChargerMemory.getMaxCellsNi(this.device) : (maxNumberCells = this.cellTypeNamesArray[this.memoryValues[0]].startsWith("P") ? ChargerMemory.getMaxCellsPb(this.device) : 0));
                                            if (this.tbtmPower != null && !this.tbtmPower.isDisposed()) {
                                                this.powerComposite.removeListener(13, this.memoryParameterChangeListener);
                                                for (i2 = 42; i2 < 47; ++i2) {
                                                    this.memoryParameters[i2].dispose();
                                                }
                                                this.powerComposite.dispose();
                                                this.tbtmPower.dispose();
                                            }
                                            if (this.powerLabel != null && !this.powerLabel.isDisposed()) {
                                                this.powerLabel.dispose();
                                                this.createBaseBatteryParameters();
                                            }
                                            if (this.tbtmCharge == null || this.tbtmCharge.isDisposed()) {
                                                this.createChargeTabItem();
                                                this.grpRunProgram.setEnabled(true);
                                                this.tabFolderProgrMem.setSelection(0);
                                            }
                                            if (this.tbtmDischarge == null || this.tbtmDischarge.isDisposed()) {
                                                this.createDischargeTabItem();
                                            }
                                            if (this.tbtmCycle == null || this.tbtmCycle.isDisposed()) {
                                                this.createCycleTabItem();
                                            }
                                            if (this.tbtmOption == null || this.tbtmOption.isDisposed()) {
                                                this.createOptionTabItem();
                                            }
                                            this.memoryParameters[1].updateValueRange("0(auto) - " + maxNumberCells, 0, maxNumberCells, 0);
                                            this.memoryParameters[5].setEnabled(true);
                                            this.memoryParameters[6].setEnabled(this.memoryValues[5] != 0);
                                            this.memoryParameters[7].setEnabled(true);
                                            this.memoryParameters[7].getSlider().setEnabled(true);
                                            this.grpBalancerSettings.setEnabled(true);
                                            for (i2 = 11; i2 < 17; ++i2) {
                                                this.memoryParameters[i2].setEnabled(true);
                                            }
                                            if (!this.isDuo) break block123;
                                            switch (this.memoryValues[0]) {
                                                case 0: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                    this.memoryParameters[7].updateValueRange("4.2V (3.850 - 4.350V)", 3850, 4350, 4200, -3850);
                                                    break;
                                                }
                                                case 1: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                    this.memoryParameters[7].updateValueRange("4.1V (3.750 - 4.350V)", 3750, 4350, 4100, -3750);
                                                    break;
                                                }
                                                case 2: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                    this.memoryParameters[7].updateValueRange("3.3V (3.300 - 3.800 V", 3300, 3800, 3600, -3300);
                                                    break;
                                                }
                                                case 6: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.NiMode.VALUES);
                                                    this.memoryParameters[7].updateValueRange("1.9V (1.200 - 2.100 V", 1200, 2100, 2000, -1200);
                                                    break;
                                                }
                                                case 7: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                    this.memoryParameters[7].updateValueRange("4.35V (3.900 - 4.450V)", 3900, 4450, 4350, -3900);
                                                    break;
                                                }
                                                case 3: 
                                                case 4: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.NiMode.VALUES);
                                                    this.memoryParameters[5].setEnabled(false);
                                                    this.memoryParameters[7].setEnabled(false);
                                                    this.grpBalancerSettings.setEnabled(false);
                                                    for (i2 = 11; i2 < 17; ++i2) {
                                                        this.memoryParameters[i2].setEnabled(false);
                                                    }
                                                    break block124;
                                                }
                                                case 5: {
                                                    this.memoryParameters[4].updateTextFieldValues(ChargerMemory.PbMode.VALUES);
                                                    this.memoryParameters[5].setEnabled(false);
                                                    this.memoryParameters[7].setEnabled(false);
                                                    this.grpBalancerSettings.setEnabled(false);
                                                    for (i2 = 11; i2 < 17; ++i2) {
                                                        this.memoryParameters[i2].setEnabled(false);
                                                    }
                                                    break block124;
                                                }
                                                default: {
                                                    this.memoryParameters[7].setEnabled(false);
                                                    this.grpBalancerSettings.setEnabled(false);
                                                    break;
                                                }
                                            }
                                            break block124;
                                        }
                                        switch (this.memoryValues[0]) {
                                            case 0: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("4.2V (3.850 - 4.350V)", 3850, 4350, 4200, -3850);
                                                break;
                                            }
                                            case 1: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("4.1V (3.750 - 4.350V)", 3750, 4350, 4100, -3750);
                                                break;
                                            }
                                            case 2: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("3.3V (3.300 - 3.800 V", 3300, 3800, 3600, -3300);
                                                break;
                                            }
                                            case 3: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("4.35V (3.900 - 4.450V)", 3900, 4450, 4350, -3900);
                                                break;
                                            }
                                            case 4: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.LiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("2.85V (2.400 - 3.100 V", 2400, 3100, 2850, -2400);
                                                break;
                                            }
                                            case 7: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.NiMode.VALUES);
                                                this.memoryParameters[7].updateValueRange("1.9V (1.200 - 2.100 V", 1200, 2100, 2000, -1200);
                                                break;
                                            }
                                            case 5: 
                                            case 6: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.NiMode.VALUES);
                                                this.memoryParameters[5].setEnabled(false);
                                                this.memoryParameters[7].setEnabled(false);
                                                this.grpBalancerSettings.setEnabled(false);
                                                for (i2 = 11; i2 < 17; ++i2) {
                                                    this.memoryParameters[i2].setEnabled(false);
                                                }
                                                break;
                                            }
                                            case 8: {
                                                this.memoryParameters[4].updateTextFieldValues(ChargerMemory.PbMode.VALUES);
                                                this.memoryParameters[5].setEnabled(false);
                                                this.memoryParameters[7].setEnabled(false);
                                                this.grpBalancerSettings.setEnabled(false);
                                                for (i2 = 11; i2 < 17; ++i2) {
                                                    this.memoryParameters[i2].setEnabled(false);
                                                }
                                                break;
                                            }
                                            default: {
                                                this.memoryParameters[7].setEnabled(false);
                                                this.grpBalancerSettings.setEnabled(false);
                                                for (i2 = 11; i2 < 17; ++i2) {
                                                    this.memoryParameters[i2].setEnabled(false);
                                                }
                                            }
                                        }
                                    }
                                    this.memoryParameters[13].setEnabled(this.memoryValues[11] == 3);
                                    this.memoryParameters[14].setEnabled(this.memoryValues[11] == 3);
                                    this.memoryParameters[15].setEnabled(this.memoryValues[11] == 3);
                                    this.memoryParameters[16].setEnabled(this.memoryValues[11] == 3);
                                    this.memoryParameters[18].updateNameLabel(Messages.getString((String)"GDE_MSGT2672"));
                                    if (this.isDuo) {
                                        switch (this.memoryValues[0]) {
                                            case 0: {
                                                this.memoryParameters[18].updateValueRange("3.5V (3.000 - 4.100V)", 3000, 4100, -3000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 1: {
                                                this.memoryParameters[18].updateValueRange("3.5V (2.500 - 4.000V)", 2500, 4000, -2500);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 2: {
                                                this.memoryParameters[18].updateValueRange("2.5V (2.000 - 3.500V)", 2000, 3500, -2000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 3: 
                                            case 4: {
                                                this.memoryParameters[18].updateNameLabel(Messages.getString((String)"GDE_MSGT2619"));
                                                this.memoryParameters[18].updateValueRange("0.100 - 35.000V", 100, 35000, -100);
                                                this.memoryParameters[21].setEnabled(false);
                                                this.memoryParameters[22].setEnabled(false);
                                                break;
                                            }
                                            case 5: {
                                                this.memoryParameters[18].updateValueRange("1.8V (1.500 - 2.400V)", 1500, 2400, -1500);
                                                this.memoryParameters[21].setEnabled(false);
                                                this.memoryParameters[22].setEnabled(false);
                                                break;
                                            }
                                            case 6: {
                                                this.memoryParameters[18].updateValueRange("1.1V (0.900 - 1.600V)", 900, 1600, -900);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 7: {
                                                this.memoryParameters[18].updateValueRange("3.6V (3.000 - 4.250V)", 3000, 4250, -3000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                        }
                                    } else {
                                        switch (this.memoryValues[0]) {
                                            case 0: {
                                                this.memoryParameters[18].updateValueRange("3.5V (3.000 - 4.100V)", 3000, 4100, -3000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 1: {
                                                this.memoryParameters[18].updateValueRange("3.5V (2.500 - 4.000V)", 2500, 4000, -2500);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 2: {
                                                this.memoryParameters[18].updateValueRange("2.5V (2.000 - 3.500V)", 2000, 3500, -2000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 3: {
                                                this.memoryParameters[18].updateValueRange("3.6V (3.000 - 4.250V)", 3000, 4250, -3000);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 4: {
                                                this.memoryParameters[18].updateValueRange("1.8V (1.500 - 2.900V)", 1500, 2900, -1500);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 5: 
                                            case 6: {
                                                this.memoryParameters[18].updateNameLabel(Messages.getString((String)"GDE_MSGT2619"));
                                                this.memoryParameters[18].updateValueRange("0.100 - 35.000 V", 100, 35000, -100);
                                                this.memoryParameters[21].setEnabled(false);
                                                this.memoryParameters[22].setEnabled(false);
                                                break;
                                            }
                                            case 7: {
                                                this.memoryParameters[18].updateValueRange("1.1V (0.900 - 1.600V)", 900, 1600, -900);
                                                this.memoryParameters[21].setEnabled(true);
                                                this.memoryParameters[22].setEnabled(true);
                                                break;
                                            }
                                            case 8: {
                                                this.memoryParameters[18].updateValueRange("1.8V (1.500 - 2.400V)", 1500, 2400, -1500);
                                                this.memoryParameters[21].setEnabled(false);
                                                this.memoryParameters[22].setEnabled(false);
                                                break;
                                            }
                                        }
                                    }
                                    if (!this.isDuo) break block125;
                                    switch (this.memoryValues[0]) {
                                        default: {
                                            for (i2 = 26; i2 < 32; ++i2) {
                                                this.memoryParameters[i2].setEnabled(false);
                                            }
                                            break block126;
                                        }
                                        case 3: 
                                        case 4: {
                                            for (i2 = 26; i2 < 32; ++i2) {
                                                this.memoryParameters[i2].setEnabled(true);
                                            }
                                            break block126;
                                        }
                                    }
                                }
                                switch (this.memoryValues[0]) {
                                    default: {
                                        for (i2 = 26; i2 < 32; ++i2) {
                                            this.memoryParameters[i2].setEnabled(false);
                                        }
                                        break;
                                    }
                                    case 5: 
                                    case 6: {
                                        for (i2 = 26; i2 < 32; ++i2) {
                                            this.memoryParameters[i2].setEnabled(true);
                                        }
                                    }
                                }
                            }
                            if (!this.isDuo) break block127;
                            switch (this.memoryValues[0]) {
                                default: {
                                    for (i2 = 32; i2 < 36; ++i2) {
                                        this.memoryParameters[i2].setEnabled(true);
                                    }
                                    break block128;
                                }
                                case 3: 
                                case 4: {
                                    for (i2 = 32; i2 < 36; ++i2) {
                                        this.memoryParameters[i2].setEnabled(false);
                                    }
                                    break block128;
                                }
                            }
                        }
                        switch (this.memoryValues[0]) {
                            default: {
                                for (i2 = 32; i2 < 36; ++i2) {
                                    this.memoryParameters[i2].setEnabled(true);
                                }
                                break;
                            }
                            case 5: 
                            case 6: {
                                for (i2 = 32; i2 < 36; ++i2) {
                                    this.memoryParameters[i2].setEnabled(false);
                                }
                            }
                        }
                    }
                    if (this.isDuo) {
                        block51 : switch (this.memoryValues[0]) {
                            default: {
                                if (this.tbtmStorage == null || this.tbtmStorage.isDisposed()) {
                                    this.createStorageTabItem();
                                }
                                switch (this.memoryValues[0]) {
                                    case 0: {
                                        this.memoryParameters[36].updateValueRange("3.85V (3.700 - 3.900V)", 3700, 3900, -3700);
                                        break block51;
                                    }
                                    case 1: {
                                        this.memoryParameters[36].updateValueRange("3.75V (3.600 - 3.800V)", 3600, 3800, -3600);
                                        break block51;
                                    }
                                    case 2: {
                                        this.memoryParameters[36].updateValueRange("3.3V (3.100 - 3.400V)", 3100, 3400, -3100);
                                        break block51;
                                    }
                                    case 7: {
                                        this.memoryParameters[36].updateValueRange("3.9V (3.750 - 4.100V)", 3750, 4100, -3750);
                                        break block51;
                                    }
                                }
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                if (this.tbtmStorage != null && !this.tbtmStorage.isDisposed()) {
                                    this.storageComposite.removeListener(13, this.memoryParameterChangeListener);
                                    for (i2 = 36; i2 < 39; ++i2) {
                                        this.memoryParameters[i2].dispose();
                                    }
                                    this.storageComposite.dispose();
                                    this.tbtmStorage.dispose();
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        block60 : switch (this.memoryValues[0]) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (this.tbtmStorage == null || this.tbtmStorage.isDisposed()) {
                                    this.createStorageTabItem();
                                }
                                switch (this.memoryValues[0]) {
                                    case 0: {
                                        this.memoryParameters[36].updateValueRange("3.85V (3.700 - 3.900V)", 3700, 3900, -3700);
                                        break block60;
                                    }
                                    case 1: {
                                        this.memoryParameters[36].updateValueRange("3.75V (3.600 - 3.800V)", 3600, 3800, -3600);
                                        break block60;
                                    }
                                    case 2: {
                                        this.memoryParameters[36].updateValueRange("3.3V (3.100 - 3.400V)", 3100, 3400, -3100);
                                        break block60;
                                    }
                                    case 3: {
                                        this.memoryParameters[36].updateValueRange("3.9V (3.750 - 4.100V)", 3750, 4100, -3750);
                                        break block60;
                                    }
                                    case 4: {
                                        this.memoryParameters[36].updateValueRange("2.5V (2.200 - 2.600V)", 2200, 2600, -2200);
                                        break block60;
                                    }
                                }
                                break;
                            }
                            default: {
                                if (this.tbtmStorage == null || this.tbtmStorage.isDisposed()) break;
                                this.storageComposite.removeListener(13, this.memoryParameterChangeListener);
                                for (i2 = 36; i2 < 39; ++i2) {
                                    this.memoryParameters[i2].dispose();
                                }
                                this.storageComposite.dispose();
                                this.tbtmStorage.dispose();
                            }
                        }
                    }
                    if (this.isDuo || this.isDx) {
                        if (this.memoryParameters[47] != null) {
                            this.memoryParameters[47].setEnabled(true);
                            if (this.regToInputWarningLable != null) {
                                isToInput = this.memoryValues[20] == 1;
                                this.regToInputWarningLable.setEnabled(isToInput);
                                this.regToInputWarningLable.setForeground(isToInput ? SWTResourceManager.getColor((int)3) : SWTResourceManager.getColor((int)22));
                            }
                            if (this.regToChannelSettings != null) {
                                isToChannel = this.memoryValues[20] == 2;
                                this.regToChannelSettings.setEnabled(isToChannel);
                                this.memoryParameters[50].setEnabled(isToChannel);
                                boolean isResOrBulb = this.memoryValues[50] == 0;
                                this.memoryParameters[51].setEnabled(isToChannel && isResOrBulb);
                                this.memoryParameters[52].setEnabled(isToChannel && isResOrBulb);
                            }
                            if (this.memoryValues[47] == 1) {
                                this.memoryParameters[3].updateValueRange(String.format("0.05 ~ %d A", this.device.getChargeCurrentMaxSyncChannels() / 10), 5, this.device.getChargeCurrentMaxSyncChannels() * 10);
                                this.memoryParameters[17].updateValueRange(String.format("0.05 ~ %d A", this.device.getChargeCurrentMaxSyncChannels() / 10), 5, this.device.getChargeCurrentMaxSyncChannels() * 10);
                            } else {
                                this.memoryParameters[3].updateValueRange(String.format("0.05 ~ %d A", this.device.getChargeCurrentMax4Channel() / 10), 5, this.device.getChargeCurrentMax4Channel() * 10);
                                this.memoryParameters[17].updateValueRange(String.format("0.05 ~ %d A", this.device.getChargeCurrentMax4Channel() / 10), 5, this.device.getChargeCurrentMax4Channel() * 10);
                            }
                        }
                    } else {
                        if (this.memoryParameters[47] != null) {
                            this.memoryParameters[47].setEnabled(false);
                        }
                        if (this.regToInputWarningLable != null) {
                            isToInput = this.memoryValues[20] == 1;
                            this.regToInputWarningLable.setEnabled(isToInput);
                            this.regToInputWarningLable.setForeground(isToInput ? SWTResourceManager.getColor((int)3) : SWTResourceManager.getColor((int)22));
                        }
                        if (this.regToChannelSettings != null) {
                            isToChannel = false;
                            this.regToChannelSettings.setEnabled(isToChannel);
                            this.memoryParameters[50].setEnabled(isToChannel);
                            this.memoryParameters[51].setEnabled(isToChannel);
                            this.memoryParameters[52].setEnabled(isToChannel);
                        }
                    }
                    break block129;
                }
                if (!this.isDuo && this.memoryValues[0] == 9) {
                    this.memoryComposite.removeListener(13, this.memoryParameterChangeListener);
                    for (i = 0; i < 42; ++i) {
                        if (this.memoryParameters[i] == null) continue;
                        this.memoryParameters[i].dispose();
                    }
                    if (this.powerLabel == null || this.powerLabel.isDisposed()) {
                        this.powerLabel = new CLabel(this.memoryComposite, 0x1000000);
                        this.powerLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 15), (int)1));
                        this.powerLabel.setBackground(this.application.COLOR_CANVAS_YELLOW);
                        this.powerLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                        this.powerLabel.setText(Messages.getString((String)"GDE_MSGT2677"));
                        this.memoryComposite.layout();
                    }
                    if (this.tbtmCharge != null && !this.tbtmCharge.isDisposed()) {
                        this.grpBalancerSettings.removeListener(13, this.memoryParameterChangeListener);
                        this.grpBalancerSettings.dispose();
                        this.grpAdvancedRestoreSettings.removeListener(13, this.memoryParameterChangeListener);
                        this.grpAdvancedRestoreSettings.dispose();
                        this.grpChargeSaftySettings.removeListener(13, this.memoryParameterChangeListener);
                        this.grpChargeSaftySettings.dispose();
                        this.chargeComposite.removeListener(13, this.memoryParameterChangeListener);
                        this.chargeComposite.dispose();
                        this.tbtmCharge.dispose();
                    }
                    if (this.tbtmDischarge != null && !this.tbtmDischarge.isDisposed()) {
                        this.dischargeComposite.removeListener(13, this.memoryParameterChangeListener);
                        this.dischargeComposite.dispose();
                        this.tbtmDischarge.dispose();
                    }
                    if (this.tbtmStorage != null && !this.tbtmStorage.isDisposed()) {
                        this.storageComposite.removeListener(13, this.memoryParameterChangeListener);
                        this.storageComposite.dispose();
                        this.tbtmStorage.dispose();
                    }
                    if (this.tbtmCycle != null && !this.tbtmCycle.isDisposed()) {
                        this.cycleComposite.removeListener(13, this.memoryParameterChangeListener);
                        this.cycleComposite.dispose();
                        this.tbtmCycle.dispose();
                    }
                    if (this.tbtmOption != null && !this.tbtmOption.isDisposed()) {
                        this.optionComposite.removeListener(13, this.memoryParameterChangeListener);
                        this.optionComposite.dispose();
                        this.tbtmOption.dispose();
                    }
                    if (this.tbtmPower == null || this.tbtmPower.isDisposed()) {
                        this.createPowerTabItem();
                        this.tabFolderProgrMem.setSelection(0);
                        if (this.memoryParameters[47] != null) {
                            this.memoryParameters[47].dispose();
                        }
                    }
                }
            }
            for (i = 0; i < this.memoryParameters.length; ++i) {
                if (this.memoryParameters[i] == null) continue;
                this.memoryParameters[i].setSliderSelection(this.memoryValues[i]);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialogAsync(this.getDialogShell(), e.getMessage());
        }
    }

    void addAllListeners() {
        if (this.storageComposite != null && !this.storageComposite.isDisposed()) {
            this.storageComposite.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.memoryComposite != null && !this.memoryComposite.isDisposed()) {
            this.memoryComposite.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.chargeComposite != null && !this.chargeComposite.isDisposed()) {
            this.chargeComposite.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpChargeSaftySettings != null && !this.grpChargeSaftySettings.isDisposed()) {
            this.grpChargeSaftySettings.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpBalancerSettings != null && !this.grpBalancerSettings.isDisposed()) {
            this.grpBalancerSettings.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpAdvancedRestoreSettings != null && !this.grpAdvancedRestoreSettings.isDisposed()) {
            this.grpAdvancedRestoreSettings.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.dischargeComposite != null && !this.dischargeComposite.isDisposed()) {
            this.dischargeComposite.addListener(13, this.memoryParameterChangeListener);
        }
        if (this.powerComposite != null && !this.powerComposite.isDisposed()) {
            this.powerComposite.addListener(13, this.memoryParameterChangeListener);
        }
    }

    void removeAllListeners() {
        if (this.storageComposite != null && !this.storageComposite.isDisposed()) {
            this.storageComposite.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.memoryComposite != null && !this.memoryComposite.isDisposed()) {
            this.memoryComposite.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.chargeComposite != null && !this.chargeComposite.isDisposed()) {
            this.chargeComposite.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpChargeSaftySettings != null && !this.grpChargeSaftySettings.isDisposed()) {
            this.grpChargeSaftySettings.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpBalancerSettings != null && !this.grpBalancerSettings.isDisposed()) {
            this.grpBalancerSettings.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.grpAdvancedRestoreSettings != null && !this.grpAdvancedRestoreSettings.isDisposed()) {
            this.grpAdvancedRestoreSettings.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.dischargeComposite != null && !this.dischargeComposite.isDisposed()) {
            this.dischargeComposite.removeListener(13, this.memoryParameterChangeListener);
        }
        if (this.powerComposite != null && !this.powerComposite.isDisposed()) {
            this.powerComposite.removeListener(13, this.memoryParameterChangeListener);
        }
    }

    static /* synthetic */ int[] access$1302(ChargerDialog x0, int[] x1) {
        x0.memoryValues = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1902(ChargerDialog x0, int[] x1) {
        x0.systemValues = x1;
        return x1;
    }

    static {
        channels = Channels.getInstance();
        settings = Settings.getInstance();
    }

    static enum Register {
        REG_SEL_OP(Short.MIN_VALUE),
        REG_SEL_MEM(-32767),
        REG_SEL_CHANNEL(-32766),
        REG_ORDER_KEY(-32765),
        REG_ORDER(-32764),
        REG_CURRENT(-32763),
        REG_VOLT(-32762);

        short value;
        public static final Register[] VALUES;

        private Register(short newValue) {
            this.value = newValue;
        }

        static {
            VALUES = Register.values();
        }
    }

    static enum Order {
        ORDER_STOP,
        ORDER_RUN,
        ORDER_MODIFY,
        ORDER_WRITE_SYS,
        ORDER_WRITE_MEM_HEAD,
        ORDER_WRITE_MEM,
        ORDER_TRANS_LOG_ON,
        ORDER_TRANS_LOG_OFF,
        ORDER_MSGBOX_YES,
        ORDER_MSGBOX_NO;

    }

    static enum OperationNiPb {
        Charge,
        Discharge,
        Cycle;

    }

    static enum OperationLi {
        Charge,
        Storage,
        Discharge,
        Cycle,
        Balance;

    }
}

