/*
 * Decompiled with CFR 0.152.
 */
package gde.device.nmea;

import gde.GDE;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.nmea.NMEAAdapterDialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControl;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NMEAAdapterDialogTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(NMEAAdapterDialogTabItem.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    Composite mainTabComposite;
    boolean isVisibilityChanged = false;
    final CTabFolder parent;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final NMEAAdapterDialog dialog;
    final int channelConfigNumber;
    final List<MeasurementControl> measurementTypes = new ArrayList<MeasurementControl>();

    public NMEAAdapterDialogTabItem(CTabFolder parentTabFolder, NMEAAdapterDialog parentDialog, int useChannelConfigNumber, IDevice useDevice) {
        super(parentTabFolder, 0);
        this.parent = parentTabFolder;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.setText(this.device.getChannelNameReplacement(this.channelConfigNumber));
        this.create();
    }

    void create() {
        this.mainTabComposite = new Composite((Composite)this.parent, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        this.mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        this.setControl((Control)this.mainTabComposite);
        this.tabItemLabel = new Label(this.mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.horizontalAlignment = 1;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 20;
        tabItemLabelLData.widthHint = 292;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT2101"));
        for (int i = 0; i < this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).size(); ++i) {
            this.measurementTypes.add(new MeasurementControl(this.mainTabComposite, (DeviceDialog)this.dialog, this.channelConfigNumber, i, (MeasurementType)this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).get(i), this.device, 1));
        }
        this.buttonComposite = new Composite(this.mainTabComposite, 0);
        GridData buttonCompositeLData = new GridData();
        buttonCompositeLData.verticalAlignment = 1;
        buttonCompositeLData.horizontalAlignment = 2;
        buttonCompositeLData.heightHint = 35;
        buttonCompositeLData.widthHint = 180;
        buttonCompositeLData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)buttonCompositeLData);
        FormLayout buttonCompositeLayout = new FormLayout();
        this.buttonComposite.setLayout((Layout)buttonCompositeLayout);
        this.inputFileButton = new Button(this.buttonComposite, 0x1000008);
        FormData inputFileButtonLData = new FormData();
        inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
        inputFileButtonLData.left = new FormAttachment(0, 1000, 0);
        inputFileButtonLData.right = new FormAttachment(1000, 1000, 0);
        inputFileButtonLData.top = new FormAttachment(0, 1000, 0);
        this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
        this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2102"));
        this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2110"));
        this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                if (NMEAAdapterDialogTabItem.this.isVisibilityChanged) {
                    String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{NMEAAdapterDialogTabItem.this.device.getPropertiesFileName()});
                    if (NMEAAdapterDialogTabItem.this.application.openYesNoMessageDialog(NMEAAdapterDialogTabItem.this.dialog.getDialogShell(), msg) == 64) {
                        log.log(Level.FINE, "SWT.YES");
                        NMEAAdapterDialogTabItem.this.device.storeDeviceProperties();
                    }
                }
                NMEAAdapterDialogTabItem.this.device.open_closeCommPort();
            }
        });
    }
}

