/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.device.DataTypes;
import gde.device.smmodellbau.GPSLoggerDialog;
import gde.device.smmodellbau.GPSLoggerSetupConfiguration2;
import gde.device.smmodellbau.SetupReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GPSLoggerSetupConfiguration1
extends Composite {
    static final Logger log = Logger.getLogger(GPSLoggerSetupConfiguration1.class.getName());
    static final int COMBO_WIDTH = 66;
    final GPSLoggerDialog dialog;
    final DataExplorer application;
    Composite fillerComposite;
    Composite addonComposite;
    Group gpsLoggerGroup;
    CLabel serialNumberLabel;
    CLabel firmwareLabel;
    CLabel languageLabel;
    CLabel hottSpeedTypeLabel;
    CLabel dataRateLabel;
    CLabel startModusLabel;
    CLabel stopModusLabel;
    CLabel timeZoneLabel;
    CLabel timeAutoLabel;
    CLabel varioLimitClimbLabel;
    CLabel varioLimitSinkLabel;
    CLabel varioTonLabel;
    CLabel timeZoneUnitLabel;
    CLabel varioLimitUnitLabel;
    CLabel smoothAltitudeLabel;
    CLabel modusIgcLabel;
    CLabel modusDistanceLabel;
    CLabel telemetryTypeLabel;
    CLabel varioFactorLabel;
    CLabel varioFilterLabel;
    CLabel minMaxRxLabel;
    Text serialNumberText;
    Text firmwareText;
    CCombo languageCombo;
    CCombo hottSpeedTypeCombo;
    CCombo dataRateCombo;
    CCombo startModusCombo;
    CCombo stopModusCombo;
    CCombo timeZoneCombo;
    CCombo timeAutoCombo;
    CCombo varioLimitClimbCombo;
    CCombo varioLimitSinkCombo;
    CCombo varioToneCombo;
    CCombo smoothAltitudeCombo;
    CCombo modusIgcCombo;
    CCombo modusDistanceCombo;
    CCombo telemetryTypeCombo;
    CCombo varioFactorCombo;
    CCombo varioFilterCombo;
    CCombo minMaxRxCombo;
    Group gpsTelemertieAlarmGroup;
    Button heightMaxAlarmButton;
    Button speedMaxAlarmButton;
    Button speedMinAlarmButton;
    Button distanceMaxButton;
    Button distanceMinButton;
    Button tripLengthButton;
    Button voltageRxButton;
    CCombo heightMaxAlarmCombo;
    CCombo speedMaxAlarmCombo;
    CCombo speedMinAlarmCombo;
    CCombo distanceMaxCombo;
    CCombo distanceMinCombo;
    CCombo tripLengthCombo;
    CCombo voltageRxCombo;
    CLabel heightMaxAlarmLabel;
    CLabel speedAlarmLabel;
    CLabel distanceMaxLabel;
    CLabel distanceMinLabel;
    CLabel tripLengthLabel;
    CLabel voltageRxLabel;
    CLabel frskyIdLabel;
    Button fixSerialNumberButton;
    Button fixStartPositionButton;
    Button robbeTBoxButton;
    CCombo frskyIdCombo;
    final SetupReaderWriter configuration;
    final String[] languageValues = new String[]{"Deutsch", "English"};
    final String[] speedTypeValues = new String[]{" auto", " GPS", "AirSpeed"};
    final String[] dataRateValues = Messages.getString((String)"GDE_MSGT2020").split(",");
    final String[] startValues = Messages.getString((String)"GDE_MSGT2021").split(",");
    final String[] stopValues = Messages.getString((String)"GDE_MSGT2072").split(",");
    final String[] deltaUTC = new String[]{" -12", " -11", " -10", " -9", " -8", " -7", " -6", " -5", " -4", " -3", " -2", " -1", " 0", " +1", " +2", " +3", " +4", " +5", " +6", " +7", " +8", " +9", " +10", " +11", " +12"};
    final String[] varioThresholds = new String[]{" 0.0", " 0.1", " 0.2", " 0.3", " 0.4", " 0.5", " 0.6", " 0.7", " 0.8", " 0.9", " 1.0", " 1.1", " 1.2", " 1.3", " 1.4", " 1.5", " 1.6", " 1.7", " 1.8", " 1.9", " 2.0", " 2.1", " 2.2", " 2.3", " 2.4", " 2.5", " 2.6", " 2.7", " 2.8", " 2.9", " 3.0", " 3.1", " 3.2", " 3.3", " 3.4", " 3.5", " 3.6", " 3.7", " 3.8", " 3.9", " 4.0", " 4.1", " 4.2", " 4.3", " 4.4", " 4.5", " 4.6", " 4.7", " 4.8", " 4.9", " 5.0"};
    final String[] varioTons = Messages.getString((String)"GDE_MSGT2022").split(",");
    final String[] heightValues = new String[]{"   10", "   25", "   50", "   75", "  100", "  150", "  200", "  250", "  300", "  350", "  400", "  450", "  500", "  600", "  700", "  800", "  900", " 1000", " 1250", " 1500", " 2000", " 2500", " 3000", " 3500", " 4000"};
    final String[] speedValues = new String[]{"   10", "   25", "   50", "   75", "  100", "  150", "  200", "  250", "  300", "  350", "  400", "  450", "  500", "  600", "  700", "  800", "  900", " 1000"};
    final String[] distanceValues = new String[]{"   10", "   25", "   50", "   75", "  100", "  150", "  200", "  250", "  300", "  350", "  400", "  450", "  500", "  600", "  700", "  800", "  900", " 1000", " 1250", " 1500", " 2000", " 2500", " 3000", " 3500", " 4000", " 4500", " 5000"};
    final String[] tripValues = new String[]{"  1.0", "  2.5", "  5.0", "  7.5", " 10.0", " 15.0", " 20.0", " 25.0", " 30.0", " 35.0", " 40.0", " 45.0", " 50.0", " 60.0", " 70.0", " 80.0", " 90.0", " 99.0"};
    final String[] voltageRxValues = new String[]{"  3.00", "  3.25", "  3.50", "  3.75", "  4.00", "  4.25", "  4.50", "  4.75", "  4.80", "  4.85", "  4.90", "  4.95", "  5.00", "  5.05", "  5.10", "  5.15", "  5.20", "  5.25", "  5.50", "  6.00", "  6.25", "  6.50", "  6.75", "  7.00", "  7.25", "  7.50", "  7.75", "  8.00"};
    final String[] smoothAltNull = Messages.getString((String)"GDE_MSGI2002").split(",");
    final String[] igcModes = Messages.getString((String)"GDE_MSGT2069").split(",");
    final String[] distanceModes = Messages.getString((String)"GDE_MSGT2071").split(",");
    final String[] telemetrieTypes = new String[]{" - - - ", " Futaba", " JR DMSS", " HoTT", " JetiDuplex", " M-Link", " FrSky", " Spektrum", " P2Bus"};
    final String[] varioFactors;
    final String[] varioFilters = Messages.getString((String)"GDE_MSGT2019").split(",");
    final String[] frskyIDs = new String[]{" 0x00", " 0xA1", " 0x22", " 0x83", " 0xE4", " 0x45", " 0xC6", " 0x67", " 0x48", " 0xE9", " 0x6A", " 0xCB", " 0xAC", " 0x0D", " 0x8E", " 0x2F", " 0xD0", " 0x71", " 0xF2", " 0x53", " 0x34", " 0x95", " 0x16", " 0xB7", " 0x98", " 0x39", " 0xBA", " 0x1B"};

    public GPSLoggerSetupConfiguration1(Composite parent, int style, GPSLoggerDialog useDialog, SetupReaderWriter useConfiguration) {
        super(parent, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.dialog = useDialog;
        this.configuration = useConfiguration;
        this.application = DataExplorer.getInstance();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 41; ++i) {
            sb.append(String.format(Locale.ENGLISH, " %2.1f ,", 1.0 + (double)i / 10.0));
        }
        this.varioFactors = sb.toString().split(",");
        this.initGUI();
        this.updateValues();
    }

    public void updateValues() {
        this.serialNumberText.setText("" + this.configuration.serialNumber);
        this.firmwareText.setText(String.format(" %.2f", (double)this.configuration.firmwareVersion / 100.0));
        this.languageCombo.select((int)this.configuration.language);
        this.hottSpeedTypeCombo.select((int)this.configuration.hottSpeedType);
        this.dataRateCombo.select((int)this.configuration.datarate);
        this.startModusCombo.select((int)this.configuration.startModus);
        this.stopModusCombo.select((int)this.configuration.stopModus);
        this.timeZoneCombo.select(this.configuration.timeZone + 12);
        this.timeAutoCombo.select((int)this.configuration.daylightSavingModus);
        this.varioLimitClimbCombo.select((int)this.configuration.varioThreshold);
        this.varioLimitSinkCombo.select((int)this.configuration.varioThresholdSink);
        this.varioToneCombo.select((int)this.configuration.varioTon);
        this.varioFactorCombo.select((int)this.configuration.varioFactor);
        this.varioFilterCombo.select((int)this.configuration.varioFilter);
        this.modusIgcCombo.select((int)this.configuration.modusIGC);
        this.modusDistanceCombo.select((int)this.configuration.modusDistance);
        this.telemetryTypeCombo.select((int)this.configuration.telemetryType);
        this.minMaxRxCombo.select((int)this.configuration.rxControl);
        this.frskyIdCombo.select(this.configuration.frskyAddr - 1);
        this.fixSerialNumberButton.setSelection(this.configuration.serialNumberFix == 1);
        this.robbeTBoxButton.setSelection(this.configuration.robbe_T_Box == 1);
        this.heightMaxAlarmButton.setSelection((this.configuration.telemetryAlarms & 1) > 0);
        this.heightMaxAlarmCombo.setText(String.format("%5d", this.configuration.heightAlarm));
        this.speedMaxAlarmButton.setSelection((this.configuration.telemetryAlarms & 2) > 0);
        this.speedMaxAlarmCombo.setText(String.format("%5d", this.configuration.speedMaxAlarm));
        this.speedMinAlarmButton.setSelection((this.configuration.telemetryAlarms & 0x400) > 0);
        this.speedMinAlarmCombo.setText(String.format("%5d", this.configuration.speedMinAlarm));
        this.distanceMaxButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
        this.distanceMinButton.setSelection((this.configuration.telemetryAlarms & 0x200) > 0);
        this.distanceMaxCombo.setText(String.format("%5d", this.configuration.distanceMaxAlarm));
        this.tripLengthButton.setSelection((this.configuration.telemetryAlarms & 8) > 0);
        this.tripLengthCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.tripLengthAlarm / 10.0));
        this.voltageRxButton.setSelection((this.configuration.telemetryAlarms & 0x10) > 0);
        this.voltageRxCombo.setText(String.format(Locale.ENGLISH, "%6.2f", (double)this.configuration.voltageRxAlarm / 100.0));
        this.changeVisibility();
    }

    public void changeVisibility() {
        this.frskyIdLabel.setVisible(false);
        this.frskyIdCombo.setVisible(false);
        this.hottSpeedTypeLabel.setVisible(false);
        this.hottSpeedTypeCombo.setVisible(false);
        this.fixSerialNumberButton.setVisible(false);
        this.fixStartPositionButton.setVisible(false);
        this.fixStartPositionButton.setSelection(false);
        this.robbeTBoxButton.setVisible(false);
        if (GPSLoggerSetupConfiguration2.mLinkGroupStatic != null && !GPSLoggerSetupConfiguration2.mLinkGroupStatic.isDisposed()) {
            GPSLoggerSetupConfiguration2.mLinkGroupStatic.setVisible(false);
        }
        if (GPSLoggerSetupConfiguration2.jetiExGroupStatic != null && !GPSLoggerSetupConfiguration2.jetiExGroupStatic.isDisposed()) {
            GPSLoggerSetupConfiguration2.jetiExGroupStatic.setVisible(false);
        }
        if (GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic != null && !GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic.isDisposed()) {
            GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic.setVisible(false);
        }
        if (GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic != null && !GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic.isDisposed()) {
            GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic.setVisible(false);
        }
        if (GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic != null && !GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic.isDisposed()) {
            GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic.setVisible(true);
        }
        if (this.gpsLoggerGroup != null && !this.gpsLoggerGroup.isDisposed()) {
            switch (this.telemetryTypeCombo.getSelectionIndex()) {
                case 3: {
                    this.hottSpeedTypeLabel.setVisible(true);
                    this.hottSpeedTypeCombo.setVisible(true);
                    break;
                }
                case 7: {
                    if (GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic == null || GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic.isDisposed()) break;
                    GPSLoggerSetupConfiguration2.spektrumAdapterGroupStatic.setVisible(true);
                    break;
                }
                case 6: {
                    this.frskyIdLabel.setVisible(true);
                    this.frskyIdCombo.setVisible(true);
                    break;
                }
                case 5: {
                    if (GPSLoggerSetupConfiguration2.mLinkGroupStatic == null) break;
                    GPSLoggerSetupConfiguration2.mLinkGroupStatic.setVisible(true);
                    break;
                }
                case 4: {
                    this.fixSerialNumberButton.setVisible(true);
                    this.fixStartPositionButton.setVisible(true);
                    if (GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic != null) {
                        GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic.setVisible(false);
                    }
                    if (GPSLoggerSetupConfiguration2.jetiExGroupStatic == null) break;
                    GPSLoggerSetupConfiguration2.jetiExGroupStatic.setVisible(true);
                    GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic.setVisible(true);
                    break;
                }
                case 1: {
                    this.fixSerialNumberButton.setVisible(true);
                    this.robbeTBoxButton.setVisible(true);
                    break;
                }
            }
        }
    }

    void initGUI() {
        try {
            this.setLayout((Layout)new FormLayout());
            this.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "GPSLoggerSetupConfiguration1.helpRequested, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2010"), "HelpInfo.html#configuration");
                }
            });
            this.gpsLoggerGroup = new Group((Composite)this, 0);
            FormData gpsLoggerGroupLData = new FormData();
            gpsLoggerGroupLData.left = new FormAttachment(0, 1000, 10);
            gpsLoggerGroupLData.top = new FormAttachment(0, 1000, 5);
            gpsLoggerGroupLData.width = 290;
            gpsLoggerGroupLData.height = GDE.IS_MAC ? 440 : 445;
            RowLayout gpsLoggerGroupLayout = new RowLayout(256);
            this.gpsLoggerGroup.setLayout((Layout)gpsLoggerGroupLayout);
            this.gpsLoggerGroup.setLayoutData((Object)gpsLoggerGroupLData);
            this.gpsLoggerGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gpsLoggerGroup.setText(Messages.getString((String)"GDE_MSGT2031"));
            this.serialNumberLabel = new CLabel((Composite)this.gpsLoggerGroup, 0);
            RowData serialNumberLabelLData = new RowData();
            serialNumberLabelLData.width = GDE.IS_LINUX ? 90 : 100;
            serialNumberLabelLData.height = 18;
            this.serialNumberLabel.setLayoutData((Object)serialNumberLabelLData);
            this.serialNumberLabel.setText(Messages.getString((String)"GDE_MSGT2032"));
            this.serialNumberLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.serialNumberText = new Text((Composite)this.gpsLoggerGroup, 133120);
            RowData serialNumberTextLData = new RowData();
            serialNumberTextLData.width = 50;
            serialNumberTextLData.height = GDE.IS_MAC ? 16 : (GDE.IS_LINUX ? 10 : 13);
            this.serialNumberText.setLayoutData((Object)serialNumberTextLData);
            this.serialNumberText.setEditable(false);
            this.serialNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.firmwareLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData firmwareLabelLData = new RowData();
            firmwareLabelLData.width = GDE.IS_LINUX ? 65 : 75;
            firmwareLabelLData.height = 18;
            this.firmwareLabel.setLayoutData((Object)firmwareLabelLData);
            this.firmwareLabel.setText(Messages.getString((String)"GDE_MSGT2033"));
            this.firmwareLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.firmwareText = new Text((Composite)this.gpsLoggerGroup, 133120);
            RowData firmwareTextLData = new RowData();
            int n = firmwareTextLData.width = GDE.IS_LINUX ? 35 : 40;
            firmwareTextLData.height = GDE.IS_MAC ? 16 : (GDE.IS_LINUX ? 10 : 13);
            this.firmwareText.setLayoutData((Object)firmwareTextLData);
            this.firmwareText.setEditable(false);
            this.firmwareText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.gpsLoggerGroup, 0);
            RowData fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 5;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.telemetryTypeLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData telemetryTypeLabelLData = new RowData();
            telemetryTypeLabelLData.width = 130;
            telemetryTypeLabelLData.height = 18;
            this.telemetryTypeLabel.setLayoutData((Object)telemetryTypeLabelLData);
            this.telemetryTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetryTypeLabel.setText(Messages.getString((String)"GDE_MSGT2075"));
            this.telemetryTypeCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData telemetryTypeComboLData = new RowData();
            telemetryTypeComboLData.width = 80;
            telemetryTypeComboLData.height = 17;
            this.telemetryTypeCombo.setLayoutData((Object)telemetryTypeComboLData);
            this.telemetryTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetryTypeCombo.setItems(this.telemetrieTypes);
            this.telemetryTypeCombo.select((int)this.configuration.telemetryType);
            this.telemetryTypeCombo.setEditable(false);
            this.telemetryTypeCombo.setBackground(this.application.COLOR_WHITE);
            this.telemetryTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "telemetryTypeCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryType = (short)GPSLoggerSetupConfiguration1.this.telemetryTypeCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    GPSLoggerSetupConfiguration1.this.changeVisibility();
                }
            });
            this.fillerComposite = new Composite((Composite)this.gpsLoggerGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 45;
            fillerCompositeRA1LData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.addonComposite = new Composite((Composite)this.gpsLoggerGroup, 0);
            this.addonComposite.setLayout((Layout)new FormLayout());
            RowData addonCompositeLData = new RowData();
            addonCompositeLData.width = 285;
            addonCompositeLData.height = 44;
            this.addonComposite.setLayoutData((Object)addonCompositeLData);
            this.fixSerialNumberButton = new Button(this.addonComposite, 16416);
            FormData sensorTypeLabelLData = new FormData();
            sensorTypeLabelLData.width = 280;
            sensorTypeLabelLData.height = 18;
            sensorTypeLabelLData.left = new FormAttachment(0, 1000, 2);
            sensorTypeLabelLData.top = new FormAttachment(0, 1000, 0);
            this.fixSerialNumberButton.setLayoutData((Object)sensorTypeLabelLData);
            this.fixSerialNumberButton.setText(Messages.getString((String)"GDE_MSGT2092"));
            this.fixSerialNumberButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fixSerialNumberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "fixSerialNumberButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.serialNumberFix = (byte)(GPSLoggerSetupConfiguration1.this.fixSerialNumberButton.getSelection() ? 1 : 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fixStartPositionButton = new Button(this.addonComposite, 16416);
            sensorTypeLabelLData = new FormData();
            sensorTypeLabelLData.width = 285;
            sensorTypeLabelLData.height = 18;
            sensorTypeLabelLData.left = new FormAttachment(0, 1000, 2);
            sensorTypeLabelLData.top = new FormAttachment(0, 1000, 22);
            this.fixStartPositionButton.setLayoutData((Object)sensorTypeLabelLData);
            this.fixStartPositionButton.setText(Messages.getString((String)"GDE_MSGT2090") + "|" + Messages.getString((String)"GDE_MSGT2065"));
            this.fixStartPositionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fixStartPositionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "fixStartPositionButton.widgetSelected, event=" + evt);
                    if (GPSLoggerSetupConfiguration1.this.fixStartPositionButton.getSelection()) {
                        GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic.setVisible(false);
                        GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic.setVisible(true);
                    } else {
                        GPSLoggerSetupConfiguration2.unilogTelemtryAlarmsGroupStatic.setVisible(true);
                        GPSLoggerSetupConfiguration2.fixGpsStartPositionGroupStatic.setVisible(false);
                    }
                }
            });
            this.robbeTBoxButton = new Button(this.addonComposite, 16416);
            sensorTypeLabelLData = new FormData();
            sensorTypeLabelLData.width = 130;
            sensorTypeLabelLData.height = 18;
            sensorTypeLabelLData.left = new FormAttachment(0, 1000, 2);
            sensorTypeLabelLData.top = new FormAttachment(0, 1000, 22);
            this.robbeTBoxButton.setLayoutData((Object)sensorTypeLabelLData);
            this.robbeTBoxButton.setText(Messages.getString((String)"GDE_MSGT2093"));
            this.robbeTBoxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.robbeTBoxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "robbeTBoxButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.robbe_T_Box = (byte)(GPSLoggerSetupConfiguration1.this.robbeTBoxButton.getSelection() ? 1 : 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.frskyIdLabel = new CLabel(this.addonComposite, 131072);
            FormData frskyIdLabelLData = new FormData();
            frskyIdLabelLData.width = 130;
            frskyIdLabelLData.height = 18;
            frskyIdLabelLData.left = new FormAttachment(0, 1000, 0);
            frskyIdLabelLData.top = new FormAttachment(0, 1000, 0);
            this.frskyIdLabel.setLayoutData((Object)frskyIdLabelLData);
            this.frskyIdLabel.setText(Messages.getString((String)"GDE_MSGT2079"));
            this.frskyIdLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.frskyIdCombo = new CCombo(this.addonComposite, 2048);
            FormData sensorTypeComboLData = new FormData();
            sensorTypeComboLData.width = 66;
            sensorTypeComboLData.height = 17;
            sensorTypeComboLData.left = new FormAttachment(0, 1000, 133);
            sensorTypeComboLData.top = new FormAttachment(0, 1000, 0);
            this.frskyIdCombo.setLayoutData((Object)sensorTypeComboLData);
            this.frskyIdCombo.setItems(this.frskyIDs);
            this.frskyIdCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.frskyIdCombo.setEditable(false);
            this.frskyIdCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.frskyIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "sensorTypeCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.frskyAddr = (short)(GPSLoggerSetupConfiguration1.this.frskyIdCombo.getSelectionIndex() + 1);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addonComposite.layout();
            this.languageLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData languageLabelLData = new RowData();
            languageLabelLData.width = 130;
            languageLabelLData.height = 18;
            this.languageLabel.setLayoutData((Object)languageLabelLData);
            this.languageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.languageLabel.setText(Messages.getString((String)"GDE_MSGT2014"));
            this.languageCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData dataRateCComboLData = new RowData();
            dataRateCComboLData.width = 66;
            dataRateCComboLData.height = 17;
            this.languageCombo.setLayoutData((Object)dataRateCComboLData);
            this.languageCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.languageCombo.setItems(this.languageValues);
            this.languageCombo.select((int)this.configuration.language);
            this.languageCombo.setEditable(false);
            this.languageCombo.setBackground(this.application.COLOR_WHITE);
            this.languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "languageCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.language = (byte)GPSLoggerSetupConfiguration1.this.languageCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.hottSpeedTypeLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData speedTypeLabelLData = new RowData();
            speedTypeLabelLData.width = 130;
            speedTypeLabelLData.height = 18;
            this.hottSpeedTypeLabel.setLayoutData((Object)speedTypeLabelLData);
            this.hottSpeedTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.hottSpeedTypeLabel.setText(Messages.getString((String)"GDE_MSGI2003"));
            this.hottSpeedTypeCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            dataRateCComboLData = new RowData();
            dataRateCComboLData.width = 66;
            dataRateCComboLData.height = 17;
            this.hottSpeedTypeCombo.setLayoutData((Object)dataRateCComboLData);
            this.hottSpeedTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.hottSpeedTypeCombo.setItems(this.speedTypeValues);
            this.hottSpeedTypeCombo.select((int)this.configuration.hottSpeedType);
            this.hottSpeedTypeCombo.setEditable(false);
            this.hottSpeedTypeCombo.setBackground(this.application.COLOR_WHITE);
            this.hottSpeedTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "hottSpeedTypeCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.hottSpeedType = (byte)GPSLoggerSetupConfiguration1.this.hottSpeedTypeCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.dataRateLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData dataRateLabelLData = new RowData();
            dataRateLabelLData.width = 130;
            dataRateLabelLData.height = 18;
            this.dataRateLabel.setLayoutData((Object)dataRateLabelLData);
            this.dataRateLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.dataRateLabel.setText(Messages.getString((String)"GDE_MSGT2034"));
            this.dataRateCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            dataRateCComboLData = new RowData();
            dataRateCComboLData.width = 66;
            dataRateCComboLData.height = 17;
            this.dataRateCombo.setLayoutData((Object)dataRateCComboLData);
            this.dataRateCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.dataRateCombo.setItems(this.dataRateValues);
            this.dataRateCombo.select((int)this.configuration.datarate);
            this.dataRateCombo.setEditable(false);
            this.dataRateCombo.setBackground(this.application.COLOR_WHITE);
            this.dataRateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "dataRateCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.datarate = (short)GPSLoggerSetupConfiguration1.this.dataRateCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.startModusLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData startModusLabelLData = new RowData();
            startModusLabelLData.width = 130;
            startModusLabelLData.height = 18;
            this.startModusLabel.setLayoutData((Object)startModusLabelLData);
            this.startModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.startModusLabel.setText(Messages.getString((String)"GDE_MSGT2035"));
            this.startModusCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData startModusCComboLData = new RowData();
            startModusCComboLData.width = 66;
            startModusCComboLData.height = 17;
            this.startModusCombo.setLayoutData((Object)startModusCComboLData);
            this.startModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.startModusCombo.setItems(this.startValues);
            this.startModusCombo.select((int)this.configuration.startModus);
            this.startModusCombo.setEditable(false);
            this.startModusCombo.setBackground(this.application.COLOR_WHITE);
            this.startModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "startModusCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.startModus = (short)GPSLoggerSetupConfiguration1.this.startModusCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.stopModusLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData stopModusLabelLData = new RowData();
            stopModusLabelLData.width = 130;
            stopModusLabelLData.height = 18;
            this.stopModusLabel.setLayoutData((Object)stopModusLabelLData);
            this.stopModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stopModusLabel.setText(Messages.getString((String)"GDE_MSGT2026"));
            this.stopModusCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData stopModusCComboLData = new RowData();
            stopModusCComboLData.width = 66;
            stopModusCComboLData.height = 17;
            this.stopModusCombo.setLayoutData((Object)stopModusCComboLData);
            this.stopModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stopModusCombo.setItems(this.stopValues);
            this.stopModusCombo.select((int)this.configuration.stopModus);
            this.stopModusCombo.setEditable(false);
            this.stopModusCombo.setBackground(this.application.COLOR_WHITE);
            this.stopModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stopModusCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.stopModus = (short)GPSLoggerSetupConfiguration1.this.stopModusCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.timeZoneLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData timeZoneLabelLData = new RowData();
            timeZoneLabelLData.width = 130;
            timeZoneLabelLData.height = 18;
            this.timeZoneLabel.setLayoutData((Object)timeZoneLabelLData);
            this.timeZoneLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.timeZoneLabel.setText(Messages.getString((String)"GDE_MSGT2036"));
            this.timeZoneCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData timeZoneCComboLData = new RowData();
            timeZoneCComboLData.width = 66;
            timeZoneCComboLData.height = 17;
            this.timeZoneCombo.setLayoutData((Object)timeZoneCComboLData);
            this.timeZoneCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.timeZoneCombo.setItems(this.deltaUTC);
            this.timeZoneCombo.select(this.configuration.timeZone + 12);
            this.timeZoneCombo.setEditable(false);
            this.timeZoneCombo.setBackground(this.application.COLOR_WHITE);
            this.timeZoneCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "timeZoneCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.timeZone = (short)(GPSLoggerSetupConfiguration1.this.timeZoneCombo.getSelectionIndex() - 12);
                    GPSLoggerSetupConfiguration1.this.dialog.device.setUTCdelta(GPSLoggerSetupConfiguration1.this.configuration.timeZone);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.timeZoneUnitLabel = new CLabel((Composite)this.gpsLoggerGroup, 0x1000000);
            RowData timeZoneUnitLabelLData = new RowData();
            timeZoneUnitLabelLData.width = 79;
            timeZoneUnitLabelLData.height = 18;
            this.timeZoneUnitLabel.setLayoutData((Object)timeZoneUnitLabelLData);
            this.timeZoneUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.timeZoneUnitLabel.setText(Messages.getString((String)"GDE_MSGT2037"));
            this.timeAutoLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            timeZoneLabelLData = new RowData();
            timeZoneLabelLData.width = 130;
            timeZoneLabelLData.height = 18;
            this.timeAutoLabel.setLayoutData((Object)timeZoneLabelLData);
            this.timeAutoLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.timeAutoLabel.setText(Messages.getString((String)"GDE_MSGT2073"));
            this.timeAutoCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            timeZoneCComboLData = new RowData();
            timeZoneCComboLData.width = 66;
            timeZoneCComboLData.height = 17;
            this.timeAutoCombo.setLayoutData((Object)timeZoneCComboLData);
            this.timeAutoCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.timeAutoCombo.setItems(Messages.getString((String)"GDE_MSGT2070").split(","));
            this.timeAutoCombo.select((int)this.configuration.daylightSavingModus);
            this.timeAutoCombo.setEditable(false);
            this.timeAutoCombo.setBackground(this.application.COLOR_WHITE);
            this.timeAutoCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "timeAutoCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.timeZone = (short)GPSLoggerSetupConfiguration1.this.timeAutoCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioLimitClimbLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData varioLimitLabelLData = new RowData();
            varioLimitLabelLData.width = 130;
            varioLimitLabelLData.height = 18;
            this.varioLimitClimbLabel.setLayoutData((Object)varioLimitLabelLData);
            this.varioLimitClimbLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitClimbLabel.setText(Messages.getString((String)"GDE_MSGT2038"));
            this.varioLimitClimbCombo = new CCombo((Composite)this.gpsLoggerGroup, 133120);
            RowData varioLimitCComboLData = new RowData();
            varioLimitCComboLData.width = 66;
            varioLimitCComboLData.height = 17;
            this.varioLimitClimbCombo.setLayoutData((Object)varioLimitCComboLData);
            this.varioLimitClimbCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitClimbCombo.setItems(this.varioThresholds);
            this.varioLimitClimbCombo.select((int)this.configuration.varioThreshold);
            this.varioLimitClimbCombo.setEditable(false);
            this.varioLimitClimbCombo.setBackground(this.application.COLOR_WHITE);
            this.varioLimitClimbCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioLimitCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.varioThreshold = (short)GPSLoggerSetupConfiguration1.this.varioLimitClimbCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioLimitUnitLabel = new CLabel((Composite)this.gpsLoggerGroup, 0x1000000);
            RowData varioLimitUnitLabelLData = new RowData();
            varioLimitUnitLabelLData.width = 79;
            varioLimitUnitLabelLData.height = 18;
            this.varioLimitUnitLabel.setLayoutData((Object)varioLimitUnitLabelLData);
            this.varioLimitUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitUnitLabel.setText(Messages.getString((String)"GDE_MSGT2039"));
            this.varioLimitSinkLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            varioLimitLabelLData = new RowData();
            varioLimitLabelLData.width = 130;
            varioLimitLabelLData.height = 18;
            this.varioLimitSinkLabel.setLayoutData((Object)varioLimitLabelLData);
            this.varioLimitSinkLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitSinkLabel.setText(Messages.getString((String)"GDE_MSGT2074"));
            this.varioLimitSinkCombo = new CCombo((Composite)this.gpsLoggerGroup, 133120);
            varioLimitCComboLData = new RowData();
            varioLimitCComboLData.width = 66;
            varioLimitCComboLData.height = 17;
            this.varioLimitSinkCombo.setLayoutData((Object)varioLimitCComboLData);
            this.varioLimitSinkCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitSinkCombo.setItems(this.varioThresholds);
            this.varioLimitSinkCombo.select((int)this.configuration.varioThreshold);
            this.varioLimitSinkCombo.setEditable(false);
            this.varioLimitSinkCombo.setBackground(this.application.COLOR_WHITE);
            this.varioLimitSinkCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioLimitSinkCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.varioThresholdSink = (short)GPSLoggerSetupConfiguration1.this.varioLimitSinkCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioLimitUnitLabel = new CLabel((Composite)this.gpsLoggerGroup, 0x1000000);
            varioLimitUnitLabelLData = new RowData();
            varioLimitUnitLabelLData.width = 79;
            varioLimitUnitLabelLData.height = 18;
            this.varioLimitUnitLabel.setLayoutData((Object)varioLimitUnitLabelLData);
            this.varioLimitUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioLimitUnitLabel.setText(Messages.getString((String)"GDE_MSGT2039"));
            this.varioTonLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData varioTonLabelLData = new RowData();
            varioTonLabelLData.width = 130;
            varioTonLabelLData.height = 18;
            this.varioTonLabel.setLayoutData((Object)varioTonLabelLData);
            this.varioTonLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioTonLabel.setText(Messages.getString((String)"GDE_MSGT2040"));
            this.varioToneCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData varioToneComboLData = new RowData();
            varioToneComboLData.width = 66;
            varioToneComboLData.height = 17;
            this.varioToneCombo.setLayoutData((Object)varioToneComboLData);
            this.varioToneCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioToneCombo.setItems(this.varioTons);
            this.varioToneCombo.select((int)this.configuration.varioTon);
            this.varioToneCombo.setEditable(false);
            this.varioToneCombo.setBackground(this.application.COLOR_WHITE);
            this.varioToneCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioToneCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.varioTon = (short)GPSLoggerSetupConfiguration1.this.varioToneCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioFactorLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData varioFactorLabelLData = new RowData();
            varioFactorLabelLData.width = 130;
            varioFactorLabelLData.height = 18;
            this.varioFactorLabel.setLayoutData((Object)varioFactorLabelLData);
            this.varioFactorLabel.setText(Messages.getString((String)"GDE_MSGT2078"));
            this.varioFactorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFactorCombo = new CCombo((Composite)this.gpsLoggerGroup, 0x1000800);
            RowData varioFactorComboLData = new RowData();
            varioFactorComboLData.width = 66;
            varioFactorComboLData.height = 17;
            this.varioFactorCombo.setLayoutData((Object)varioFactorComboLData);
            this.varioFactorCombo.setItems(this.varioFactors);
            this.varioFactorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFactorCombo.setEditable(false);
            this.varioFactorCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.varioFactorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioFactorCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.varioFactor = (short)GPSLoggerSetupConfiguration1.this.varioFactorCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioFilterLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData varioFilterLabelLData = new RowData();
            varioFilterLabelLData.width = 130;
            varioFilterLabelLData.height = 18;
            this.varioFilterLabel.setLayoutData((Object)varioFilterLabelLData);
            this.varioFilterLabel.setText("Vario Filter");
            this.varioFilterLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFilterCombo = new CCombo((Composite)this.gpsLoggerGroup, 0x1000800);
            RowData varioFilterComboLData = new RowData();
            varioFilterComboLData.width = 66;
            varioFilterComboLData.height = 17;
            this.varioFilterCombo.setLayoutData((Object)varioFilterComboLData);
            this.varioFilterCombo.setItems(this.varioFilters);
            this.varioFilterCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFilterCombo.setEditable(false);
            this.varioFilterCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.varioFilterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioFilterCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.varioFilter = (short)GPSLoggerSetupConfiguration1.this.varioFilterCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.smoothAltitudeLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData smoothAltitudeLabelLData = new RowData();
            smoothAltitudeLabelLData.width = 130;
            smoothAltitudeLabelLData.height = 18;
            this.smoothAltitudeLabel.setLayoutData((Object)smoothAltitudeLabelLData);
            this.smoothAltitudeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.smoothAltitudeLabel.setText(Messages.getString((String)"GDE_MSGI2001"));
            this.smoothAltitudeCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData smoothAltitudeComboLData = new RowData();
            smoothAltitudeComboLData.width = 66;
            smoothAltitudeComboLData.height = 17;
            this.smoothAltitudeCombo.setLayoutData((Object)smoothAltitudeComboLData);
            this.smoothAltitudeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.smoothAltitudeCombo.setItems(this.smoothAltNull);
            this.smoothAltitudeCombo.select((int)this.configuration.smoothAltitudeNulling);
            this.smoothAltitudeCombo.setEditable(false);
            this.smoothAltitudeCombo.setBackground(this.application.COLOR_WHITE);
            this.smoothAltitudeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioToneCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.smoothAltitudeNulling = (byte)GPSLoggerSetupConfiguration1.this.smoothAltitudeCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.modusIgcLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData modusIgcLabelLData = new RowData();
            modusIgcLabelLData.width = 130;
            modusIgcLabelLData.height = 18;
            this.modusIgcLabel.setLayoutData((Object)modusIgcLabelLData);
            this.modusIgcLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.modusIgcLabel.setText(Messages.getString((String)"GDE_MSGT2068"));
            this.modusIgcCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData modusIgcComboLData = new RowData();
            modusIgcComboLData.width = 66;
            modusIgcComboLData.height = 17;
            this.modusIgcCombo.setLayoutData((Object)modusIgcComboLData);
            this.modusIgcCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.modusIgcCombo.setItems(this.igcModes);
            this.modusIgcCombo.select((int)this.configuration.modusIGC);
            this.modusIgcCombo.setEditable(false);
            this.modusIgcCombo.setBackground(this.application.COLOR_WHITE);
            this.modusIgcCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioToneCCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.modusIGC = (short)GPSLoggerSetupConfiguration1.this.modusIgcCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.modusDistanceLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData modusDistanceLabelLData = new RowData();
            modusDistanceLabelLData.width = 130;
            modusDistanceLabelLData.height = 18;
            this.modusDistanceLabel.setLayoutData((Object)modusDistanceLabelLData);
            this.modusDistanceLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.modusDistanceLabel.setText(Messages.getString((String)"GDE_MSGT2027"));
            this.modusDistanceCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData modusDistanceComboLData = new RowData();
            modusDistanceComboLData.width = 66;
            modusDistanceComboLData.height = 17;
            this.modusDistanceCombo.setLayoutData((Object)modusDistanceComboLData);
            this.modusDistanceCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.modusDistanceCombo.setItems(this.distanceModes);
            this.modusDistanceCombo.select((int)this.configuration.modusDistance);
            this.modusDistanceCombo.setEditable(false);
            this.modusDistanceCombo.setBackground(this.application.COLOR_WHITE);
            this.modusDistanceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "modusDistanceCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.modusDistance = (short)GPSLoggerSetupConfiguration1.this.modusDistanceCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.minMaxRxLabel = new CLabel((Composite)this.gpsLoggerGroup, 131072);
            RowData minMaxRxLabelLData = new RowData();
            minMaxRxLabelLData.width = 130;
            minMaxRxLabelLData.height = 18;
            this.minMaxRxLabel.setLayoutData((Object)minMaxRxLabelLData);
            this.minMaxRxLabel.setText(Messages.getString((String)"GDE_MSGT2080"));
            this.minMaxRxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.minMaxRxCombo = new CCombo((Composite)this.gpsLoggerGroup, 2048);
            RowData minMaxRxComboLData = new RowData();
            minMaxRxComboLData.width = 66;
            minMaxRxComboLData.height = 17;
            this.minMaxRxCombo.setLayoutData((Object)minMaxRxComboLData);
            this.minMaxRxCombo.setItems(Messages.getString((String)"GDE_MSGT2081").split(","));
            this.minMaxRxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.minMaxRxCombo.setEditable(false);
            this.minMaxRxCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.minMaxRxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "minMaxRxCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.rxControl = (short)GPSLoggerSetupConfiguration1.this.minMaxRxCombo.getSelectionIndex();
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.gpsTelemertieAlarmGroup = new Group((Composite)this, 0);
            FormData gpsTelemertieGroupLData = new FormData();
            gpsTelemertieGroupLData.left = new FormAttachment(0, 1000, 10);
            gpsTelemertieGroupLData.top = new FormAttachment(0, 1000, 470);
            gpsTelemertieGroupLData.width = 290;
            gpsTelemertieGroupLData.height = 155;
            this.gpsTelemertieAlarmGroup.setLayoutData((Object)gpsTelemertieGroupLData);
            this.gpsTelemertieAlarmGroup.setLayout((Layout)new RowLayout(256));
            this.gpsTelemertieAlarmGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gpsTelemertieAlarmGroup.setText(Messages.getString((String)"GDE_MSGT2041"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            RowData fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 275;
            fillerCompositeRALData.height = 5;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.heightMaxAlarmButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            RowData heightButtonLData = new RowData();
            heightButtonLData.width = 100;
            heightButtonLData.height = 16;
            this.heightMaxAlarmButton.setLayoutData((Object)heightButtonLData);
            this.heightMaxAlarmButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightMaxAlarmButton.setText(Messages.getString((String)"GDE_MSGT2030") + " max");
            this.heightMaxAlarmButton.setSelection((this.configuration.telemetryAlarms & 1) > 0);
            this.heightMaxAlarmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "heightButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.heightMaxAlarmButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 1) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 1);
                    GPSLoggerSetupConfiguration1.this.heightMaxAlarmButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 1) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.heightMaxAlarmCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            RowData heightCComboLData = new RowData();
            heightCComboLData.width = 70;
            heightCComboLData.height = 17;
            this.heightMaxAlarmCombo.setLayoutData((Object)heightCComboLData);
            this.heightMaxAlarmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightMaxAlarmCombo.setItems(this.heightValues);
            this.heightMaxAlarmCombo.setText(String.format("%5d", this.configuration.heightAlarm));
            this.heightMaxAlarmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "heightCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.heightAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.heightMaxAlarmCombo.getText().trim());
                    GPSLoggerSetupConfiguration1.this.configuration.heightAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.heightAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.heightAlarm > 4000 ? 4000 : (int)GPSLoggerSetupConfiguration1.this.configuration.heightAlarm));
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.heightMaxAlarmCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "heightCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.heightMaxAlarmCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "heightCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.heightAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.heightMaxAlarmCombo.getText().trim());
                        GPSLoggerSetupConfiguration1.this.configuration.heightAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.heightAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.heightAlarm > 4000 ? 4000 : (int)GPSLoggerSetupConfiguration1.this.configuration.heightAlarm));
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.heightMaxAlarmLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            RowData heightLabelLData = new RowData();
            heightLabelLData.width = 89;
            heightLabelLData.height = 18;
            this.heightMaxAlarmLabel.setLayoutData((Object)heightLabelLData);
            this.heightMaxAlarmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightMaxAlarmLabel.setText(Messages.getString((String)"GDE_MSGT2042"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.speedMaxAlarmButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            RowData velocityButtonLData = new RowData();
            velocityButtonLData.width = 100;
            velocityButtonLData.height = 16;
            this.speedMaxAlarmButton.setLayoutData((Object)velocityButtonLData);
            this.speedMaxAlarmButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedMaxAlarmButton.setText(Messages.getString((String)"GDE_MSGT2043") + " max");
            this.speedMaxAlarmButton.setSelection((this.configuration.telemetryAlarms & 2) > 0);
            this.speedMaxAlarmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "velocityButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.speedMaxAlarmButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 2) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 2);
                    GPSLoggerSetupConfiguration1.this.speedMaxAlarmButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 2) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.speedMaxAlarmCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            RowData velocityCComboLData = new RowData();
            velocityCComboLData.width = 70;
            velocityCComboLData.height = 17;
            this.speedMaxAlarmCombo.setLayoutData((Object)velocityCComboLData);
            this.speedMaxAlarmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedMaxAlarmCombo.setItems(this.speedValues);
            this.speedMaxAlarmCombo.setText(String.format("%5d", this.configuration.speedMaxAlarm));
            this.speedMaxAlarmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "velocityCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.speedMaxAlarmCombo.getText().trim());
                    GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm > 1000 ? 1000 : (int)GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm));
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.speedMaxAlarmCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "velocityCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.speedMaxAlarmCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "velocityCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.speedMaxAlarmCombo.getText().trim());
                        GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm > 1000 ? 1000 : (int)GPSLoggerSetupConfiguration1.this.configuration.speedMaxAlarm));
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.speedAlarmLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            RowData velocityLabelLData = new RowData();
            velocityLabelLData.width = 89;
            velocityLabelLData.height = 18;
            this.speedAlarmLabel.setLayoutData((Object)velocityLabelLData);
            this.speedAlarmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedAlarmLabel.setText(Messages.getString((String)"GDE_MSGT2044"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.speedMinAlarmButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            velocityButtonLData = new RowData();
            velocityButtonLData.width = 100;
            velocityButtonLData.height = 16;
            this.speedMinAlarmButton.setLayoutData((Object)velocityButtonLData);
            this.speedMinAlarmButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedMinAlarmButton.setText(Messages.getString((String)"GDE_MSGT2043") + " min");
            this.speedMinAlarmButton.setSelection((this.configuration.telemetryAlarms & 0x400) > 0);
            this.speedMinAlarmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "velocityButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.speedMinAlarmButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 0x400) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 0x400);
                    GPSLoggerSetupConfiguration1.this.speedMinAlarmButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 0x400) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.speedMinAlarmCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            velocityCComboLData = new RowData();
            velocityCComboLData.width = 70;
            velocityCComboLData.height = 17;
            this.speedMinAlarmCombo.setLayoutData((Object)velocityCComboLData);
            this.speedMinAlarmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedMinAlarmCombo.setItems(this.speedValues);
            this.speedMinAlarmCombo.setText(String.format("%5d", this.configuration.speedMinAlarm));
            this.speedMinAlarmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "velocityCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.speedMinAlarmCombo.getText().trim());
                    GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm > 1000 ? 1000 : (int)GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm));
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.speedMinAlarmCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "velocityCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.speedMinAlarmCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "velocityCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.speedMinAlarmCombo.getText().trim());
                        GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm > 1000 ? 1000 : (int)GPSLoggerSetupConfiguration1.this.configuration.speedMinAlarm));
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.speedAlarmLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            velocityLabelLData = new RowData();
            velocityLabelLData.width = 89;
            velocityLabelLData.height = 18;
            this.speedAlarmLabel.setLayoutData((Object)velocityLabelLData);
            this.speedAlarmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.speedAlarmLabel.setText(Messages.getString((String)"GDE_MSGT2044"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.distanceMaxButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            RowData distanceButtonLData = new RowData();
            distanceButtonLData.width = 100;
            distanceButtonLData.height = 16;
            this.distanceMaxButton.setLayoutData((Object)distanceButtonLData);
            this.distanceMaxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMaxButton.setText(Messages.getString((String)"GDE_MSGT2045"));
            this.distanceMaxButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.distanceMaxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "distanceButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.distanceMaxButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 4) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 4);
                    GPSLoggerSetupConfiguration1.this.distanceMaxButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 4) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.distanceMaxCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            RowData distanceCComboLData = new RowData();
            distanceCComboLData.width = 70;
            distanceCComboLData.height = 17;
            this.distanceMaxCombo.setLayoutData((Object)distanceCComboLData);
            this.distanceMaxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMaxCombo.setItems(this.distanceValues);
            this.distanceMaxCombo.setText(String.format("%5d", this.configuration.distanceMaxAlarm));
            this.distanceMaxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "distanceCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.distanceMaxCombo.getText().trim());
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.distanceMaxCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "distanceCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.distanceMaxCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "distanceCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.distanceMaxCombo.getText().trim());
                        GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm < 10 ? 10 : (GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm > 5000 ? 5000 : (int)GPSLoggerSetupConfiguration1.this.configuration.distanceMaxAlarm));
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.distanceMaxLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            RowData distanceLabelLData = new RowData();
            distanceLabelLData.width = 89;
            distanceLabelLData.height = 18;
            this.distanceMaxLabel.setLayoutData((Object)distanceLabelLData);
            this.distanceMaxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMaxLabel.setText(Messages.getString((String)"GDE_MSGT2046"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.distanceMinButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            distanceButtonLData = new RowData();
            distanceButtonLData.width = 100;
            distanceButtonLData.height = 16;
            this.distanceMinButton.setLayoutData((Object)distanceButtonLData);
            this.distanceMinButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMinButton.setText(Messages.getString((String)"GDE_MSGT2082"));
            this.distanceMinButton.setSelection((this.configuration.telemetryAlarms & 0x200) > 0);
            this.distanceMinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "distanceMinButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.distanceMinButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 0x200) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 0x200);
                    GPSLoggerSetupConfiguration1.this.distanceMinButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 0x200) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.distanceMinCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            distanceCComboLData = new RowData();
            distanceCComboLData.width = 70;
            distanceCComboLData.height = 17;
            this.distanceMinCombo.setLayoutData((Object)distanceCComboLData);
            this.distanceMinCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMinCombo.setItems(this.distanceValues);
            this.distanceMinCombo.setText(String.format("%5d", this.configuration.distanceMinAlarm));
            this.distanceMinCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "distanceMinCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.distanceMinCombo.getText().trim());
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.distanceMinCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "distanceMinCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.distanceMinCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "distanceMinCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm = (short)Integer.parseInt(GPSLoggerSetupConfiguration1.this.distanceMinCombo.getText().trim());
                        GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm = GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm < 0 ? 0 : (GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm > 5000 ? 5000 : (int)GPSLoggerSetupConfiguration1.this.configuration.distanceMinAlarm);
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.distanceMinLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            distanceLabelLData = new RowData();
            distanceLabelLData.width = 89;
            distanceLabelLData.height = 18;
            this.distanceMinLabel.setLayoutData((Object)distanceLabelLData);
            this.distanceMinLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.distanceMinLabel.setText(Messages.getString((String)"GDE_MSGT2046"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.tripLengthButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            RowData pathLengthButtonLData = new RowData();
            pathLengthButtonLData.width = 100;
            pathLengthButtonLData.height = 16;
            this.tripLengthButton.setLayoutData((Object)pathLengthButtonLData);
            this.tripLengthButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tripLengthButton.setText(Messages.getString((String)"GDE_MSGT2047"));
            this.tripLengthButton.setSelection((this.configuration.telemetryAlarms & 8) > 0);
            this.tripLengthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "pathLengthButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.tripLengthButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 8) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 8);
                    GPSLoggerSetupConfiguration1.this.tripLengthButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 8) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData pathLengthCComboLData = new RowData();
            pathLengthCComboLData.width = 70;
            pathLengthCComboLData.height = 17;
            this.tripLengthCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            this.tripLengthCombo.setLayoutData((Object)pathLengthCComboLData);
            this.tripLengthCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tripLengthCombo.setItems(this.tripValues);
            this.tripLengthCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.tripLengthAlarm / 10.0));
            this.tripLengthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "tripLengthCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm = (short)(Double.parseDouble(GPSLoggerSetupConfiguration1.this.tripLengthCombo.getText().trim().replace(',', '.')) * 10.0);
                    GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm = GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm < 1 ? 1 : (GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm > 999 ? 999 : (int)GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.distanceMaxCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "tripLengthCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.distanceMaxCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "tripLengthCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm = (short)(Double.parseDouble(GPSLoggerSetupConfiguration1.this.tripLengthCombo.getText().trim().replace(',', '.')) * 10.0);
                        GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm = GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm < 1 ? 1 : (GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm > 999 ? 999 : (int)GPSLoggerSetupConfiguration1.this.configuration.tripLengthAlarm);
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.tripLengthLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            RowData pathLengthLabelLData = new RowData();
            pathLengthLabelLData.width = 89;
            pathLengthLabelLData.height = 18;
            this.tripLengthLabel.setLayoutData((Object)pathLengthLabelLData);
            this.tripLengthLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tripLengthLabel.setText(Messages.getString((String)"GDE_MSGT2048"));
            this.fillerComposite = new Composite((Composite)this.gpsTelemertieAlarmGroup, 0);
            fillerCompositeRALData = new RowData();
            fillerCompositeRALData.width = 15;
            fillerCompositeRALData.height = 18;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRALData);
            this.voltageRxButton = new Button((Composite)this.gpsTelemertieAlarmGroup, 16416);
            RowData voltageRxButtonLData = new RowData();
            voltageRxButtonLData.width = 100;
            voltageRxButtonLData.height = 16;
            this.voltageRxButton.setLayoutData((Object)voltageRxButtonLData);
            this.voltageRxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxButton.setText(Messages.getString((String)"GDE_MSGT2049"));
            this.voltageRxButton.setSelection((this.configuration.telemetryAlarms & 0x10) > 0);
            this.voltageRxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageRxButton.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms = GPSLoggerSetupConfiguration1.this.voltageRxButton.getSelection() ? (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms | 0x10) : (short)(GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms ^ 0x10);
                    GPSLoggerSetupConfiguration1.this.voltageRxButton.setSelection((GPSLoggerSetupConfiguration1.this.configuration.telemetryAlarms & 0x10) > 0);
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.voltageRxCombo = new CCombo((Composite)this.gpsTelemertieAlarmGroup, 2048);
            RowData voltageRxCComboLData = new RowData();
            voltageRxCComboLData.width = 70;
            voltageRxCComboLData.height = 17;
            this.voltageRxCombo.setLayoutData((Object)voltageRxCComboLData);
            this.voltageRxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxCombo.setItems(this.voltageRxValues);
            this.voltageRxCombo.setText(String.format(Locale.ENGLISH, "%6.2f", (double)this.configuration.voltageRxAlarm / 100.0));
            this.voltageRxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageRxCombo.widgetSelected, event=" + evt);
                    GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm = (short)(Double.parseDouble(GPSLoggerSetupConfiguration1.this.voltageRxCombo.getText().trim().replace(',', '.')) * 100.0);
                    GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm < 300 ? 300 : (GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm > 800 ? 800 : (int)GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm));
                    GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.voltageRxCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "voltageRxCombo.verify, event=" + verifyevent);
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.voltageRxCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "voltageRxCombo.keyReleased, event=" + keyevent);
                    try {
                        GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm = (short)(Double.parseDouble(GPSLoggerSetupConfiguration1.this.voltageRxCombo.getText().trim().replace(',', '.')) * 100.0);
                        GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm = (short)(GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm < 300 ? 300 : (GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm > 800 ? 800 : (int)GPSLoggerSetupConfiguration1.this.configuration.voltageRxAlarm));
                        GPSLoggerSetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.voltageRxLabel = new CLabel((Composite)this.gpsTelemertieAlarmGroup, 0x1000000);
            RowData voltageRxLabelLData = new RowData();
            voltageRxLabelLData.width = 89;
            voltageRxLabelLData.height = 18;
            this.voltageRxLabel.setLayoutData((Object)voltageRxLabelLData);
            this.voltageRxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxLabel.setText(Messages.getString((String)"GDE_MSGT2050"));
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

