/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTlogReader;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.logging.Logger;

public class HoTTlogReader2
extends HoTTlogReader {
    static final Logger log = Logger.getLogger(HoTTlogReader2.class.getName());
    static int[] points;
    static RecordSet recordSet;
    static boolean isJustMigrated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        String $METHOD_NAME = "read";
        pickerParameters = newPickerParameters;
        HashMap<String, String> fileInfoHeader = HoTTlogReader2.getFileInfo(new File(filePath), newPickerParameters);
        detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(fileInfoHeader.get("DETECTED SENSOR"));
        File file = new File(fileInfoHeader.get("FilePath"));
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        HoTTAdapter2 device = (HoTTAdapter2)HoTTbinReader.application.getActiveDevice();
        isHoTTAdapter2 = application.getActiveDevice() instanceof HoTTAdapter2;
        int recordSetNumber = ((Channel)HoTTbinReader.channels.get((Object)1)).maxSize() + 1;
        String recordSetName = "";
        String recordSetNameExtend = HoTTlogReader2.getRecordSetExtend(file);
        Channel channel = null;
        int channelNumber = HoTTlogReader2.pickerParameters.analyzer.getActiveChannel().getNumber();
        boolean isReceiverData = false;
        boolean isVarioData = false;
        boolean isGPSData = false;
        boolean isGeneralData = false;
        boolean isElectricData = false;
        boolean isEscData = false;
        boolean isEsc2Data = false;
        boolean isEsc3Data = false;
        boolean isEsc4Data = false;
        recordSet = null;
        isJustMigrated = false;
        points = new int[device.getNumberOfMeasurements(channelNumber)];
        long[] timeSteps_ms = new long[]{0L};
        int numberLogChannels = Integer.valueOf(fileInfoHeader.get("LOG NOB CHANNEL"));
        boolean isASCII = fileInfoHeader.get("LOG TYPE").contains("ASCII");
        int rawDataBlockSize = Integer.parseInt(fileInfoHeader.get("RAW_LOG_SIZE"));
        int asciiDataBlockSize = Integer.parseInt(fileInfoHeader.get("ASCII_LOG_SIZE"));
        dataBlockSize = isASCII ? asciiDataBlockSize : rawDataBlockSize;
        buf = new byte[HoTTbinReader.dataBlockSize];
        int[] valuesRec = new int[10];
        int[] valuesChn = new int[23];
        int[] valuesVar = new int[13];
        int[] valuesGPS = new int[24];
        int[] valuesGAM = new int[26];
        int[] valuesEAM = new int[31];
        int[] valuesESC = new int[30];
        int[] valuesESC2 = new int[30];
        int[] valuesESC3 = new int[30];
        int[] valuesESC4 = new int[30];
        rcvLogParser = (HoTTlogReader.RcvLogParser)HoTTAdapter.Sensor.RECEIVER.createLogParser(HoTTbinReader.pickerParameters, valuesRec, timeSteps_ms, buf, numberLogChannels);
        chnLogParser = (HoTTlogReader.ChnLogParser)HoTTAdapter.Sensor.CHANNEL.createLogParser(HoTTbinReader.pickerParameters, valuesChn, timeSteps_ms, buf, numberLogChannels);
        varLogParser = (HoTTlogReader.VarLogParser)HoTTAdapter.Sensor.VARIO.createLogParser(HoTTbinReader.pickerParameters, valuesVar, timeSteps_ms, buf, numberLogChannels);
        gpsLogParser = (HoTTlogReader.GpsLogParser)HoTTAdapter.Sensor.GPS.createLogParser(HoTTbinReader.pickerParameters, valuesGPS, timeSteps_ms, buf, numberLogChannels);
        gamLogParser = (HoTTlogReader.GamLogParser)HoTTAdapter.Sensor.GAM.createLogParser(HoTTbinReader.pickerParameters, valuesGAM, timeSteps_ms, buf, numberLogChannels);
        eamLogParser = (HoTTlogReader.EamLogParser)HoTTAdapter.Sensor.EAM.createLogParser(HoTTbinReader.pickerParameters, valuesEAM, timeSteps_ms, buf, numberLogChannels);
        escLogParser = (HoTTlogReader.EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(HoTTbinReader.pickerParameters, valuesESC, timeSteps_ms, buf, numberLogChannels);
        esc2LogParser = (HoTTlogReader.Esc2LogParser)HoTTAdapter.Sensor.ESC2.createLogParser(HoTTbinReader.pickerParameters, valuesESC2, timeSteps_ms, buf, numberLogChannels);
        esc3LogParser = (HoTTlogReader.Esc3LogParser)HoTTAdapter.Sensor.ESC3.createLogParser(HoTTbinReader.pickerParameters, valuesESC3, timeSteps_ms, buf, numberLogChannels);
        esc4LogParser = (HoTTlogReader.Esc4LogParser)HoTTAdapter.Sensor.ESC4.createLogParser(HoTTbinReader.pickerParameters, valuesESC4, timeSteps_ms, buf, numberLogChannels);
        int logTimeStep_ms = 1000 / Integer.valueOf(fileInfoHeader.get("COUNTER").split("/")[1].split(" ")[0]);
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean isESC2detected = false;
        boolean isESC3detected = false;
        boolean isESC4detected = false;
        int logDataOffset = Integer.valueOf(fileInfoHeader.get("LOG DATA OFFSET"));
        long numberDatablocks = Long.parseLong(fileInfoHeader.get("LogCount"));
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(fileInfoHeader.get("LOG START TIME"), HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks));
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = HoTTbinReader.application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        try {
            String packageLossPercentage;
            HoTTAdapter.Sensor altitudeClimbSensorSelection;
            String newFileDescription;
            channel = (Channel)HoTTbinReader.channels.get((Object)channelNumber);
            String string = newFileDescription = HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || HoTTbinReader.application.isObjectoriented() && !channel.getFileDescription().contains(HoTTbinReader.application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
            channel.put((Object)recordSetName, (Object)recordSet);
            RecordSet tmpRecordSet = (RecordSet)channel.get((Object)recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            data_in.skip(logDataOffset);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(HoTTbinReader.buf);
                if (isASCII) {
                    HoTTlogReader.convertAscii2Raw(rawDataBlockSize, HoTTbinReader.buf);
                }
                if (HoTTbinReader.buf[8] != 0 && HoTTbinReader.buf[9] != 0 && HoTTbinReader.buf[24] != 31) break;
                ++i;
            }
            while ((long)i < numberDatablocks) {
                data_in.read(HoTTbinReader.buf);
                if (log.isLoggable(Level.FINE)) {
                    if (isASCII) {
                        log.logp(Level.FINE, HoTTbinReader.$CLASS_NAME, "read", new String(HoTTbinReader.buf));
                    } else {
                        log.logp(Level.FINE, HoTTbinReader.$CLASS_NAME, "read", StringHelper.byte2Hex4CharString((byte[])HoTTbinReader.buf, (int)HoTTbinReader.buf.length));
                    }
                }
                if (isASCII) {
                    HoTTlogReader.convertAscii2Raw(rawDataBlockSize, HoTTbinReader.buf);
                }
                if (HoTTbinReader.buf[8] != 0 && HoTTbinReader.buf[9] != 0) {
                    if (HoTTbinReader.buf[24] == 31) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "sensitivity data " + StringHelper.byte2Hex2CharString((byte[])HoTTbinReader.buf, (int)HoTTbinReader.buf.length));
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %02X", HoTTbinReader.buf[26]));
                        }
                        rcvLogParser.trackPackageLoss(true);
                        if (log.isLoggable(Level.FINEST)) {
                            log.logp(Level.FINEST, HoTTbinReader.$CLASS_NAME, "read", StringHelper.byte2Hex2CharString((byte[])new byte[]{HoTTbinReader.buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)HoTTbinReader.buf[7], (boolean)false));
                        }
                        if (HoTTbinReader.buf[24] != 31) {
                            isReceiverData = rcvLogParser.parse();
                            System.arraycopy(valuesRec, 0, points, 0, 10);
                        }
                        if (channelNumber == 4) {
                            chnLogParser.parse();
                            System.arraycopy(valuesChn, 3, points, 87, 20);
                        }
                        switch ((byte)(HoTTbinReader.buf[26] & 0xFF)) {
                            case -112: {
                                isVarioData = varLogParser.parse();
                                if (!isVarioData || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(varLogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isVarioDetected) break;
                                HoTTAdapter2.updateVarioTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, recordSet);
                                isVarioDetected = true;
                                break;
                            }
                            case -96: {
                                isGPSData = gpsLogParser.parse();
                                if (!isGPSData || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(gpsLogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isGPSdetected) break;
                                HoTTAdapter2.updateGpsTypeDependent(HoTTbinReader.buf[65] & 0xFF, (IDevice)device, recordSet, 0);
                                isGPSdetected = true;
                                break;
                            }
                            case -48: {
                                isGeneralData = gamLogParser.parse();
                                if (!isGeneralData || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(gamLogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                break;
                            }
                            case -32: {
                                isElectricData = eamLogParser.parse();
                                if (!isElectricData || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(eamLogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                break;
                            }
                            case -64: {
                                isEscData = escLogParser.parse(recordSet, escLogParser.getTimeStep_ms());
                                if (!isEscData || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(escLogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isESCdetected) break;
                                HoTTAdapter2.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, recordSet, 1);
                                isESCdetected = true;
                                break;
                            }
                            case 80: {
                                if (channelNumber != 6 || !(isEsc2Data = esc2LogParser.parse(recordSet, esc2LogParser.getTimeStep_ms())) || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(esc2LogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isESC2detected) break;
                                HoTTAdapter2.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, recordSet, 2);
                                detectedSensors.add(HoTTAdapter.Sensor.ESC2);
                                isESC2detected = true;
                                break;
                            }
                            case 96: {
                                if (channelNumber != 6 || !(isEsc3Data = esc3LogParser.parse(recordSet, esc3LogParser.getTimeStep_ms())) || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(esc3LogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isESC3detected) break;
                                HoTTAdapter2.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, recordSet, 3);
                                detectedSensors.add(HoTTAdapter.Sensor.ESC3);
                                isESC3detected = true;
                                break;
                            }
                            case 112: {
                                if (channelNumber != 6 || !(isEsc4Data = esc4LogParser.parse(recordSet, esc4LogParser.getTimeStep_ms())) || !isReceiverData) break;
                                HoTTlogReader2.migrateAddPoints(esc4LogParser.getTimeStep_ms(), isVarioData, isGPSData, isGeneralData, isElectricData, isEscData, isEsc2Data, isEsc3Data, isEsc4Data, channelNumber, valuesVar, valuesGPS, valuesGAM, valuesEAM, valuesESC, valuesESC2, valuesESC3, valuesESC4);
                                isReceiverData = false;
                                if (isESC4detected) break;
                                HoTTAdapter2.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, recordSet, 4);
                                detectedSensors.add(HoTTAdapter.Sensor.ESC4);
                                isESC4detected = true;
                                break;
                            }
                        }
                        if (isReceiverData) {
                            recordSet.addPoints(points, (double)rcvLogParser.getTimeStep_ms());
                            isReceiverData = false;
                        } else if (channelNumber == 4 && !isJustMigrated) {
                            recordSet.addPoints(points, (double)chnLogParser.getTimeStep_ms());
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms;
                        isJustMigrated = !rcvLogParser.updateLossStatistics();
                        isJustMigrated = false;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                    }
                    rcvLogParser.trackPackageLoss(false);
                    if (channelNumber == 4) {
                        chnLogParser.parse();
                        System.arraycopy(valuesChn, 3, points, 87, 20);
                        recordSet.addPoints(points, (double)chnLogParser.getTimeStep_ms());
                    }
                    timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms;
                }
                ++i;
            }
            HoTTAdapter.Sensor sensor = altitudeClimbSensorSelection = HoTTlogReader2.pickerParameters.altitudeClimbSensorSelection == 0 ? null : HoTTAdapter.Sensor.fromOrdinal(HoTTlogReader2.pickerParameters.altitudeClimbSensorSelection);
            if (HoTTlogReader2.pickerParameters.altitudeClimbSensorSelection == 0 || !detectedSensors.contains((Object)HoTTAdapter.Sensor.fromOrdinal(HoTTlogReader2.pickerParameters.altitudeClimbSensorSelection))) {
                if (isElectricData && !isVarioData && !isGPSData && !isGeneralData) {
                    altitudeClimbSensorSelection = HoTTAdapter.Sensor.EAM;
                } else if (isGeneralData && !isVarioData && !isGPSData) {
                    altitudeClimbSensorSelection = HoTTAdapter.Sensor.GAM;
                } else if (isGPSData && !isVarioData) {
                    altitudeClimbSensorSelection = HoTTAdapter.Sensor.GPS;
                } else if (isVarioData) {
                    altitudeClimbSensorSelection = HoTTAdapter.Sensor.VARIO;
                }
            }
            rcvLogParser.finalUpdateLossStatistics();
            String string2 = packageLossPercentage = tmpRecordSet.getRecordDataSize(true) > 0 ? String.format("%.1f", HoTTlogReader2.rcvLogParser.getLostPackages().percentage) : "100";
            if (channelNumber == 4) {
                HoTTbinReader.detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            tmpRecordSet.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{rcvLogParser.getLossTotal(), HoTTlogReader.rcvLogParser.getLostPackages().lossTotal, packageLossPercentage, HoTTlogReader.rcvLogParser.getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", detectedSensors.toString()) + (altitudeClimbSensorSelection != null && (detectedSensors.contains((Object)HoTTAdapter.Sensor.fromOrdinal(HoTTlogReader2.pickerParameters.altitudeClimbSensorSelection)) || detectedSensors.contains((Object)altitudeClimbSensorSelection)) ? String.format(" - %s = %s", new Object[]{Messages.getString((String)"GDE_MSGT2419"), altitudeClimbSensorSelection}) : ""));
            log.logp(Level.WARNING, HoTTbinReader.$CLASS_NAME, "read", "skipped number receiver data due to package loss = " + HoTTlogReader2.rcvLogParser.getLostPackages().lossTotal);
            log.logp(Level.TIME, HoTTbinReader.$CLASS_NAME, "read", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                GDE.getUiNotification().setProgress(99);
                device.makeInActiveDisplayable(recordSet);
                device.updateVisibilityStatus(recordSet, true);
                channel.applyTemplate(recordSetName, false);
                recordSet.descriptionAppendFilename(file.getName());
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    public static void migrateAddPoints(long timeStep_ms, boolean isVarioData, boolean isGPSData, boolean isGeneralData, boolean isElectricData, boolean isEscData, boolean isEsc2Data, boolean isEsc3Data, boolean isEsc4Data, int channelNumber, int[] valuesVario, int[] valuesGPS, int[] valuesGAM, int[] valuesEAM, int[] valuesESC, int[] valuesESC2, int[] valuesESC3, int[] valuesESC4) throws DataInconsitsentException {
        int k;
        int j;
        if (isElectricData) {
            for (j = 0; !(isVarioData || isGPSData || isGeneralData || j >= 3); ++j) {
                HoTTlogReader2.points[j + 10] = valuesEAM[j + 20];
            }
            System.arraycopy(valuesEAM, 1, points, 60, 19);
            System.arraycopy(valuesEAM, 23, points, 79, 8);
        }
        if (isGeneralData) {
            for (k = 0; !isVarioData && !isGPSData && k < 3; ++k) {
                HoTTlogReader2.points[k + 10] = valuesGAM[k + 13];
            }
            for (j = 0; j < 12; ++j) {
                HoTTlogReader2.points[j + 38] = valuesGAM[j + 1];
            }
            for (j = 0; j < 10; ++j) {
                HoTTlogReader2.points[j + 50] = valuesGAM[j + 16];
            }
        }
        if (isGPSData) {
            for (j = 0; !isVarioData && j < 3; ++j) {
                HoTTlogReader2.points[j + 10] = valuesGPS[j + 3];
            }
            HoTTlogReader2.points[20] = valuesGPS[1];
            HoTTlogReader2.points[21] = valuesGPS[2];
            for (k = 0; k < 4; ++k) {
                HoTTlogReader2.points[k + 22] = valuesGPS[k + 6];
            }
            for (k = 0; k < 3; ++k) {
                HoTTlogReader2.points[k + 26] = valuesGPS[k + 12];
            }
            for (k = 0; k < 9; ++k) {
                HoTTlogReader2.points[k + 29] = valuesGPS[k + 15];
            }
        }
        if (isVarioData) {
            for (j = 0; j < 4; ++j) {
                HoTTlogReader2.points[j + 10] = valuesVario[j + 1];
            }
            HoTTlogReader2.points[14] = valuesVario[7];
            for (j = 0; j < 5; ++j) {
                HoTTlogReader2.points[j + 15] = valuesVario[j + 8];
            }
        }
        if (isEscData) {
            if (channelNumber == 4) {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 107] = valuesESC[j + 1];
                }
            } else {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 87] = valuesESC[j + 1];
                }
            }
        }
        if (isEsc2Data) {
            if (channelNumber == 4) {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 107] = valuesESC2[j + 1];
                }
            } else {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 116] = valuesESC2[j + 1];
                }
            }
        }
        if (isEsc3Data) {
            if (channelNumber == 4) {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 107] = valuesESC3[j + 1];
                }
            } else {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 145] = valuesESC3[j + 1];
                }
            }
        }
        if (isEsc4Data) {
            if (channelNumber == 4) {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 107] = valuesESC4[j + 1];
                }
            } else {
                for (j = 0; j < 29; ++j) {
                    HoTTlogReader2.points[j + 174] = valuesESC4[j + 1];
                }
            }
        }
        switch (HoTTAdapter.Sensor.VALUES[HoTTbinReader.pickerParameters.altitudeClimbSensorSelection]) {
            case VARIO: {
                if (!isVarioData) break;
                for (j = 0; j < 4; ++j) {
                    HoTTlogReader2.points[j + 10] = valuesVario[j + 1];
                }
                break;
            }
            case GPS: {
                if (isGPSData) {
                    for (j = 0; j < 3; ++j) {
                        HoTTlogReader2.points[j + 10] = valuesGPS[j + 3];
                    }
                }
                HoTTlogReader2.points[11] = 0;
                break;
            }
            case GAM: {
                if (isGeneralData) {
                    for (j = 0; j < 3; ++j) {
                        HoTTlogReader2.points[j + 10] = valuesGAM[j + 13];
                    }
                }
                HoTTlogReader2.points[11] = 0;
                break;
            }
            case EAM: {
                if (isElectricData) {
                    for (j = 0; j < 3; ++j) {
                        HoTTlogReader2.points[j + 10] = valuesEAM[j + 20];
                    }
                }
                HoTTlogReader2.points[11] = 0;
                break;
            }
        }
        recordSet.addPoints(points, (double)timeStep_ms);
        isJustMigrated = true;
    }

    static {
        isJustMigrated = false;
    }
}

