/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.Channel;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.StatisticsType;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinReaderD;
import gde.device.graupner.HoTTlogReaderD;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.FileDialog;

public class HoTTAdapterD
extends HoTTAdapter2
implements IDevice {
    static final Logger log = Logger.getLogger(HoTTAdapterD.class.getName());

    public HoTTAdapterD(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    public HoTTAdapterD(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    @Override
    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2400"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean isInitialSwitched = false;
                    HoTTAdapterD.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".bin") && !selectedImportFile.toLowerCase().endsWith(".log")) {
                            log.log(Level.WARNING, String.format("skip selectedImportFile %s since it has not a supported file ending", selectedImportFile));
                        }
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String directoryName = ObjectKeyCompliance.getUpcomingObjectKey((Path)Paths.get(selectedImportFile, new String[0]));
                        if (!directoryName.isEmpty()) {
                            ObjectKeyCompliance.createObjectKey((String)directoryName);
                        }
                        try {
                            if (selectedImportFile.toLowerCase().endsWith(".bin")) {
                                HoTTbinReaderD.read(selectedImportFile, new HoTTAdapter.PickerParameters(HoTTAdapterD.this.pickerParameters));
                            } else if (selectedImportFile.toLowerCase().endsWith(".log")) {
                                HoTTlogReaderD.read(selectedImportFile, new HoTTAdapter.PickerParameters(HoTTAdapterD.this.pickerParameters));
                            }
                            if (!isInitialSwitched) {
                                Channel activeChannel = HoTTAdapterD.this.application.getActiveChannel();
                                HoTTbinReaderD.channels.switchChannel(activeChannel.getName());
                                if (selectedImportFile.toLowerCase().endsWith(".bin")) {
                                    activeChannel.switchRecordSet(HoTTbinReaderD.recordSet.getName());
                                } else if (selectedImportFile.toLowerCase().endsWith(".log")) {
                                    activeChannel.switchRecordSet(HoTTlogReaderD.recordSet.getName());
                                }
                                isInitialSwitched = true;
                            } else {
                                HoTTAdapterD.this.makeInActiveDisplayable(HoTTbinReaderD.recordSet);
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    HoTTAdapterD.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        int latOrdinal = 20;
        int lonOrdinal = 21;
        if (record.getOrdinal() == 20 || record.getOrdinal() == 21) {
            int grad = (int)(value / 1000.0);
            double minuten = (value - (double)grad * 1000.0) / 10.0;
            newValue = (double)grad + minuten / 60.0;
        } else if (record.getOrdinal() >= 87 && record.getOrdinal() <= 102 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = (value - reduction) * factor + 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - reduction) * factor + offset;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        int latOrdinal = 20;
        int lonOrdinal = 21;
        if (record.getOrdinal() == 20 || record.getOrdinal() == 21) {
            int grad = (int)value;
            double minuten = (value - (double)grad * 1.0) * 60.0;
            newValue = ((double)grad + minuten / 100.0) * 1000.0;
        } else if (record.getOrdinal() >= 87 && record.getOrdinal() <= 102 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = value / factor + reduction - 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                int ordinal = record.getOrdinal();
                dataTableRow[index + 1] = ordinal >= 0 && ordinal <= 5 ? String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0) : (ordinal == 106 && record.getUnit().equals("") ? (record.realGet(rowIndex) == 0 ? "" : String.format("'%c'", record.realGet(rowIndex) / 1000 + 64)) : (ordinal == 33 && record.getUnit().endsWith("HH:mm:ss.SSS") ? HoTTAdapter.getFormattedTime(record.realGet(rowIndex)) : (ordinal == 34 && record.getUnit().endsWith("yy-MM-dd") ? HoTTAdapter.getFormattedDate(record.realGet(rowIndex) / 10) : record.getFormattedTableValue(rowIndex))));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    protected static void updateEscTypeDependent(int version, IDevice device, RecordSet tmpRecordSet, int numESC) {
        int channelConfigNumber = tmpRecordSet.getChannelConfigNumber();
        int offsetNumberESC = (numESC - 1) * 29;
        int channelOffset = 20 + offsetNumberESC;
        if (version == 3) {
            tmpRecordSet.get(100 + channelOffset).setName(device.getMeasurementReplacement("speed") + " M" + numESC);
            tmpRecordSet.get(100 + channelOffset).setUnit("km/h");
            device.getMeasurement(channelConfigNumber, 100 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(101 + channelOffset).setName(device.getMeasurementReplacement("speed") + " M" + numESC + "_max");
            tmpRecordSet.get(101 + channelOffset).setUnit("km/h");
            tmpRecordSet.get(102 + channelOffset).setName("PWM M" + numESC);
            tmpRecordSet.get(102 + channelOffset).setUnit("%");
            tmpRecordSet.get(103 + channelOffset).setName(device.getMeasurementReplacement("throttle") + " M" + numESC);
            tmpRecordSet.get(103 + channelOffset).setUnit("%");
            tmpRecordSet.get(104 + channelOffset).setName(device.getMeasurementReplacement("voltage_bec") + " M" + numESC);
            tmpRecordSet.get(104 + channelOffset).setUnit("V");
            tmpRecordSet.get(104 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 104 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(104 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(105 + channelOffset).setName(device.getMeasurementReplacement("voltage_bec") + " M" + numESC + "_min");
            tmpRecordSet.get(105 + channelOffset).setUnit("V");
            tmpRecordSet.get(105 + channelOffset).setFactor(0.1);
            tmpRecordSet.get(105 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(106 + channelOffset).setName(device.getMeasurementReplacement("current_bec") + " M" + numESC);
            tmpRecordSet.get(106 + channelOffset).setUnit("A");
            tmpRecordSet.get(106 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 106 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(107 + channelOffset).setName(device.getMeasurementReplacement("temperature_bec") + " M" + numESC);
            tmpRecordSet.get(107 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(107 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 107 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(108 + channelOffset).setName(device.getMeasurementReplacement("temperature_capacitor") + " M" + numESC);
            tmpRecordSet.get(108 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(108 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 108 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(109 + channelOffset).setName(device.getMeasurementReplacement("timing") + " M" + numESC);
            tmpRecordSet.get(109 + channelOffset).setUnit("\u00b0");
            tmpRecordSet.get(110 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " M" + numESC + "_3");
            tmpRecordSet.get(110 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(110 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 110 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(111 + channelOffset).setName(device.getMeasurementReplacement("gear") + " M" + numESC);
            tmpRecordSet.get(111 + channelOffset).setUnit("");
            tmpRecordSet.get(112 + channelOffset).setName("YGEGenExt M" + numESC);
            tmpRecordSet.get(112 + channelOffset).setUnit("");
            tmpRecordSet.get(113 + channelOffset).setName("MotStatEscNr M" + numESC);
            tmpRecordSet.get(113 + channelOffset).setUnit("#");
        } else if (version >= 128) {
            tmpRecordSet.get(87 + channelOffset).setName(device.getMeasurementReplacement("voltage") + " ECU" + numESC);
            tmpRecordSet.get(88 + channelOffset).setName(device.getMeasurementReplacement("current") + " ECU" + numESC);
            tmpRecordSet.get(92 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT" + numESC + " 1");
            tmpRecordSet.get(93 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT" + numESC + " 2");
            tmpRecordSet.get(94 + channelOffset).setName(device.getMeasurementReplacement("voltage") + " ECU" + numESC + "_min");
            tmpRecordSet.get(95 + channelOffset).setName(device.getMeasurementReplacement("current") + " ECU" + numESC + "_max");
            tmpRecordSet.get(97 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT" + numESC + " 1_max");
            tmpRecordSet.get(98 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT" + numESC + " 2_max");
            tmpRecordSet.get(100 + channelOffset).setName(device.getMeasurementReplacement("air_speed") + " M" + numESC);
            tmpRecordSet.get(100 + channelOffset).setUnit("km/h");
            device.getMeasurement(channelConfigNumber, 100 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(101 + channelOffset).setName(device.getMeasurementReplacement("air_speed") + " M" + numESC + "_max");
            tmpRecordSet.get(101 + channelOffset).setUnit("km/h");
            tmpRecordSet.get(102 + channelOffset).setName("PWM M");
            tmpRecordSet.get(102 + channelOffset).setUnit("%");
            tmpRecordSet.get(103 + channelOffset).setName(device.getMeasurementReplacement("throttle") + " M" + numESC);
            tmpRecordSet.get(103 + channelOffset).setUnit("%");
            tmpRecordSet.get(104 + channelOffset).setName(device.getMeasurementReplacement("voltage_pump") + " M" + numESC);
            tmpRecordSet.get(104 + channelOffset).setUnit("V");
            tmpRecordSet.get(104 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 104 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(105 + channelOffset).setName(device.getMeasurementReplacement("voltage_pump") + " M" + numESC + "_min");
            tmpRecordSet.get(105 + channelOffset).setUnit("V");
            tmpRecordSet.get(105 + channelOffset).setFactor(0.1);
            tmpRecordSet.get(106 + channelOffset).setName(device.getMeasurementReplacement("flow") + " M" + numESC);
            tmpRecordSet.get(106 + channelOffset).setUnit("ml/min");
            device.getMeasurement(channelConfigNumber, 106 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(107 + channelOffset).setName(device.getMeasurementReplacement("fuel") + " M" + numESC);
            tmpRecordSet.get(107 + channelOffset).setUnit("ml");
            device.getMeasurement(channelConfigNumber, 107 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(108 + channelOffset).setName(device.getMeasurementReplacement("power") + " M" + numESC);
            tmpRecordSet.get(108 + channelOffset).setUnit("W");
            device.getMeasurement(channelConfigNumber, 108 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(109 + channelOffset).setName(device.getMeasurementReplacement("thrust") + " M" + numESC);
            tmpRecordSet.get(109 + channelOffset).setUnit("N");
            tmpRecordSet.get(110 + channelOffset).setName(device.getMeasurementReplacement("temperature_pump") + " M" + numESC);
            tmpRecordSet.get(110 + channelOffset).setUnit("\u00b0C");
            device.getMeasurement(channelConfigNumber, 110 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(111 + channelOffset).setName(device.getMeasurementReplacement("engine") + " M" + numESC);
            tmpRecordSet.get(111 + channelOffset).setUnit("");
        }
    }
}

