/*
 * Decompiled with CFR 0.152.
 */
package gde.device.tttronix;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.tttronix.GathererThread;
import gde.device.tttronix.QcCopter;
import gde.device.tttronix.QcCopterSerialPort;
import gde.device.tttronix.QcCopterTabItem;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class QcCopterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(QcCopterDialog.class.getName());
    CTabFolder tabFolder;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();
    Text terminalText;
    Composite terminalComposite;
    CTabItem terminalTabItem;
    Button saveButton;
    Button startConfiguration;
    Button closeButton;
    GathererThread dataGatherThread;
    final QcCopter device;
    final QcCopterSerialPort serialPort;
    final Settings settings;
    int measurementsCount = 0;
    int tabFolderSelectionIndex = 0;

    public QcCopterDialog(Shell parent, QcCopter useDevice) {
        super(parent);
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
        for (int i = 1; i <= this.device.getChannelCount(); ++i) {
            int actualMeasurementCount = this.device.getNumberOfMeasurements(i);
            this.measurementsCount = actualMeasurementCount > this.measurementsCount ? actualMeasurementCount : this.measurementsCount;
        }
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(600, 100 + this.measurementsCount * 30 / 2 + 55);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                QcCopterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (QcCopterDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{QcCopterDialog.this.device.getPropertiesFileName()});
                            if (QcCopterDialog.this.application.openYesNoMessageDialog(QcCopterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                QcCopterDialog.this.device.storeDeviceProperties();
                                QcCopterDialog.this.setClosePossible(true);
                            }
                        }
                        QcCopterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        QcCopterDialog.this.application.openHelpDialog("QC-Copter", "HelpInfo.html");
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.terminalTabItem = new CTabItem(this.tabFolder, 0);
                this.terminalTabItem.setText("Terminal");
                this.terminalComposite = new Composite((Composite)this.tabFolder, 0);
                GridLayout terminalCompositeLayout = new GridLayout();
                this.terminalComposite.setLayout((Layout)terminalCompositeLayout);
                this.terminalTabItem.setControl((Control)this.terminalComposite);
                this.terminalText = new Text(this.terminalComposite, 18498);
                GridData terminalTextLData = new GridData();
                terminalTextLData.widthHint = 410;
                terminalTextLData.heightHint = 300;
                terminalTextLData.grabExcessHorizontalSpace = true;
                terminalTextLData.grabExcessVerticalSpace = true;
                terminalTextLData.verticalAlignment = 2;
                terminalTextLData.horizontalAlignment = 2;
                this.terminalText.setLayoutData((Object)terminalTextLData);
                this.terminalText.setText("012345678901234567890123456789012345678901234567890\n1\n2\n3\n4\n5\n6\n7\n8\n9\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9");
                this.terminalText.setFont(SWTResourceManager.getFont((String)(GDE.IS_LINUX ? "Monospace" : "Courier"), (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    this.configurations.add(new QcCopterTabItem(this.tabFolder, this, i + 1, this.device));
                }
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 120;
                saveButtonLData.height = 30;
                saveButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                saveButtonLData.left = new FormAttachment(0, 1000, 55);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        QcCopterDialog.this.device.storeDeviceProperties();
                        QcCopterDialog.this.saveButton.setEnabled(false);
                    }
                });
                this.startConfiguration = new Button((Composite)this.dialogShell, 0x1000008);
                FormData startConfigurationLData = new FormData();
                startConfigurationLData.height = 30;
                startConfigurationLData.left = new FormAttachment(0, 1000, 200);
                startConfigurationLData.right = new FormAttachment(1000, 1000, -200);
                startConfigurationLData.bottom = new FormAttachment(1000, 1000, -10);
                this.startConfiguration.setLayoutData((Object)startConfigurationLData);
                this.startConfiguration.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startConfiguration.setText(this.device.serialPort.isConnected() ? "stop configurartion" : "start configurartion");
                this.startConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "startConfiguration.widgetSelected, event=" + evt);
                        QcCopterDialog.this.device.open_closeCommPort();
                        QcCopterDialog.this.checkPortStatus();
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 120;
                closeButtonLData.height = 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -55);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        QcCopterDialog.this.dialogShell.dispose();
                    }
                });
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        int channelNumber;
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + evt);
                        if (QcCopterDialog.this.tabFolder.getSelectionIndex() > 0 && (channelNumber = QcCopterDialog.this.tabFolder.getSelectionIndex() - 1) >= 0 && channelNumber <= QcCopterDialog.this.device.getChannelCount()) {
                            String configKey = ++channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels channels = Channels.getInstance();
                            Channel activeChannel = channels.getActiveChannel();
                            if (activeChannel != null) {
                                log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                                RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                                if (activeRecordSet != null && activeChannel.getNumber() != channelNumber) {
                                    int answer = QcCopterDialog.this.application.openYesNoMessageDialog(QcCopterDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGI1901"));
                                    if (answer == 64) {
                                        String recordSetKey = activeRecordSet.getName();
                                        Channel tmpChannel = (Channel)channels.get((Object)channelNumber);
                                        if (tmpChannel != null) {
                                            log.log(Level.FINE, "move record set " + recordSetKey + " to channel/configuration " + channelNumber + " : " + configKey);
                                            tmpChannel.put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                                            activeChannel.remove(recordSetKey);
                                            channels.switchChannel(channelNumber, recordSetKey);
                                            RecordSet newActiveRecordSet = ((Channel)channels.get((Object)channelNumber)).getActiveRecordSet();
                                            if (newActiveRecordSet != null) {
                                                QcCopterDialog.this.device.updateVisibilityStatus(newActiveRecordSet, true);
                                                QcCopterDialog.this.device.makeInActiveDisplayable(newActiveRecordSet);
                                            }
                                        }
                                    }
                                    QcCopterDialog.this.application.updateCurveSelectorTable();
                                }
                            }
                        }
                        QcCopterDialog.this.tabFolderSelectionIndex = QcCopterDialog.this.tabFolder.getSelectionIndex();
                    }
                });
                Channel activChannel = Channels.getInstance().getActiveChannel();
                if (activChannel != null) {
                    RecordSet activeRecordSet = activChannel.getActiveRecordSet();
                    if (activeRecordSet != null) {
                        this.tabFolder.setSelection(activeRecordSet.getChannelConfigNumber());
                        this.tabFolderSelectionIndex = this.tabFolder.getSelectionIndex();
                    } else if (this.device.serialPort.isMatchAvailablePorts(this.device.getPort()) && !this.device.serialPort.isConnected()) {
                        this.device.open_closeCommPort();
                    }
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
                this.checkPortStatus();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolderSelectionIndex;
    }

    public void setTerminalText(final String newText) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!QcCopterDialog.this.dialogShell.isDisposed()) {
                    QcCopterDialog.this.terminalText.setText(newText);
                    QcCopterDialog.this.terminalText.update();
                    log.logp(Level.FINER, "QCCopterDialog", "setTerminalText()", newText);
                }
            }
        });
    }

    void checkPortStatus() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!QcCopterDialog.this.startConfiguration.isDisposed()) {
                    if (QcCopterDialog.this.device.serialPort.isConnected()) {
                        QcCopterDialog.this.startConfiguration.setText("stop configurartion");
                    } else {
                        QcCopterDialog.this.startConfiguration.setText("start configurartion");
                    }
                }
            }
        });
    }
}

