/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextWriterBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

class HTMLWriter
extends StyledTextWriterBase {
    private String tag;
    private boolean multiline;

    public HTMLWriter(StyledText styledText, int n, int n2, StyledTextContent styledTextContent) {
        super(styledText, n, n2);
        String string = styledTextContent.getTextRange(n, n2);
        this.multiline = string.contains("\n");
        this.tag = this.multiline ? "div" : "span";
        this.writeHeader();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.write("</" + this.tag + ">");
            this.write("</" + this.tag + ">");
            super.close();
        }
    }

    @Override
    void writeHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        HTMLWriter.appendStyle(stringBuilder, "background-color:", this.styledText.getMarginColor(), ";");
        HTMLWriter.appendStyle(stringBuilder2, "color:", this.styledText.getForeground(), ";");
        HTMLWriter.appendStyle(stringBuilder2, "background-color:", this.styledText.getBackground(), ";");
        HTMLWriter.appendStyle(stringBuilder, "padding:" + this.styledText.getTopMargin() + "px " + this.styledText.getRightMargin() + "px " + this.styledText.getBottomMargin() + "px " + this.styledText.getLeftMargin() + "px;");
        String string = HTMLWriter.appendFont(stringBuilder2, this.styledText.getFont(), 0);
        int n = this.styledText.getIndent();
        if (n != 0) {
            HTMLWriter.appendStyle(stringBuilder2, "text-indent:", n, "px;");
        }
        if (this.styledText.getWordWrap()) {
            HTMLWriter.appendStyle(stringBuilder2, "white-space:pre-wrap;");
        } else {
            HTMLWriter.appendStyle(stringBuilder2, "white-space:pre;");
        }
        HTMLWriter.appendAlignAndJustify(stringBuilder2, this.styledText.getAlignment(), this.styledText.getJustify());
        if (this.styledText.getOrientation() == 0x4000000 || this.styledText.getTextDirection() == 0x4000000) {
            HTMLWriter.appendStyle(stringBuilder2, "direction:rtl;");
        }
        this.write("<" + this.tag + " style='" + stringBuilder + "'>");
        if (string == null || string.isEmpty()) {
            this.write("<" + this.tag + " style='" + stringBuilder2 + "'>");
        } else {
            this.write("<" + this.tag + " lang='" + string + "' style='" + stringBuilder2 + "'>");
        }
    }

    @Override
    public void writeLineDelimiter(String string) {
        if (this.isClosed()) {
            SWT.error(39);
        }
    }

    @Override
    String writeLineStart(Color color, int n, int n2, int n3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        HTMLWriter.appendAlignAndJustify(stringBuilder, n3, bl);
        HTMLWriter.appendStyle(stringBuilder, "background-color:", color, ";");
        if (n != 0) {
            HTMLWriter.appendStyle(stringBuilder, "text-indent:", n, "px;");
        }
        if (n2 == 0) {
            HTMLWriter.appendStyle(stringBuilder, "margin:0;");
        } else {
            HTMLWriter.appendStyle(stringBuilder, "margin:", n2, " 0 0 0;");
        }
        if (!this.multiline) {
            return "";
        }
        if (stringBuilder.length() == 0) {
            this.write("<p>");
        } else {
            this.write("<p style='" + stringBuilder + "'>");
        }
        return "</p>";
    }

    @Override
    void writeEmptyLine() {
        this.write("<br>");
    }

    @Override
    String writeSpanStart(StyleRange styleRange) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        HTMLWriter.appendStyle(stringBuilder2, "color:", styleRange.foreground, ";");
        HTMLWriter.appendStyle(stringBuilder2, "background-color:", styleRange.background, ";");
        HTMLWriter.appendFont(stringBuilder2, styleRange.font, styleRange.fontStyle);
        if (styleRange.rise != 0) {
            HTMLWriter.appendStyle(stringBuilder2, "position:relative;bottom:", styleRange.rise, "pt;");
        }
        String string = styleRange.borderColor != null ? " " + HTMLWriter.colorToHex(styleRange.borderColor) : "";
        switch (styleRange.borderStyle) {
            case 1: 
            case 2048: {
                HTMLWriter.appendStyle(stringBuilder2, "border:solid 1pt", string, ";");
                break;
            }
            case 2: {
                HTMLWriter.appendStyle(stringBuilder2, "border:dashed 1pt", string, ";");
                break;
            }
            case 4: {
                HTMLWriter.appendStyle(stringBuilder2, "border:dotted 1pt", string, ";");
                break;
            }
        }
        if (styleRange.underline) {
            HTMLWriter.appendStyle(stringBuilder2, "text-decoration:underline;");
            HTMLWriter.appendStyle(stringBuilder2, "text-decoration-color:", styleRange.underlineColor, ";");
            switch (styleRange.underlineStyle) {
                case 0: {
                    HTMLWriter.appendStyle(stringBuilder2, "text-decoration-style:solid;");
                    break;
                }
                case 1: {
                    HTMLWriter.appendStyle(stringBuilder2, "text-decoration-style:double;");
                    break;
                }
                case 2: {
                    HTMLWriter.appendStyle(stringBuilder2, "text-decoration-style:wavy;");
                    break;
                }
                case 3: {
                    HTMLWriter.appendStyle(stringBuilder2, "text-decoration-style:wavy;");
                    break;
                }
                case 4: {
                    HTMLWriter.appendStyle(stringBuilder2, "text-decoration-style:solid;");
                    if (styleRange.underlineColor == null) {
                        HTMLWriter.appendStyle(stringBuilder2, "text-decoration-color:#0066cc;");
                    }
                    if (styleRange.foreground != null) break;
                    HTMLWriter.appendStyle(stringBuilder2, "color:#0066cc;");
                    break;
                }
            }
        }
        if (styleRange.strikeout) {
            stringBuilder = new StringBuilder();
            HTMLWriter.appendStyle(stringBuilder, "text-decoration:line-through;");
            HTMLWriter.appendStyle(stringBuilder, "text-decoration-color:", styleRange.strikeoutColor, ";");
        } else {
            stringBuilder = null;
        }
        if (stringBuilder2.length() != 0) {
            this.write("<span style='" + stringBuilder2 + "'>");
        }
        if (stringBuilder != null) {
            this.write("<span style='" + stringBuilder + "'>");
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        if (stringBuilder != null) {
            stringBuilder3.append("</span>");
        }
        if (stringBuilder2.length() != 0) {
            stringBuilder3.append("</span>");
        }
        return stringBuilder3.toString();
    }

    @Override
    String escapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        string.chars().forEach(n -> {
            switch (n) {
                case 38: {
                    stringBuilder.append("&amp;");
                    break;
                }
                case 34: {
                    stringBuilder.append("&quot;");
                    break;
                }
                case 60: {
                    stringBuilder.append("&lt;");
                    break;
                }
                case 62: {
                    stringBuilder.append("&gt;");
                    break;
                }
                default: {
                    stringBuilder.append((char)n);
                }
            }
        });
        return stringBuilder.toString();
    }

    private static String colorToHex(Color color) {
        if (color == null) {
            return null;
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static void appendStyle(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
    }

    private static void appendStyle(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.append(string3);
    }

    private static void appendStyle(StringBuilder stringBuilder, String string, int n, String string2) {
        stringBuilder.append(string);
        stringBuilder.append(n);
        stringBuilder.append(string2);
    }

    private static void appendStyle(StringBuilder stringBuilder, String string, Color color, String string2) {
        if (color != null) {
            stringBuilder.append(string);
            stringBuilder.append(HTMLWriter.colorToHex(color));
            stringBuilder.append(string2);
        }
    }

    private static String appendFont(StringBuilder stringBuilder, Font font, int n) {
        FontData[] fontDataArray;
        String string = null;
        if (font != null && (fontDataArray = font.getFontData()) != null && fontDataArray.length > 0) {
            FontData fontData = fontDataArray[0];
            String string2 = fontData.getName();
            if (string2 != null && !string2.isEmpty()) {
                HTMLWriter.appendStyle(stringBuilder, "font-family:\"", fontData.getName(), "\";");
            }
            HTMLWriter.appendStyle(stringBuilder, "font-size:", fontData.getHeight(), "pt;");
            string = fontData.getLocale();
            n = fontData.getStyle();
        }
        if (n != 0) {
            if ((n & 2) == 2) {
                HTMLWriter.appendStyle(stringBuilder, "font-style:italic;");
            }
            if ((n & 1) == 1) {
                HTMLWriter.appendStyle(stringBuilder, "font-weight:bold;");
            }
        }
        return string;
    }

    private static void appendAlignAndJustify(StringBuilder stringBuilder, int n, boolean bl) {
        String string;
        if (bl) {
            HTMLWriter.appendStyle(stringBuilder, "text-align:justify;");
            string = "text-align-last:";
        } else {
            string = "text-align:";
        }
        switch (n) {
            case 16384: {
                break;
            }
            case 0x1000000: {
                HTMLWriter.appendStyle(stringBuilder, string, "center", ";");
                break;
            }
            case 131072: {
                HTMLWriter.appendStyle(stringBuilder, string, "right", ";");
                break;
            }
        }
    }
}

