/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class GDBus {
    static final String SWT_GDBUS_VERSION_INFO = "SWT_LIB GDbus firing up. Implementation v1.5";
    private static boolean initialized;
    private static List<GDBusMethod> gdbusMethods;
    private static final String DBUS_SERVICE_NAME = "org.eclipse.swt";
    private static final String DBUS_OBJECT_NAME = "/org/eclipse/swt";
    private static final String INTERFACE_NAME = "org.eclipse.swt";
    private static Callback onBusAcquired;
    private static Callback onNameAcquired;
    private static Callback onNameLost;
    private static Callback handleMethod;

    public static void init(GDBusMethod[] gDBusMethodArray, String string) {
        Object object = "org.eclipse.swt";
        if (initialized) {
            return;
        }
        initialized = true;
        if (gDBusMethodArray == null || gDBusMethodArray.length == 0) {
            System.err.println("SWT Error, no gdbus methods to initialize.");
            return;
        }
        if (string != null) {
            string = string.replaceAll("[^0-9A-Za-z_.\\-]", "-");
            object = (String)object + "." + string;
        }
        gdbusMethods = Arrays.asList(gDBusMethodArray);
        int n = OS.g_bus_own_name(2, Converter.javaStringToCString((String)object), 3, onBusAcquired.getAddress(), onNameAcquired.getAddress(), onNameLost.getAddress(), 0L, 0L);
        if (n == 0) {
            System.err.println("SWT GDBus: Failed to aquire bus name: " + (String)object);
        }
    }

    static void teardown_gdbus() {
    }

    private static long onBusAcquired(long l, long l2, long l3) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("<node><interface name='org.eclipse.swt'>\n");
        for (GDBusMethod gDBusMethod : gdbusMethods) {
            ((StringBuilder)object).append("  <method name='" + gDBusMethod.name + "'>\n");
            ((StringBuilder)object).append("   " + gDBusMethod.getMethodArgsXmlSignature() + "\n");
            ((StringBuilder)object).append("  </method>\n");
        }
        ((StringBuilder)object).append("</interface></node>");
        Object object2 = new long[1];
        long l4 = OS.g_dbus_node_info_new_for_xml(Converter.javaStringToCString(((StringBuilder)object).toString()), (long[])object2);
        if (l4 == 0L || object2[0] != 0L) {
            System.err.println("SWT GDBus: Failed to get introspection data");
        }
        assert (l4 != 0L) : "SWT GDBus: introspection data should not be 0";
        object = new long[1];
        long l5 = OS.g_dbus_node_info_lookup_interface(l4, Converter.javaStringToCString("org.eclipse.swt"));
        long[] lArray = new long[]{handleMethod.getAddress(), 0L, 0L};
        OS.g_dbus_connection_register_object(l, Converter.javaStringToCString(DBUS_OBJECT_NAME), l5, lArray, 0L, 0L, (long[])object);
        if (object[0] != 0L) {
            System.err.println("SWT GDBus: Failed to register object: /org/eclipse/swt");
            return 0L;
        }
        return 0L;
    }

    private static long onNameAcquired(long l, long l2, long l3) {
        return 0L;
    }

    private static long onNameLost(long l, long l2, long l3) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long handleMethod(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        long l9 = 0L;
        try {
            String string = Converter.cCharPtrToJavaString(l5, false);
            for (GDBusMethod gDBusMethod : gdbusMethods) {
                if (!gDBusMethod.getName().equals(string)) continue;
                Object[] objectArray = GDBus.convertGVariantToJava(l6);
                Object[] objectArray2 = gDBusMethod.getUserFunction().apply(objectArray);
                if (objectArray2 == null || objectArray2 instanceof Object[]) {
                    l9 = GDBus.convertJavaToGVariant(objectArray2);
                } else {
                    System.err.println("SWT GDBus error processing user return value: " + objectArray2.toString() + ". Return value must be an Object[] or null.");
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("SWT GDBUS ERROR: Error in handling method: \n" + exception.getMessage());
        }
        finally {
            OS.g_dbus_method_invocation_return_value(l7, l9);
        }
        return 0L;
    }

    public static Object[] convertGVariantToJava(long l) {
        Object object = GDBus.convertGVariantToJavaHelper(l);
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        System.err.println("SWT GDBus Error converting arguments : Expecting object array, received Object.");
        return null;
    }

    private static Object convertGVariantToJavaHelper(long l) {
        if (OS.g_variant_is_of_type(l, OS.G_VARIANT_TYPE_STRING)) {
            return Converter.cCharPtrToJavaString(OS.g_variant_get_string(l, null), false);
        }
        if (OS.g_variant_is_of_type(l, OS.G_VARIANT_TYPE_BOOLEAN)) {
            return OS.g_variant_get_boolean(l);
        }
        if (OS.g_variant_is_of_type(l, OS.G_VARIANT_TYPE_IN32)) {
            return OS.g_variant_get_int32(l);
        }
        if (OS.g_variant_is_of_type(l, OS.G_VARIANT_TYPE_TUPLE)) {
            int n = (int)OS.g_variant_n_children(l);
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = GDBus.convertGVariantToJavaHelper(OS.g_variant_get_child_value(l, i));
            }
            return objectArray;
        }
        if (OS.g_variant_is_of_type(l, OS.G_VARIANT_TYPE_STRING_ARRAY)) {
            int n = (int)OS.g_variant_n_children(l);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)GDBus.convertGVariantToJavaHelper(OS.g_variant_get_child_value(l, i));
            }
            return stringArray;
        }
        String string = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(l), false);
        System.err.println("SWT GDBus: Error. Unhandled variant type (i.e DBus type):  " + string + "     You probably need to update  (SWT) GDBus.java:convertGVariantToJavaHelper() to support this type.");
        SWT.error(5);
        return null;
    }

    public static long convertJavaToGVariant(Object object) throws SWTException {
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            return OS.g_variant_new_string(Converter.javaStringToCString((String)object));
        }
        if (object instanceof Boolean) {
            return OS.g_variant_new_boolean((Boolean)object);
        }
        if (object instanceof Integer) {
            return OS.g_variant_new_int32((Integer)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = GDBus.convertJavaToGVariant(objectArray[i]);
            }
            return OS.g_variant_new_tuple(lArray, n);
        }
        System.err.println("SWT GDbus: Invalid object being returned to caller: " + object.toString() + "   You probably need to update (SWT) GDBus.java:convertJavaToGVariant()");
        throw new SWTException(5);
    }

    static {
        onBusAcquired = new Callback(GDBus.class, "onBusAcquired", 3);
        onNameAcquired = new Callback(GDBus.class, "onNameAcquired", 3);
        onNameLost = new Callback(GDBus.class, "onNameLost", 3);
        handleMethod = new Callback(GDBus.class, "handleMethod", 8);
        String string = OS.getEnvironmentalVariable("SWT_LIB_VERSIONS");
        if (string != null && string.equals("1")) {
            System.out.println(SWT_GDBUS_VERSION_INFO);
        }
    }

    public static class GDBusMethod {
        private final String name;
        private final Function<Object[], Object[]> userFunction;
        private final String methodArgsXmlSignature;

        public GDBusMethod(String string, String[][] stringArray, String[][] stringArray2, Function<Object[], Object[]> function) {
            this.name = string;
            this.userFunction = function;
            StringBuilder stringBuilder = new StringBuilder();
            for (String[] stringArray3 : stringArray) {
                stringBuilder.append("     <arg type='" + stringArray3[0] + "' name='" + stringArray3[1] + "' direction='in'/>\n");
            }
            for (String[] stringArray3 : stringArray2) {
                stringBuilder.append("     <arg type='" + stringArray3[0] + "' name='" + stringArray3[1] + "' direction='out'/>\n");
            }
            this.methodArgsXmlSignature = stringBuilder.toString();
        }

        private String getName() {
            return this.name;
        }

        private Function<Object[], Object[]> getUserFunction() {
            return this.userFunction;
        }

        private String getMethodArgsXmlSignature() {
            return this.methodArgsXmlSignature;
        }
    }
}

