/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    long frameHandle;
    long labelHandle;
    long imageHandle;
    long boxHandle;
    Image image;
    String text;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.labelHandle == 0L) {
            return;
        }
        control._getAccessible().addRelation(9, this._getAccessible());
        control.labelRelation = this;
    }

    @Override
    Point computeNativeSize(long l, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = n;
        int n4 = n2;
        boolean bl3 = bl2 = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (bl2 && n == -1 && n2 == -1) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            GtkRequisition gtkRequisition2 = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(l, gtkRequisition2, gtkRequisition);
            n3 = gtkRequisition2.width;
            n4 = gtkRequisition.height;
            return new Point(n3, n4);
        }
        return super.computeNativeSize(l, n, n2, bl);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point;
        long l;
        boolean bl2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                if (n == -1) {
                    n = 64;
                }
            } else if (n2 == -1) {
                n2 = 64;
            }
        }
        boolean bl3 = bl2 = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (bl2 || this.frameHandle != 0L) {
            this.forceResize();
        }
        if (bl2) {
            l = GTK.gtk_label_get_layout(this.labelHandle);
            int n3 = OS.pango_layout_get_width(l);
            if (n != -1) {
                OS.pango_layout_set_width(l, n * 1024);
            } else {
                OS.pango_layout_set_width(l, -1);
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.pango_layout_get_pixel_size(l, nArray, nArray2);
            OS.pango_layout_set_width(l, n3);
            if (this.frameHandle != 0L) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                GTK.gtk_widget_get_size_request(this.labelHandle, nArray3, nArray4);
                GTK.gtk_widget_set_size_request(this.labelHandle, 1, 1);
                point = this.computeNativeSize(this.frameHandle, -1, -1, bl);
                GTK.gtk_widget_set_size_request(this.labelHandle, nArray3[0], nArray4[0]);
                --point.y;
            } else {
                point = new Point(0, 0);
            }
            point.x = --point.x + (n == -1 ? nArray[0] : n);
            point.y = point.y + (n2 == -1 ? nArray2[0] : n2);
        } else if (this.frameHandle != 0L) {
            int[] nArray = new int[1];
            int[] nArray5 = new int[1];
            GTK.gtk_widget_get_size_request(this.handle, nArray, nArray5);
            GTK.gtk_widget_set_size_request(this.handle, n, n2);
            point = this.computeNativeSize(this.frameHandle, -1, -1, bl);
            GTK.gtk_widget_set_size_request(this.handle, nArray[0], nArray5[0]);
        } else {
            point = this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n2 == -1 && this.labelHandle != 0L) {
            l = GTK.gtk_label_get_layout(this.labelHandle);
            long l2 = OS.pango_layout_get_context(l);
            long l3 = OS.pango_context_get_language(l2);
            long l4 = this.getFontDescription();
            long l5 = OS.pango_context_get_metrics(l2, l4, l3);
            OS.pango_font_description_free(l4);
            int n4 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(l5));
            int n5 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(l5));
            OS.pango_font_metrics_unref(l5);
            int n6 = n4 + n5;
            int[] nArray = new int[1];
            int[] nArray6 = new int[1];
            OS.g_object_get(this.labelHandle, OS.margin_bottom, nArray, 0L);
            OS.g_object_get(this.labelHandle, OS.margin_top, nArray6, 0L);
            n6 += nArray[0] + nArray6[0];
            if (this.frameHandle != 0L) {
                n6 += 2 * this.getThickness((long)this.frameHandle).y;
                n6 += 2 * this.gtk_container_get_border_width_or_margin(this.frameHandle);
            }
            point.y = Math.max(point.y, n6);
        }
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                this.handle = GTK.gtk_separator_new(0);
                if (this.handle != 0L) {
                    GTK.gtk_widget_set_valign(this.handle, 3);
                }
            } else {
                this.handle = GTK.gtk_separator_new(1);
                if (this.handle != 0L) {
                    GTK.gtk_widget_set_halign(this.handle, 3);
                }
            }
            if (this.handle == 0L) {
                this.error(2);
            }
        } else if (GTK.GTK4) {
            this.handle = this.gtk_box_new(0, false, 0);
            if (this.handle == 0L) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = GTK4.gtk_picture_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            GTK4.gtk_box_append(this.handle, this.labelHandle);
            GTK4.gtk_box_append(this.handle, this.imageHandle);
            this.gtk_box_set_child_packing(this.handle, this.labelHandle, true, true, 0, 0);
            this.gtk_box_set_child_packing(this.handle, this.imageHandle, true, true, 0, 0);
        } else {
            this.handle = GTK3.gtk_event_box_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.boxHandle = this.gtk_box_new(0, false, 0);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = GTK.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(this.handle, this.boxHandle);
            GTK3.gtk_container_add(this.boxHandle, this.labelHandle);
            GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
            this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 0);
            this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
        }
        if ((this.style & 0x800) != 0) {
            this.frameHandle = GTK.gtk_frame_new(null);
            if (this.frameHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                OS.swt_fixed_add(this.fixedHandle, this.frameHandle);
                GTK4.gtk_frame_set_child(this.frameHandle, this.handle);
            } else {
                GTK3.gtk_container_add(this.fixedHandle, this.frameHandle);
                GTK3.gtk_container_add(this.frameHandle, this.handle);
                GTK3.gtk_frame_set_shadow_type(this.frameHandle, 3);
            }
        } else if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x40) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_label_set_wrap(this.labelHandle, true);
                GTK4.gtk_label_set_wrap_mode(this.labelHandle, 2);
            } else {
                GTK3.gtk_label_set_line_wrap(this.labelHandle, true);
                GTK3.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
            }
        }
        this.setFontDescription(this.defaultFont().handle);
        this.setAlignment();
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.frameHandle != 0L) {
            this.display.removeWidget(this.frameHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.boxHandle != 0L) {
            this.display.removeWidget(this.boxHandle);
        }
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long cssHandle() {
        if ((this.style & 2) == 0) {
            return this.labelHandle;
        }
        return this.handle;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if (this.frameHandle != 0L) {
            return this.getThickness((long)this.frameHandle).x;
        }
        return 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            Control control = this;
            while (control.parent != null) {
                int n;
                Control[] controlArray = control.parent._getChildren();
                for (n = 0; n < controlArray.length && controlArray[n] != control; ++n) {
                }
                if (++n < controlArray.length && controlArray[n].setFocus()) {
                    return bl;
                }
                control = control.parent;
            }
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0L) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.frameHandle != 0L) {
            this.display.addWidget(this.frameHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0L) {
            this.display.addWidget(this.imageHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.boxHandle = 0L;
        this.labelHandle = 0L;
        this.imageHandle = 0L;
        this.frameHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    @Override
    void resizeHandle(int n, int n2) {
        OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.fixedHandle), this.fixedHandle, n, n2);
        long l = this.frameHandle != 0L ? this.frameHandle : this.handle;
        Point point = this.resizeCalculationsGTK3(l, n, n2);
        n = point.x;
        n2 = point.y;
        OS.swt_fixed_resize(GTK.gtk_widget_get_parent(l), l, n, n2);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.setAlignment();
    }

    void setAlignment() {
        if ((this.style & 0x4000) != 0) {
            this.gtk_widget_set_align(this.labelHandle, 1, 1);
            this.gtk_label_set_align(0.0f, 0.0f);
            this.gtk_widget_set_align(this.imageHandle, 1, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            this.gtk_widget_set_align(this.labelHandle, 3, 1);
            this.gtk_label_set_align(0.5f, 0.0f);
            this.gtk_widget_set_align(this.imageHandle, 3, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 2);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            this.gtk_widget_set_align(this.labelHandle, 2, 1);
            this.gtk_label_set_align(1.0f, 0.0f);
            this.gtk_widget_set_align(this.imageHandle, 2, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    private void gtk_label_set_align(float f, float f2) {
        GTK.gtk_label_set_xalign(this.labelHandle, f);
        GTK.gtk_label_set_yalign(this.labelHandle, f2);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bl2 && this.labelHandle != 0L && (this.style & 0x40) != 0;
        if (bl3) {
            GTK.gtk_widget_set_size_request(this.labelHandle, -1, -1);
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
            int n6 = gtkAllocation.width;
            int n7 = gtkAllocation.height;
            GTK.gtk_widget_set_size_request(this.labelHandle, n6, n7);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.labelHandle, gtkRequisition);
            GTK.gtk_widget_get_allocation(this.labelHandle, gtkAllocation);
            gtkAllocation.width = n6;
            gtkAllocation.height = n7;
            this.gtk_widget_size_allocate(this.labelHandle, gtkAllocation, -1);
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, l);
        }
        if (this.labelHandle != 0L) {
            int n = (this.style & 0x4000000) != 0 ? 2 : 1;
            int n2 = (this.style & 0x4000000) != 0 ? 1 : 2;
            GTK.gtk_widget_set_direction(this.labelHandle, n2);
            GTK.gtk_widget_set_direction(this.labelHandle, n);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        this.setForegroundGdkRGBA(this.fixedHandle, gdkRGBA);
        if (this.labelHandle != 0L) {
            this.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundGdkRGBA(this.imageHandle, gdkRGBA);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_set_direction(this.imageHandle, n);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        if (image != null) {
            if (GTK.GTK4) {
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_picture_set_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, image.surface);
            }
            GTK.gtk_widget_hide(this.labelHandle);
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_picture_set_paintable(this.imageHandle, 0L);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        GTK.gtk_widget_hide(this.imageHandle);
        GTK.gtk_widget_show(this.labelHandle);
    }

    @Override
    void setWidgetBackground() {
        GdkRGBA gdkRGBA = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
        super.setBackgroundGdkRGBA(this.handle, gdkRGBA);
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.frameHandle != 0L) {
            GTK.gtk_widget_show(this.frameHandle);
        }
        if (this.labelHandle != 0L) {
            GTK.gtk_widget_show(this.labelHandle);
        }
        if (this.boxHandle != 0L) {
            GTK.gtk_widget_show(this.boxHandle);
        }
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 18: {
                if (this.paintHandle() != l) break;
                return this.gtk_draw(l, l2);
            }
        }
        return super.windowProc(l, l2, l3);
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

