/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.config;

import gde.Analyzer;
import gde.histo.config.HistoGraphicsTemplate;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.InvalidPropertiesFormatException;
import java.util.logging.Level;

public final class ObjectGraphicsTemplate
extends HistoGraphicsTemplate {
    private static final long serialVersionUID = -4197176848694996415L;
    private final String objectFolderName;

    protected ObjectGraphicsTemplate(Analyzer analyzer, String objectFolderName, boolean suppressNewFile) {
        super(analyzer, suppressNewFile);
        this.objectFolderName = objectFolderName;
    }

    @Override
    public Path getTargetFileSubPath() {
        String fileName = this.histoFileName == null || this.histoFileName.equals("") ? this.defaultHistoFileName : this.histoFileName;
        return Paths.get(this.objectFolderName, fileName);
    }

    @Override
    public void load() {
        try {
            if (!this.analyzer.getDataAccess().existsGraphicsTemplate(this.getTargetFileSubPath())) {
                super.load();
            } else {
                this.currentFilePathFragment = null;
                this.loadFromXml(this.getTargetFileSubPath());
                this.currentFilePathFragment = this.getTargetFileSubPath();
            }
            this.isAvailable = true;
        }
        catch (InvalidPropertiesFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }

    @Override
    public void store() {
        String propertiesComment = "-- DataExplorer ObjectGraphicsTemplate " + this.objectFolderName + "/" + this.getTargetFileSubPath().getFileName().toString() + " " + ZonedDateTime.now().toInstant() + " -- " + this.commentSuffix;
        super.store(propertiesComment);
    }
}

