/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkRGBA;

public final class Color
extends Resource {
    public GdkRGBA handle;
    int alpha = 0;

    Color() {
    }

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3, 255);
        this.init();
    }

    public Color(int n, int n2, int n3) {
        this.init(n, n2, n3, 255);
    }

    public Color(Device device, int n, int n2, int n3, int n4) {
        super(device);
        this.init(n, n2, n3, n4);
        this.init();
    }

    public Color(int n, int n2, int n3, int n4) {
        this.init(n, n2, n3, n4);
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
        this.init();
    }

    public Color(RGB rGB) {
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
    }

    public Color(Device device, RGBA rGBA) {
        super(device);
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
        this.init();
    }

    public Color(RGBA rGBA) {
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
    }

    public Color(Device device, RGB rGB, int n) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n);
        this.init();
    }

    public Color(RGB rGB, int n) {
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n);
    }

    @Override
    void destroy() {
        this.handle = null;
    }

    @Override
    public void dispose() {
        this.destroy();
        this.device = null;
    }

    @Override
    public Device getDevice() {
        if (this.device == null && this.handle != null) {
            return Device.getDevice();
        }
        return super.getDevice();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (this.isDisposed() || color.isDisposed()) {
            return false;
        }
        GdkRGBA gdkRGBA = color.handle;
        if (this.handle == gdkRGBA) {
            return true;
        }
        if (this.getRed() != color.getRed()) {
            return false;
        }
        if (this.getGreen() != color.getGreen()) {
            return false;
        }
        if (this.getBlue() != color.getBlue()) {
            return false;
        }
        return this.getAlpha() == color.getAlpha();
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n = (int)(this.handle.blue * 65535.0 + 0.5) >> 8;
        return Math.min(n, 255);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n = (int)(this.handle.green * 65535.0 + 0.5) >> 8;
        return Math.min(n, 255);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n = (int)(this.handle.red * 65535.0 + 0.5) >> 8;
        return Math.min(n, 255);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return ((this.getAlpha() * 31 + this.getGreen()) * 31 + this.getBlue()) * 31 + this.getRed();
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = (int)(gdkRGBA.alpha * 255.0);
        return color;
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA, int n) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = n;
        return color;
    }

    void init(int n, int n2, int n3, int n4) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        gdkRGBA.red = (double)n / 255.0;
        gdkRGBA.green = (double)n2 / 255.0;
        gdkRGBA.blue = (double)n3 / 255.0;
        gdkRGBA.alpha = (double)n4 / 255.0;
        this.alpha = n4;
        this.handle = gdkRGBA;
    }

    @Override
    void init() {
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

