/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.io.DataParser;
import gde.utils.StringHelper;

public class ChargerInfo {
    private short deviceID;
    private byte[] deviceSN = new byte[12];
    private short softwareVersion;
    private short hardwareVersion;
    private short systemMemoryLength;
    private short programMemoryLength;
    private short status;
    private static final int size = 24;

    public ChargerInfo(byte[] chargerInfoBuffer) {
        this.deviceID = DataParser.parse2Short((byte)chargerInfoBuffer[0], (byte)chargerInfoBuffer[1]);
        System.arraycopy(chargerInfoBuffer, 2, this.deviceSN, 0, this.deviceSN.length);
        this.softwareVersion = DataParser.parse2Short((byte)chargerInfoBuffer[14], (byte)chargerInfoBuffer[15]);
        this.hardwareVersion = DataParser.parse2Short((byte)chargerInfoBuffer[16], (byte)chargerInfoBuffer[17]);
        this.systemMemoryLength = DataParser.parse2Short((byte)chargerInfoBuffer[18], (byte)chargerInfoBuffer[19]);
        this.programMemoryLength = DataParser.parse2Short((byte)chargerInfoBuffer[20], (byte)chargerInfoBuffer[21]);
        this.status = DataParser.parse2Short((byte)chargerInfoBuffer[22], (byte)chargerInfoBuffer[23]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":\n");
        sb.append(String.format("deviceID \t\t= %d", this.deviceID)).append("\n");
        sb.append(String.format("deviceSN \t\t= %s", this.getDeviceSnString())).append("\n");
        sb.append(String.format("softwareVersion \t= %d", this.softwareVersion)).append("\n");
        sb.append(String.format("hardwareVersion \t= %d", this.hardwareVersion)).append("\n");
        sb.append(String.format("systemMemoryLength \t= %d", this.systemMemoryLength)).append("\n");
        sb.append(String.format("programMemoryLength \t= %d", this.programMemoryLength)).append("\n");
        sb.append(this.getStatusString());
        return sb.toString();
    }

    public String getStatusString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("status \t\t\t= %s", StringHelper.printBinary((byte)((byte)(this.status & 0xFF)), (boolean)false)));
        if ((this.status & 0x40) != 0) {
            sb.append(" - balance");
        }
        if ((this.status & 0x20) != 0) {
            sb.append(" - cell-voltage");
        }
        if ((this.status & 0x10) != 0) {
            sb.append(" - dialog-box");
        }
        if ((this.status & 8) != 0) {
            sb.append(" - run-status");
        }
        if ((this.status & 4) != 0) {
            sb.append(" - control");
        }
        if ((this.status & 2) != 0) {
            sb.append(" - error");
        }
        if ((this.status & 1) != 0) {
            sb.append(" - run");
        }
        return sb.toString();
    }

    public String getHardwareVersionString(boolean isDuo) {
        String hardwareVersionString = "V" + this.hardwareVersion;
        try {
            hardwareVersionString = String.format("%s.%s%d", hardwareVersionString.substring(0, 2), hardwareVersionString.substring(2, 3), Integer.parseInt(hardwareVersionString.substring(3)));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return hardwareVersionString;
    }

    public String getSoftwareVersionString(boolean isDuo) {
        String softwareVersionString = "V" + this.softwareVersion;
        try {
            softwareVersionString = String.format("%s.%s%d", softwareVersionString.substring(0, 2), softwareVersionString.substring(2, 3), Integer.parseInt(softwareVersionString.substring(3)));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return softwareVersionString;
    }

    public String getSystemInfo(boolean isDuo) {
        return String.format("Firmware:%s; Hardware:%s; SN:%s", this.getSoftwareVersionString(isDuo), this.getHardwareVersionString(isDuo), this.getDeviceSnString());
    }

    public static int getSize() {
        return 24;
    }

    public short getDeviceID() {
        return this.deviceID;
    }

    public byte[] getDeviceSN() {
        return this.deviceSN;
    }

    public String getDeviceSnString() {
        return new String(this.deviceSN).trim();
    }

    public short getSoftwareVersion() {
        return this.softwareVersion;
    }

    public short getHardwareVersion() {
        return this.hardwareVersion;
    }

    public short getSystemMemoryLength() {
        return this.systemMemoryLength;
    }

    public short getProgramMemoryLength() {
        return this.programMemoryLength;
    }

    public short getStatus() {
        return this.status;
    }
}

