/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.kontronik.Kosmik;
import gde.device.kontronik.KosmikConfiguration;
import gde.device.smmodellbau.JLog2;
import gde.device.smmodellbau.JLog2Configuration;
import gde.device.smmodellbau.JLog2LiveGathererThread;
import gde.device.smmodellbau.JLog2SerialPort;
import gde.device.smmodellbau.JLog2VisualizationControl;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class JLog2Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(JLog2Dialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    CTabItem configurationTabItem;
    Composite visualizationMainComposite;
    Composite uniLogVisualization;
    Composite mLinkVisualization;
    Composite configurationMainComposite;
    Button saveVisualizationButton;
    Button inputFileButton;
    Button helpButton;
    Button liveGathererButton;
    Button closeButton;
    JLog2LiveGathererThread liveThread;
    final IDevice device;
    final Settings settings;
    final JLog2SerialPort serialPort;
    String selectedSetupFile;
    String selectedVersionFile;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    boolean isConfigChanged = false;
    int measurementsCount = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();
    boolean isJLog2 = true;

    public JLog2Dialog(Shell parent, JLog2 useDevice) {
        super(parent);
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
        this.isJLog2 = this.device.getClass().getSimpleName().equals("JLog2");
        this.measurementsCount = this.isJLog2 ? 40 : this.device.getNumberOfMeasurements(this.device.getLastChannelNumber());
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_LINUX ? 740 : 700, 80 + (this.measurementsCount + 1) / 2 * 26 + 50 + 45);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                JLog2Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (JLog2Dialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{JLog2Dialog.this.device.getPropertiesFileName()});
                            if (JLog2Dialog.this.application.openYesNoMessageDialog(JLog2Dialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                JLog2Dialog.this.device.storeDeviceProperties();
                                JLog2Dialog.this.setClosePossible(true);
                            }
                        }
                        JLog2Dialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        JLog2Dialog.this.application.openHelpDialog("JLog2", JLog2Dialog.this.isJLog2 ? "HelpInfo.html" : "HelpInfo2.html", true);
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + paintevent);
                        }
                        RecordSet activeRecordSet = JLog2Dialog.this.application.getActiveRecordSet();
                        if (JLog2Dialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !JLog2Dialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            JLog2Dialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        JLog2Dialog.this.lastActiveRecordSet = JLog2Dialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                for (int i = 1; i <= this.device.getChannelCount(); ++i) {
                    this.createVisualizationTabItem(i, this.isJLog2 ? 31 : this.device.getNumberOfMeasurements(i));
                }
                this.configurationTabItem = new CTabItem(this.tabFolder, 0);
                this.configurationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 1 : 0)), (int)0));
                this.configurationTabItem.setText(Messages.getString((String)"GDE_MSGT2814"));
                this.configurationTabItem.setControl((Control)(this.isJLog2 ? new JLog2Configuration((Composite)this.tabFolder, 0, this, (JLog2)this.device) : new KosmikConfiguration((Composite)this.tabFolder, 0, this, (Kosmik)this.device)));
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                this.tabFolder.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (JLog2Dialog.this.isJLog2) {
                            if (JLog2Dialog.this.tabFolder.getSelectionIndex() == JLog2Dialog.this.tabFolder.getItemCount() - 1) {
                                JLog2Dialog.this.loadSetup();
                                JLog2Dialog.this.liveGathererButton.setEnabled(false);
                                JLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2803"));
                                JLog2Dialog.this.liveGathererButton.setToolTipText(Messages.getString((String)"GDE_MSGT2815"));
                            } else {
                                if (JLog2Dialog.this.isConfigChanged) {
                                    if (64 == JLog2Dialog.this.application.openYesNoMessageDialog(JLog2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGW2802"))) {
                                        JLog2Dialog.this.saveSetup();
                                    }
                                    JLog2Dialog.this.isConfigChanged = false;
                                }
                                JLog2Dialog.this.liveGathererButton.setEnabled(true);
                                JLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
                                JLog2Dialog.this.liveGathererButton.setToolTipText(Messages.getString((String)"GDE_MSGT2807"));
                            }
                        }
                    }
                });
                this.saveVisualizationButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveVisualizationButton.setLayoutData((Object)saveButtonLData);
                this.saveVisualizationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveVisualizationButton.setText(Messages.getString((String)"GDE_MSGT2810"));
                this.saveVisualizationButton.setToolTipText(Messages.getString((String)"GDE_MSGT2811"));
                this.saveVisualizationButton.setEnabled(false);
                this.saveVisualizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        JLog2Dialog.this.device.storeDeviceProperties();
                        JLog2Dialog.this.saveVisualizationButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2812"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2813"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                        if (JLog2Dialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{JLog2Dialog.this.device.getPropertiesFileName()});
                            if (JLog2Dialog.this.application.openYesNoMessageDialog(JLog2Dialog.this.dialogShell, msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                JLog2Dialog.this.device.storeDeviceProperties();
                            }
                        }
                        JLog2Dialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_LINUX ? 70 : 65;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, GDE.IS_LINUX ? 332 : 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        JLog2Dialog.this.application.openHelpDialog("JLog2", JLog2Dialog.this.isJLog2 ? "HelpInfo.html" : "HelpInfo2.html", true);
                    }
                });
                this.liveGathererButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveSetupButtonLData = new FormData();
                saveSetupButtonLData.width = 130;
                saveSetupButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveSetupButtonLData.right = new FormAttachment(1000, 1000, -155);
                saveSetupButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.liveGathererButton.setLayoutData((Object)saveSetupButtonLData);
                this.liveGathererButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.liveGathererButton.setToolTipText(Messages.getString((String)"GDE_MSGT2807"));
                if (this.isJLog2) {
                    this.liveGathererButton.setEnabled(true);
                    this.liveGathererButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "liveGathererButton.widgetSelected, event=" + evt);
                            }
                            if (!JLog2Dialog.this.configurationTabItem.getControl().isVisible()) {
                                if (JLog2Dialog.this.liveThread == null || !JLog2Dialog.this.serialPort.isConnected()) {
                                    try {
                                        JLog2Dialog.this.liveThread = new JLog2LiveGathererThread(JLog2Dialog.this.application, (JLog2)JLog2Dialog.this.device, JLog2Dialog.this.serialPort, JLog2Dialog.this.application.getActiveChannelNumber(), JLog2Dialog.this);
                                        try {
                                            JLog2Dialog.this.device.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2806"), Messages.getString((String)"GDE_MSGT2806"));
                                            JLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2806"));
                                            JLog2Dialog.this.liveThread.start();
                                        }
                                        catch (RuntimeException e) {
                                            log.log(Level.WARNING, e.getMessage(), e);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (JLog2Dialog.this.liveThread != null && JLog2Dialog.this.liveThread.isAlive()) {
                                            JLog2Dialog.this.liveThread.stopDataGathering();
                                            JLog2Dialog.this.liveThread.interrupt();
                                        }
                                        JLog2Dialog.this.device.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2804"), Messages.getString((String)"GDE_MSGT2804"));
                                        JLog2Dialog.this.application.updateGraphicsWindow();
                                        JLog2Dialog.this.application.openMessageDialog(JLog2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGW2801", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                                        JLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
                                        JLog2Dialog.this.liveThread = null;
                                    }
                                } else {
                                    if (JLog2Dialog.this.liveThread != null && JLog2Dialog.this.liveThread.isAlive()) {
                                        JLog2Dialog.this.liveThread.stopDataGathering();
                                        JLog2Dialog.this.liveThread.interrupt();
                                    }
                                    JLog2Dialog.this.device.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2804"), Messages.getString((String)"GDE_MSGT2804"));
                                    JLog2Dialog.this.application.updateGraphicsWindow();
                                    JLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
                                }
                            } else {
                                JLog2Dialog.this.saveSetup();
                            }
                        }
                    });
                } else {
                    this.liveGathererButton.setEnabled(false);
                }
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        JLog2Dialog.this.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            if (this.serialPort != null && this.serialPort.isConnected()) {
                this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2806"));
            } else {
                this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItem(int channelNumber, int numMeasurements) {
        this.visualizationTabItem = new CTabItem(this.tabFolder, 0);
        this.visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 1 : 0)), (int)0));
        this.visualizationTabItem.setText(Messages.getString((String)"GDE_MSGT2809") + " - " + this.device.getChannelNameReplacement(channelNumber));
        this.visualizationMainComposite = new Composite((Composite)this.tabFolder, 0);
        FormLayout visualizationMainCompositeLayout = new FormLayout();
        this.visualizationMainComposite.setLayout((Layout)visualizationMainCompositeLayout);
        this.visualizationTabItem.setControl((Control)this.visualizationMainComposite);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 1000, 0);
        layoutData.left = new FormAttachment(0, 1000, 0);
        layoutData.right = new FormAttachment(1000, 1000, 0);
        layoutData.bottom = new FormAttachment(1000, 1000, 0);
        new JLog2VisualizationControl(this.visualizationMainComposite, layoutData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2809"), 0, numMeasurements);
    }

    public void enableSaveButton(boolean enable) {
        this.saveVisualizationButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getItemCount() == this.tabFolder.getSelectionIndex() + 1 ? this.tabFolder.getSelectionIndex() - 1 : this.tabFolder.getSelectionIndex();
    }

    void loadSetup() {
        FileDialog fd = this.application.openFileOpenDialog(this.dialogShell, Messages.getString((String)"GDE_MSGT2801"), new String[]{"*.txt", "*"}, ((JLog2)this.device).getConfigurationFileDirecotry(), "CONFIG.txt", 4);
        this.selectedSetupFile = fd.getFilterPath() + "/" + fd.getFileName();
        this.selectedVersionFile = fd.getFilterPath() + "/" + "version.txt";
        log.log(Level.FINE, "selectedSetupFile = " + this.selectedSetupFile);
        if (fd.getFileName().length() > 4) {
            String searchDirectory = this.device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
            if (!Settings.getInstance().isDeviceImportDirectoryObjectRelated() && !searchDirectory.contains(fd.getFilterPath().replace('\\', '/'))) {
                this.device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fd.getFilterPath());
            }
            int version = Integer.valueOf("400");
            try {
                String line;
                BufferedReader reader;
                File versionFile = new File(this.selectedVersionFile);
                if (versionFile.exists()) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(versionFile), "ISO-8859-1"));
                    line = reader.readLine();
                    try {
                        version = Integer.valueOf(line.substring(0, 5).replace(".", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    reader.close();
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.selectedSetupFile), "ISO-8859-1"));
                line = reader.readLine();
                ((JLog2Configuration)this.configurationTabItem.getControl()).loadConfiuration(line, version);
                reader.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                ((JLog2Configuration)this.configurationTabItem.getControl()).loadConfiuration("9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132", version);
            }
        }
    }

    void saveSetup() {
        FileDialog fileDialog = this.application.prepareFileSaveDialog(this.dialogShell, Messages.getString((String)"GDE_MSGT2802"), new String[]{"*.txt", "*"}, ((JLog2)this.device).getConfigurationFileDirecotry(), "CONFIG.txt");
        String setupFilePath = fileDialog.open();
        log.log(Level.FINE, "selectedSetupFile = " + setupFilePath);
        if (setupFilePath != null && setupFilePath.length() > 4) {
            String searchDirectory = this.device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
            if (!Settings.getInstance().isDeviceImportDirectoryObjectRelated() && !searchDirectory.contains(fileDialog.getFilterPath().replace('\\', '/'))) {
                this.device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fileDialog.getFilterPath());
            }
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(setupFilePath), "ISO-8859-1"));
                writer.write(((JLog2Configuration)this.configurationTabItem.getControl()).configuration.getConfiguration());
                writer.close();
                this.liveGathererButton.setEnabled(false);
                this.isConfigChanged = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

