/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.PropertyType;
import gde.device.wb.CSV2SerialAdapter;
import gde.device.wb.CSV2SerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 36;
    final DataExplorer application;
    final CSV2SerialPort serialPort;
    final CSV2SerialAdapter device;
    final Channels channels;
    final DataParser parser;
    Channel activeChannel;
    RecordSet activeRecordSet;
    int channelNumber;
    Channel channel;
    int stateNumber = 1;
    String recordSetKey;
    boolean isPortOpenedByLiveGatherer = false;
    int retryCounter = 36;
    int lastNumberDisplayableRecords = 0;

    public GathererThread(DataExplorer currentApplication, CSV2SerialAdapter useDevice, CSV2SerialPort useSerialPort, int channelConfigNumber) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        this.recordSetKey = " " + this.device.getRecordSetStateNameReplacement(this.stateNumber);
        this.parser = new DataParser(this.device.getDataBlockTimeUnitFactor(), this.device.getDataBlockLeader(), this.device.getDataBlockSeparator().value(), this.device.getDataBlockCheckSumType(), this.device.getDataBlockSize(InputTypes.FILE_IO));
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        String processName = "";
        RecordSet channelRecordSet = null;
        long startCycleTime = 0L;
        long tmpCycleTime = 0L;
        long lastTmpCycleTime = 0L;
        long delayTime = 0L;
        long measurementCount = -1L;
        double deviceTimeStep_ms = this.device.getTimeStep_ms();
        byte[] dataBuffer = null;
        this.serialPort.isInterruptedByUser = false;
        if (log.isLoggable(Level.TIME)) {
            log.logp(Level.TIME, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        }
        try {
            this.serialPort.cleanInputStream();
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        lastTmpCycleTime = System.nanoTime() / 1000000L;
        while (!this.serialPort.isInterruptedByUser) {
            try {
                if (this.application != null) {
                    this.application.setPortConnected(true);
                }
                for (int i = 0; i < this.device.getChannelCount() && !this.serialPort.isInterruptedByUser; ++i) {
                    RecordSet activeRecordSet;
                    dataBuffer = this.serialPort.getData();
                    try {
                        this.channelNumber = Integer.valueOf("" + (char)dataBuffer[1]);
                        this.stateNumber = Integer.valueOf("" + (char)dataBuffer[3]);
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", this.device.getChannelCount() + " - data for channel = " + this.channelNumber + " state = " + this.stateNumber);
                        }
                        if (this.channelNumber > this.device.getChannelCount()) continue;
                        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
                        PropertyType stateProperty = this.device.getStateProperty(this.stateNumber);
                        if (stateProperty == null) {
                            throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGW1702", (Object[])new Object[]{this.stateNumber}));
                        }
                        processName = this.device.getRecordSetStateNameReplacement(this.stateNumber);
                        if (log.isLoggable(Level.FINER)) {
                            log.logp(Level.FINER, $CLASS_NAME, "run", "processing mode = " + processName);
                        }
                        channelRecordSet = (RecordSet)this.channel.get((Object)this.channel.getLastActiveRecordSetName());
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                        if (!(e instanceof DevicePropertiesInconsistenceException)) break;
                        this.application.openMessageDialogAsync(e.getMessage());
                        throw e;
                    }
                    if (this.channel.size() == 0 || channelRecordSet == null || !this.recordSetKey.endsWith(" " + processName)) {
                        this.application.setStatusMessage("");
                        this.setRetryCounter(36);
                        this.recordSetKey = (this.device.recordSetNumberFollowChannel() && this.channel.getType() == ChannelTypes.TYPE_CONFIG ? this.channel.getNextRecordSetNumber(this.channelNumber) : this.channel.getNextRecordSetNumber()) + ") " + processName;
                        this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                        }
                        if (this.channel.getActiveRecordSet() == null) {
                            this.channel.setActiveRecordSet(this.recordSetKey);
                        }
                        channelRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                        if (this.channel.getType() == ChannelTypes.TYPE_CONFIG) {
                            this.channel.applyTemplate(this.recordSetKey, false);
                        } else {
                            this.channel.applyTemplateBasics(this.recordSetKey);
                        }
                        if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                            this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                        }
                        this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        ((RecordSet)this.channel.get((Object)this.recordSetKey)).updateVisibleAndDisplayableRecordsForTable();
                        measurementCount = 0L;
                        startCycleTime = 0L;
                    }
                    tmpCycleTime = System.nanoTime() / 1000000L;
                    if (measurementCount++ == 0L) {
                        startCycleTime = tmpCycleTime;
                    }
                    if (channelRecordSet == null) continue;
                    if (this.serialPort.isInterruptedByUser) break;
                    this.parser.parse(new String(dataBuffer), 42);
                    if (this.parser.getValues().length == channelRecordSet.size()) {
                        channelRecordSet.addPoints(this.parser.getValues(), (double)(tmpCycleTime - startCycleTime));
                    } else {
                        this.application.setStatusMessage(String.format("Miss match record set size = %d to parsed values length = %d, please correct!", channelRecordSet.size(), this.parser.getValues().length), 3);
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.logp(Level.TIME, $CLASS_NAME, "run", "time after add = " + TimeLine.getFomatedTimeWithUnit((double)(tmpCycleTime - startCycleTime)));
                    }
                    if (measurementCount > 0L && measurementCount % 10L == 0L) {
                        this.activeChannel = this.channels.getActiveChannel();
                        if (this.activeChannel != null) {
                            this.activeRecordSet = this.activeChannel.getActiveRecordSet();
                            if (this.activeRecordSet != null) {
                                this.device.updateVisibilityStatus(channelRecordSet, true);
                            }
                        }
                    }
                    if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) == null || channelRecordSet.size() <= 0 || !channelRecordSet.isChildOfActiveChannel() || !channelRecordSet.equals((Object)activeRecordSet)) continue;
                    this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != channelRecordSet.getConfiguredDisplayable());
                    this.lastNumberDisplayableRecords = channelRecordSet.getConfiguredDisplayable();
                }
                if (deviceTimeStep_ms > 0.0) {
                    delayTime = (long)(deviceTimeStep_ms - 3.0 - (double)(tmpCycleTime - lastTmpCycleTime));
                    if (delayTime > 0L) {
                        WaitTimer.delay((long)delayTime);
                    }
                    lastTmpCycleTime = tmpCycleTime;
                }
                if (log.isLoggable(Level.TIME)) {
                    log.logp(Level.TIME, $CLASS_NAME, "run", "delayTime = " + TimeLine.getFomatedTimeWithUnit((double)delayTime));
                }
                if (!log.isLoggable(Level.TIME)) continue;
                log.logp(Level.TIME, $CLASS_NAME, "run", "time = " + TimeLine.getFomatedTimeWithUnit((double)(tmpCycleTime - startCycleTime)));
            }
            catch (DataInconsitsentException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Throwable e) {
                if (this.serialPort.isInterruptedByUser) continue;
                if (e instanceof TimeOutException) {
                    if (measurementCount > 0L) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGW1701"));
                        log.logp(Level.FINE, $CLASS_NAME, "run", "timeout!");
                        continue;
                    }
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1702"));
                    log.logp(Level.FINE, $CLASS_NAME, "run", "wait for activation ...");
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(Level.FINE, "activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW1700"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(Level.FINE, "program end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.serialPort.isInterruptedByUser = true;
        try {
            for (int i = 1; i <= this.channels.size(); ++i) {
                RecordSet recordSet = (RecordSet)((Channel)this.channels.get((Object)i)).get((Object)((Channel)this.channels.get((Object)i)).getLastActiveRecordSetName());
                if (recordSet == null || recordSet.getRecordDataSize(true) <= 5) continue;
                this.finalizeRecordSet(recordSet, false);
                if (!enableEndMessage) continue;
                this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT1709"));
            }
        }
        finally {
            if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
                log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
            }
            if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
                this.serialPort.close();
            }
        }
    }

    void finalizeRecordSet(RecordSet tmpRecordSet, boolean doClosePort) {
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if (tmpRecordSet != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        for (int i = 1; i <= this.channels.size(); ++i) {
            RecordSet recordSet = (RecordSet)((Channel)this.channels.get((Object)i)).get((Object)((Channel)this.channels.get((Object)i)).getLastActiveRecordSetName());
            if (recordSet != null) {
                recordSet.clear();
                this.channel.remove(recordSet.getName());
                if (Thread.currentThread().getId() == this.application.getThreadId()) {
                    this.application.getMenuToolBar().updateRecordSetSelectCombo();
                    this.application.updateStatisticsData();
                    this.application.updateDataTable(this.recordSetKey, true);
                    this.application.openMessageDialog(message);
                    continue;
                }
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(message);
                    }
                });
                continue;
            }
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.serialPort.isInterruptedByUser = enabled;
    }

    boolean isCollectDataStopped() {
        return this.serialPort.isInterruptedByUser;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

