/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.DataAccess;
import gde.GDE;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelPropertyType;
import gde.device.ChannelPropertyTypes;
import gde.device.ChannelType;
import gde.device.ChannelTypes;
import gde.device.CheckSumTypes;
import gde.device.CommaSeparatorTypes;
import gde.device.DataBitsTypes;
import gde.device.DataBlockType;
import gde.device.DataTypes;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DesktopType;
import gde.device.DeviceDialog;
import gde.device.DevicePropertiesType;
import gde.device.DeviceType;
import gde.device.DeviceTypes;
import gde.device.FlowControlTypes;
import gde.device.FormatTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.LineEndingTypes;
import gde.device.MeasurementType;
import gde.device.ObjectFactory;
import gde.device.ParityTypes;
import gde.device.PropertyType;
import gde.device.ScoreGroupType;
import gde.device.SerialPortType;
import gde.device.SettlementType;
import gde.device.StateType;
import gde.device.StatisticsType;
import gde.device.StopBitsTypes;
import gde.device.TimeBaseType;
import gde.device.TimeUnitTypes;
import gde.device.UsbInterfaceType;
import gde.device.UsbPortType;
import gde.device.resource.DeviceXmlResource;
import gde.histo.utils.SecureHash;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.StringHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.swt.custom.CTabItem;

public class DeviceConfiguration {
    private static final Logger log = Logger.getLogger(DeviceConfiguration.class.getName());
    private final Settings settings;
    protected final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
    private Path xmlFile;
    private String fileSha1Hash = "";
    private JAXBElement<DevicePropertiesType> elememt;
    private DevicePropertiesType deviceProps;
    private DeviceType device;
    private SerialPortType serialPort;
    private UsbPortType usbPort;
    private DataBlockType dataBlock;
    private StateType state;
    private TimeBaseType timeBase;
    private DesktopType desktop;
    private boolean isChangePropery = false;
    public static final int DEVICE_TYPE_UNDEFINED = 0;
    public static final int DEVICE_TYPE_CHARGER = 1;
    public static final int DEVICE_TYPE_LOGGER = 2;
    public static final int DEVICE_TYPE_BALANCER = 3;
    public static final int DEVICE_TYPE_CURRENT_SINK = 4;
    public static final int DEVICE_TYPE_POWER_SUPPLY = 5;
    public static final int DEVICE_TYPE_GPS = 5;
    public static final int DEVICE_TYPE_RECEIVER = 7;
    public static final int DEVICE_TYPE_MULTIMETER = 8;
    public static final int DEVICE_TYPE_CONTROLLER = 9;
    public static final int HEIGHT_RELATIVE = 0;
    public static final int HEIGHT_ABSOLUTE = 1;
    public static final int HEIGHT_CLAMPTOGROUND = 2;
    public static final String UNIT_DEGREE_FAHRENHEIT = "\u00b0F";
    public static final String UNIT_DEGREE_CELSIUS = "\u00b0C";
    protected CalculationThread calculationThread = null;
    protected Integer kmzMeasurementOrdinal = null;
    private int[] channelGroups;

    public static void main(String[] args) {
        ConsoleHandler ch = new ConsoleHandler();
        LogFormatter lf = new LogFormatter();
        ch.setFormatter(lf);
        ch.setLevel(gde.log.Level.ALL);
        Logger.getLogger("").addHandler(ch);
        Logger.getLogger("").setLevel(gde.log.Level.ALL);
        String basePath = "C:/Documents and Settings/brueg/Application Data/DataExplorer/Devices/";
        try (FileInputStream inputStream = new FileInputStream(basePath + "DeviceProperties_V48.xsd");){
            JAXBElement elememt;
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(inputStream));
            JAXBContext jc = JAXBContext.newInstance("gde.device");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            try (FileInputStream inputStream2 = new FileInputStream(basePath + "Picolario.xml");){
                elememt = (JAXBElement)unmarshaller.unmarshal(inputStream2);
                DevicePropertiesType devProps = (DevicePropertiesType)elememt.getValue();
                DeviceType device = devProps.getDevice();
                log.log(gde.log.Level.ALL, "device.getName() = " + device.getName());
                SerialPortType serialPort = devProps.getSerialPort();
                log.log(gde.log.Level.ALL, "serialPort.getPort() = " + serialPort.getPort());
                serialPort.setPort("COM10");
                log.log(gde.log.Level.ALL, "serialPort.getPort() = " + serialPort.getPort());
            }
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            marshaller.setProperty("jaxb.schemaLocation", "DeviceProperties_V48.xsd");
            try (FileOutputStream outputStream = new FileOutputStream(basePath + "jaxbOutput.xml");){
                marshaller.marshal((Object)elememt, outputStream);
            }
        }
        catch (Exception e) {
            log.log(gde.log.Level.SEVERE, e.getMessage(), e);
        }
        catch (Throwable t) {
            log.log(gde.log.Level.SEVERE, t.getMessage(), t);
        }
    }

    public DeviceConfiguration(String xmlFileName) throws FileNotFoundException, JAXBException {
        this.xmlFile = Paths.get(xmlFileName, new String[0]);
        DataAccess.LocalAccess localAccess = (DataAccess.LocalAccess)DataAccess.getInstance();
        if (!localAccess.existsDeviceXml(xmlFileName)) {
            throw new FileNotFoundException(Messages.getString("GDE_MSGE0003") + xmlFileName);
        }
        this.settings = Settings.getInstance();
        this.settings.joinXsdThread();
        this.elememt = this.settings.getDeviceSerialization().getTopElement(this.xmlFile.toString(), localAccess);
        this.deviceProps = this.elememt.getValue();
        this.device = this.deviceProps.getDevice();
        this.serialPort = this.deviceProps.getSerialPort();
        this.usbPort = this.deviceProps.getUsbPort();
        this.dataBlock = this.deviceProps.getDataBlock();
        this.state = this.deviceProps.getState();
        this.timeBase = this.deviceProps.getTimeBase();
        this.desktop = this.deviceProps.getDesktop();
        this.isChangePropery = false;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, this.toString());
        }
    }

    public DeviceConfiguration(String xmlFileName, Unmarshaller tmpUnmarshaller) throws FileNotFoundException, JAXBException {
        this.xmlFile = Paths.get(xmlFileName, new String[0]);
        DataAccess.LocalAccess localAccess = (DataAccess.LocalAccess)DataAccess.getInstance();
        if (!localAccess.existsDeviceXml(xmlFileName)) {
            throw new FileNotFoundException(Messages.getString("GDE_MSGE0003") + xmlFileName);
        }
        this.settings = Settings.getInstance();
        this.settings.joinXsdThread();
        this.elememt = this.settings.getDeviceSerialization().getTopElement(this.xmlFile, tmpUnmarshaller, (DataAccess)localAccess);
        this.deviceProps = this.elememt.getValue();
        this.device = this.deviceProps.getDevice();
        this.serialPort = this.deviceProps.getSerialPort();
        this.usbPort = this.deviceProps.getUsbPort();
        this.dataBlock = this.deviceProps.getDataBlock();
        this.state = this.deviceProps.getState();
        this.timeBase = this.deviceProps.getTimeBase();
        this.desktop = this.deviceProps.getDesktop();
        this.isChangePropery = false;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, this.toString());
        }
    }

    public DeviceConfiguration(DeviceConfiguration deviceConfig) {
        this.settings = deviceConfig.settings;
        this.xmlFile = deviceConfig.xmlFile;
        this.fileSha1Hash = deviceConfig.fileSha1Hash;
        this.elememt = deviceConfig.elememt;
        this.deviceProps = deviceConfig.deviceProps;
        this.device = deviceConfig.device;
        this.serialPort = deviceConfig.serialPort;
        this.usbPort = this.deviceProps.getUsbPort();
        this.dataBlock = this.deviceProps.dataBlock;
        this.state = this.deviceProps.state;
        this.timeBase = deviceConfig.timeBase;
        this.desktop = this.deviceProps.desktop;
        this.isChangePropery = deviceConfig.isChangePropery;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, this.toString());
        }
    }

    public DeviceConfiguration(Path xmlFileSubPath, Unmarshaller tmpUnmarshaller, Analyzer analyzer) throws FileNotFoundException, JAXBException {
        this.xmlFile = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve(xmlFileSubPath);
        if (!analyzer.getDataAccess().existsDeviceXml(xmlFileSubPath)) {
            throw new FileNotFoundException(Messages.getString("GDE_MSGE0003") + xmlFileSubPath.toString());
        }
        this.settings = analyzer.getSettings();
        this.settings.joinXsdThread();
        this.elememt = this.settings.getDeviceSerialization().getTopElement(xmlFileSubPath, tmpUnmarshaller, analyzer.getDataAccess());
        this.deviceProps = this.elememt.getValue();
        this.device = this.deviceProps.getDevice();
        this.serialPort = this.deviceProps.getSerialPort();
        this.usbPort = this.deviceProps.getUsbPort();
        this.dataBlock = this.deviceProps.getDataBlock();
        this.state = this.deviceProps.getState();
        this.timeBase = this.deviceProps.getTimeBase();
        this.desktop = this.deviceProps.getDesktop();
        this.isChangePropery = false;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, this.toString());
        }
    }

    public DeviceConfiguration(Path xmlFileSubPath, Analyzer analyzer) throws FileNotFoundException, JAXBException {
        this.xmlFile = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve(xmlFileSubPath);
        if (!analyzer.getDataAccess().existsDeviceXml(xmlFileSubPath)) {
            throw new FileNotFoundException(Messages.getString("GDE_MSGE0003") + xmlFileSubPath.toString());
        }
        this.settings = analyzer.getSettings();
        this.settings.joinXsdThread();
        this.elememt = this.settings.getDeviceSerialization().getTopElement(xmlFileSubPath, analyzer.getDataAccess());
        this.deviceProps = this.elememt.getValue();
        this.device = this.deviceProps.getDevice();
        this.serialPort = this.deviceProps.getSerialPort();
        this.usbPort = this.deviceProps.getUsbPort();
        this.dataBlock = this.deviceProps.getDataBlock();
        this.state = this.deviceProps.getState();
        this.timeBase = this.deviceProps.getTimeBase();
        this.desktop = this.deviceProps.getDesktop();
        this.isChangePropery = false;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, this.toString());
        }
    }

    public void storeDeviceProperties() {
        if (this.isChangePropery) {
            try {
                this.fileSha1Hash = "";
                this.settings.getDeviceSerialization().marshall(this.elememt, this.xmlFile.toString(), (DataAccess.LocalAccess)DataAccess.getInstance());
            }
            catch (Throwable t) {
                log.log(gde.log.Level.SEVERE, t.getMessage(), t);
            }
            this.isChangePropery = false;
        }
    }

    public void storeDeviceProperties(String fullQualifiedFileName) {
        try {
            this.fileSha1Hash = "";
            this.settings.getDeviceSerialization().marshall(this.elememt, fullQualifiedFileName, (DataAccess.LocalAccess)DataAccess.getInstance());
        }
        catch (Throwable t) {
            log.log(gde.log.Level.SEVERE, t.getMessage(), t);
        }
        this.isChangePropery = false;
    }

    public DeviceConfiguration getDeviceConfiguration() {
        return this;
    }

    public DeviceType getDeviceType() {
        return this.device;
    }

    public SerialPortType getSerialPortType() {
        return this.serialPort;
    }

    public void removeSerialPortType() {
        this.isChangePropery = true;
        this.deviceProps.serialPort = null;
        this.serialPort = null;
    }

    public UsbPortType getUsbPortType() {
        return this.usbPort;
    }

    public void removeUsbPortType() {
        this.isChangePropery = true;
        this.deviceProps.usbPort = null;
        this.usbPort = null;
    }

    public TimeBaseType getTimeBaseType() {
        return this.timeBase;
    }

    public boolean isUsed() {
        return this.device.isUsage();
    }

    public void setUsed(boolean value) {
        this.isChangePropery = true;
        this.device.setUsage(value);
    }

    public String getPropertiesFileName() {
        return this.xmlFile.toAbsolutePath().toString();
    }

    public String getName() {
        return this.device.getName().getValue();
    }

    public String getPureDeviceName(String deviceName) {
        String pureDeviceName = deviceName;
        if (pureDeviceName.endsWith("-Set")) {
            pureDeviceName = pureDeviceName.substring(0, pureDeviceName.length() - 4);
        }
        return pureDeviceName;
    }

    public String getDeviceImplName() {
        return this.device.getName().getImplementation() == null ? this.device.getName().getValue() : this.device.getName().getImplementation();
    }

    public String getClassImplName() {
        String deviceImplName = this.getDeviceImplName().replace(" ", "").replace("-", "");
        return deviceImplName.contains(".") ? deviceImplName : "gde.device." + this.getManufacturer().toLowerCase().replace(" ", "").replace("-", "") + "." + deviceImplName;
    }

    public IDevice defineInstanceOfDevice() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoClassDefFoundError {
        String className = this.getClassImplName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> c = loader.loadClass(className);
        Constructor<?> constructor = c.getDeclaredConstructor(DeviceConfiguration.class);
        if (constructor != null) {
            try {
                return (IDevice)constructor.newInstance(this);
            }
            catch (IllegalArgumentException e) {
                constructor = c.getDeclaredConstructor(String.class);
                if (constructor != null) {
                    return (IDevice)constructor.newInstance(this.getPropertiesFileName());
                }
                throw new NoClassDefFoundError(Messages.getString("GDE_MSGE0016"));
            }
        }
        throw new NoClassDefFoundError(Messages.getString("GDE_MSGE0016"));
    }

    @Nullable
    public IDevice getAsDevice() {
        IDevice tmpDevice = null;
        try {
            Class<?> currentClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClassImplName());
            Constructor<?> constructor = currentClass.getDeclaredConstructor(DeviceConfiguration.class);
            tmpDevice = constructor != null ? (IDevice)constructor.newInstance(this) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpDevice;
    }

    public void setName(String newDeviceName) {
        this.isChangePropery = true;
        this.device.getName().setValue(newDeviceName);
    }

    public void setDeviceImplName(String newDeviceImplClass) {
        this.isChangePropery = true;
        this.device.getName().setImplementation(newDeviceImplClass);
    }

    public String getImageFileName() {
        return this.device.getImage().length() > 0 ? this.device.getImage() : "NoDevicePicture.jpg";
    }

    public void setImageFileName(String newImageFileName) {
        this.isChangePropery = true;
        this.device.setImage(newImageFileName);
    }

    public String getManufacturer() {
        return this.device.getManufacturer();
    }

    public void setManufacturer(String name) {
        this.isChangePropery = true;
        this.device.setManufacturer(name);
    }

    public String getManufacturerURL() {
        return this.device.getManufacturerURL();
    }

    public void setManufacturerURL(String name) {
        this.isChangePropery = true;
        this.device.setManufacturerURL(name);
    }

    public DeviceTypes getDeviceGroup() {
        return this.device.getGroup();
    }

    public void setDeviceGroup(DeviceTypes name) {
        this.isChangePropery = true;
        this.device.setGroup(name);
    }

    public double getTimeStep_ms() {
        return this.timeBase.getTimeStep();
    }

    public void setTimeStep_ms(double newTimeStep_ms) {
        this.isChangePropery = true;
        this.timeBase.setTimeStep(newTimeStep_ms);
    }

    public Double getAverageTimeStep_ms() {
        return this.timeBase.getAvarageTimeStep();
    }

    public void setAverageTimeStep_ms(double newAverageTimeStep_ms) {
        this.isChangePropery = true;
        this.timeBase.setAvarageTimeStep(newAverageTimeStep_ms);
    }

    public short getUTCdelta() {
        return this.timeBase.getUTCdelta();
    }

    public void setUTCdelta(int newUTCdelta) {
        this.isChangePropery = true;
        this.timeBase.setUTCdelta(newUTCdelta);
    }

    public String getPort() {
        return this.serialPort != null ? this.serialPort.getPort() : (this.getUsbPortType() != null ? "USB" : "");
    }

    public String getPortString() {
        return this.serialPort.getPort();
    }

    public void setPort(String newPort) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setPort(newPort);
    }

    public Integer getBaudeRate() {
        return this.serialPort != null ? this.serialPort.getBaudeRate() : 9800;
    }

    public void setBaudeRate(Integer value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setBaudeRate(value);
    }

    public DataBitsTypes getDataBits() {
        return this.serialPort != null ? this.serialPort.getDataBits() : DataBitsTypes.DATABITS_8;
    }

    public void setDataBits(DataBitsTypes value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setDataBits(value);
    }

    public StopBitsTypes getStopBits() {
        return this.serialPort != null ? this.serialPort.getStopBits() : StopBitsTypes.STOPBITS_1;
    }

    public void setStopBits(StopBitsTypes enumOrdinal) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setStopBits(enumOrdinal);
    }

    public int getFlowCtrlMode() {
        return this.serialPort != null ? this.serialPort.getFlowControlMode() : 0;
    }

    public int getFlowCtrlModeOrdinal() {
        return this.serialPort != null ? this.serialPort.getFlowControlModeOrdinal() : 0;
    }

    public String getFlowCtrlModeString() {
        return this.serialPort.getFlowControlModeString();
    }

    public void setFlowCtrlMode(FlowControlTypes value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setFlowControlMode(value);
    }

    public ParityTypes getParity() {
        return this.serialPort != null ? this.serialPort.getParity() : ParityTypes.PARITY_NONE;
    }

    private void createSerialPort() {
        this.deviceProps.serialPort = this.serialPort = new ObjectFactory().createSerialPortType();
        this.serialPort.setPort("");
        this.serialPort.setBaudeRate(9600);
        this.serialPort.setParity(ParityTypes.PARITY_NONE);
        this.serialPort.setDataBits(DataBitsTypes.DATABITS_8);
        this.serialPort.setStopBits(StopBitsTypes.STOPBITS_1);
        this.serialPort.setFlowControlMode(FlowControlTypes.FLOWCONTROL_NONE);
        this.serialPort.setIsDTR(false);
        this.serialPort.setIsRTS(false);
        this.isChangePropery = true;
    }

    public void setParity(ParityTypes value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setParity(value);
    }

    public boolean isDTR() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.isIsDTR();
    }

    public void setIsDTR(boolean value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setIsDTR(value);
    }

    public boolean isRTS() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.isIsRTS();
    }

    public void setIsRTS(boolean value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setIsRTS(value);
    }

    public int getReadTimeOut() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getTimeOut() != null ? this.serialPort.getTimeOut().getReadTimeOut() : 0;
    }

    public void setReadTimeOut(int value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        if (this.serialPort.getTimeOut() == null) {
            this.serialPort.setTimeOut(new ObjectFactory().createTimeOutType());
        }
        this.serialPort.getTimeOut().setReadTimeOut(value);
    }

    public int getReadStableIndex() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getTimeOut() != null ? this.serialPort.getTimeOut().getReadStableIndex() : 0;
    }

    public void setReadStableIndex(int value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        if (this.serialPort.getTimeOut() == null) {
            this.serialPort.setTimeOut(new ObjectFactory().createTimeOutType());
        }
        this.serialPort.getTimeOut().setReadStableIndex(value);
    }

    public int getWriteCharDelayTime() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getTimeOut() != null ? this.serialPort.getTimeOut().getWriteCharDelayTime() : 0;
    }

    public void setWriteCharDelayTime(int value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        if (this.serialPort.getTimeOut() == null) {
            this.serialPort.setTimeOut(new ObjectFactory().createTimeOutType());
        }
        this.serialPort.getTimeOut().setWriteCharDelayTime(value);
    }

    public int getWriteDelayTime() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getTimeOut() != null ? this.serialPort.getTimeOut().getWriteDelayTime() : 0;
    }

    public void setWriteDelayTime(int value) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        if (this.serialPort.getTimeOut() == null) {
            this.serialPort.setTimeOut(new ObjectFactory().createTimeOutType());
        }
        this.serialPort.getTimeOut().setWriteDelayTime(value);
    }

    public void removeSerialPortTimeOut() {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        if (this.serialPort.getTimeOut() != null) {
            this.serialPort.setTimeOut(null);
        }
    }

    public boolean isSerialPortRequest() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getRequest() != null && this.serialPort.getRequest().length > 0;
    }

    public byte[] getSerialPortRequest() {
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        return this.serialPort.getRequest();
    }

    public void setSerialPortRequest(byte[] newRequest) {
        this.isChangePropery = true;
        if (this.serialPort == null) {
            this.createSerialPort();
        }
        this.serialPort.setRequest(newRequest);
    }

    public UsbInterfaceType getUsbInterfaceType() {
        return this.usbPort.getUsbInterface();
    }

    public short getUsbVendorId() {
        return Short.valueOf(this.usbPort.getVendorId().substring(2), 16);
    }

    public short getUsbProductId() {
        return Short.valueOf(this.usbPort.getProductId().substring(2), 16);
    }

    public String getUsbProductString() {
        return this.usbPort.getProductString();
    }

    public byte getUsbInterface() {
        return Byte.valueOf(this.usbPort.getUsbInterface().getInterface().getValue().substring(2), 16);
    }

    public byte getUsbEndpointIn() {
        return Byte.valueOf(this.usbPort.getUsbInterface().getEndPointIn().substring(2), 16);
    }

    public byte getUsbEndpointOut() {
        return Short.valueOf(this.usbPort.getUsbInterface().getEndPointOut().substring(2), 16).byteValue();
    }

    public void setDesktopType(DesktopType newDesktopType) {
        this.deviceProps.setDesktop(newDesktopType);
        this.desktop = this.deviceProps.desktop;
        this.isChangePropery = true;
    }

    public DesktopType getDesktopType() {
        return this.desktop;
    }

    public DesktopPropertyType getDesktopProperty(DesktopPropertyTypes dektopType) {
        DesktopPropertyType property = null;
        if (this.desktop != null) {
            List<DesktopPropertyType> properties = this.desktop.getProperty();
            for (DesktopPropertyType propertyType : properties) {
                if (!propertyType.getName().equals((Object)dektopType)) continue;
                property = propertyType;
                break;
            }
            if (property == null) {
                property = new ObjectFactory().createDesktopPropertyType();
                property.setName(dektopType);
                property.setValue(false);
                property.setDescription(dektopType.name());
                if (dektopType.equals((Object)DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB)) {
                    property.setTargetReferenceOrdinal(0);
                }
                properties.add(property);
            }
        }
        return property;
    }

    public void setDesktopTypeValue(DesktopPropertyTypes desktopType, Boolean newValue) {
        this.getDesktopProperty(desktopType).setValue(newValue);
        this.isChangePropery = true;
    }

    public int getStateSize() {
        return this.state.property.size();
    }

    public StateType getStateType() {
        return this.deviceProps.state;
    }

    public void removeStateType() {
        this.isChangePropery = true;
        this.deviceProps.state = null;
        this.state = null;
    }

    public void appendStateType(PropertyType newStateProperty) {
        this.isChangePropery = true;
        if (this.deviceProps.state == null) {
            this.deviceProps.state = new ObjectFactory().createStateType();
        }
        this.deviceProps.state.getProperty().add(newStateProperty);
        this.isChangePropery = true;
    }

    public void removeStateType(PropertyType removeStateProperty) {
        this.isChangePropery = true;
        this.deviceProps.state.remove(removeStateProperty);
    }

    public void setStateName(int modeStateOrdinal, String newName) {
        this.isChangePropery = true;
        PropertyType tmpPoperty = this.getStateProperty(modeStateOrdinal);
        if (tmpPoperty != null) {
            tmpPoperty.setName(newName);
        }
    }

    public void setStateValue(int modeStateOrdinal, String newValue) {
        this.isChangePropery = true;
        PropertyType tmpPoperty = this.getStateProperty(modeStateOrdinal);
        if (tmpPoperty != null) {
            tmpPoperty.setValue(StringHelper.verifyTypedInput(tmpPoperty.getType(), newValue));
        }
    }

    public void setStateDescription(int modeStateOrdinal, String newDescription) {
        this.isChangePropery = true;
        PropertyType tmpPoperty = this.getStateProperty(modeStateOrdinal);
        if (tmpPoperty != null) {
            tmpPoperty.setDescription(newDescription);
        }
    }

    public PropertyType getStateProperty(int modeStateOrdinal) {
        PropertyType property = null;
        if (this.state != null) {
            List<PropertyType> properties = this.state.getProperty();
            for (PropertyType propertyType : properties) {
                try {
                    int propertyValue = Integer.parseInt(propertyType.getValue());
                    if (propertyValue != modeStateOrdinal) continue;
                    property = propertyType;
                    break;
                }
                catch (NumberFormatException e) {
                    log.log(gde.log.Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return property;
    }

    public DataBlockType getDataBlockType() {
        return this.dataBlock;
    }

    public void removeDataBlockType() {
        this.isChangePropery = true;
        this.deviceProps.dataBlock = null;
        this.dataBlock = null;
    }

    public void addDataBlockType() {
        this.isChangePropery = true;
        this.dataBlock = this.deviceProps.dataBlock = new DataBlockType();
    }

    public int getDataBlockSize(InputTypes inputType) {
        int dataBlockSize = -1;
        for (DataBlockType.Format format : this.dataBlock.getFormat()) {
            if (format.getInputType() != inputType) continue;
            dataBlockSize = format.getSize();
        }
        return dataBlockSize;
    }

    public int getDataBlockSize(FormatTypes formatType) {
        int dataBlockSize = -1;
        try {
            for (DataBlockType.Format format : this.dataBlock.getFormat()) {
                if (format.getType() != formatType) continue;
                dataBlockSize = format.getSize();
            }
        }
        catch (Exception e) {
            log.log(gde.log.Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGE0052", new String[]{this.xmlFile.getFileName().toString()}));
        }
        return dataBlockSize;
    }

    public void setDataBlockSize(InputTypes useInputType, FormatTypes useFormat, Integer newSize) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.dataBlock = this.deviceProps.dataBlock = new DataBlockType();
            DataBlockType.Format format = new DataBlockType.Format();
            format.setFormatType(useFormat);
            format.setInputType(useInputType);
            format.setSize(newSize);
            this.dataBlock.getFormat().add(format);
        } else {
            boolean isSizeSet = false;
            for (DataBlockType.Format format : this.dataBlock.getFormat()) {
                if (isSizeSet || format.getType() != useFormat) continue;
                format.setInputType(useInputType);
                format.setSize(newSize);
                isSizeSet = true;
                break;
            }
            if (!isSizeSet && this.dataBlock.getFormat().size() == 1) {
                DataBlockType.Format format = new DataBlockType.Format();
                format.setFormatType(useFormat);
                format.setInputType(useInputType);
                format.setSize(newSize);
                this.dataBlock.getFormat().add(format);
            }
        }
    }

    public FormatTypes getDataBlockFormat(InputTypes inputType) {
        FormatTypes dataBlockformat = inputType == InputTypes.FILE_IO ? FormatTypes.VALUE : (inputType == InputTypes.SERIAL_IO ? FormatTypes.BYTE : FormatTypes.BINARY);
        for (DataBlockType.Format format : this.dataBlock.getFormat()) {
            if (format.getInputType() != inputType) continue;
            dataBlockformat = format.getType();
        }
        return dataBlockformat;
    }

    public void setDataBlockFormat(InputTypes inputType, FormatTypes value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.dataBlock = this.deviceProps.dataBlock = new DataBlockType();
            DataBlockType.Format format = new DataBlockType.Format();
            format.setFormatType(value);
            format.setInputType(inputType);
            format.setSize(-1);
            this.dataBlock.getFormat().add(format);
        } else {
            boolean isSizeSet = false;
            for (DataBlockType.Format format : this.dataBlock.getFormat()) {
                if (isSizeSet || format.getType() != value) continue;
                format.setInputType(inputType);
                format.setSize(-1);
                isSizeSet = true;
                break;
            }
            if (!isSizeSet && this.dataBlock.getFormat().size() == 1) {
                DataBlockType.Format format = new DataBlockType.Format();
                format.setFormatType(value);
                format.setInputType(inputType);
                format.setSize(-1);
                this.dataBlock.getFormat().add(format);
            }
        }
    }

    public boolean isDataBlockCheckSumDefined() {
        return this.dataBlock != null && this.dataBlock.getCheckSum() != null && this.dataBlock.getCheckSum() != null && this.dataBlock.getCheckSum().getFormat() != null;
    }

    public CheckSumTypes getDataBlockCheckSumType() {
        return this.dataBlock != null && this.dataBlock.getCheckSum() != null ? this.dataBlock.getCheckSum().getType() : null;
    }

    public void setDataBlockCheckSumType(CheckSumTypes value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        if (value == null) {
            this.dataBlock.setCheckSum(null);
        } else {
            if (this.dataBlock.getCheckSum() == null) {
                this.dataBlock.setCheckSum(new DataBlockType.CheckSum());
            }
            this.dataBlock.getCheckSum().setType(value);
        }
    }

    public FormatTypes getDataBlockCheckSumFormat() {
        return this.dataBlock != null && this.dataBlock.getCheckSum() != null ? this.dataBlock.getCheckSum().getFormat() : FormatTypes.BINARY;
    }

    public void setDataBlockCheckSumFormat(FormatTypes value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        if (value == null) {
            this.dataBlock.setCheckSum(null);
        } else {
            if (this.dataBlock.getCheckSum() == null) {
                this.dataBlock.setCheckSum(new DataBlockType.CheckSum());
            }
            this.dataBlock.getCheckSum().setFormat(value);
        }
    }

    public String getDataBlockLeader() {
        return this.dataBlock != null ? this.dataBlock.getLeader() : "$";
    }

    public void setDataBlockLeader(String value) {
        this.isChangePropery = true;
        if (value == null) {
            this.dataBlock.setLeader(null);
        } else {
            this.dataBlock.setLeader(value);
        }
    }

    public byte[] getDataBlockEnding() {
        return this.dataBlock != null ? this.dataBlock.getTrailer() : new HexBinaryAdapter().unmarshal("0D0A");
    }

    public String getDataBlockEndingLineEndingType() {
        return this.dataBlock != null ? LineEndingTypes.valueFrom(this.dataBlock.getTrailer()) : LineEndingTypes.CRLF.value();
    }

    public void setDataBlockEnding(String value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        if (value == null) {
            this.dataBlock.setTrailer(null);
        } else {
            this.dataBlock.setTrailer(LineEndingTypes.bytesFromValue(value));
        }
    }

    public TimeUnitTypes getDataBlockTimeUnit() {
        return this.dataBlock != null ? this.dataBlock.getTimeUnit() : TimeUnitTypes.MSEC;
    }

    public void setDataBlockTimeUnit(TimeUnitTypes value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        this.dataBlock.setTimeUnit(value);
    }

    public int getDataBlockTimeUnitFactor() {
        return this.dataBlock != null && this.dataBlock.getTimeUnit() == null ? 1000 : (this.dataBlock != null && this.dataBlock.getTimeUnit().equals((Object)TimeUnitTypes.MSEC) ? 1 : 1000);
    }

    public CommaSeparatorTypes getDataBlockSeparator() {
        return this.dataBlock != null && this.dataBlock.getSeparator() != null ? this.dataBlock.getSeparator() : CommaSeparatorTypes.SEMICOLON;
    }

    public void setDataBlockSeparator(CommaSeparatorTypes value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        this.dataBlock.setSeparator(value);
    }

    public String getDataBlockPreferredDataLocation() {
        return this.dataBlock != null ? (this.dataBlock.getPreferredDataLocation() != null && this.dataBlock.getPreferredDataLocation().length() != 0 ? this.dataBlock.getPreferredDataLocation() : this.settings.getDataFilePath()) : this.settings.getDataFilePath();
    }

    public void setDataBlockPreferredDataLocation(String value) {
        this.isChangePropery = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        this.dataBlock.setPreferredDataLocation(value != null ? value.trim() : "");
    }

    public boolean isDataBlockPreferredFileExtentionDefined() {
        return this.dataBlock != null && this.dataBlock.preferredFileExtention != null && this.dataBlock.preferredFileExtention.length() > 3;
    }

    public String getDataBlockPreferredFileExtention() {
        try {
            return this.dataBlock.getPreferredFileExtention();
        }
        catch (Exception e) {
            log.log(gde.log.Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGE0052", new String[]{this.xmlFile.getFileName().toString()}));
            return "*.*";
        }
    }

    public void setDataBlockPreferredFileExtention(String value) {
        this.isChangePropery = true;
        boolean isValidExt = true;
        if (this.dataBlock == null) {
            this.deviceProps.dataBlock = this.dataBlock = new ObjectFactory().createDataBlockType();
        }
        if (value != null) {
            boolean bl = isValidExt = (value = value.replace(" ", "").replace("*", "").replace(".", "").trim()).length() >= 1;
            if (!isValidExt) {
                this.dataBlock.setPreferredFileExtention(null);
            } else {
                value = "*." + value;
            }
        }
        this.dataBlock.setPreferredFileExtention(value != null && isValidExt ? value : this.dataBlock.getPreferredFileExtention());
    }

    public boolean isTableTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.TABLE_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    public void setTableTabRequested(boolean enable) {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.TABLE_TAB);
        if (property == null) {
            this.createDesktopProperty(DesktopPropertyTypes.TABLE_TAB.name(), enable);
        } else {
            property.setValue(enable);
        }
        this.isChangePropery = true;
    }

    public boolean isDigitalTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.DIGITAL_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    public void setDigitalTabRequested(boolean enable) {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.DIGITAL_TAB);
        if (property == null) {
            this.createDesktopProperty(DesktopPropertyTypes.DIGITAL_TAB.name(), enable);
        } else {
            property.setValue(enable);
        }
        this.isChangePropery = true;
    }

    public boolean isAnalogTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.ANALOG_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    public void setAnalogTabRequested(boolean enable) {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.ANALOG_TAB);
        if (property == null) {
            this.createDesktopProperty(DesktopPropertyTypes.ANALOG_TAB.name(), enable);
        } else {
            property.setValue(enable);
        }
        this.isChangePropery = true;
    }

    public boolean isVoltagePerCellTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    @Deprecated
    public void setVoltagePerCellTabRequested(boolean enable) {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB);
        if (property == null) {
            this.createDesktopProperty(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB.name(), enable);
        } else {
            property.setValue(enable);
        }
        this.isChangePropery = true;
    }

    public boolean isUtilityGraphicsTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.UTILITY_GRAPHICS_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    public boolean isUtilityDeviceTabRequested() {
        DesktopPropertyType property = this.getDesktopProperty(DesktopPropertyTypes.UTILITY_DEVICE_TAB);
        return property != null ? property.isValue() : Boolean.FALSE.booleanValue();
    }

    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        return property != null ? (property.getTargetReferenceOrdinal() != null ? property.getTargetReferenceOrdinal() : -1) : -1;
    }

    public void setDesktopTypeDesription(DesktopPropertyTypes desktopType, String newDescription) {
        this.getDesktopProperty(desktopType).setDescription(newDescription);
        this.isChangePropery = true;
    }

    public int getChannelCount() {
        return this.deviceProps.getChannels().channel.size();
    }

    public String getChannelName(int channelNumber) {
        return this.deviceProps.getChannels().channel.get(channelNumber - 1).getName();
    }

    public String getChannelNameReplacement(int channelNumber) {
        return this.xmlResource.getReplacement(this.deviceProps.getChannels().channel.get(channelNumber - 1).getName());
    }

    public void setChannelName(String channelConfigName, int channelNumber) {
        this.isChangePropery = true;
        this.deviceProps.getChannels().channel.get(channelNumber - 1).setName(channelConfigName);
    }

    public ChannelType getChannelType(int channelConfigNumber) {
        return this.deviceProps.getChannels().channel.get(channelConfigNumber - 1);
    }

    public ChannelTypes getChannelTypes(int channelConfigNumber) {
        return this.deviceProps.getChannels().channel.get(channelConfigNumber - 1).getType();
    }

    @Deprecated
    public ChannelTypes getChannelTypes(String channelConfigKey) {
        return this.getChannel(channelConfigKey).getType();
    }

    public void setChannelTypes(ChannelTypes newChannleType, int channelNumber) {
        this.isChangePropery = true;
        this.deviceProps.getChannels().channel.get(channelNumber - 1).setType(newChannleType);
    }

    public void addChannelType(ChannelType newChannelType) {
        this.isChangePropery = true;
        this.deviceProps.getChannels().channel.add(newChannelType);
    }

    public void removeChannelType(int channelNumber) {
        this.isChangePropery = true;
        this.deviceProps.getChannels().channel.remove(channelNumber - 1);
    }

    public List<MeasurementType> getChannelMeasuremts(int channelConfigNumber) {
        return this.getChannel(channelConfigNumber).getMeasurement();
    }

    @Deprecated
    public List<MeasurementType> getChannelMeasuremts(String channelConfigKey) {
        return this.getChannel(channelConfigKey).getMeasurement();
    }

    public List<MeasurementType> getChannelMeasuremtsReplacedNames(int channelConfigNumber) {
        List<MeasurementType> tmpMeasurements = this.getChannel(channelConfigNumber).getMeasurement();
        ArrayList<MeasurementType> cpMeasurements = new ArrayList<MeasurementType>();
        Iterator<MeasurementType> ite = tmpMeasurements.iterator();
        while (ite.hasNext()) {
            MeasurementType measurementType = ite.next().clone();
            measurementType.name = this.xmlResource.getReplacement(measurementType.name);
            cpMeasurements.add(measurementType);
        }
        return cpMeasurements;
    }

    public int getNumberOfMeasurements(int channelConfigNumber) {
        return this.getChannel(channelConfigNumber) != null ? this.getChannel(channelConfigNumber).getMeasurement().size() : 0;
    }

    @Deprecated
    public int getNumberOfMeasurements(String channelConfigKey) {
        return this.getChannel(channelConfigKey).getMeasurement().size();
    }

    public void addMeasurement2Channel(int channelNumber, MeasurementType newMeasurementType) {
        this.isChangePropery = true;
        this.getChannel(channelNumber).getMeasurement().add(newMeasurementType);
    }

    @Deprecated
    public void addMeasurement2Channel(String channelConfigKey, MeasurementType newMeasurementType) {
        this.isChangePropery = true;
        this.getChannel(channelConfigKey).getMeasurement().add(newMeasurementType);
    }

    public void removeMeasurementFromChannel(int channelConfigNumber, MeasurementType removeMeasurementType) {
        this.isChangePropery = true;
        this.getChannel(channelConfigNumber).getMeasurement().remove(removeMeasurementType);
    }

    @Deprecated
    public void removeMeasurementFromChannel(String channelConfigKey, MeasurementType newMeasurementType) {
        this.isChangePropery = true;
        this.getChannel(channelConfigKey).getMeasurement().remove(newMeasurementType);
    }

    public ChannelType getChannel(int channelConfigNumber) {
        return this.deviceProps.getChannels().channel.size() >= channelConfigNumber ? this.deviceProps.getChannels().channel.get(channelConfigNumber - 1) : null;
    }

    @Deprecated
    public ChannelType getChannel(String channelConfigKey) {
        ChannelType channel = null;
        for (ChannelType c : this.deviceProps.getChannels().channel) {
            if (!c.getName().trim().startsWith(channelConfigKey)) continue;
            channel = c;
            break;
        }
        return channel;
    }

    public void setMeasurementActive(int channelConfigNumber, int measurementOrdinal, boolean isActive) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelConfigNumber = \"" + channelConfigNumber + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigNumber)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigNumber, measurementOrdinal).setActive(isActive);
    }

    @Deprecated
    public void setMeasurementActive(String channelConfigKey, int measurementOrdinal, boolean isActive) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelKey = \"" + channelConfigKey + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigKey)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigKey, measurementOrdinal).setActive(isActive);
    }

    public MeasurementType getMeasurement(int channelConfigNumber, int measurementOrdinal) {
        if (this.deviceProps.getChannels().channel.size() >= channelConfigNumber) {
            try {
                MeasurementType measurement = this.getChannel(channelConfigNumber).getMeasurement().get(measurementOrdinal);
                if (measurement != null) {
                    return measurement;
                }
            }
            catch (IndexOutOfBoundsException e) {
                MeasurementType newMeasurement = this.getChannel(channelConfigNumber).getMeasurement().get(0).clone();
                newMeasurement.setName("tmpMeasurement" + measurementOrdinal);
                this.addMeasurement2Channel(channelConfigNumber, newMeasurement);
                this.isChangePropery = true;
            }
        }
        return this.deviceProps.getChannels().channel.size() >= channelConfigNumber ? this.getChannel(channelConfigNumber).getMeasurement().get(measurementOrdinal) : this.getChannel(1).getMeasurement().get(measurementOrdinal);
    }

    @Deprecated
    public MeasurementType getMeasurement(String channelConfigKey, int measurementOrdinal) {
        MeasurementType measurement = null;
        try {
            String tmpMeasurementKey = this.getMeasurementNames(channelConfigKey)[measurementOrdinal];
            for (MeasurementType meas : this.getChannel(channelConfigKey).getMeasurement()) {
                if (!meas.getName().equals(tmpMeasurementKey)) continue;
                measurement = meas;
                break;
            }
        }
        catch (RuntimeException e) {
            log.log(gde.log.Level.SEVERE, channelConfigKey + " - " + this.getMeasurementNames(channelConfigKey)[measurementOrdinal], e);
        }
        return measurement;
    }

    public List<PropertyType> getProperties(int channelConfigNumber, int measurementOrdinal) {
        List<PropertyType> list = new ArrayList<PropertyType>();
        MeasurementType measurement = this.getMeasurement(channelConfigNumber, measurementOrdinal);
        if (measurement != null) {
            list = measurement.getProperty();
        }
        return list;
    }

    @Deprecated
    public List<PropertyType> getProperties(String channelConfigKey, int measurementOrdinal) {
        List<PropertyType> list = new ArrayList<PropertyType>();
        MeasurementType measurement = this.getMeasurement(channelConfigKey, measurementOrdinal);
        if (measurement != null) {
            list = measurement.getProperty();
        }
        return list;
    }

    public static void addProperty(List<PropertyType> properties, String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        properties.add(newProperty);
    }

    public String getMeasurementName(int channelConfigNumber, int measurementOrdinal) {
        return this.getMeasurement(channelConfigNumber, measurementOrdinal).getName();
    }

    public String getMeasurementNameReplacement(int channelConfigNumber, int measurementOrdinal) {
        return this.xmlResource.getReplacement(this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
    }

    public void setMeasurementName(int channelConfigNumber, int measurementOrdinal, String name) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelConfigNumber = \"" + channelConfigNumber + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigNumber)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigNumber, measurementOrdinal).setName(name);
    }

    @Deprecated
    public void setMeasurementName(String channelConfigKey, int measurementOrdinal, String name) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelKey = \"" + channelConfigKey + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigKey)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigKey, measurementOrdinal).setName(name);
    }

    public String getMeasurementUnit(int channelConfigNumber, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelConfigNumber = \"" + channelConfigNumber + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigNumber)[measurementOrdinal] + "\"");
        }
        return this.getMeasurement(channelConfigNumber, measurementOrdinal).getUnit();
    }

    @Deprecated
    public String getMeasurementUnit(String channelConfigKey, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelKey = \"" + channelConfigKey + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigKey)[measurementOrdinal] + "\"");
        }
        return this.getMeasurement(channelConfigKey, measurementOrdinal).getUnit();
    }

    public void setMeasurementUnit(int channelConfigNumber, int measurementOrdinal, String unit) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelConfigNumber = \"" + channelConfigNumber + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigNumber)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigNumber, measurementOrdinal).setUnit(unit);
    }

    @Deprecated
    public void setMeasurementUnit(String channelConfigKey, int measurementOrdinal, String unit) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "channelKey = \"" + channelConfigKey + "\" measurementKey = \"" + this.getMeasurementNames(channelConfigKey)[measurementOrdinal] + "\"");
        }
        this.isChangePropery = true;
        this.getMeasurement(channelConfigKey, measurementOrdinal).setUnit(unit);
    }

    public String getMeasurementSymbol(int channelConfigNumber, int measurementOrdinal) {
        return this.getMeasurement(channelConfigNumber, measurementOrdinal).getSymbol();
    }

    @Deprecated
    public String getMeasurementSymbol(String channelConfigKey, int measurementOrdinal) {
        return this.getMeasurement(channelConfigKey, measurementOrdinal).getSymbol();
    }

    public void setMeasurementSymbol(int channelConfigNumber, int measurementOrdinal, String symbol) {
        this.isChangePropery = true;
        this.getMeasurement(channelConfigNumber, measurementOrdinal).setSymbol(symbol);
    }

    @Deprecated
    public void setMeasurementSymbol(String channelConfigKey, int measurementOrdinal, String symbol) {
        this.isChangePropery = true;
        this.getMeasurement(channelConfigKey, measurementOrdinal).setSymbol(symbol);
    }

    public String getMeasurementLabelReplacement(int channelConfigNumber, int measurementOrdinal) {
        String key = this.getMeasurement(channelConfigNumber, measurementOrdinal).getLabel();
        return key != null ? this.xmlResource.getReplacement(key) : "";
    }

    public StatisticsType getMeasurementStatistic(int channelConfigNumber, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get statistics type from measurement = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        return this.getMeasurement(channelConfigNumber, measurementOrdinal).getStatistics();
    }

    @Deprecated
    public StatisticsType getMeasurementStatistic(String channelConfigKey, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get statistics type from measurement = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        return this.getMeasurement(channelConfigKey, measurementOrdinal).getStatistics();
    }

    public void removeStatisticsTypeFromMeasurement(int channelConfigNumber, int measurementOrdinal) {
        this.isChangePropery = true;
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "remove statistics type from measurement = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        this.getMeasurement(channelConfigNumber, measurementOrdinal).setStatistics(null);
    }

    public String[] getMeasurementSettlementScoregroupNames(int channelConfigNumber) {
        StringBuilder sb = new StringBuilder();
        ChannelType channel = this.getChannel(channelConfigNumber);
        if (channel != null) {
            for (MeasurementType measurementType : channel.getMeasurement()) {
                sb.append(measurementType.getName()).append(";");
            }
            if (channel.getSettlements() != null) {
                for (SettlementType settlement : channel.getSettlements().values()) {
                    sb.append(settlement.getName()).append(";");
                }
            }
            if (channel.getScoreGroups() != null) {
                for (ScoreGroupType scoregroup : channel.getScoreGroups().values()) {
                    sb.append(scoregroup.getName()).append(";");
                }
            }
        }
        return sb.toString().length() > 1 ? sb.toString().split(";") : new String[]{};
    }

    public String[] getMeasurementNames(int channelConfigNumber) {
        StringBuilder sb = new StringBuilder();
        ChannelType channel = this.getChannel(channelConfigNumber);
        if (channel != null) {
            List<MeasurementType> measurement = channel.getMeasurement();
            for (MeasurementType measurementType : measurement) {
                sb.append(measurementType.getName()).append(";");
            }
        }
        return sb.toString().length() > 1 ? sb.toString().split(";") : new String[]{};
    }

    public String[] getMeasurementNamesReplacements(int channelConfigNumber) {
        return this.xmlResource.getReplacements(this.getMeasurementNames(channelConfigNumber));
    }

    @Deprecated
    public String[] getMeasurementNames(String channelConfigKey) {
        StringBuilder sb = new StringBuilder();
        ChannelType channel = this.getChannel(channelConfigKey);
        if (channel != null) {
            List<MeasurementType> measurement = channel.getMeasurement();
            for (MeasurementType measurementType : measurement) {
                sb.append(measurementType.getName()).append(";");
            }
        }
        return sb.toString().length() > 1 ? this.xmlResource.getReplacements(sb.toString().split(";")) : new String[]{};
    }

    public PropertyType getMeasruementProperty(int channelConfigNumber, int measurementOrdinal, String propertyKey) {
        PropertyType property;
        block3: {
            property = null;
            try {
                MeasurementType measurementType = this.getMeasurement(channelConfigNumber, measurementOrdinal);
                if (measurementType == null) break block3;
                List<PropertyType> properties = measurementType.getProperty();
                for (PropertyType propertyType : properties) {
                    if (!propertyType.getName().equals(propertyKey)) continue;
                    property = propertyType;
                    break;
                }
            }
            catch (RuntimeException e) {
                log.log(gde.log.Level.SEVERE, channelConfigNumber + " - " + this.getMeasurementNames(channelConfigNumber)[measurementOrdinal] + " - " + propertyKey, e);
            }
        }
        return property;
    }

    public void removeMeasruementProperty(int channelConfigNumber, int measurementOrdinal, String propertyKey) {
        MeasurementType measurementType = this.getMeasurement(channelConfigNumber, measurementOrdinal);
        if (measurementType != null) {
            List<PropertyType> properties = measurementType.getProperty();
            Iterator<PropertyType> iter = properties.iterator();
            while (iter.hasNext()) {
                PropertyType propertyType = iter.next();
                if (!propertyType.getName().equals(propertyKey)) continue;
                iter.remove();
                break;
            }
        }
        this.isChangePropery = true;
    }

    @Deprecated
    public PropertyType getMeasruementProperty(String channelConfigKey, int measurementOrdinal, String propertyKey) {
        PropertyType property;
        block3: {
            property = null;
            try {
                MeasurementType measurementType = this.getMeasurement(channelConfigKey, measurementOrdinal);
                if (measurementType == null) break block3;
                List<PropertyType> properties = measurementType.getProperty();
                for (PropertyType propertyType : properties) {
                    if (!propertyType.getName().equals(propertyKey)) continue;
                    property = propertyType;
                    break;
                }
            }
            catch (RuntimeException e) {
                log.log(gde.log.Level.SEVERE, channelConfigKey + " - " + this.getMeasurementNames(channelConfigKey)[measurementOrdinal] + " - " + propertyKey, e);
            }
        }
        return property;
    }

    public double getMeasurementOffset(int channelConfigNumber, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get offset from measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        double value = 0.0;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.OFFSET);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    @Deprecated
    public double getMeasurementOffset(String channelConfigKey, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get offset from measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        double value = 0.0;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.OFFSET);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    public void setMeasurementOffset(int channelConfigNumber, int measurementOrdinal, double offset) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set offset onto measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.OFFSET);
        if (property == null) {
            this.createProperty(channelConfigNumber, measurementOrdinal, IDevice.OFFSET, DataTypes.DOUBLE, (Object)offset);
        } else {
            property.setValue("" + offset);
        }
    }

    @Deprecated
    public void setMeasurementOffset(String channelConfigKey, int measurementOrdinal, double offset) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set offset onto measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.OFFSET);
        if (property == null) {
            this.createProperty(channelConfigKey, measurementOrdinal, IDevice.OFFSET, DataTypes.DOUBLE, (Object)offset);
        } else {
            property.setValue("" + offset);
        }
    }

    public double getMeasurementFactor(int channelConfigNumber, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get factor from measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        double value = 1.0;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.FACTOR);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    @Deprecated
    public double getMeasurementFactor(String channelConfigKey, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get factor from measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        double value = 1.0;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.FACTOR);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    public void setMeasurementFactor(int channelConfigNumber, int measurementOrdinal, double factor) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set factor onto measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.FACTOR);
        if (property == null) {
            this.createProperty(channelConfigNumber, measurementOrdinal, IDevice.FACTOR, DataTypes.DOUBLE, (Object)factor);
        } else {
            property.setValue("" + factor);
        }
    }

    @Deprecated
    public void setMeasurementFactor(String channelConfigKey, int measurementOrdinal, double factor) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set factor onto measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.FACTOR);
        if (property == null) {
            this.createProperty(channelConfigKey, measurementOrdinal, IDevice.FACTOR, DataTypes.DOUBLE, (Object)factor);
        } else {
            property.setValue("" + factor);
        }
    }

    public double getMeasurementReduction(int channelConfigNumber, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get reduction from measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        double value = 0.0;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.REDUCTION);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    @Deprecated
    public double getMeasurementReduction(String channelConfigKey, int measurementOrdinal) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "get reduction from measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        double value = 0.0;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.REDUCTION);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        }
        return value;
    }

    public void setMeasurementReduction(int channelConfigNumber, int measurementOrdinal, double reduction) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set reduction onto measurement name = " + this.getMeasurement(channelConfigNumber, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, IDevice.REDUCTION);
        if (property == null) {
            this.createProperty(channelConfigNumber, measurementOrdinal, IDevice.REDUCTION, DataTypes.DOUBLE, (Object)reduction);
        } else {
            property.setValue("" + reduction);
        }
    }

    @Deprecated
    public void setMeasurementReduction(String channelConfigKey, int measurementOrdinal, double reduction) {
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.log(gde.log.Level.FINER, "set reduction onto measurement name = " + this.getMeasurement(channelConfigKey, measurementOrdinal).getName());
        }
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, IDevice.REDUCTION);
        if (property == null) {
            this.createProperty(channelConfigKey, measurementOrdinal, IDevice.REDUCTION, DataTypes.DOUBLE, (Object)reduction);
        } else {
            property.setValue("" + reduction);
        }
    }

    public Object getMeasurementPropertyValue(int channelConfigNumber, int measurementOrdinal, String propertyKey) {
        PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, propertyKey);
        return property != null ? property.getValue() : "";
    }

    @Deprecated
    public Object getMeasurementPropertyValue(String channelConfigKey, int measurementOrdinal, String propertyKey) {
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, propertyKey);
        return property != null ? property.getValue() : "";
    }

    public void setMeasurementPropertyValue(int channelConfigNumber, int measurementOrdinal, String propertyKey, DataTypes type, Object value) {
        this.isChangePropery = true;
        if (value != null) {
            PropertyType property = this.getMeasruementProperty(channelConfigNumber, measurementOrdinal, propertyKey);
            if (property == null) {
                if (type == DataTypes.STRING) {
                    this.createProperty(channelConfigNumber, measurementOrdinal, propertyKey, type, (Object)("" + value));
                } else {
                    this.createProperty(channelConfigNumber, measurementOrdinal, propertyKey, type, (Object)("" + value).replace(',', '.'));
                }
            } else if (type == DataTypes.STRING) {
                property.setValue("" + value);
            } else {
                property.setValue(("" + value).replace(',', '.'));
            }
        } else {
            this.removeMeasruementProperty(channelConfigNumber, measurementOrdinal, propertyKey);
        }
    }

    @Deprecated
    public void setMeasurementPropertyValue(String channelConfigKey, int measurementOrdinal, String propertyKey, DataTypes type, Object value) {
        this.isChangePropery = true;
        PropertyType property = this.getMeasruementProperty(channelConfigKey, measurementOrdinal, propertyKey);
        if (property == null) {
            this.createProperty(channelConfigKey, measurementOrdinal, propertyKey, type, (Object)("" + value).replace(',', '.'));
        } else {
            property.setValue(("" + value).replace(',', '.'));
        }
    }

    private void createProperty(int channelConfigNumber, int measurementOrdinal, String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.getMeasurement(channelConfigNumber, measurementOrdinal).getProperty().add(newProperty);
        this.isChangePropery = true;
    }

    @Deprecated
    private void createProperty(String channelConfigKey, int measurementOrdinal, String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.getMeasurement(channelConfigKey, measurementOrdinal).getProperty().add(newProperty);
        this.isChangePropery = true;
    }

    private void createDesktopProperty(String propertyKey, Boolean value) {
        ObjectFactory factory = new ObjectFactory();
        DesktopPropertyType newProperty = factory.createDesktopPropertyType();
        newProperty.setName(DesktopPropertyTypes.fromValue(propertyKey));
        newProperty.setValue(value);
        if (this.desktop == null) {
            this.desktop = factory.createDesktopType();
            this.deviceProps.setDesktop(this.desktop);
        }
        this.desktop.getProperty().add(newProperty);
        this.isChangePropery = true;
    }

    public void setChangePropery(boolean enabled) {
        this.isChangePropery = enabled;
    }

    public boolean isChangePropery() {
        return this.isChangePropery;
    }

    public void configureSerialPortMenu(int useIconSet, String useToolTipOpen, String useTooTipClose) {
        DataExplorer application = DataExplorer.getInstance();
        if (application.getMenuBar() != null) {
            application.getMenuBar().setSerialPortIconSet(useIconSet);
        }
        if (application.getMenuToolBar() != null) {
            application.getMenuToolBar().setSerialPortIconSet(useIconSet, useToolTipOpen, useTooTipClose);
        }
    }

    public CalculationThread getCalculationThread() {
        return this.calculationThread;
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{-1, -1};
    }

    public CTabItem getUtilityGraphicsTabItem() {
        return null;
    }

    public CTabItem getUtilityDeviceTabItem() {
        return null;
    }

    public boolean isActualRecordSetWithGpsData() {
        return false;
    }

    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        if (log.isLoggable(gde.log.Level.FINEST)) {
            log.log(gde.log.Level.FINEST, "fileEndingType = " + fileEndingType + ", isExport2TmpDir = " + isExport2TmpDir);
        }
        return "";
    }

    public String getJarName() {
        return this.getClass().getProtectionDomain().toString();
    }

    public void setGPS2KMZMeasurementOrdinal(Integer ordinal) {
        this.kmzMeasurementOrdinal = ordinal;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        return -1;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, recordSet.getName() + index + fixValidity + startAltitude + offsetAltitude);
        }
        return "DDMMmmmNDDDMMmmm0V000000000000";
    }

    public String getRecordSetStemName() {
        return this.getStateType() != null ? (this.getStateType().getProperty() != null ? ") " + this.getStateType().getProperty().get(0).getName() : Messages.getString("GDE_MSGT0272")) : Messages.getString("GDE_MSGT0272");
    }

    public String getRecordSetStemNameReplacement() {
        return this.getStateType() != null ? (this.getStateType().getProperty() != null ? ") " + this.xmlResource.getReplacement(this.getStateType().getProperty().get(0).getName()) : Messages.getString("GDE_MSGT0272")) : Messages.getString("GDE_MSGT0272");
    }

    public String getRecordSetStateName(int stateNumber) {
        return this.getStateType() != null ? (this.getStateType().getProperty() != null ? this.getStateProperty(stateNumber).getName() : "state_data_recording") : "state_data_recording";
    }

    public String getRecordSetStateNameReplacement(int stateNumber) {
        try {
            return this.getStateType() != null ? (this.getStateType().getProperty() != null ? this.xmlResource.getReplacement(this.getStateProperty(stateNumber).getName()) : this.xmlResource.getReplacement("state_data_recording")) : this.xmlResource.getReplacement("state_data_recording");
        }
        catch (Exception e) {
            return this.xmlResource.getReplacement("state_data_recording");
        }
    }

    public IDeviceCommPort getCommunicationPort() {
        return null;
    }

    public int getLastChannelNumber() {
        int channelNumber = this.settings.getLastUseChannelNumber(this.getName());
        return channelNumber <= this.deviceProps.getChannels().channel.size() ? channelNumber : this.deviceProps.getChannels().channel.size();
    }

    @Deprecated
    public void setLastChannelNumber(int channelNumber) {
        this.settings.addDeviceUse(this.getName(), channelNumber);
    }

    public List<ChannelPropertyType> getChannelProperties() {
        return this.deviceProps.getChannels().getProperty();
    }

    public ChannelPropertyType getChannelProperty(ChannelPropertyTypes key) {
        if (this.getChannelProperties() != null) {
            for (ChannelPropertyType property : this.getChannelProperties()) {
                if (!property.name.equals((Object)key)) continue;
                return property;
            }
        }
        ChannelPropertyType channelProperty = new ObjectFactory().createChannelPropertyType();
        channelProperty.setName(key);
        return channelProperty;
    }

    public void setChannelProperty(ChannelPropertyTypes key, DataTypes type, String value) {
        ChannelPropertyType channelProperty = this.getChannelProperty(key);
        channelProperty.setType(type);
        channelProperty.setValue(value);
        List<ChannelPropertyType> properties = this.getChannelProperties();
        if (!properties.contains(channelProperty)) {
            properties.add(channelProperty);
        }
        this.isChangePropery = true;
    }

    public boolean isFilterEnabled() {
        return false;
    }

    public Integer getFilteredPoint(int channelNumber, Record record, int index) {
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, channelNumber + record.getName() + index);
        }
        return record.realGet(index);
    }

    public DeviceDialog getDialog() {
        return null;
    }

    public String[] getNoneCalculationMeasurementNames(int channelConfigNumber, String[] validMeasurementNames) {
        Vector<String> tmpCalculationRecords = new Vector<String>();
        String[] deviceMeasurements = this.getMeasurementNames(channelConfigNumber);
        int deviceDataBlockSize = Math.abs(this.getDataBlockSize(FormatTypes.VALUE));
        deviceDataBlockSize = this.getDataBlockSize(FormatTypes.VALUE) <= 0 ? deviceMeasurements.length : deviceDataBlockSize;
        for (int i = 0; i < deviceMeasurements.length && i < validMeasurementNames.length; ++i) {
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (measurement.isCalculation()) continue;
            tmpCalculationRecords.add(validMeasurementNames[i]);
        }
        while (tmpCalculationRecords.size() > deviceDataBlockSize) {
            tmpCalculationRecords.remove(deviceDataBlockSize);
        }
        return tmpCalculationRecords.toArray(new String[0]);
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordKeys.length - fileRecordsProperties.length > 0) {
            int i;
            for (i = 0; i < fileRecordsProperties.length; ++i) {
                cleanedRecordNames.add(recordKeys[i]);
            }
            while (i < recordKeys.length) {
                recordSet.remove(recordKeys[i]);
                ++i;
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        return recordKeys;
    }

    public void applyMeasurementSpecialties(String[] fileRecordsProperties, RecordSet recordSet) {
    }

    public boolean isGPSCoordinates(Record record) {
        return false;
    }

    public int getMeasurementOrdinalFirstLithiumCell(RecordSet recordSet) {
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, recordSet.getName());
        }
        return 0;
    }

    public int getNumberOfLithiumCells(Object specificData) {
        return 0;
    }

    public boolean recordSetNumberFollowChannel() {
        return this.getChannelTypes(1) == ChannelTypes.TYPE_OUTLET;
    }

    public boolean useChannelWithSyncedDescription() {
        return false;
    }

    public int getCurrentSmoothIndex() {
        return 0;
    }

    public boolean isVariableMeasurementSize() {
        return false;
    }

    public boolean isPairOfChannels(int channelConfigNumberI, int channelConfigNumberJ) {
        if (this.channelGroups == null) {
            this.initChannelGroups();
        }
        return this.channelGroups[channelConfigNumberI - 1] > -1 && this.channelGroups[channelConfigNumberI - 1] == this.channelGroups[channelConfigNumberJ - 1];
    }

    public List<Integer> getChannelMixConfigNumbers(int channelNumber) {
        List<Integer> channelMixConfigNumbers = this.getDeviceGroup() == DeviceTypes.CHARGER ? this.getChannelBundle(channelNumber) : Collections.singletonList(channelNumber);
        return channelMixConfigNumbers;
    }

    private List<Integer> getChannelBundle(int channelConfigNumber) {
        ArrayList<Integer> channelNumbers = new ArrayList<Integer>();
        if (this.channelGroups == null) {
            this.initChannelGroups();
        }
        if (this.channelGroups[channelConfigNumber - 1] > -1) {
            for (int i = 0; i < this.channelGroups.length; ++i) {
                if (this.channelGroups[i] == -1 || this.channelGroups[i] != this.channelGroups[channelConfigNumber - 1]) continue;
                channelNumbers.add(i + 1);
            }
        } else {
            channelNumbers.add(channelConfigNumber);
        }
        return channelNumbers;
    }

    private void initChannelGroups() {
        int tmpGroupIndex = -1;
        this.channelGroups = new int[this.getChannelCount()];
        Arrays.fill(this.channelGroups, -1);
        for (int i = 0; i < this.deviceProps.getChannels().channel.size(); ++i) {
            Object[] measurementNamesI = this.getMeasurementNames(i + 1);
            Arrays.sort(measurementNamesI);
            for (int j = i + 1; j < this.deviceProps.getChannels().channel.size(); ++j) {
                Object[] measurementNamesJ = this.getMeasurementNames(j + 1);
                Arrays.sort(measurementNamesJ);
                if (!Arrays.equals(measurementNamesI, measurementNamesJ)) continue;
                if (this.channelGroups[i] == -1) {
                    this.channelGroups[i] = ++tmpGroupIndex;
                }
                this.channelGroups[j] = this.channelGroups[i];
            }
        }
    }

    public String[] prepareExportRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                if (this.isGPSCoordinates(record)) {
                    int grad = record.realGet(rowIndex) / 1000000;
                    double minuten = (double)(record.realGet(rowIndex) % 1000000) / 10000.0;
                    dataTableRow[index + 1] = String.format("%02.6f", (double)grad + minuten / 100.0);
                } else {
                    dataTableRow[index + 1] = record.getDecimalFormat().format(record.getOffset() + ((double)record.realGet(rowIndex).intValue() / 1000.0 - record.getReduction()) * record.getFactor());
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public String[] prepareRawExportRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            String[] recordNames = recordSet.getRecordNames();
            int index = 1;
            for (int j = 0; index < dataTableRow.length && j < recordNames.length; ++j) {
                Record record = recordSet.get(recordNames[j]);
                MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), record.getOrdinal());
                if (measurement.isCalculation()) continue;
                dataTableRow[index] = String.format("%d", record.realGet(rowIndex) / 1000);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public String getFileBaseDir() {
        return this.getName();
    }

    public String getFileSha1Hash() {
        if (this.fileSha1Hash.isEmpty()) {
            this.setFileSha1Hash();
        }
        return this.fileSha1Hash;
    }

    private void setFileSha1Hash() {
        Path fileSubPath = Paths.get(GDE.APPL_HOME_PATH, new String[0]).relativize(this.xmlFile);
        try (InputStream inputStream = DataAccess.getInstance().getDeviceXmlInputStream(fileSubPath);){
            this.fileSha1Hash = SecureHash.sha1(inputStream);
        }
        catch (Exception e) {
            this.fileSha1Hash = "";
            log.log(gde.log.Level.SEVERE, e.getMessage(), e);
        }
    }

    public int[] getAtlitudeTripSpeedOrdinals() {
        return new int[0];
    }

    public String getMeasurementReplacement(String key) {
        return this.xmlResource.getReplacement(key);
    }

    public String crossCheckChannelConfig(String channelConfig, HashMap<String, String> recordSetInfo) {
        return channelConfig;
    }
}

