/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.config.Settings;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.AbstractMeasuring;
import gde.histo.ui.CurveSurvey;
import gde.histo.ui.Measure;
import gde.histo.ui.SummaryComposite;
import gde.histo.ui.data.SummarySpots;
import gde.log.Logger;
import gde.utils.ColorUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class SummaryMeasuring
extends AbstractMeasuring {
    private static final String $CLASS_NAME = SummaryMeasuring.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Settings settings = Settings.getInstance();
    boolean isLeftMouseMeasure = false;
    boolean isRightMouseMeasure = false;
    private final SummaryComposite summaryComposite;
    private final CurveSurvey curveSurvey;
    private GC canvasGC;

    public SummaryMeasuring(SummaryComposite summaryComposite, Measure measure) {
        super(measure);
        this.summaryComposite = summaryComposite;
        this.curveSurvey = null;
    }

    @Override
    public void drawMeasuring(GC canvasGC) {
        this.drawMeasuring(canvasGC, this.measure.getTimestampMeasure_ms(), this.measure.getTimestampDelta_ms());
    }

    private void drawMeasuring(GC canvasGC, long timestampMeasureNew_ms, long timestampDeltaNew_ms) {
        canvasGC.setForeground(ColorUtils.getColor(this.measure.measureRecord.getRGB()));
        this.measure.setTimestampMeasure_ms(timestampMeasureNew_ms);
        this.measure.setTimestampDelta_ms(timestampDeltaNew_ms);
        this.drawModeMeasurement(canvasGC);
    }

    private void drawModeMeasurement(GC canvasImageGC) {
        SummaryComposite hgc = this.summaryComposite;
        boolean isSummarySpotsVisible = this.settings.isSummarySpotsVisible();
        if (!isSummarySpotsVisible) {
            return;
        }
        boolean isPartialDataTable = this.settings.isPartialDataTable();
        TrailRecordSet trailRecordSet = hgc.retrieveTrailRecordSet();
        if (trailRecordSet.getDisplayRecords() == null || trailRecordSet.getDisplayRecords().isEmpty()) {
            return;
        }
        SummarySpots.Density density = SummarySpots.Density.toDensity(hgc.curveAreaBounds.width, trailRecordSet.getTimeStepSize());
        int stripHeight = hgc.fixedCanvasHeight / trailRecordSet.getDisplayRecords().size();
        SummarySpots previousSpots = null;
        for (int i = 0; i < trailRecordSet.getDisplayRecords().size(); ++i) {
            TrailRecord record = trailRecordSet.getDisplayRecords().get(i);
            Rectangle drawStripBounds = new Rectangle(hgc.curveAreaBounds.x, hgc.curveAreaBounds.y + stripHeight * i + 2, hgc.curveAreaBounds.width, stripHeight);
            SummarySpots summarySpots = this.summaryComposite.getChartData(record).getSummarySpots();
            summarySpots.initialize(drawStripBounds, density);
            if (!record.isVisible() && isPartialDataTable) continue;
            if (record.equals(hgc.measuring.measure.measureRecord)) {
                summarySpots.drawMarkers(canvasImageGC, hgc.measuring.measure);
            }
            if (previousSpots != null && this.settings.isCurveSurvey()) {
                summarySpots.drawConnections(canvasImageGC, previousSpots, hgc.measuring.measure);
            }
            previousSpots = summarySpots;
        }
    }

    @Override
    public void cleanMeasuring() {
        this.isLeftMouseMeasure = false;
        this.isRightMouseMeasure = false;
        log.finer(() -> "canvasGC=" + this.canvasGC + " curveSurvey=" + this.curveSurvey + " height=" + this.summaryComposite.graphicCanvas.getBounds().height);
        if (this.curveSurvey != null) {
            throw new UnsupportedOperationException();
        }
        this.summaryComposite.setRecordSetCommentStandard();
    }

    @Override
    public void processMouseDownMove(long timestamp_ms) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processMouseUpMove(Point point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processMouseDownAction(Point point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processMouseUpAction(Point point) {
        throw new UnsupportedOperationException();
    }
}

