/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.config.Settings;
import gde.histo.datasources.HistoSet;
import gde.histo.utils.ElementaryQuantile;
import gde.histo.utils.Spot;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UniversalQuantile<T extends Number>
extends ElementaryQuantile<T> {
    private static final String $CLASS_NAME = UniversalQuantile.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final double CLOSE_OUTLIER_LIMIT = 1.5;
    public static final int FAR_OUTLIER_LIMIT = 3;
    private final Set<T> outcasts;
    private final List<T> castaways = new ArrayList<T>();
    private final List<T> constantScraps = new ArrayList<T>();
    private T firstValidElement;
    private T lastValidElement;

    public static UniversalQuantile<Double> createUniversalSpotQuantile(Collection<Spot<Double>> population, double sigmaFactor, double outlierFactor, Settings settings) {
        ArrayList<Double> trunk = new ArrayList<Double>();
        for (Spot<Double> spot : population) {
            trunk.add(spot.y());
        }
        boolean isSample = true;
        return new UniversalQuantile<Double>(trunk, isSample, sigmaFactor, outlierFactor, settings);
    }

    public UniversalQuantile(Collection<T> population, boolean isSample, boolean removeCastaways, boolean removeConstantOutliers, Settings settings) {
        this(population, isSample, 0.674489694, removeCastaways ? (double)settings.getOutlierToleranceSpread() : 9999.0, removeConstantOutliers ? 3.0 : (removeCastaways ? (double)settings.getOutlierToleranceSpread() : 9999.0), new HashSet(), settings);
    }

    public UniversalQuantile(List<T> population, boolean isSample, double sigmaFactor, double outlierFactor, Settings settings) {
        this(population, isSample, sigmaFactor, outlierFactor, outlierFactor, new HashSet(), settings);
    }

    public UniversalQuantile(Collection<T> population, boolean isSample, double sigmaFactor, double outlierFactor, double constantOutlierFactor, Set<T> outcasts, Settings settings) {
        super(!outcasts.isEmpty() ? new ArrayList() : new ArrayList<T>(population), isSample, settings);
        Number t;
        this.outcasts = outcasts;
        if (population == null || population.isEmpty()) {
            throw new IllegalArgumentException("empty population");
        }
        if (!outcasts.isEmpty()) {
            for (Number element : population) {
                if (outcasts.contains(element)) {
                    this.castaways.add(element);
                    continue;
                }
                this.trunk.add(element);
            }
            Collections.sort(this.trunk);
        }
        this.removeOutliers(sigmaFactor, outlierFactor, constantOutlierFactor);
        List<Object> populationList = population instanceof List ? (List<Object>)population : new ArrayList<T>(population);
        this.firstValidElement = null;
        ListIterator listIterator = populationList.listIterator();
        while (listIterator.hasNext()) {
            t = (Number)listIterator.next();
            if (this.castaways.contains(t)) continue;
            this.firstValidElement = t;
            break;
        }
        this.lastValidElement = null;
        listIterator = populationList.listIterator(populationList.size());
        while (listIterator.hasPrevious()) {
            t = (Number)listIterator.previous();
            if (this.castaways.contains(t)) continue;
            this.lastValidElement = t;
            break;
        }
        log.finest(() -> "" + populationList.size() + Arrays.toString(populationList.toArray()));
        log.finest(() -> "" + this.trunk.size() + Arrays.toString(this.trunk.toArray()));
    }

    private void removeOutliers(double sigmaFactor, double outlierFactor, double constantOutlierFactor) {
        Number value;
        if (constantOutlierFactor > outlierFactor) {
            throw new IllegalArgumentException();
        }
        double outlierProbability = (1.0 - ElementaryQuantile.ErrorFunction.getProbability(sigmaFactor)) / 2.0;
        double[] toleranceLowerUpper = this.getQuantileToleranceLowerUpper(sigmaFactor);
        if (HistoSet.fuzzyEquals(toleranceLowerUpper[0], 0.0) || HistoSet.fuzzyEquals(toleranceLowerUpper[1], 0.0)) {
            return;
        }
        ArrayList<Number> candidates = new ArrayList<Number>();
        double nonOutlierRange = toleranceLowerUpper[0] * 2.0 * outlierFactor;
        double nonConstantOutlierRange = toleranceLowerUpper[0] * 2.0 * constantOutlierFactor;
        double q1WithOutliers = this.getQuantile(outlierProbability);
        ListIterator iterator = this.trunk.listIterator();
        while (iterator.hasNext()) {
            value = (Number)iterator.next();
            if (value.doubleValue() < q1WithOutliers - nonOutlierRange) {
                this.castaways.add(value);
                iterator.remove();
                continue;
            }
            if (!(value.doubleValue() < q1WithOutliers - nonConstantOutlierRange)) break;
            candidates.add(value);
        }
        if (this.castaways.isEmpty() && candidates.size() > 2 && this.removePrevalentValues((Number)candidates.get(0), candidates)) {
            this.constantScraps.add((Number)candidates.get(0));
        }
        candidates = new ArrayList();
        nonOutlierRange = toleranceLowerUpper[1] * 2.0 * outlierFactor;
        nonConstantOutlierRange = toleranceLowerUpper[1] * 2.0 * constantOutlierFactor;
        double q3WithOutliers = this.getQuantile(1.0 - outlierProbability);
        iterator = this.trunk.listIterator(this.trunk.size());
        while (iterator.hasPrevious()) {
            value = (Number)iterator.previous();
            if (value.doubleValue() > q3WithOutliers + nonOutlierRange) {
                this.castaways.add(value);
                iterator.remove();
                continue;
            }
            if (!(value.doubleValue() > q3WithOutliers + nonConstantOutlierRange)) break;
            candidates.add(value);
        }
        if (this.castaways.isEmpty() && candidates.size() > 2 && this.removePrevalentValues((Number)candidates.get(0), candidates)) {
            this.constantScraps.add((Number)candidates.get(0));
        }
        if (this.trunk.isEmpty()) {
            throw new UnsupportedOperationException("empty trunk");
        }
    }

    private boolean removePrevalentValues(T scrappableCandidate, List<T> candidates) {
        boolean[] toRemove = new boolean[]{false};
        Number halfWayValue = (Number)candidates.get(candidates.size() / 2);
        toRemove[0] = scrappableCandidate.equals(halfWayValue);
        if (!toRemove[0]) {
            log.finest(() -> candidates.stream().collect(Collectors.groupingBy(t -> t, Collectors.counting())).entrySet().toString());
            Optional<Map.Entry> mostFrequentValueGroup = candidates.stream().collect(Collectors.groupingBy(t -> t, Collectors.counting())).entrySet().stream().max(Comparator.comparing(Map.Entry::getValue));
            mostFrequentValueGroup.ifPresent(e -> {
                Number mostFrequentValue = (Number)e.getKey();
                toRemove[0] = scrappableCandidate.equals(mostFrequentValue) && (Long)e.getValue() > 1L;
            });
        }
        if (toRemove[0]) {
            return this.trunk.removeAll(Collections.singleton(scrappableCandidate));
        }
        return false;
    }

    public double getPopulationMaxFigure() {
        double realMax = this.getQuartile4();
        for (Number t : this.castaways) {
            realMax = Math.max(realMax, t.doubleValue());
        }
        return realMax;
    }

    public double getPopulationMinFigure() {
        double realMin = this.getQuartile0();
        for (Number t : this.castaways) {
            realMin = Math.min(realMin, t.doubleValue());
        }
        return realMin;
    }

    public List<T> getOutliers() {
        ArrayList<T> outliers = new ArrayList<T>(this.castaways);
        outliers.removeAll(this.outcasts);
        return outliers;
    }

    public String getOutliersCsv() {
        return this.getOutliers().stream().map(rec$ -> ((Number)rec$).doubleValue()).map(String::valueOf).collect(Collectors.joining(","));
    }

    public List<T> getConstantScraps() {
        return this.constantScraps;
    }

    public String getConstantScrapsCsv() {
        return this.constantScraps.stream().map(rec$ -> ((Number)rec$).doubleValue()).map(String::valueOf).collect(Collectors.joining(","));
    }

    @Override
    public String toString() {
        return "isSample=" + this.isSample + ", size=" + this.getSize() + ", castawaysSize=" + this.castaways.size() + ", constantScraps=" + this.getConstantScrapsCsv() + ", sumFigure=" + this.getSumFigure() + ", avgFigure=" + this.getAvgFigure() + ", sigmaFigure=" + this.getSigmaFigure() + "";
    }

    public double getFirstFigure() {
        return ((Number)this.firstValidElement).doubleValue();
    }

    public double getLastFigure() {
        return ((Number)this.lastValidElement).doubleValue();
    }
}

