/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RowLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 3;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean fill = false;
    public boolean center = false;
    public boolean justify = false;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public RowLayout() {
    }

    public RowLayout(int type2) {
        this.type = type2;
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point extent = this.type == 256 ? this.layoutHorizontal(composite, false, wHint != -1 && this.wrap, wHint, flushCache) : this.layoutVertical(composite, false, hHint != -1 && this.wrap, hHint, flushCache);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        return extent;
    }

    Point computeSize(Control control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        RowData data2 = (RowData)control.getLayoutData();
        if (data2 != null) {
            wHint = data2.width;
            hHint = data2.height;
        }
        return control.computeSize(wHint, hHint, flushCache);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    String getName() {
        String string2 = this.getClass().getName();
        int index = string2.lastIndexOf(46);
        if (index == -1) {
            return string2;
        }
        return string2.substring(index + 1, string2.length());
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        if (this.type == 256) {
            this.layoutHorizontal(composite, true, this.wrap, clientArea.width, flushCache);
        } else {
            this.layoutVertical(composite, true, this.wrap, clientArea.height, flushCache);
        }
    }

    Point layoutHorizontal(Composite composite, boolean move2, boolean wrap, int width, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = 0;
        int i2 = 0;
        while (i2 < children.length) {
            Control control = children[i2];
            RowData data2 = (RowData)control.getLayoutData();
            if (data2 == null || !data2.exclude) {
                children[count++] = children[i2];
            }
            ++i2;
        }
        if (count == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        int childWidth = 0;
        int childHeight = 0;
        int maxHeight = 0;
        if (!this.pack) {
            int i3 = 0;
            while (i3 < count) {
                Control child = children[i3];
                Point size = this.computeSize(child, flushCache);
                if (width > -1 && width < size.x && wrap) {
                    size = child.computeSize(width, child.getLayoutData() == null ? -1 : ((RowData)child.getLayoutData()).height, flushCache);
                }
                childWidth = Math.max(childWidth, size.x);
                childHeight = Math.max(childHeight, size.y);
                ++i3;
            }
            maxHeight = childHeight;
        }
        int clientX = 0;
        int clientY = 0;
        if (move2) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        int[] wraps = null;
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move2 && (this.justify || this.fill || this.center)) {
            bounds = new Rectangle[count];
            wraps = new int[count];
        }
        int maxX = 0;
        int x = this.marginLeft + this.marginWidth;
        int y = this.marginTop + this.marginHeight;
        int i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            if (this.pack) {
                Point size = this.computeSize(child, flushCache);
                if (width > -1 && width < size.x && wrap) {
                    size = child.computeSize(width, child.getLayoutData() == null ? -1 : ((RowData)child.getLayoutData()).height, flushCache);
                }
                childWidth = size.x;
                childHeight = size.y;
            }
            if (wrap && i4 != 0 && x + childWidth > width) {
                wrapped = true;
                if (move2 && (this.justify || this.fill || this.center)) {
                    wraps[i4 - 1] = maxHeight;
                }
                x = this.marginLeft + this.marginWidth;
                y += this.spacing + maxHeight;
                if (this.pack) {
                    maxHeight = 0;
                }
            }
            if (this.pack || this.fill || this.center) {
                maxHeight = Math.max(maxHeight, childHeight);
            }
            if (move2) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify || this.fill || this.center) {
                    bounds[i4] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxX = Math.max(maxX, x += this.spacing + childWidth);
            ++i4;
        }
        maxX = Math.max(clientX + this.marginLeft + this.marginWidth, maxX - this.spacing);
        if (!wrapped) {
            maxX += this.marginRight + this.marginWidth;
        }
        if (move2 && (this.justify || this.fill || this.center)) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (width - maxX) / (count + 1));
                margin = Math.max(0, (width - maxX) % (count + 1) / 2);
            } else if (this.fill || this.justify || this.center) {
                int last = 0;
                if (count > 0) {
                    wraps[count - 1] = maxHeight;
                }
                int i5 = 0;
                while (i5 < count) {
                    if (wraps[i5] != 0) {
                        int wrapCount = i5 - last + 1;
                        if (this.justify) {
                            int wrapX = 0;
                            int j = last;
                            while (j <= i5) {
                                wrapX += bounds[j].width + this.spacing;
                                ++j;
                            }
                            space = Math.max(0, (width - wrapX) / (wrapCount + 1));
                            margin = Math.max(0, (width - wrapX) % (wrapCount + 1) / 2);
                        }
                        int j = last;
                        while (j <= i5) {
                            if (this.justify) {
                                bounds[j].x += space * (j - last + 1) + margin;
                            }
                            if (this.fill) {
                                bounds[j].height = wraps[i5];
                            } else if (this.center) {
                                bounds[j].y += Math.max(0, (wraps[i5] - bounds[j].height) / 2);
                            }
                            ++j;
                        }
                        last = i5 + 1;
                    }
                    ++i5;
                }
            }
            int i6 = 0;
            while (i6 < count) {
                if (!wrapped) {
                    if (this.justify) {
                        bounds[i6].x += space * (i6 + 1) + margin;
                    }
                    if (this.fill) {
                        bounds[i6].height = maxHeight;
                    } else if (this.center) {
                        bounds[i6].y += Math.max(0, (maxHeight - bounds[i6].height) / 2);
                    }
                }
                children[i6].setBounds(bounds[i6]);
                ++i6;
            }
        }
        return new Point(maxX, y + maxHeight + this.marginBottom + this.marginHeight);
    }

    Point layoutVertical(Composite composite, boolean move2, boolean wrap, int height, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = 0;
        int i2 = 0;
        while (i2 < children.length) {
            Control control = children[i2];
            RowData data2 = (RowData)control.getLayoutData();
            if (data2 == null || !data2.exclude) {
                children[count++] = children[i2];
            }
            ++i2;
        }
        if (count == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        int childWidth = 0;
        int childHeight = 0;
        int maxWidth = 0;
        if (!this.pack) {
            int i3 = 0;
            while (i3 < count) {
                Control child = children[i3];
                Point size = this.computeSize(child, flushCache);
                if (height > -1 && height < size.y && wrap) {
                    size = child.computeSize(child.getLayoutData() == null ? -1 : ((RowData)child.getLayoutData()).width, height, flushCache);
                }
                childWidth = Math.max(childWidth, size.x);
                childHeight = Math.max(childHeight, size.y);
                ++i3;
            }
            maxWidth = childWidth;
        }
        int clientX = 0;
        int clientY = 0;
        if (move2) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        int[] wraps = null;
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move2 && (this.justify || this.fill || this.center)) {
            bounds = new Rectangle[count];
            wraps = new int[count];
        }
        int maxY = 0;
        int x = this.marginLeft + this.marginWidth;
        int y = this.marginTop + this.marginHeight;
        int i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            if (this.pack) {
                Point size = this.computeSize(child, flushCache);
                if (height > -1 && height < size.y && wrap) {
                    size = child.computeSize(child.getLayoutData() == null ? -1 : ((RowData)child.getLayoutData()).width, height, flushCache);
                }
                childWidth = size.x;
                childHeight = size.y;
            }
            if (wrap && i4 != 0 && y + childHeight > height) {
                wrapped = true;
                if (move2 && (this.justify || this.fill || this.center)) {
                    wraps[i4 - 1] = maxWidth;
                }
                x += this.spacing + maxWidth;
                y = this.marginTop + this.marginHeight;
                if (this.pack) {
                    maxWidth = 0;
                }
            }
            if (this.pack || this.fill || this.center) {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (move2) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify || this.fill || this.center) {
                    bounds[i4] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxY = Math.max(maxY, y += this.spacing + childHeight);
            ++i4;
        }
        maxY = Math.max(clientY + this.marginTop + this.marginHeight, maxY - this.spacing);
        if (!wrapped) {
            maxY += this.marginBottom + this.marginHeight;
        }
        if (move2 && (this.justify || this.fill || this.center)) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (height - maxY) / (count + 1));
                margin = Math.max(0, (height - maxY) % (count + 1) / 2);
            } else if (this.fill || this.justify || this.center) {
                int last = 0;
                if (count > 0) {
                    wraps[count - 1] = maxWidth;
                }
                int i5 = 0;
                while (i5 < count) {
                    if (wraps[i5] != 0) {
                        int wrapCount = i5 - last + 1;
                        if (this.justify) {
                            int wrapY = 0;
                            int j = last;
                            while (j <= i5) {
                                wrapY += bounds[j].height + this.spacing;
                                ++j;
                            }
                            space = Math.max(0, (height - wrapY) / (wrapCount + 1));
                            margin = Math.max(0, (height - wrapY) % (wrapCount + 1) / 2);
                        }
                        int j = last;
                        while (j <= i5) {
                            if (this.justify) {
                                bounds[j].y += space * (j - last + 1) + margin;
                            }
                            if (this.fill) {
                                bounds[j].width = wraps[i5];
                            } else if (this.center) {
                                bounds[j].x += Math.max(0, (wraps[i5] - bounds[j].width) / 2);
                            }
                            ++j;
                        }
                        last = i5 + 1;
                    }
                    ++i5;
                }
            }
            int i6 = 0;
            while (i6 < count) {
                if (!wrapped) {
                    if (this.justify) {
                        bounds[i6].y += space * (i6 + 1) + margin;
                    }
                    if (this.fill) {
                        bounds[i6].width = maxWidth;
                    } else if (this.center) {
                        bounds[i6].x += Math.max(0, (maxWidth - bounds[i6].width) / 2);
                    }
                }
                children[i6].setBounds(bounds[i6]);
                ++i6;
            }
        }
        return new Point(x + maxWidth + this.marginRight + this.marginWidth, maxY);
    }

    public String toString() {
        String string2 = String.valueOf(this.getName()) + " {";
        string2 = String.valueOf(string2) + "type=" + (this.type != 256 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string2 = String.valueOf(string2) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string2 = String.valueOf(string2) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string2 = String.valueOf(string2) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginTop != 0) {
            string2 = String.valueOf(string2) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginRight != 0) {
            string2 = String.valueOf(string2) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginBottom != 0) {
            string2 = String.valueOf(string2) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string2 = String.valueOf(string2) + "spacing=" + this.spacing + " ";
        }
        string2 = String.valueOf(string2) + "wrap=" + this.wrap + " ";
        string2 = String.valueOf(string2) + "pack=" + this.pack + " ";
        string2 = String.valueOf(string2) + "fill=" + this.fill + " ";
        string2 = String.valueOf(string2) + "justify=" + this.justify + " ";
        string2 = string2.trim();
        string2 = String.valueOf(string2) + "}";
        return string2;
    }
}

