/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.SwtRunnable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BusyIndicator {
    private static final AtomicInteger nextBusyId = new AtomicInteger();
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    public static void showWhile(Display display, Runnable runnable) {
        if (runnable == null) {
            SWT.error(4);
        }
        if (display == null && (display = Display.getCurrent()) == null) {
            runnable.run();
            return;
        }
        Integer n = BusyIndicator.setBusyCursor(display);
        try {
            runnable.run();
        }
        finally {
            BusyIndicator.clearBusyCursor(display, n);
        }
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> swtRunnable) {
        return BusyIndicator.execute(swtRunnable, ForkJoinPool.commonPool());
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> swtRunnable, Executor executor) {
        return BusyIndicator.compute(() -> {
            swtRunnable.run();
            return null;
        }, executor);
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> swtCallable) {
        return BusyIndicator.compute(swtCallable, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> swtCallable, Executor executor) {
        Objects.requireNonNull(swtCallable);
        Objects.requireNonNull(executor);
        if (executor instanceof Display) {
            throw new IllegalArgumentException("passing a Display as an executor is not allowed!");
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null) {
            try {
                V v = swtCallable.call();
                return CompletableFuture.completedFuture(v);
            }
            catch (Exception exception) {
                return CompletableFuture.failedFuture(exception);
            }
        }
        Integer n = BusyIndicator.setBusyCursor(display);
        CompletableFuture completableFuture = new CompletableFuture();
        executor.execute(() -> {
            try {
                if (completableFuture.isCancelled()) {
                    return;
                }
                Object v = swtCallable.call();
                completableFuture.complete(v);
            }
            catch (Exception exception) {
                completableFuture.completeExceptionally(exception);
            }
            finally {
                display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, n));
            }
        });
        return completableFuture;
    }

    private static void clearBusyCursor(Display display, Integer n) {
        Shell[] shellArray;
        for (Shell shell : shellArray = display.getShells()) {
            Integer n2 = (Integer)shell.getData(BUSYID_NAME);
            if (!Objects.equals(n2, n)) continue;
            BusyIndicator.setCursorAndId(shell, null, null);
        }
    }

    private static Integer setBusyCursor(Display display) {
        Shell[] shellArray;
        Integer n = nextBusyId.getAndIncrement();
        Cursor cursor = display.getSystemCursor(1);
        for (Shell shell : shellArray = display.getShells()) {
            Integer n2 = (Integer)shell.getData(BUSYID_NAME);
            if (n2 != null) continue;
            BusyIndicator.setCursorAndId(shell, cursor, n);
        }
        return n;
    }

    private static void setCursorAndId(Shell shell, Cursor cursor, Integer n) {
        if (!shell.isDisposed()) {
            shell.setCursor(cursor);
        }
        if (!shell.isDisposed()) {
            shell.setData(BUSYID_NAME, n);
        }
    }
}

