/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextWriterBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

class RTFWriter
extends StyledTextWriterBase {
    static final int DEFAULT_FOREGROUND = 0;
    static final int DEFAULT_BACKGROUND = 1;
    List<Color> colorTable = new ArrayList<Color>();
    List<Font> fontTable = new ArrayList<Font>();

    public RTFWriter(StyledText styledText, int n, int n2) {
        super(styledText, n, n2);
        this.colorTable.add(this.styledText.getForeground());
        this.colorTable.add(this.styledText.getBackground());
        this.fontTable.add(this.styledText.getFont());
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.writeHeader();
            this.write("\n}}\u0000");
            super.close();
        }
    }

    @Override
    void writeHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        FontData fontData = this.styledText.getFont().getFontData()[0];
        stringBuilder.append("{\\rtf1\\ansi");
        String string = System.getProperty("file.encoding").toLowerCase();
        if (string.startsWith("cp") || string.startsWith("ms")) {
            string = string.substring(2, string.length());
            stringBuilder.append("\\ansicpg");
            stringBuilder.append(string);
        }
        stringBuilder.append("\\uc1\\deff0{\\fonttbl{\\f0\\fnil ");
        stringBuilder.append(fontData.getName());
        stringBuilder.append(";");
        for (int i = 1; i < this.fontTable.size(); ++i) {
            stringBuilder.append("\\f");
            stringBuilder.append(i);
            stringBuilder.append(" ");
            FontData object = this.fontTable.get(i).getFontData()[0];
            stringBuilder.append(object.getName());
            stringBuilder.append(";");
        }
        stringBuilder.append("}}\n{\\colortbl");
        for (Color color : this.colorTable) {
            stringBuilder.append("\\red");
            stringBuilder.append(color.getRed());
            stringBuilder.append("\\green");
            stringBuilder.append(color.getGreen());
            stringBuilder.append("\\blue");
            stringBuilder.append(color.getBlue());
            stringBuilder.append(";");
        }
        stringBuilder.append("}\n{\\f0\\fs");
        stringBuilder.append(fontData.getHeight() * 2);
        stringBuilder.append(" ");
        this.write(stringBuilder.toString(), 0);
    }

    @Override
    public void writeLineDelimiter(String string) {
        if (this.isClosed()) {
            SWT.error(39);
        }
        this.write(string);
        this.write("\\par ");
    }

    @Override
    String writeLineStart(Color color, int n, int n2, int n3, boolean bl) {
        this.write("\\fi");
        this.write(n);
        switch (n3) {
            case 16384: {
                this.write("\\ql");
                break;
            }
            case 0x1000000: {
                this.write("\\qc");
                break;
            }
            case 131072: {
                this.write("\\qr");
            }
        }
        if (bl) {
            this.write("\\qj");
        }
        this.write(" ");
        if (color != null) {
            this.write("{\\chshdng0\\chcbpat");
            this.write(this.getColorIndex(color, 1));
            this.write(" ");
        }
        return color == null ? "" : "}";
    }

    @Override
    void writeEmptyLine() {
    }

    @Override
    String writeSpanStart(StyleRange styleRange) {
        this.write("{\\cf");
        this.write(this.getColorIndex(styleRange.foreground, 0));
        int n = this.getColorIndex(styleRange.background, 1);
        if (n != 1) {
            this.write("\\chshdng0\\chcbpat");
            this.write(n);
        }
        int n2 = styleRange.fontStyle;
        Font font = styleRange.font;
        if (font != null) {
            int n3 = this.getFontIndex(font);
            this.write("\\f");
            this.write(n3);
            FontData fontData = font.getFontData()[0];
            this.write("\\fs");
            this.write(fontData.getHeight() * 2);
            n2 = fontData.getStyle();
        }
        if ((n2 & 1) != 0) {
            this.write("\\b");
        }
        if ((n2 & 2) != 0) {
            this.write("\\i");
        }
        if (styleRange.underline) {
            this.write("\\ul");
        }
        if (styleRange.strikeout) {
            this.write("\\strike");
        }
        this.write(" ");
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 1) != 0) {
            stringBuilder.append("\\b0");
        }
        if ((styleRange.fontStyle & 2) != 0) {
            stringBuilder.append("\\i0");
        }
        if (styleRange.underline) {
            stringBuilder.append("\\ul0");
        }
        if (styleRange.strikeout) {
            stringBuilder.append("\\strike0");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    String escapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        string.chars().forEach(n -> {
            if (n > 127) {
                stringBuilder.append("\\u");
                stringBuilder.append(Integer.toString((short)n));
                stringBuilder.append('?');
            } else if (n == 125 || n == 123 || n == 92) {
                stringBuilder.append('\\');
                stringBuilder.append((char)n);
            } else {
                stringBuilder.append((char)n);
            }
        });
        return stringBuilder.toString();
    }

    private int getColorIndex(Color color, int n) {
        if (color == null) {
            return n;
        }
        int n2 = this.colorTable.indexOf(color);
        if (n2 == -1) {
            n2 = this.colorTable.size();
            this.colorTable.add(color);
        }
        return n2;
    }

    private int getFontIndex(Font font) {
        int n = this.fontTable.indexOf(font);
        if (n == -1) {
            n = this.fontTable.size();
            this.fontTable.add(font);
        }
        return n;
    }
}

