/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Table;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    int scrollIndex;
    long scrollBeginTime;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    @Override
    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    @Override
    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        long l = table.handle;
        GTK.gtk_tree_view_set_drag_dest_row(l, 0L, 0);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    @Override
    public void dragOver(DropTargetEvent dropTargetEvent) {
        long l;
        Table table = (Table)this.control;
        long l2 = table.handle;
        int n = this.checkEffect(dropTargetEvent.feedback);
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = DPIUtil.autoScaleUp(table.toControl(point));
        long[] lArray = new long[1];
        GTK.gtk_tree_view_get_path_at_pos(l2, point.x, point.y, lArray, null, null, null);
        int n2 = -1;
        if (lArray[0] != 0L && (l = GTK.gtk_tree_path_get_indices(lArray[0])) != 0L) {
            int[] nArray = new int[1];
            C.memmove(nArray, l, 4L);
            n2 = nArray[0];
        }
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n2 != -1 && this.scrollIndex == n2 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                if (point.y < DPIUtil.autoScaleUp(table.getItemHeight())) {
                    GTK.gtk_tree_path_prev(lArray[0]);
                } else {
                    GTK.gtk_tree_path_next(lArray[0]);
                }
                if (lArray[0] != 0L) {
                    GTK.gtk_tree_view_scroll_to_cell(l2, lArray[0], 0L, false, 0.0f, 0.0f);
                    GTK.gtk_tree_path_free(lArray[0]);
                    lArray[0] = 0L;
                    GTK.gtk_tree_view_get_path_at_pos(l2, point.x, point.y, lArray, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = n2;
        }
        if (lArray[0] != 0L) {
            int n3 = -1;
            if ((n & 1) != 0) {
                n3 = 2;
            }
            if ((n & 2) != 0) {
                n3 = 0;
            }
            if ((n & 4) != 0) {
                n3 = 1;
            }
            if (n3 != -1) {
                GTK.gtk_tree_view_set_drag_dest_row(l2, lArray[0], n3);
            } else {
                GTK.gtk_tree_view_set_drag_dest_row(l2, 0L, 0);
            }
        } else {
            GTK.gtk_tree_view_set_drag_dest_row(l2, 0L, 0);
        }
        if (lArray[0] != 0L) {
            GTK.gtk_tree_path_free(lArray[0]);
        }
    }
}

