/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.DPIUtil;

public final class ImageData
implements Cloneable {
    public int width;
    public int height;
    public int depth;
    public int scanlinePad;
    public int bytesPerLine;
    public byte[] data;
    public PaletteData palette;
    public int transparentPixel;
    public byte[] maskData;
    public int maskPad;
    public byte[] alphaData;
    public int alpha;
    public int type;
    public int x;
    public int y;
    public int disposalMethod;
    public int delayTime;
    static final byte[][] ANY_TO_EIGHT = new byte[9][];
    static final int[][] DITHER_MATRIX;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_16_LSB = 11;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;

    public ImageData(int n, int n2, int n3, PaletteData paletteData) {
        this(n, n2, n3, paletteData, 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray) {
        this(n, n2, n3, paletteData, n4, ImageData.checkData(byArray), 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(InputStream inputStream) {
        ImageData[] imageDataArray = ImageDataLoader.load(inputStream);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    public ImageData(String string) {
        ImageData[] imageDataArray = ImageDataLoader.load(string);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    ImageData() {
    }

    ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13;
        if (paletteData == null) {
            SWT.error(4);
        }
        if (n3 != 1 && n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
            SWT.error(5);
        }
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            SWT.error(7);
        }
        int n14 = ((n * n3 + 7) / 8 + (n4 - 1)) / n4 * n4;
        int n15 = n13 = n8 == 5 ? ((n + 7) / 8 + 3) / 4 * 4 : n14;
        if (byArray != null && byArray.length < n13 * n2) {
            SWT.error(5);
        }
        this.setAllFields(n, n2, n3, n4, n14, byArray != null ? byArray : new byte[n14 * n2], paletteData, n7, byArray2, n5, byArray3, n6, n8, n9, n10, n11, n12);
    }

    void setAllFields(int n, int n2, int n3, int n4, int n5, byte[] byArray, PaletteData paletteData, int n6, byte[] byArray2, int n7, byte[] byArray3, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.scanlinePad = n4;
        this.bytesPerLine = n5;
        this.data = byArray;
        this.palette = paletteData;
        this.transparentPixel = n6;
        this.maskData = byArray2;
        this.maskPad = n7;
        this.alphaData = byArray3;
        this.alpha = n8;
        this.type = n9;
        this.x = n10;
        this.y = n11;
        this.disposalMethod = n12;
        this.delayTime = n13;
    }

    public static ImageData internal_new(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        return new ImageData(n, n2, n3, paletteData, n4, byArray, n5, byArray2, byArray3, n6, n7, n8, n9, n10, n11, n12);
    }

    ImageData colorMaskImage(int n) {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int[] nArray = new int[this.width];
        for (int i = 0; i < this.height; ++i) {
            this.getPixels(0, i, this.width, nArray, 0);
            for (int j = 0; j < this.width; ++j) {
                nArray[j] = n != -1 && nArray[j] == n ? 0 : 1;
            }
            imageData.setPixels(0, i, this.width, nArray, 0);
        }
        return imageData;
    }

    static byte[] checkData(byte[] byArray) {
        if (byArray == null) {
            SWT.error(4);
        }
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byte[] byArray2 = null;
        if (this.maskData != null) {
            byArray2 = new byte[this.maskData.length];
            System.arraycopy(this.maskData, 0, byArray2, 0, this.maskData.length);
        }
        byte[] byArray3 = null;
        if (this.alphaData != null) {
            byArray3 = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, byArray3, 0, this.alphaData.length);
        }
        return new ImageData(this.width, this.height, this.depth, this.palette, this.scanlinePad, byArray, this.maskPad, byArray2, byArray3, this.alpha, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
    }

    public int getAlpha(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            return 255;
        }
        return this.alphaData[n2 * this.width + n] & 0xFF;
    }

    public void getAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            int n5 = n4 + n3;
            for (int i = n4; i < n5; ++i) {
                byArray[i] = -1;
            }
            return;
        }
        System.arraycopy(this.alphaData, n2 * this.width + n, byArray, n4, n3);
    }

    public int getPixel(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n3 = n2 * this.bytesPerLine + n * 4;
                return ((this.data[n3] & 0xFF) << 24) + ((this.data[n3 + 1] & 0xFF) << 16) + ((this.data[n3 + 2] & 0xFF) << 8) + (this.data[n3 + 3] & 0xFF);
            }
            case 24: {
                int n4 = n2 * this.bytesPerLine + n * 3;
                return ((this.data[n4] & 0xFF) << 16) + ((this.data[n4 + 1] & 0xFF) << 8) + (this.data[n4 + 2] & 0xFF);
            }
            case 16: {
                int n5 = n2 * this.bytesPerLine + n * 2;
                return ((this.data[n5 + 1] & 0xFF) << 8) + (this.data[n5] & 0xFF);
            }
            case 8: {
                int n6 = n2 * this.bytesPerLine + n;
                return this.data[n6] & 0xFF;
            }
            case 4: {
                int n7 = n2 * this.bytesPerLine + (n >> 1);
                int n8 = this.data[n7] & 0xFF;
                if ((n & 1) == 0) {
                    return n8 >> 4;
                }
                return n8 & 0xF;
            }
            case 2: {
                int n9 = n2 * this.bytesPerLine + (n >> 2);
                int n10 = this.data[n9] & 0xFF;
                int n11 = 3 - n % 4;
                int n12 = 3 << n11 * 2;
                return (n10 & n12) >> n11 * 2;
            }
            case 1: {
                int n13 = n2 * this.bytesPerLine + (n >> 3);
                int n14 = this.data[n13] & 0xFF;
                int n15 = 1 << 7 - (n & 7);
                if ((n14 & n15) == 0) {
                    return 0;
                }
                return 1;
            }
        }
        SWT.error(38);
        return 0;
    }

    public void getPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = 0;
        int n6 = n3;
        int n7 = n4;
        int n8 = n;
        int n9 = n2;
        switch (this.depth) {
            case 8: {
                int n10 = n2 * this.bytesPerLine + n;
                for (int i = 0; i < n3; ++i) {
                    byArray[n7] = this.data[n10];
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n10;
                }
                return;
            }
            case 4: {
                int n11;
                int n12 = n2 * this.bytesPerLine + (n >> 1);
                if ((n & 1) == 1) {
                    n11 = this.data[n12] & 0xFF;
                    byArray[n7] = (byte)(n11 & 0xF);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n12;
                    }
                }
                while (n6 > 1) {
                    n11 = this.data[n12] & 0xFF;
                    byArray[n7] = (byte)(n11 >> 4);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    byArray[n7] = (byte)(n11 & 0xF);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n12;
                }
                if (n6 > 0) {
                    n11 = this.data[n12] & 0xFF;
                    byArray[n7] = (byte)(n11 >> 4);
                }
                return;
            }
            case 2: {
                int n13 = n2 * this.bytesPerLine + (n >> 2);
                int n14 = this.data[n13] & 0xFF;
                while (n6 > 0) {
                    int n15 = 3 - n8 % 4;
                    n5 = 3 << n15 * 2;
                    byArray[n7] = (byte)((n14 & n5) >> n15 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n14 = this.data[n13] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n15 != 0) continue;
                    n14 = this.data[++n13] & 0xFF;
                }
                return;
            }
            case 1: {
                int n16 = n2 * this.bytesPerLine + (n >> 3);
                int n17 = this.data[n16] & 0xFF;
                while (n6 > 0) {
                    n5 = 1 << 7 - (n8 & 7);
                    byArray[n7] = (n17 & n5) == 0 ? (byte)0 : 1;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n16 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n17 = this.data[n16] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n5 != 1) continue;
                    ++n16;
                    if (n6 <= 0) continue;
                    n17 = this.data[n16] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void getPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        switch (this.depth) {
            case 32: {
                int n9 = n2 * this.bytesPerLine + n * 4;
                n6 = n4;
                for (int i = 0; i < n3; ++i) {
                    nArray[n6] = (this.data[n9] & 0xFF) << 24 | (this.data[n9 + 1] & 0xFF) << 16 | (this.data[n9 + 2] & 0xFF) << 8 | this.data[n9 + 3] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n9 += 4;
                }
                return;
            }
            case 24: {
                int n10 = n2 * this.bytesPerLine + n * 3;
                for (int i = 0; i < n3; ++i) {
                    nArray[n6] = (this.data[n10] & 0xFF) << 16 | (this.data[n10 + 1] & 0xFF) << 8 | this.data[n10 + 2] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n10 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n10 += 3;
                }
                return;
            }
            case 16: {
                int n11 = n2 * this.bytesPerLine + n * 2;
                for (int i = 0; i < n3; ++i) {
                    nArray[n6] = ((this.data[n11 + 1] & 0xFF) << 8) + (this.data[n11] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n11 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n11 += 2;
                }
                return;
            }
            case 8: {
                int n12 = n2 * this.bytesPerLine + n;
                for (int i = 0; i < n3; ++i) {
                    nArray[n6] = this.data[n12] & 0xFF;
                    ++n6;
                    if (++n7 >= this.width) {
                        n12 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    ++n12;
                }
                return;
            }
            case 4: {
                int n13;
                int n14 = n2 * this.bytesPerLine + (n >> 1);
                if ((n & 1) == 1) {
                    n13 = this.data[n14] & 0xFF;
                    nArray[n6] = n13 & 0xF;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n14 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                    } else {
                        ++n14;
                    }
                }
                while (n5 > 1) {
                    n13 = this.data[n14] & 0xFF;
                    nArray[n6] = n13 >> 4;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n14 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    nArray[n6] = n13 & 0xF;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n14 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    ++n14;
                }
                if (n5 > 0) {
                    n13 = this.data[n14] & 0xFF;
                    nArray[n6] = n13 >> 4;
                }
                return;
            }
            case 2: {
                int n15 = n2 * this.bytesPerLine + (n >> 2);
                int n16 = this.data[n15] & 0xFF;
                while (n5 > 0) {
                    int n17 = 3 - n7 % 4;
                    int n18 = 3 << n17 * 2;
                    nArray[n6] = (byte)((n16 & n18) >> n17 * 2);
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n15 = ++n8 * this.bytesPerLine;
                        if (n5 > 0) {
                            n16 = this.data[n15] & 0xFF;
                        }
                        n7 = 0;
                        continue;
                    }
                    if (n17 != 0) continue;
                    n16 = this.data[++n15] & 0xFF;
                }
                return;
            }
            case 1: {
                int n19 = n2 * this.bytesPerLine + (n >> 3);
                int n20 = this.data[n19] & 0xFF;
                while (n5 > 0) {
                    int n21 = 1 << 7 - (n7 & 7);
                    nArray[n6] = (n20 & n21) == 0 ? 0 : 1;
                    ++n6;
                    --n5;
                    if (++n7 >= this.width) {
                        n19 = ++n8 * this.bytesPerLine;
                        if (n5 > 0) {
                            n20 = this.data[n19] & 0xFF;
                        }
                        n7 = 0;
                        continue;
                    }
                    if (n21 != 1) continue;
                    ++n19;
                    if (n5 <= 0) continue;
                    n20 = this.data[n19] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public RGB[] getRGBs() {
        return this.palette.getRGBs();
    }

    public ImageData getTransparencyMask() {
        int n = this.getTransparencyType();
        switch (n) {
            case 1: {
                return this.getTransparencyMaskFromAlphaData();
            }
            case 2: {
                return new ImageData(this.width, this.height, 1, ImageData.bwPalette(), this.maskPad, this.maskData);
            }
            case 4: {
                return this.colorMaskImage(this.transparentPixel);
            }
        }
        return this.colorMaskImage(this.transparentPixel);
    }

    ImageData getTransparencyMaskFromAlphaData() {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                byte by;
                if ((by = this.alphaData[n++]) == 0) {
                    imageData.setPixel(j, i, 0);
                    continue;
                }
                imageData.setPixel(j, i, 1);
            }
        }
        return imageData;
    }

    public int getTransparencyType() {
        if (this.maskData != null) {
            return 2;
        }
        if (this.transparentPixel != -1) {
            return 4;
        }
        if (this.alphaData != null) {
            return 1;
        }
        return 0;
    }

    int getByteOrder() {
        return this.depth != 16 ? 1 : 0;
    }

    public ImageData scaledTo(int n, int n2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        boolean bl4 = bl = n2 < 0;
        if (bl) {
            n2 = -n2;
        }
        ImageData imageData = new ImageData(n, n2, this.depth, this.palette, this.scanlinePad, null, 0, null, null, -1, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
        if (this.palette.isDirect) {
            ImageData.blit(this.data, this.depth, this.bytesPerLine, this.getByteOrder(), this.width, this.height, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), imageData.width, imageData.height, 0, 0, 0, bl2, bl);
        } else {
            ImageData.blit(this.data, this.depth, this.bytesPerLine, this.getByteOrder(), this.width, this.height, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), imageData.width, imageData.height, bl2, bl);
        }
        if (this.maskData != null) {
            imageData.maskPad = this.maskPad;
            int n3 = (imageData.width + 7) / 8;
            n3 = (n3 + (imageData.maskPad - 1)) / imageData.maskPad * imageData.maskPad;
            imageData.maskData = new byte[n3 * imageData.height];
            int n4 = (this.width + 7) / 8;
            n4 = (n4 + (this.maskPad - 1)) / this.maskPad * this.maskPad;
            ImageData.blit(this.maskData, 1, n4, 1, this.width, this.height, imageData.maskData, 1, n3, 1, imageData.width, imageData.height, bl2, bl);
        } else if (this.alpha != -1) {
            imageData.alpha = this.alpha;
        } else if (this.alphaData != null) {
            imageData.alphaData = new byte[imageData.width * imageData.height];
            ImageData.blit(this.alphaData, 8, this.width, 1, this.width, this.height, imageData.alphaData, 8, imageData.width, 1, imageData.width, imageData.height, bl2, bl);
        }
        return imageData;
    }

    public void setAlpha(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0 || n3 < 0 || n3 > 255) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        this.alphaData[n2 * this.width + n] = (byte)n3;
    }

    public void setAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        System.arraycopy(byArray, n4, this.alphaData, n2 * this.width + n, n3);
    }

    public void setPixel(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n4 = n2 * this.bytesPerLine + n * 4;
                this.data[n4] = (byte)(n3 >> 24 & 0xFF);
                this.data[n4 + 1] = (byte)(n3 >> 16 & 0xFF);
                this.data[n4 + 2] = (byte)(n3 >> 8 & 0xFF);
                this.data[n4 + 3] = (byte)(n3 & 0xFF);
                return;
            }
            case 24: {
                int n5 = n2 * this.bytesPerLine + n * 3;
                this.data[n5] = (byte)(n3 >> 16 & 0xFF);
                this.data[n5 + 1] = (byte)(n3 >> 8 & 0xFF);
                this.data[n5 + 2] = (byte)(n3 & 0xFF);
                return;
            }
            case 16: {
                int n6 = n2 * this.bytesPerLine + n * 2;
                this.data[n6 + 1] = (byte)(n3 >> 8 & 0xFF);
                this.data[n6] = (byte)(n3 & 0xFF);
                return;
            }
            case 8: {
                int n7 = n2 * this.bytesPerLine + n;
                this.data[n7] = (byte)(n3 & 0xFF);
                return;
            }
            case 4: {
                int n8 = n2 * this.bytesPerLine + (n >> 1);
                this.data[n8] = (n & 1) == 0 ? (byte)(this.data[n8] & 0xF | (n3 & 0xF) << 4) : (byte)(this.data[n8] & 0xF0 | n3 & 0xF);
                return;
            }
            case 2: {
                int n9 = n2 * this.bytesPerLine + (n >> 2);
                byte by = this.data[n9];
                int n10 = 3 - n % 4;
                int n11 = 0xFF ^ 3 << n10 * 2;
                this.data[n9] = (byte)(this.data[n9] & n11 | n3 << n10 * 2);
                return;
            }
            case 1: {
                int n12 = n2 * this.bytesPerLine + (n >> 3);
                byte by = this.data[n12];
                int n13 = 1 << 7 - (n & 7);
                this.data[n12] = (n3 & 1) == 1 ? (byte)(by | n13) : (byte)(by & ~n13);
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n4;
        int n6 = n;
        int n7 = n2;
        switch (this.depth) {
            case 8: {
                int n8 = n2 * this.bytesPerLine + n;
                for (int i = 0; i < n3; ++i) {
                    this.data[n8] = (byte)(byArray[n5] & 0xFF);
                    ++n5;
                    if (++n6 >= this.width) {
                        n8 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    ++n8;
                }
                return;
            }
            case 4: {
                int n9;
                boolean bl;
                int n10 = n2 * this.bytesPerLine + (n >> 1);
                boolean bl2 = bl = (n & 1) == 0;
                while (n9 > 0) {
                    int n11 = byArray[n5] & 0xF;
                    this.data[n10] = bl ? (byte)(this.data[n10] & 0xF | n11 << 4) : (byte)(this.data[n10] & 0xF0 | n11);
                    ++n5;
                    --n9;
                    if (++n6 >= this.width) {
                        n10 = ++n7 * this.bytesPerLine;
                        bl = true;
                        n6 = 0;
                        continue;
                    }
                    if (!bl) {
                        ++n10;
                    }
                    bl = !bl;
                }
                return;
            }
            case 2: {
                int n9;
                byte[] byArray2 = new byte[]{-4, -13, -49, 63};
                int n12 = n2 * this.bytesPerLine + (n >> 2);
                int n13 = 3 - n % 4;
                for (n9 = n3; n9 > 0; --n9) {
                    int n14 = byArray[n5] & 3;
                    this.data[n12] = (byte)(this.data[n12] & byArray2[n13] | n14 << n13 * 2);
                    ++n5;
                    if (++n6 >= this.width) {
                        n12 = ++n7 * this.bytesPerLine;
                        n13 = 0;
                        n6 = 0;
                        continue;
                    }
                    if (n13 == 0) {
                        ++n12;
                        n13 = 3;
                        continue;
                    }
                    --n13;
                }
                return;
            }
            case 1: {
                int n9;
                int n15 = n2 * this.bytesPerLine + (n >> 3);
                while (n9 > 0) {
                    int n16 = 1 << 7 - (n6 & 7);
                    this.data[n15] = (byArray[n5] & 1) == 1 ? (byte)(this.data[n15] & 0xFF | n16) : (byte)(this.data[n15] & 0xFF & ~n16);
                    ++n5;
                    --n9;
                    if (++n6 >= this.width) {
                        n15 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    if (n16 != 1) continue;
                    ++n15;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n4;
        int n6 = n;
        int n7 = n2;
        switch (this.depth) {
            case 32: {
                int n8 = n2 * this.bytesPerLine + n * 4;
                for (int i = 0; i < n3; ++i) {
                    int n9 = nArray[n5];
                    this.data[n8] = (byte)(n9 >> 24 & 0xFF);
                    this.data[n8 + 1] = (byte)(n9 >> 16 & 0xFF);
                    this.data[n8 + 2] = (byte)(n9 >> 8 & 0xFF);
                    this.data[n8 + 3] = (byte)(n9 & 0xFF);
                    ++n5;
                    if (++n6 >= this.width) {
                        n8 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    n8 += 4;
                }
                return;
            }
            case 24: {
                int n10 = n2 * this.bytesPerLine + n * 3;
                for (int i = 0; i < n3; ++i) {
                    int n11 = nArray[n5];
                    this.data[n10] = (byte)(n11 >> 16 & 0xFF);
                    this.data[n10 + 1] = (byte)(n11 >> 8 & 0xFF);
                    this.data[n10 + 2] = (byte)(n11 & 0xFF);
                    ++n5;
                    if (++n6 >= this.width) {
                        n10 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    n10 += 3;
                }
                return;
            }
            case 16: {
                int n12 = n2 * this.bytesPerLine + n * 2;
                for (int i = 0; i < n3; ++i) {
                    int n13 = nArray[n5];
                    this.data[n12] = (byte)(n13 & 0xFF);
                    this.data[n12 + 1] = (byte)(n13 >> 8 & 0xFF);
                    ++n5;
                    if (++n6 >= this.width) {
                        n12 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    n12 += 2;
                }
                return;
            }
            case 8: {
                int n14 = n2 * this.bytesPerLine + n;
                for (int i = 0; i < n3; ++i) {
                    this.data[n14] = (byte)(nArray[n5] & 0xFF);
                    ++n5;
                    if (++n6 >= this.width) {
                        n14 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    ++n14;
                }
                return;
            }
            case 4: {
                int n15;
                boolean bl;
                int n16 = n2 * this.bytesPerLine + (n >> 1);
                boolean bl2 = bl = (n & 1) == 0;
                while (n15 > 0) {
                    int n17 = nArray[n5] & 0xF;
                    this.data[n16] = bl ? (byte)(this.data[n16] & 0xF | n17 << 4) : (byte)(this.data[n16] & 0xF0 | n17);
                    ++n5;
                    --n15;
                    if (++n6 >= this.width) {
                        n16 = ++n7 * this.bytesPerLine;
                        bl = true;
                        n6 = 0;
                        continue;
                    }
                    if (!bl) {
                        ++n16;
                    }
                    bl = !bl;
                }
                return;
            }
            case 2: {
                int n15;
                byte[] byArray = new byte[]{-4, -13, -49, 63};
                int n18 = n2 * this.bytesPerLine + (n >> 2);
                int n19 = 3 - n % 4;
                for (n15 = n3; n15 > 0; --n15) {
                    int n20 = nArray[n5] & 3;
                    this.data[n18] = (byte)(this.data[n18] & byArray[n19] | n20 << n19 * 2);
                    ++n5;
                    if (++n6 >= this.width) {
                        n18 = ++n7 * this.bytesPerLine;
                        n19 = 3;
                        n6 = 0;
                        continue;
                    }
                    if (n19 == 0) {
                        ++n18;
                        n19 = 3;
                        continue;
                    }
                    --n19;
                }
                return;
            }
            case 1: {
                int n15;
                int n21 = n2 * this.bytesPerLine + (n >> 3);
                while (n15 > 0) {
                    int n22 = 1 << 7 - (n6 & 7);
                    this.data[n21] = (nArray[n5] & 1) == 1 ? (byte)(this.data[n21] & 0xFF | n22) : (byte)(this.data[n21] & 0xFF & ~n22);
                    ++n5;
                    --n15;
                    if (++n6 >= this.width) {
                        n21 = ++n7 * this.bytesPerLine;
                        n6 = 0;
                        continue;
                    }
                    if (n22 != 1) continue;
                    ++n21;
                }
                return;
            }
        }
        SWT.error(38);
    }

    static PaletteData bwPalette() {
        return new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
    }

    static ImageData convertMask(ImageData imageData) {
        int n;
        if (imageData.depth == 1) {
            return imageData;
        }
        PaletteData paletteData = new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
        RGB[] rGBArray = imageData.getRGBs();
        if (rGBArray != null) {
            for (n = 0; n < rGBArray.length && !rGBArray[n].equals(paletteData.colors[0]); ++n) {
            }
        }
        int[] nArray = new int[imageData.width];
        for (int i = 0; i < imageData.height; ++i) {
            imageData.getPixels(0, i, imageData.width, nArray, 0);
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = nArray[j] == n ? 0 : 1;
            }
            imageData2.setPixels(0, i, imageData.width, nArray, 0);
        }
        return imageData2;
    }

    static byte[] convertPad(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return byArray;
        }
        int n6 = (n * n3 + 7) / 8;
        int n7 = (n6 + (n4 - 1)) / n4 * n4;
        int n8 = (n6 + (n5 - 1)) / n5 * n5;
        byte[] byArray2 = new byte[n2 * n8];
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(byArray, n9, byArray2, n10, n6);
            n9 += n7;
            n10 += n8;
        }
        return byArray2;
    }

    static void blit(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray2, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, boolean bl, boolean bl2) {
        int n17;
        int n18;
        int n19;
        int n20;
        if (n12 <= 0 || n13 <= 0) {
            return;
        }
        int n21 = n12 - 1;
        int n22 = n21 != 0 ? (int)((((long)n4 << 16) - 1L) / (long)n21) : 0;
        int n23 = n13 - 1;
        int n24 = n23 != 0 ? (int)((((long)n5 << 16) - 1L) / (long)n23) : 0;
        switch (n) {
            case 8: {
                n20 = 1;
                n19 = 0;
                break;
            }
            case 16: {
                n20 = 2;
                n19 = n3 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n20 = 3;
                n19 = 3;
                break;
            }
            case 32: {
                n20 = 4;
                n19 = n3 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n25 = 0;
        switch (n9) {
            case 8: {
                n18 = 1;
                n17 = 0;
                break;
            }
            case 16: {
                n18 = 2;
                n17 = n11 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n18 = 3;
                n17 = 3;
                break;
            }
            case 32: {
                n18 = 4;
                n17 = n11 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n26 = (bl2 ? n23 : 0) * n10 + (bl ? n21 : 0) * n18;
        int n27 = bl ? -n18 : n18;
        int n28 = bl2 ? -n10 : n10;
        int n29 = n26;
        int n30 = n25;
        if (n19 == n17 && n6 == n14 && n7 == n15 && n8 == n16) {
            switch (n20) {
                case 1: {
                    int n31 = n24;
                    for (int i = n13; i > 0; --i) {
                        int n32 = n12;
                        int n33 = n22;
                        while (n32 > 0) {
                            byArray2[n29] = byArray[n30];
                            n30 += n33 >>> 16;
                            --n32;
                            n29 += n27;
                            n33 = (n33 & 0xFFFF) + n22;
                        }
                        n30 = n25 += (n31 >>> 16) * n2;
                        n31 = (n31 & 0xFFFF) + n24;
                        n29 = n26 += n28;
                    }
                    break;
                }
                case 2: {
                    int n34 = n24;
                    for (int i = n13; i > 0; --i) {
                        int n35 = n12;
                        int n36 = n22;
                        while (n35 > 0) {
                            byArray2[n29] = byArray[n30];
                            byArray2[n29 + 1] = byArray[n30 + 1];
                            n30 += (n36 >>> 16) * 2;
                            --n35;
                            n29 += n27;
                            n36 = (n36 & 0xFFFF) + n22;
                        }
                        n30 = n25 += (n34 >>> 16) * n2;
                        n34 = (n34 & 0xFFFF) + n24;
                        n29 = n26 += n28;
                    }
                    break;
                }
                case 3: {
                    int n37 = n24;
                    for (int i = n13; i > 0; --i) {
                        int n38 = n12;
                        int n39 = n22;
                        while (n38 > 0) {
                            byArray2[n29] = byArray[n30];
                            byArray2[n29 + 1] = byArray[n30 + 1];
                            byArray2[n29 + 2] = byArray[n30 + 2];
                            n30 += (n39 >>> 16) * 3;
                            --n38;
                            n29 += n27;
                            n39 = (n39 & 0xFFFF) + n22;
                        }
                        n30 = n25 += (n37 >>> 16) * n2;
                        n37 = (n37 & 0xFFFF) + n24;
                        n29 = n26 += n28;
                    }
                    break;
                }
                case 4: {
                    int n40 = n24;
                    for (int i = n13; i > 0; --i) {
                        int n41 = n12;
                        int n42 = n22;
                        while (n41 > 0) {
                            byArray2[n29] = byArray[n30];
                            byArray2[n29 + 1] = byArray[n30 + 1];
                            byArray2[n29 + 2] = byArray[n30 + 2];
                            byArray2[n29 + 3] = byArray[n30 + 3];
                            n30 += (n42 >>> 16) * 4;
                            --n41;
                            n29 += n27;
                            n42 = (n42 & 0xFFFF) + n22;
                        }
                        n30 = n25 += (n40 >>> 16) * n2;
                        n40 = (n40 & 0xFFFF) + n24;
                        n29 = n26 += n28;
                    }
                    break;
                }
            }
            return;
        }
        if (n19 == 4 && n17 == 4 && n6 == 65280 && n7 == 0xFF0000 && n8 == -16777216 && n14 == 0xFF0000 && n15 == 65280 && n16 == 255) {
            int n43 = n24;
            for (int i = n13; i > 0; --i) {
                int n44 = n12;
                int n45 = n22;
                while (n44 > 0) {
                    byArray2[n29] = byArray[n30 + 3];
                    byArray2[n29 + 1] = byArray[n30 + 2];
                    byArray2[n29 + 2] = byArray[n30 + 1];
                    byArray2[n29 + 3] = byArray[n30];
                    n30 += (n45 >>> 16) * 4;
                    --n44;
                    n29 += n27;
                    n45 = (n45 & 0xFFFF) + n22;
                }
                n30 = n25 += (n43 >>> 16) * n2;
                n43 = (n43 & 0xFFFF) + n24;
                n29 = n26 += n28;
            }
            return;
        }
        if (n19 == 3 && n17 == 4 && n6 == 255 && n7 == 65280 && n8 == 0xFF0000 && n14 == 0xFF0000 && n15 == 65280 && n16 == 255) {
            int n46 = n24;
            for (int i = n13; i > 0; --i) {
                int n47 = n12;
                int n48 = n22;
                while (n47 > 0) {
                    byArray2[n29] = 0;
                    byArray2[n29 + 1] = byArray[n30 + 2];
                    byArray2[n29 + 2] = byArray[n30 + 1];
                    byArray2[n29 + 3] = byArray[n30];
                    n30 += (n48 >>> 16) * 3;
                    --n47;
                    n29 += n27;
                    n48 = (n48 & 0xFFFF) + n22;
                }
                n30 = n25 += (n46 >>> 16) * n2;
                n46 = (n46 & 0xFFFF) + n24;
                n29 = n26 += n28;
            }
            return;
        }
        int n49 = ImageData.getChannelShift(n6);
        byte[] byArray3 = ANY_TO_EIGHT[ImageData.getChannelWidth(n6, n49)];
        int n50 = ImageData.getChannelShift(n7);
        byte[] byArray4 = ANY_TO_EIGHT[ImageData.getChannelWidth(n7, n50)];
        int n51 = ImageData.getChannelShift(n8);
        byte[] byArray5 = ANY_TO_EIGHT[ImageData.getChannelWidth(n8, n51)];
        int n52 = ImageData.getChannelShift(n14);
        int n53 = ImageData.getChannelWidth(n14, n52);
        int n54 = 8 - n53;
        int n55 = ImageData.getChannelShift(n15);
        int n56 = ImageData.getChannelWidth(n15, n55);
        int n57 = 8 - n56;
        int n58 = ImageData.getChannelShift(n16);
        int n59 = ImageData.getChannelWidth(n16, n58);
        int n60 = 8 - n59;
        int n61 = 0;
        int n62 = 0;
        int n63 = 0;
        int n64 = n24;
        for (int i = n13; i > 0; --i) {
            int n65 = n12;
            int n66 = n22;
            while (n65 > 0) {
                int n67;
                switch (n19) {
                    case 0: {
                        n67 = byArray[n30] & 0xFF;
                        n30 += n66 >>> 16;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                        break;
                    }
                    case 1: {
                        n67 = (byArray[n30] & 0xFF) << 8 | byArray[n30 + 1] & 0xFF;
                        n30 += (n66 >>> 16) * 2;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                        break;
                    }
                    case 2: {
                        n67 = (byArray[n30 + 1] & 0xFF) << 8 | byArray[n30] & 0xFF;
                        n30 += (n66 >>> 16) * 2;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                        break;
                    }
                    case 3: {
                        n67 = ((byArray[n30] & 0xFF) << 8 | byArray[n30 + 1] & 0xFF) << 8 | byArray[n30 + 2] & 0xFF;
                        n30 += (n66 >>> 16) * 3;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                        break;
                    }
                    case 4: {
                        n67 = (((byArray[n30] & 0xFF) << 8 | byArray[n30 + 1] & 0xFF) << 8 | byArray[n30 + 2] & 0xFF) << 8 | byArray[n30 + 3] & 0xFF;
                        n30 += (n66 >>> 16) * 4;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                        break;
                    }
                    case 5: {
                        n67 = (((byArray[n30 + 3] & 0xFF) << 8 | byArray[n30 + 2] & 0xFF) << 8 | byArray[n30 + 1] & 0xFF) << 8 | byArray[n30] & 0xFF;
                        n30 += (n66 >>> 16) * 4;
                        n61 = byArray3[(n67 & n6) >>> n49] & 0xFF;
                        n62 = byArray4[(n67 & n7) >>> n50] & 0xFF;
                        n63 = byArray5[(n67 & n8) >>> n51] & 0xFF;
                    }
                }
                n67 = n61 >>> n54 << n52 | n62 >>> n57 << n55 | n63 >>> n60 << n58;
                switch (n17) {
                    case 0: {
                        byArray2[n29] = (byte)n67;
                        break;
                    }
                    case 1: {
                        byArray2[n29] = (byte)(n67 >>> 8);
                        byArray2[n29 + 1] = (byte)(n67 & 0xFF);
                        break;
                    }
                    case 2: {
                        byArray2[n29] = (byte)(n67 & 0xFF);
                        byArray2[n29 + 1] = (byte)(n67 >>> 8);
                        break;
                    }
                    case 3: {
                        byArray2[n29] = (byte)(n67 >>> 16);
                        byArray2[n29 + 1] = (byte)(n67 >>> 8);
                        byArray2[n29 + 2] = (byte)(n67 & 0xFF);
                        break;
                    }
                    case 4: {
                        byArray2[n29] = (byte)(n67 >>> 24);
                        byArray2[n29 + 1] = (byte)(n67 >>> 16);
                        byArray2[n29 + 2] = (byte)(n67 >>> 8);
                        byArray2[n29 + 3] = (byte)(n67 & 0xFF);
                        break;
                    }
                    case 5: {
                        byArray2[n29] = (byte)(n67 & 0xFF);
                        byArray2[n29 + 1] = (byte)(n67 >>> 8);
                        byArray2[n29 + 2] = (byte)(n67 >>> 16);
                        byArray2[n29 + 3] = (byte)(n67 >>> 24);
                    }
                }
                --n65;
                n29 += n27;
                n66 = (n66 & 0xFFFF) + n22;
            }
            n30 = n25 += (n64 >>> 16) * n2;
            n64 = (n64 & 0xFFFF) + n24;
            n29 = n26 += n28;
        }
    }

    static void blit(byte[] byArray, int n, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7, int n8, int n9, int n10, boolean bl, boolean bl2) {
        block57: {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            block56: {
                if (n9 <= 0 || n10 <= 0) {
                    return;
                }
                if (n > n6) {
                    return;
                }
                int n20 = n9 - 1;
                n19 = n20 != 0 ? (int)((((long)n4 << 16) - 1L) / (long)n20) : 0;
                int n21 = n10 - 1;
                n18 = n21 != 0 ? (int)((((long)n5 << 16) - 1L) / (long)n21) : 0;
                switch (n) {
                    case 16: {
                        n17 = 11;
                        if (n2 % 2 == 0) break;
                        return;
                    }
                    case 8: {
                        n17 = 6;
                        break;
                    }
                    case 4: {
                        n17 = 7;
                        break;
                    }
                    case 2: {
                        n17 = 8;
                        break;
                    }
                    case 1: {
                        n17 = n3 == 1 ? 9 : 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n22 = 0;
                switch (n6) {
                    case 16: {
                        n16 = 11;
                        if (n7 % 2 == 0) break;
                        return;
                    }
                    case 8: {
                        n16 = 6;
                        break;
                    }
                    case 4: {
                        n16 = 7;
                        break;
                    }
                    case 2: {
                        n16 = 8;
                        break;
                    }
                    case 1: {
                        n16 = n8 == 1 ? 9 : 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                n15 = n2 * 8 / n;
                int n23 = n7 * 8 / n6;
                int n24 = (bl2 ? n21 : 0) * n23 + (bl ? n20 : 0);
                n14 = bl ? -1 : 1;
                n13 = bl2 ? -n23 : n23;
                n12 = n24;
                n11 = n22;
                if (n17 != n16) break block56;
                switch (n17) {
                    case 11: {
                        int n25 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n26 = n9;
                            int n27 = n19;
                            while (n26 > 0) {
                                byArray2[2 * n12] = byArray[2 * n11];
                                byArray2[2 * n12 + 1] = byArray[2 * n11 + 1];
                                n11 += n27 >>> 16;
                                --n26;
                                n12 += n14;
                                n27 = (n27 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n25 >>> 16) * n15;
                            n25 = (n25 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break block57;
                    }
                    case 6: {
                        int n28 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n29 = n9;
                            int n30 = n19;
                            while (n29 > 0) {
                                byArray2[n12] = byArray[n11];
                                n11 += n30 >>> 16;
                                --n29;
                                n12 += n14;
                                n30 = (n30 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n28 >>> 16) * n15;
                            n28 = (n28 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break block57;
                    }
                    case 7: {
                        int n31 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n32 = n9;
                            int n33 = n19;
                            while (n32 > 0) {
                                int n34 = n11 & true ? byArray[n11 >> 1] & 0xF : byArray[n11 >> 1] >>> 4 & 0xF;
                                n11 += n33 >>> 16;
                                byArray2[n12 >> 1] = (n12 & 1) != 0 ? (byte)(byArray2[n12 >> 1] & 0xF0 | n34) : (byte)(byArray2[n12 >> 1] & 0xF | n34 << 4);
                                --n32;
                                n12 += n14;
                                n33 = (n33 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n31 >>> 16) * n15;
                            n31 = (n31 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break block57;
                    }
                    case 8: {
                        int n35 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n36 = n9;
                            int n37 = n19;
                            while (n36 > 0) {
                                int n38 = byArray[n11 >> 2] >>> 6 - (n11 & 3) * 2 & 3;
                                n11 += n37 >>> 16;
                                int n39 = 6 - (n12 & 3) * 2;
                                byArray2[n12 >> 2] = (byte)(byArray2[n12 >> 2] & ~(3 << n39) | n38 << n39);
                                --n36;
                                n12 += n14;
                                n37 = (n37 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n35 >>> 16) * n15;
                            n35 = (n35 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break block57;
                    }
                    case 9: {
                        int n40 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n41 = n9;
                            int n42 = n19;
                            while (n41 > 0) {
                                int n43 = byArray[n11 >> 3] >>> 7 - (n11 & 7) & 1;
                                n11 += n42 >>> 16;
                                int n44 = 7 - (n12 & 7);
                                byArray2[n12 >> 3] = (byte)(byArray2[n12 >> 3] & ~(1 << n44) | n43 << n44);
                                --n41;
                                n12 += n14;
                                n42 = (n42 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n40 >>> 16) * n15;
                            n40 = (n40 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break block57;
                    }
                    case 10: {
                        int n45 = n18;
                        for (int i = n10; i > 0; --i) {
                            int n46 = n9;
                            int n47 = n19;
                            while (n46 > 0) {
                                int n48 = byArray[n11 >> 3] >>> (n11 & 7) & 1;
                                n11 += n47 >>> 16;
                                int n49 = n12 & 7;
                                byArray2[n12 >> 3] = (byte)(byArray2[n12 >> 3] & ~(1 << n49) | n48 << n49);
                                --n46;
                                n12 += n14;
                                n47 = (n47 & 0xFFFF) + n19;
                            }
                            n11 = n22 += (n45 >>> 16) * n15;
                            n45 = (n45 & 0xFFFF) + n18;
                            n12 = n24 += n13;
                        }
                        break;
                    }
                }
                break block57;
            }
            int n50 = n18;
            for (int i = n10; i > 0; --i) {
                int n51 = n9;
                int n52 = n19;
                while (n51 > 0) {
                    int n53;
                    switch (n17) {
                        case 11: {
                            n53 = ((byArray[2 * n11 + 1] & 0xFF) << 8 | byArray[2 * n11] & 0xFF) & 0xFFFF;
                            break;
                        }
                        case 6: {
                            n53 = byArray[n11] & 0xFF;
                            break;
                        }
                        case 7: {
                            if ((n11 & 1) != 0) {
                                n53 = byArray[n11 >> 1] & 0xF;
                                break;
                            }
                            n53 = byArray[n11 >> 1] >>> 4 & 0xF;
                            break;
                        }
                        case 8: {
                            n53 = byArray[n11 >> 2] >>> 6 - (n11 & 3) * 2 & 3;
                            break;
                        }
                        case 9: {
                            n53 = byArray[n11 >> 3] >>> 7 - (n11 & 7) & 1;
                            break;
                        }
                        case 10: {
                            n53 = byArray[n11 >> 3] >>> (n11 & 7) & 1;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    switch (n16) {
                        case 11: {
                            byArray2[2 * n12] = (byte)(n53 & 0xFF);
                            byArray2[2 * n12 + 1] = (byte)(n53 >>> 8);
                            break;
                        }
                        case 6: {
                            byArray2[n12] = (byte)n53;
                            break;
                        }
                        case 7: {
                            if ((n12 & 1) != 0) {
                                byArray2[n12 >> 1] = (byte)(byArray2[n12 >> 1] & 0xF0 | n53);
                                break;
                            }
                            byArray2[n12 >> 1] = (byte)(byArray2[n12 >> 1] & 0xF | n53 << 4);
                            break;
                        }
                        case 8: {
                            int n54 = 6 - (n12 & 3) * 2;
                            byArray2[n12 >> 2] = (byte)(byArray2[n12 >> 2] & ~(3 << n54) | n53 << n54);
                            break;
                        }
                        case 9: {
                            int n54 = 7 - (n12 & 7);
                            byArray2[n12 >> 3] = (byte)(byArray2[n12 >> 3] & ~(1 << n54) | n53 << n54);
                            break;
                        }
                        case 10: {
                            int n54 = n12 & 7;
                            byArray2[n12 >> 3] = (byte)(byArray2[n12 >> 3] & ~(1 << n54) | n53 << n54);
                        }
                    }
                    --n51;
                    n12 += n14;
                    n11 += n52 >>> 16;
                    n52 = (n52 & 0xFFFF) + n19;
                }
                n11 = n22 += (n50 >>> 16) * n15;
                n50 = (n50 & 0xFFFF) + n18;
                n12 = n24 += n13;
            }
        }
    }

    static void blit(int n, int n2, byte[] byArray, int n3, int n4, int n5, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        int n13;
        int n14;
        if (n6 == 24 && n3 == 8 && n9 == 0xFF0000 && n10 == 65280 && n11 == 255) {
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = n4 - n;
            int n19 = n7 - n * 3;
            while (n15 < n2) {
                for (int i = 0; i < n; ++i) {
                    int n20 = byArray[n16++] & 0xFF;
                    byArray5[n17++] = byArray2[n20];
                    byArray5[n17++] = byArray3[n20];
                    byArray5[n17++] = byArray4[n20];
                }
                ++n15;
                n16 += n18;
                n17 += n19;
            }
            return;
        }
        if (n6 == 32 && n8 == 1 && n3 == 8 && n9 == 0xFF0000 && n10 == 65280 && n11 == 255) {
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = n4 - n;
            int n25 = n7 - n * 4;
            while (n21 < n2) {
                for (int i = 0; i < n; ++i) {
                    int n26 = byArray[n22++] & 0xFF;
                    int n27 = ++n23;
                    byArray5[n27] = byArray2[n26];
                    int n28 = ++n23;
                    byArray5[n28] = byArray3[n26];
                    int n29 = ++n23;
                    ++n23;
                    byArray5[n29] = byArray4[n26];
                }
                ++n21;
                n22 += n24;
                n23 += n25;
            }
            return;
        }
        switch (n3) {
            case 16: {
                n14 = 11;
                if (n4 % 2 == 0) break;
                return;
            }
            case 8: {
                n14 = 6;
                break;
            }
            case 4: {
                n14 = 7;
                break;
            }
            case 2: {
                n14 = 8;
                break;
            }
            case 1: {
                n14 = n5 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        switch (n6) {
            case 8: {
                n13 = 1;
                n12 = 0;
                break;
            }
            case 16: {
                n13 = 2;
                n12 = n8 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n13 = 3;
                n12 = 3;
                break;
            }
            case 32: {
                n13 = 4;
                n12 = n8 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n30 = ImageData.getChannelShift(n9);
        int n31 = ImageData.getChannelWidth(n9, n30);
        int n32 = 8 - n31;
        int n33 = ImageData.getChannelShift(n10);
        int n34 = ImageData.getChannelWidth(n10, n33);
        int n35 = 8 - n34;
        int n36 = ImageData.getChannelShift(n11);
        int n37 = ImageData.getChannelWidth(n11, n36);
        int n38 = 8 - n37;
        int n39 = n4 * 8 / n3;
        int n40 = 0;
        int n41 = 0;
        int n42 = 0;
        int n43 = 0;
        int n44 = 0;
        int n45 = 0;
        int n46 = 0;
        int n47 = 0;
        for (int i = n2; i > 0; --i) {
            int n48 = n;
            while (n48 > 0) {
                switch (n14) {
                    case 11: {
                        n47 = ((byArray[2 * n43 + 1] & 0xFF) << 8 | byArray[2 * n43] & 0xFF) & 0xFFFF;
                        break;
                    }
                    case 6: {
                        n47 = byArray[n43] & 0xFF;
                        break;
                    }
                    case 7: {
                        if ((n43 & 1) != 0) {
                            n47 = byArray[n43 >> 1] & 0xF;
                            break;
                        }
                        n47 = byArray[n43 >> 1] >>> 4 & 0xF;
                        break;
                    }
                    case 8: {
                        n47 = byArray[n43 >> 2] >>> 6 - (n43 & 3) * 2 & 3;
                        break;
                    }
                    case 9: {
                        n47 = byArray[n43 >> 3] >>> 7 - (n43 & 7) & 1;
                        break;
                    }
                    case 10: {
                        n47 = byArray[n43 >> 3] >>> (n43 & 7) & 1;
                    }
                }
                n44 = byArray2[n47] & 0xFF;
                n45 = byArray3[n47] & 0xFF;
                n46 = byArray4[n47] & 0xFF;
                int n49 = n44 >>> n32 << n30 | n45 >>> n35 << n33 | n46 >>> n38 << n36;
                switch (n12) {
                    case 0: {
                        byArray5[n42] = (byte)n49;
                        break;
                    }
                    case 1: {
                        byArray5[n42] = (byte)(n49 >>> 8);
                        byArray5[n42 + 1] = (byte)(n49 & 0xFF);
                        break;
                    }
                    case 2: {
                        byArray5[n42] = (byte)(n49 & 0xFF);
                        byArray5[n42 + 1] = (byte)(n49 >>> 8);
                        break;
                    }
                    case 3: {
                        byArray5[n42] = (byte)(n49 >>> 16);
                        byArray5[n42 + 1] = (byte)(n49 >>> 8);
                        byArray5[n42 + 2] = (byte)(n49 & 0xFF);
                        break;
                    }
                    case 4: {
                        byArray5[n42] = (byte)(n49 >>> 24);
                        byArray5[n42 + 1] = (byte)(n49 >>> 16);
                        byArray5[n42 + 2] = (byte)(n49 >>> 8);
                        byArray5[n42 + 3] = (byte)(n49 & 0xFF);
                        break;
                    }
                    case 5: {
                        byArray5[n42] = (byte)(n49 & 0xFF);
                        byArray5[n42 + 1] = (byte)(n49 >>> 8);
                        byArray5[n42 + 2] = (byte)(n49 >>> 16);
                        byArray5[n42 + 3] = (byte)(n49 >>> 24);
                    }
                }
                --n48;
                ++n43;
                n42 += n13;
            }
            n43 = n40 += n39;
            n42 = n41 += n7;
        }
    }

    static int getChannelShift(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        for (n2 = 0; (n & 1) == 0 && n2 < 32; ++n2) {
            n >>>= 1;
        }
        return n2;
    }

    static int getChannelWidth(int n, int n2) {
        int n3;
        if (n == 0) {
            return 0;
        }
        n >>>= n2;
        for (n3 = n2; (n & 1) != 0 && n3 < 32; ++n3) {
            n >>>= 1;
        }
        return n3 - n2;
    }

    static ImageData createGradientBand(int n, int n2, boolean bl, RGB rGB, RGB rGB2, int n3, int n4, int n5) {
        byte[] byArray;
        int n6;
        int n7;
        int n8;
        PaletteData paletteData;
        if (n3 != 0 && n4 != 0 && n5 != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            n8 = 32;
            if (n3 >= 8 && n4 >= 8 && n5 >= 8) {
                int n9;
                if (bl) {
                    n7 = 1;
                    n6 = n2;
                    n9 = n6 > 1 ? n6 - 1 : 1;
                } else {
                    n7 = n;
                    n6 = 1;
                    n9 = n7 > 1 ? n7 - 1 : 1;
                }
                int n10 = n7 * 4;
                byArray = new byte[n6 * n10];
                ImageData.buildPreciseGradientChannel(rGB.blue, rGB2.blue, n9, n7, n6, bl, byArray, 0, n10);
                ImageData.buildPreciseGradientChannel(rGB.green, rGB2.green, n9, n7, n6, bl, byArray, 1, n10);
                ImageData.buildPreciseGradientChannel(rGB.red, rGB2.red, n9, n7, n6, bl, byArray, 2, n10);
            } else {
                int n11;
                if (bl) {
                    n7 = n < 8 ? n : 8;
                    n6 = n2;
                    n11 = n6 > 1 ? n6 - 1 : 1;
                } else {
                    n7 = n;
                    n6 = n2 < 8 ? n2 : 8;
                    n11 = n7 > 1 ? n7 - 1 : 1;
                }
                int n12 = n7 * 4;
                byArray = new byte[n6 * n12];
                ImageData.buildDitheredGradientChannel(rGB.blue, rGB2.blue, n11, n7, n6, bl, byArray, 0, n12, n5);
                ImageData.buildDitheredGradientChannel(rGB.green, rGB2.green, n11, n7, n6, bl, byArray, 1, n12, n4);
                ImageData.buildDitheredGradientChannel(rGB.red, rGB2.red, n11, n7, n6, bl, byArray, 2, n12, n3);
            }
        } else {
            int n13;
            paletteData = new PaletteData(rGB, rGB2);
            n8 = 8;
            if (bl) {
                n7 = n < 8 ? n : 8;
                n6 = n2;
                n13 = n6 > 1 ? 0x1040000 / (n6 - 1) + 1 : 1;
            } else {
                n7 = n;
                n6 = n2 < 8 ? n2 : 8;
                n13 = n7 > 1 ? 0x1040000 / (n7 - 1) + 1 : 1;
            }
            int n14 = n7 + 3 & 0xFFFFFFFC;
            byArray = new byte[n6 * n14];
            if (bl) {
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                while (n15 < n6) {
                    for (int i = 0; i < n7; ++i) {
                        byArray[n17 + i] = n16 + DITHER_MATRIX[n15 & 7][i] < 0x1000000 ? (byte)0 : 1;
                    }
                    ++n15;
                    n16 += n13;
                    n17 += n14;
                }
            } else {
                int n18 = 0;
                int n19 = 0;
                while (n18 < n7) {
                    int n20 = 0;
                    int n21 = n18;
                    while (n20 < n6) {
                        byArray[n21] = n19 + DITHER_MATRIX[n20][n18 & 7] < 0x1000000 ? (byte)0 : 1;
                        ++n20;
                        n21 += n14;
                    }
                    ++n18;
                    n19 += n13;
                }
            }
        }
        return new ImageData(n7, n6, n8, paletteData, 4, byArray);
    }

    static void buildPreciseGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7) {
        int n8 = n << 16;
        int n9 = ((n2 << 16) - n8) / n3 + 1;
        if (bl) {
            int n10 = 0;
            while (n10 < n5) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n10;
                n6 += n7;
            }
        } else {
            int n11 = 0;
            while (n11 < n4) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n11;
                n6 += 4;
            }
        }
    }

    static void buildDitheredGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7, int n8) {
        int n9 = 65280 >>> n8;
        int n10 = n << 16;
        int n11 = ((n2 << 16) - n10) / n3 + 1;
        if (bl) {
            int n12 = 0;
            while (n12 < n5) {
                int n13 = 0;
                int n14 = n6;
                while (n13 < n4) {
                    int n15 = DITHER_MATRIX[n12 & 7][n13] >>> n8;
                    int n16 = n10 + n15;
                    byArray[n14] = n16 > 0xFFFFFF ? -1 : (byte)(n16 >>> 16 & n9);
                    ++n13;
                    n14 += 4;
                }
                n10 += n11;
                ++n12;
                n6 += n7;
            }
        } else {
            int n17 = 0;
            while (n17 < n4) {
                int n18 = 0;
                int n19 = n6;
                while (n18 < n5) {
                    int n20 = DITHER_MATRIX[n18][n17 & 7] >>> n8;
                    int n21 = n10 + n20;
                    byArray[n19] = n21 > 0xFFFFFF ? -1 : (byte)(n21 >>> 16 & n9);
                    ++n18;
                    n19 += n7;
                }
                n10 += n11;
                ++n17;
                n6 += 4;
            }
        }
    }

    static void fillGradientRectangle(GC gC, Device device, int n, int n2, int n3, int n4, boolean bl, RGB rGB, RGB rGB2, int n5, int n6, int n7) {
        ImageData imageData = ImageData.createGradientBand(n3, n4, bl, rGB, rGB2, n5, n6, n7);
        Image image = new Image(device, imageData);
        if (imageData.width == 1 || imageData.height == 1) {
            gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(imageData.height), DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(n4));
        } else if (bl) {
            for (int i = 0; i < n3; i += imageData.width) {
                int n8 = n3 - i;
                if (n8 > imageData.width) {
                    n8 = imageData.width;
                }
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(n8), DPIUtil.autoScaleDown(imageData.height), DPIUtil.autoScaleDown(i + n), DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n8), DPIUtil.autoScaleDown(imageData.height));
            }
        } else {
            for (int i = 0; i < n4; i += imageData.height) {
                int n9 = n4 - i;
                if (n9 > imageData.height) {
                    n9 = imageData.height;
                }
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(n9), DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(i + n2), DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(n9));
            }
        }
        image.dispose();
    }

    static {
        for (int i = 0; i < 9; ++i) {
            ImageData.ANY_TO_EIGHT[i] = new byte[1 << i];
            byte[] byArray = ImageData.ANY_TO_EIGHT[i];
            if (i == 0) continue;
            int n = 0;
            int n2 = 65536;
            while ((n2 >>= i) != 0) {
                n |= n2;
            }
            int n3 = 0;
            for (n2 = 0; n2 < 65536; n2 += n) {
                byArray[n3++] = (byte)(n2 >> 8);
            }
        }
        DITHER_MATRIX = new int[][]{{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000}, {0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000}, {0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000}, {786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000}, {0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000}, {0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000}, {0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000}, {0, 0x800000, 0x200000, 0xA00000, 524288, 0x880000, 0x280000, 0xA80000}};
    }
}

