/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static char[] mbcsToWcs(byte[] byArray) {
        long[] lArray = new long[1];
        long l = OS.g_utf8_to_utf16(byArray, (long)byArray.length, null, lArray, null);
        if (l == 0L) {
            return EmptyCharArray;
        }
        int n = (int)lArray[0];
        char[] cArray = new char[n];
        C.memmove(cArray, l, (long)(n * 2));
        OS.g_free(l);
        return cArray;
    }

    public static byte[] wcsToMbcs(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Converter.wcsToMbcs(cArray, bl);
    }

    public static byte[] javaStringToCString(String string) {
        return Converter.wcsToMbcs(string, true);
    }

    public static String cCharPtrToJavaString(long l, boolean bl) {
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        if (bl) {
            OS.g_free(l);
        }
        return new String(Converter.mbcsToWcs(byArray));
    }

    public static byte[] wcsToMbcs(char[] cArray, boolean bl) {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l = OS.g_utf16_to_utf8(cArray, cArray.length, lArray, lArray2, null);
        if (l == 0L) {
            return bl ? NullByteArray : EmptyByteArray;
        }
        int n = (int)lArray2[0];
        byte[] byArray = new byte[n + (bl ? 1 : 0)];
        C.memmove(byArray, l, (long)n);
        OS.g_free(l);
        return byArray;
    }

    public static char wcsToMbcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return '\u0000';
    }

    public static char mbcsToWcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = n <= 255 ? new byte[]{(byte)n} : new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        char[] cArray = Converter.mbcsToWcs(byArray);
        if (cArray.length == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    public static String byteToStringViaHeuristic(byte[] byArray) {
        if (byArray.length == 0 || byArray.length == 1 && byArray[0] == 0) {
            return "";
        }
        try {
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            String string = charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString();
            boolean bl = true;
            double d = 0.01;
            int n = 0;
            for (byte by : byArray) {
                if (by != 0) continue;
                ++n;
            }
            double d2 = (double)n / (double)byArray.length;
            if (d2 > d) {
                bl = false;
            }
            if (bl) {
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    n = Character.codePointAt(cArray, i);
                    if (Character.isValidCodePoint(n)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                return new String(byArray, StandardCharsets.UTF_16LE);
            }
            return string;
        }
        catch (CharacterCodingException characterCodingException) {
            Charset[] charsetArray = new Charset[]{StandardCharsets.UTF_16LE, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16};
            for (Charset charset : charsetArray) {
                try {
                    CharsetDecoder charsetDecoder = charset.newDecoder();
                    charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
                    charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    return charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString();
                }
                catch (CharacterCodingException characterCodingException2) {
                }
            }
            StringWriter stringWriter = new StringWriter();
            new Throwable("").printStackTrace(new PrintWriter(stringWriter));
            return "SWT: Failed to decode byte buffer. Encoding is not ASCII/UTF-8/UTF-16[LE|BE|BOM]/ISO_8859_1. Stack trace:\n" + stringWriter.toString();
        }
    }
}

