/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    long[] surfaces;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.surfaces = new long[4];
    }

    public static long convertSurface(Image image) {
        long l = image.surface;
        int n = Cairo.cairo_surface_get_type(l);
        if (n != 0) {
            long l2;
            Rectangle rectangle = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
            int n2 = Cairo.cairo_surface_get_content(l) == 4096 ? 1 : 0;
            if ((l = Cairo.cairo_image_surface_create(n2, rectangle.width, rectangle.height)) == 0L) {
                SWT.error(2);
            }
            if (DPIUtil.useCairoAutoScale()) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                Cairo.cairo_surface_get_device_scale(image.surface, dArray, dArray2);
                if (dArray[0] == 0.0 || dArray2[0] == 0.0) {
                    dArray[0] = dArray2[0] = (double)((float)DPIUtil.getDeviceZoom() / 100.0f);
                }
                Cairo.cairo_surface_set_device_scale(l, dArray[0], dArray2[0]);
            }
            if ((l2 = Cairo.cairo_create(l)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(l2, 1);
            Cairo.cairo_set_source_surface(l2, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(l2);
            Cairo.cairo_destroy(l2);
        } else {
            Cairo.cairo_surface_reference(l);
        }
        return l;
    }

    public static long createPixbuf(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = Cairo.cairo_image_surface_get_format(l);
        boolean bl = n9 == 0;
        long l2 = GDK.gdk_pixbuf_new(0, bl, 8, n8 = Cairo.cairo_image_surface_get_width(l), n7 = Cairo.cairo_image_surface_get_height(l));
        if (l2 == 0L) {
            SWT.error(2);
        }
        int n10 = GDK.gdk_pixbuf_get_rowstride(l2);
        long l3 = GDK.gdk_pixbuf_get_pixels(l2);
        if (OS.BIG_ENDIAN) {
            n6 = 0;
            n5 = 1;
            n4 = 2;
            n3 = 3;
        } else {
            n6 = 3;
            n5 = 2;
            n4 = 1;
            n3 = 0;
        }
        byte[] byArray = new byte[n10];
        long l4 = Cairo.cairo_image_surface_get_data(l);
        if (bl) {
            for (n2 = 0; n2 < n7; ++n2) {
                C.memmove(byArray, l4 + (long)(n2 * n10), (long)n10);
                int n11 = 0;
                n = 0;
                while (n11 < n8) {
                    int n12 = byArray[n + n6] & 0xFF;
                    int n13 = byArray[n + n5] & 0xFF;
                    int n14 = byArray[n + n4] & 0xFF;
                    int n15 = byArray[n + n3] & 0xFF;
                    byArray[n + 3] = (byte)n12;
                    if (n12 != 0) {
                        byArray[n + 0] = (byte)((n13 * 255 + n12 / 2) / n12);
                        byArray[n + 1] = (byte)((n14 * 255 + n12 / 2) / n12);
                        byArray[n + 2] = (byte)((n15 * 255 + n12 / 2) / n12);
                    }
                    ++n11;
                    n += 4;
                }
                C.memmove(l3 + (long)(n2 * n10), byArray, (long)n10);
            }
        } else {
            n2 = Cairo.cairo_image_surface_get_stride(l);
            byte[] byArray2 = new byte[n2];
            for (n = 0; n < n7; ++n) {
                C.memmove(byArray2, l4 + (long)(n * n2), (long)n2);
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                while (n16 < n8) {
                    byte by = byArray2[n18 + n5];
                    byte by2 = byArray2[n18 + n4];
                    byte by3 = byArray2[n18 + n3];
                    byArray[n17 + 0] = by;
                    byArray[n17 + 1] = by2;
                    byArray[n17 + 2] = by3;
                    ++n16;
                    n17 += 3;
                    n18 += 4;
                }
                C.memmove(l3 + (long)(n * n10), byArray, (long)n10);
            }
        }
        if (DPIUtil.useCairoAutoScale()) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            Cairo.cairo_surface_get_device_scale(l, dArray, dArray2);
            if (dArray[0] > 1.0 && dArray2[0] > 1.0) {
                long l5 = l2;
                l2 = GDK.gdk_pixbuf_scale_simple(l2, n8 / (int)dArray[0], n7 / (int)dArray2[0], 2);
                OS.g_object_unref(l5);
            }
        }
        return l2;
    }

    public static long createPixbuf(Image image) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l = ImageList.convertSurface(image);
        int n7 = Cairo.cairo_image_surface_get_format(l);
        boolean bl = n7 == 0;
        long l2 = GDK.gdk_pixbuf_new(0, bl, 8, n6 = Cairo.cairo_image_surface_get_width(l), n5 = Cairo.cairo_image_surface_get_height(l));
        if (l2 == 0L) {
            SWT.error(2);
        }
        int n8 = GDK.gdk_pixbuf_get_rowstride(l2);
        long l3 = GDK.gdk_pixbuf_get_pixels(l2);
        if (OS.BIG_ENDIAN) {
            n4 = 0;
            n3 = 1;
            n2 = 2;
            n = 3;
        } else {
            n4 = 3;
            n3 = 2;
            n2 = 1;
            n = 0;
        }
        byte[] byArray = new byte[n8];
        long l4 = Cairo.cairo_image_surface_get_data(l);
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                C.memmove(byArray, l4 + (long)(i * n8), (long)n8);
                int n9 = 0;
                int n10 = 0;
                while (n9 < n6) {
                    int n11 = byArray[n10 + n4] & 0xFF;
                    int n12 = byArray[n10 + n3] & 0xFF;
                    int n13 = byArray[n10 + n2] & 0xFF;
                    int n14 = byArray[n10 + n] & 0xFF;
                    byArray[n10 + 3] = (byte)n11;
                    if (n11 != 0) {
                        byArray[n10 + 0] = (byte)((n12 * 255 + n11 / 2) / n11);
                        byArray[n10 + 1] = (byte)((n13 * 255 + n11 / 2) / n11);
                        byArray[n10 + 2] = (byte)((n14 * 255 + n11 / 2) / n11);
                    }
                    ++n9;
                    n10 += 4;
                }
                C.memmove(l3 + (long)(i * n8), byArray, (long)n8);
            }
        } else {
            int n15 = Cairo.cairo_image_surface_get_stride(l);
            byte[] byArray2 = new byte[n15];
            for (int i = 0; i < n5; ++i) {
                C.memmove(byArray2, l4 + (long)(i * n15), (long)n15);
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                while (n16 < n6) {
                    byte by = byArray2[n18 + n3];
                    byte by2 = byArray2[n18 + n2];
                    byte by3 = byArray2[n18 + n];
                    byArray[n17 + 0] = by;
                    byArray[n17 + 1] = by2;
                    byArray[n17 + 2] = by3;
                    ++n16;
                    n17 += 3;
                    n18 += 4;
                }
                C.memmove(l3 + (long)(i * n8), byArray, (long)n8);
            }
        }
        Cairo.cairo_surface_destroy(l);
        return l2;
    }

    public int add(Image image) {
        int n;
        for (n = 0; n < this.images.length; ++n) {
            if (this.images[n] != null && this.images[n].isDisposed()) {
                Cairo.cairo_surface_destroy(this.surfaces[n]);
                this.images[n] = null;
                this.surfaces[n] = 0L;
            }
            if (this.images[n] == null) break;
        }
        if (n == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
            long[] lArray = new long[this.surfaces.length + 4];
            System.arraycopy(this.surfaces, 0, lArray, 0, this.surfaces.length);
            this.surfaces = lArray;
        }
        this.set(n, image);
        return n;
    }

    public void dispose() {
        if (this.surfaces == null) {
            return;
        }
        for (int i = 0; i < this.surfaces.length; ++i) {
            long l = this.surfaces[i];
            if (l == 0L) continue;
            Cairo.cairo_surface_destroy(l);
        }
        this.images = null;
        this.surfaces = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public long getSurface(int n) {
        return this.surfaces[n];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(long l) {
        if (l == 0L) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (l != this.surfaces[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int n, Image image) {
        int n2 = this.images.length;
        if (0 > n || n >= n2) {
            return;
        }
        if (this.images[n] == image) {
            return;
        }
        if (image != null) {
            this.set(n, image);
        } else {
            this.images[n] = null;
            if (this.surfaces[n] != 0L) {
                Cairo.cairo_surface_destroy(this.surfaces[n]);
            }
            this.surfaces[n] = 0L;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            this.images[i] = null;
            Cairo.cairo_surface_destroy(this.surfaces[i]);
            this.surfaces[i] = 0L;
        }
    }

    void set(int n, Image image) {
        long l;
        long l2 = ImageList.convertSurface(image);
        int n2 = Cairo.cairo_image_surface_get_width(l2);
        int n3 = Cairo.cairo_image_surface_get_height(l2);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_surface_get_device_scale(image.surface, dArray, dArray2);
        n3 /= (int)dArray2[0];
        Rectangle rectangle = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
        if ((n2 /= (int)dArray[0]) == 0) {
            n2 = rectangle.width;
        }
        if (n3 == 0) {
            n3 = rectangle.height;
        }
        if (this.width == -1 || this.height == -1) {
            this.width = n2;
            this.height = n3;
        }
        if (n2 != this.width || n3 != this.height) {
            Cairo.cairo_surface_destroy(l2);
            l2 = this.scaleSurface(image, this.width, this.height);
        }
        if ((l = this.surfaces[n]) != 0L) {
            Cairo.cairo_surface_destroy(l);
        }
        this.surfaces[n] = l2;
        this.images[n] = image;
    }

    long scaleSurface(Image image, int n, int n2) {
        Rectangle rectangle;
        long l;
        int n3 = Cairo.cairo_surface_get_content(image.surface) == 4096 ? 1 : 0;
        long l2 = Cairo.cairo_image_surface_create(n3, n, n2);
        if (l2 == 0L) {
            SWT.error(2);
        }
        if ((l = Cairo.cairo_create(l2)) == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.useCairoAutoScale()) {
            int n4 = Cairo.cairo_image_surface_get_width(image.surface);
            int n5 = Cairo.cairo_image_surface_get_height(image.surface);
            rectangle = n4 == 0 && n5 == 0 ? image.getBounds() : new Rectangle(0, 0, n4, n5);
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            Cairo.cairo_surface_get_device_scale(image.surface, dArray, dArray2);
            if (dArray[0] == 0.0 || dArray2[0] == 0.0) {
                dArray[0] = dArray2[0] = (double)((float)DPIUtil.getDeviceZoom() / 100.0f);
            }
            Cairo.cairo_surface_set_device_scale(l2, dArray[0], dArray2[0]);
        } else {
            rectangle = image.getBoundsInPixels();
        }
        double d = (double)n / (double)rectangle.width;
        double d2 = (double)n2 / (double)rectangle.height;
        Cairo.cairo_scale(l, d, d2);
        Cairo.cairo_set_operator(l, 1);
        Cairo.cairo_set_source_surface(l, image.surface, 0.0, 0.0);
        Cairo.cairo_paint(l);
        Cairo.cairo_destroy(l);
        return l2;
    }
}

