/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    Composite embeddedInto;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;
    static final int DEFAULT_WIDTH = 1;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget(0);
        for (Composite composite = canvas.getParent(); composite != null; composite = composite.getParent()) {
            if (!(composite instanceof Tree) && !(composite instanceof Table)) continue;
            this.embeddedInto = composite;
            break;
        }
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        if (this.embeddedInto != null && !this.embeddedInto.isDisposed() && this.isFocusCaret()) {
            this.drawInCellEditor(this.embeddedInto.paintWindow());
        } else {
            GTK.gtk_widget_queue_draw(this.parent.handle);
        }
        return true;
    }

    private void drawInCellEditor(long l) {
        long l2 = GDK.gdk_cairo_create(l);
        Point point = this.display.map((Control)this.parent, (Control)this.embeddedInto, new Point(0, 0));
        Cairo.cairo_translate(l2, point.x, point.y);
        this.parent.drawCaretInFocus(this.parent.handle, l2);
        Cairo.cairo_destroy(l2);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Rectangle(this.x, this.y, 1, this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            return new Point(rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Point(1, this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
        this.embeddedInto = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(new Rectangle(n, n2, n3, n4));
    }

    void setBoundsInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        boolean bl = this.isFocusCaret();
        if (bl && this.isVisible) {
            this.hideCaret();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.parent.updateCaret();
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        rectangle = DPIUtil.autoScaleUp(rectangle);
        this.setBoundsInPixels(rectangle);
    }

    void setBoundsInPixels(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBoundsInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean bl;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((bl = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setLocation(new Point(n, n2));
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        this.setBoundsInPixels(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(point));
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocationInPixels(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setSize(new Point(n, n2));
    }

    void setSizeInPixels(int n, int n2) {
        this.checkWidget();
        this.setBoundsInPixels(this.x, this.y, n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        this.setSizeInPixels(DPIUtil.autoScaleUp(point));
    }

    void setSizeInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSizeInPixels(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        Canvas canvas = this.getParent();
        canvas.blink = true;
        canvas.drawFlag = bl;
        this.display.resetCaretTiming();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

