/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    long clientHandle;
    long boxHandle;
    long labelHandle;
    long imageHandle;
    int width;
    int height;

    public ExpandItem(ExpandBar expandBar, int n) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(expandBar.getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n, int n2) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(n2);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.handle = GTK.gtk_expander_new(null);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.clientHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_expander_set_child(this.handle, this.clientHandle);
        } else {
            GTK3.gtk_container_add(this.handle, this.clientHandle);
        }
        this.boxHandle = this.gtk_box_new(0, false, 4);
        if (this.boxHandle == 0L) {
            this.error(2);
        }
        this.labelHandle = GTK.gtk_label_new(null);
        if (this.labelHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.imageHandle = GTK4.gtk_picture_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            GTK4.gtk_picture_set_can_shrink(this.imageHandle, false);
            GTK4.gtk_box_append(this.boxHandle, this.imageHandle);
            GTK4.gtk_box_append(this.boxHandle, this.labelHandle);
        } else {
            this.imageHandle = GTK.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
            GTK3.gtk_container_add(this.boxHandle, this.labelHandle);
        }
        GTK.gtk_expander_set_label_widget(this.handle, this.boxHandle);
        GTK.gtk_widget_set_can_focus(this.handle, true);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.createItem(this, this.style, n);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.boxHandle);
        this.display.removeWidget(this.labelHandle);
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void release(boolean bl) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.release(bl);
        }
        super.release(bl);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return GTK.gtk_expander_get_expanded(this.handle);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(GTK.gtk_expander_get_label_widget(this.handle), gtkAllocation);
        return gtkAllocation.height;
    }

    public int getHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.height);
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    long gtk_activate(long l) {
        Event event = new Event();
        event.item = this;
        int n = GTK.gtk_expander_get_expanded(this.handle) ? 18 : 17;
        this.parent.sendEvent(n, event);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        this.setFocus();
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        GTK.gtk_widget_set_can_focus(this.handle, false);
        this.parent.lastFocus = this;
        return 0L;
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        this.parent.layoutItems();
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        this.parent.gtk_enter_notify_event(l, l2);
        return 0L;
    }

    boolean hasFocus() {
        return GTK.gtk_widget_has_focus(this.handle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(60), true);
        if (GTK.GTK4) {
            long l = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.handle, l);
            OS.g_signal_connect(l, OS.pressed, this.display.gesturePressReleaseProc, 100L);
            long l2 = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(this.handle, l2);
            GTK.gtk_event_controller_set_propagation_phase(l2, 3);
            long l3 = this.display.enterMotionCallback.getAddress();
            OS.g_signal_connect(l2, OS.enter, l3, 95L);
            OS.g_signal_connect(this.clientHandle, OS.resize, this.display.resizeProc, 0L);
        } else {
            OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.getClosure(47), true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.boxHandle, this);
        this.display.addWidget(this.labelHandle, this);
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.boxHandle = 0L;
        this.clientHandle = 0L;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.control = null;
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Object object;
            boolean bl = GTK.gtk_expander_get_expanded(this.handle);
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.clientHandle, gtkAllocation);
            int n = 0;
            int n2 = 0;
            int n3 = gtkAllocation.width;
            int n4 = gtkAllocation.height;
            if (!GTK.GTK4) {
                object = new int[1];
                GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, object, 0L);
                n2 += object[0] * 2;
                n4 -= object[0] * 2;
            }
            if ((object = (Object)this.parent.verticalBar) != null && GTK.gtk_widget_get_visible(object.handle)) {
                GTK.gtk_widget_get_allocation(this.parent.scrolledHandle, gtkAllocation);
                n3 = gtkAllocation.width - this.parent.vScrollBarWidth() - 2 * this.parent.spacing;
            }
            if (bl) {
                GTK.gtk_widget_show(this.control.topHandle());
            }
            this.control.setBounds(n, n2, n3, Math.max(0, n4), true, true);
            this.control.setVisible(bl);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            Control.gtk_widget_reparent(control, this.clientHandle);
        }
        this.parent.layoutItems();
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        GTK.gtk_expander_set_expanded(this.handle, bl);
        this.parent.layoutItems();
    }

    boolean setFocus() {
        if (!GTK.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
        GTK.gtk_widget_grab_focus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        boolean bl = GTK.gtk_widget_is_focus(this.handle);
        if (!bl) {
            GTK.gtk_widget_set_can_focus(this.handle, false);
        }
        return bl;
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.handle, l);
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, l);
        }
    }

    void setForegroundRGBA(GdkRGBA gdkRGBA) {
        this.parent.setForegroundGdkRGBA(this.handle, gdkRGBA);
        if (this.labelHandle != 0L) {
            this.parent.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
        }
        if (this.imageHandle != 0L) {
            this.parent.setForegroundGdkRGBA(this.imageHandle, gdkRGBA);
        }
    }

    public void setHeight(int n) {
        this.checkWidget();
        this.setHeightInPixels(DPIUtil.autoScaleUp(n));
    }

    void setHeightInPixels(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.height = n;
        GTK.gtk_widget_set_size_request(this.clientHandle, -1, n);
        this.parent.layoutItems();
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (GTK.GTK4) {
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_picture_set_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, image.surface);
            }
            if (this.text.length() == 0) {
                GTK.gtk_widget_hide(this.labelHandle);
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_picture_set_paintable(this.imageHandle, 0L);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.handle, n);
            GTK3.gtk_container_forall(this.handle, this.display.setDirectionProc, n);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        byte[] byArray = Converter.wcsToMbcs(string, true);
        GTK.gtk_label_set_text(this.labelHandle, byArray);
    }

    void showWidget(int n) {
        if (GTK.GTK4) {
            GTK4.gtk_box_append(this.parent.handle, this.handle);
            this.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
        } else {
            GTK.gtk_widget_show(this.handle);
            GTK.gtk_widget_show(this.clientHandle);
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.boxHandle != 0L) {
                GTK.gtk_widget_show(this.boxHandle);
            }
            GTK3.gtk_container_add(this.parent.handle, this.handle);
            this.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
        }
    }

    @Override
    long windowProc(long l, long l2) {
        switch ((int)l2) {
            case 60: {
                this.parent.layoutItems();
                return 0L;
            }
        }
        return super.windowProc(l, l2);
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

