/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    long clientHandle;
    long labelHandle;
    String text = "";
    GdkRGBA foreground;

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    long clientHandle() {
        return this.clientHandle;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point = super.computeSizeInPixels(n, n2, bl);
        int n3 = this.computeNativeSize((long)this.handle, (int)-1, (int)-1, (boolean)false).x;
        point.x = Math.max(point.x, n3);
        return point;
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.clientHandle, gtkAllocation);
        int n5 = gtkAllocation.x;
        int n6 = gtkAllocation.y;
        return new Rectangle(n -= n5, n2 -= n6, n3 += n5 + n5, n4 += n5 + n6);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rectangle = super.getClientAreaInPixels();
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        return super.getContextBackgroundGdkRGBA();
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        this.handle = GTK.gtk_frame_new(null);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.labelHandle = GTK.gtk_label_new(null);
        if (this.labelHandle == 0L) {
            this.error(2);
        }
        OS.g_object_ref_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.clientHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.clientHandle, true);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
            GTK4.gtk_frame_set_child(this.handle, this.clientHandle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
            GTK3.gtk_container_add(this.handle, this.clientHandle);
            if ((this.style & 4) != 0) {
                GTK3.gtk_frame_set_shadow_type(this.handle, 1);
            }
            if ((this.style & 8) != 0) {
                GTK3.gtk_frame_set_shadow_type(this.handle, 2);
            }
            if ((this.style & 0x10) != 0) {
                GTK3.gtk_frame_set_shadow_type(this.handle, 3);
            }
            if ((this.style & 0x40) != 0) {
                GTK3.gtk_frame_set_shadow_type(this.handle, 4);
            }
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return 1;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    @Override
    void enableWidget(boolean bl) {
        GTK.gtk_widget_set_sensitive(this.labelHandle, bl);
    }

    @Override
    long eventHandle() {
        return this.clientHandle;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    long parentingHandle() {
        return this.clientHandle;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0L;
        this.clientHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0L) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.setFontDescription(this.labelHandle, l);
    }

    @Override
    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        if (this.text != null && !this.text.isEmpty()) {
            super.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
        }
        this.foreground = gdkRGBA;
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        this.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n = (this.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.labelHandle, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            if (GTK.gtk_frame_get_label_widget(this.handle) == 0L) {
                GTK.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            GTK.gtk_frame_set_label_widget(this.handle, 0L);
        }
        if (this.foreground != null) {
            this.setForegroundGdkRGBA(this.labelHandle, this.foreground);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0L) {
            GTK.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0L) {
            GTK.gtk_widget_show(this.labelHandle);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        GtkRequisition gtkRequisition = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.handle, gtkRequisition, null);
        n3 = n3 - (gtkRequisition.width - n3) < 0 ? gtkRequisition.width : n3;
        n4 = n4 - (gtkRequisition.height - n4) < 0 ? gtkRequisition.height : n4;
        return super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    @Override
    long paintHandle() {
        if (GTK.GTK4) {
            return this.clientHandle;
        }
        long l = this.topHandle();
        long l2 = this.clientHandle;
        while (l2 != l && !GTK3.gtk_widget_get_has_window(l2)) {
            l2 = GTK.gtk_widget_get_parent(l2);
        }
        return l2;
    }

    @Override
    long paintWindow() {
        long l = this.clientHandle;
        GTK.gtk_widget_realize(l);
        return this.gtk_widget_get_window(l);
    }

    @Override
    long paintSurface() {
        long l = this.clientHandle;
        GTK.gtk_widget_realize(l);
        return this.gtk_widget_get_surface(l);
    }
}

