/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    long imContext;
    long gdkEventKey = 0L;
    long entryHandle;
    int fixStart = -1;
    int fixEnd = -1;
    double climbRate = 1.0;
    public static final int LIMIT = 65535;
    GdkRGBA background;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (GTK.GTK4) {
            GTK.gtk_widget_set_size_request(this.handle, n, n2);
            GtkRequisition gtkRequisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(this.handle, gtkRequisition, null);
            int n3 = n == -1 ? gtkRequisition.width : Math.max(n, gtkRequisition.width);
            int n4 = n2 == -1 ? gtkRequisition.height : n2;
            Rectangle rectangle = this.computeTrimInPixels(0, 0, n3, n4);
            return new Point(rectangle.width, rectangle.height);
        }
        GTK.gtk_widget_realize(this.handle);
        long l = GTK3.gtk_entry_get_layout(this.handle);
        long l2 = GTK.gtk_spin_button_get_adjustment(this.handle);
        double d = GTK.gtk_adjustment_get_upper(l2);
        int n5 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n5; ++i) {
            d *= 10.0;
        }
        String string = String.valueOf((int)d);
        if (n5 > 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append(this.getDecimalSeparator());
            for (int i = n5 - string.length(); i >= 0; --i) {
                ((StringBuilder)object).append("0");
            }
            string = ((StringBuilder)object).toString();
        }
        object = Converter.wcsToMbcs(string, false);
        long l3 = OS.pango_layout_get_text(l);
        int n6 = C.strlen(l3);
        byte[] byArray = new byte[n6];
        C.memmove(byArray, l3, (long)n6);
        OS.pango_layout_set_text(l, (byte[])object, ((Object)object).length);
        int n7 = 0;
        GTK.gtk_widget_realize(this.handle);
        GTK.gtk_widget_set_size_request(this.handle, n, n2);
        GtkRequisition gtkRequisition = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.handle, gtkRequisition, null);
        int n8 = n == -1 ? gtkRequisition.width : Math.max(n, gtkRequisition.width);
        n7 = n2 == -1 ? gtkRequisition.height : n2;
        OS.pango_layout_set_text(l, byArray, byArray.length);
        Rectangle rectangle = this.computeTrimInPixels(0, 0, n8, n7);
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        GtkBorder gtkBorder = new GtkBorder();
        long l = GTK.gtk_widget_get_style_context(this.handle);
        int n7 = GTK.gtk_widget_get_state_flags(this.handle);
        this.gtk_style_context_get_padding(l, n7, gtkBorder);
        if ((this.style & 0x800) != 0) {
            int n8 = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_border(l, n8, gtkBorder);
            rectangle.x -= gtkBorder.left;
            rectangle.y -= gtkBorder.top;
            rectangle.width += gtkBorder.left + gtkBorder.right;
            rectangle.height += gtkBorder.top + gtkBorder.bottom;
        }
        if (!GTK.GTK4) {
            int[] nArray = new int[1];
            GTK3.gtk_widget_style_get(this.handle, OS.interior_focus, nArray, 0L);
            if (nArray[0] == 0) {
                GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
                n5 += nArray[0];
                n6 += nArray[0];
            }
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        if (GTK.GTK4) {
            long l = GTK4.gtk_widget_get_first_child(this.entryHandle);
            GTK4.gtk_widget_activate_action(l, OS.action_copy_clipboard, null);
        } else {
            GTK3.gtk_editable_copy_clipboard(this.handle);
        }
    }

    @Override
    void createHandle(int n) {
        long l;
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0)) == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_spin_button_new(l, this.climbRate, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (DISABLE_EMOJI && GTK.GTK_VERSION >= OS.VERSION(3, 22, 20)) {
            GTK.gtk_entry_set_input_hints(this.handle, 1024);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
            this.entryHandle = GTK4.gtk_widget_get_first_child(this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_editable_set_editable(GTK.GTK4 ? this.entryHandle : this.handle, (this.style & 8) == 0);
        GTK.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
        this.imContext = OS.imContextLast();
        this.setFontDescription(this.defaultFont().handle);
    }

    public void cut() {
        this.checkWidget();
        if (GTK.GTK4) {
            long l = GTK4.gtk_widget_get_first_child(this.entryHandle);
            GTK4.gtk_widget_activate_action(l, OS.action_cut_clipboard, null);
        } else {
            GTK3.gtk_editable_cut_clipboard(this.handle);
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        long l = this.imContext();
        if (l != 0L) {
            this.display.removeWidget(l);
        }
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    long eventSurface() {
        return this.paintSurface();
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean filterKey(long l) {
        int n = GDK.gdk_event_get_time(l);
        if (n != this.lastEventTime) {
            this.lastEventTime = n;
            long l2 = this.imContext();
            if (l2 != 0L) {
                if (GTK.GTK4) {
                    return GTK4.gtk_im_context_filter_keypress(l2, l);
                }
                return GTK3.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            } else {
                GTK3.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            }
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if ((this.style & 0x800) != 0) {
            return this.getThickness((long)this.handle).x;
        }
        return 0;
    }

    public int getIncrement() {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        int n = GTK.gtk_spin_button_get_digits(this.handle);
        double d = GTK.gtk_adjustment_get_step_increment(l);
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        int n = GTK.gtk_spin_button_get_digits(this.handle);
        double d = GTK.gtk_adjustment_get_upper(l);
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        int n = GTK.gtk_spin_button_get_digits(this.handle);
        double d = GTK.gtk_adjustment_get_lower(l);
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        int n = GTK.gtk_spin_button_get_digits(this.handle);
        double d = GTK.gtk_adjustment_get_page_increment(l);
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        int n = GTK.gtk_spin_button_get_digits(this.handle);
        double d = GTK.gtk_adjustment_get_value(l);
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public String getText() {
        long l;
        this.checkWidget();
        if (GTK.GTK4) {
            long l2 = GTK4.gtk_text_get_buffer(this.entryHandle);
            l = GTK.gtk_entry_buffer_get_text(l2);
        } else {
            l = GTK3.gtk_entry_get_text(this.handle);
        }
        if (l == 0L) {
            return "";
        }
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = GTK.gtk_entry_get_max_length(GTK.GTK4 ? this.entryHandle : this.handle);
        return n == 0 ? LIMIT : n;
    }

    public int getDigits() {
        this.checkWidget();
        return GTK.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        long l = OS.localeconv_decimal_point();
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    @Override
    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_changed(long l) {
        long l2;
        int n;
        long l3;
        if (GTK.GTK4) {
            long l4 = GTK4.gtk_text_get_buffer(this.entryHandle);
            l3 = GTK.gtk_entry_buffer_get_text(l4);
        } else {
            l3 = GTK3.gtk_entry_get_text(this.handle);
        }
        int n2 = C.strlen(l3);
        if (n2 > 0) {
            long[] lArray = new long[1];
            double d = OS.g_strtod(l3, lArray);
            int n3 = n = this.getDigits() == 0 ? String.valueOf((int)d).length() : String.valueOf(d).length();
            if (lArray[0] == l3 + (long)n2 && n == n2) {
                long l5 = GTK.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment gtkAdjustment = new GtkAdjustment();
                this.gtk_adjustment_get(l5, gtkAdjustment);
                if (d != gtkAdjustment.value && gtkAdjustment.lower <= d && d <= gtkAdjustment.upper) {
                    GTK.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean bl = false;
        long l6 = l2 = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            n = GDK.gdk_event_get_event_type(l2);
            n = Spinner.fixGdkEventTypeValues(n);
            switch (n) {
                case 8: {
                    bl = true;
                }
            }
            this.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable(GTK.GTK4 ? this.entryHandle : this.handle)) {
            return 0L;
        }
        int n = C.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, 0L, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(GTK.GTK4 ? this.entryHandle : this.handle, this.fixStart);
            GTK.gtk_editable_select_region(GTK.GTK4 ? this.entryHandle : this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = GTK3.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(GTK.GTK4 ? this.entryHandle : this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(GTK.GTK4 ? this.entryHandle : this.handle, nArray[0]);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    @Override
    long gtk_insert_text(long l, long l2, long l3, long l4) {
        int n;
        String string;
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        C.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        int[] nArray = new int[1];
        C.memmove(nArray, l4, 4L);
        long l5 = GTK3.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf16_pointer_to_offset(l5, nArray[0]), n)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            GTK.gtk_editable_get_selection_bounds(GTK.GTK4 ? this.entryHandle : this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(GTK.GTK4 ? this.entryHandle : this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(GTK.GTK4 ? this.entryHandle : this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            C.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        return l3;
    }

    @Override
    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(l2, 2);
            GTK3.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_value_changed(long l) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    void hookEvents() {
        long l;
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
        if (GTK.GTK4) {
            l = GTK4.gtk_widget_get_first_child(this.handle);
            OS.g_signal_connect_closure(l, OS.activate, this.display.getClosure(1), false);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.handle);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    @Override
    long paintWindow() {
        long l = super.paintWindow();
        long l2 = GDK.gdk_window_get_children(l);
        if (l2 != 0L) {
            l = OS.g_list_data(l2);
        }
        OS.g_list_free(l2);
        return l;
    }

    @Override
    long paintSurface() {
        long l = super.paintSurface();
        return l;
    }

    public void paste() {
        this.checkWidget();
        GTK3.gtk_editable_paste_clipboard(GTK.GTK4 ? this.entryHandle : this.handle);
    }

    @Override
    void register() {
        super.register();
        long l = this.imContext();
        if (l != 0L) {
            this.display.addWidget(l, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA == null ? this.defaultBackground() : gdkRGBA;
        if (GTK.GTK4) {
            super.setBackgroundGdkRGBA(l, l2, gdkRGBA);
        } else {
            String string = this.display.gtk_rgba_to_css_string(this.background);
            String string2 = "spinbutton {background-image: -gtk-gradient (linear, 0 0, 0 1, color-stop(0, " + string + "), color-stop(1, " + string + "));}";
            this.cssBackground = string2;
            String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(l, string3);
        }
    }

    @Override
    void setCursor(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l2 = GTK.GTK4 ? GDK.gdk_cursor_new_from_name("xterm", 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "xterm");
        }
        super.setCursor(l != 0L ? l : l2);
        if (l == 0L) {
            OS.g_object_unref(l2);
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        double d = GTK.gtk_adjustment_get_page_increment(l);
        double d2 = n;
        int n2 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d2 /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_increments(this.handle, d2, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        double d = GTK.gtk_adjustment_get_lower(l);
        double d2 = n;
        int n2 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d2 /= 10.0;
        }
        if (d2 < d) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_range(this.handle, d, d2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        double d = GTK.gtk_adjustment_get_upper(l);
        double d2 = n;
        int n2 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d2 /= 10.0;
        }
        if (d2 > d) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_range(this.handle, d2, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        double d = GTK.gtk_adjustment_get_step_increment(l);
        double d2 = n;
        int n2 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d2 /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_increments(this.handle, d, d2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        double d = n;
        int n2 = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < n2; ++i) {
            d /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_value(this.handle, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        GTK.gtk_entry_set_max_length(GTK.GTK4 ? this.entryHandle : this.handle, n);
    }

    public void setDigits(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == (n2 = GTK.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(l, gtkAdjustment);
        int n3 = Math.abs(n - n2);
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            n4 *= 10;
        }
        if (n2 > n) {
            gtkAdjustment.value *= (double)n4;
            gtkAdjustment.upper *= (double)n4;
            gtkAdjustment.lower *= (double)n4;
            gtkAdjustment.step_increment *= (double)n4;
            gtkAdjustment.page_increment *= (double)n4;
            this.climbRate *= (double)n4;
        } else {
            gtkAdjustment.value /= (double)n4;
            gtkAdjustment.upper /= (double)n4;
            gtkAdjustment.lower /= (double)n4;
            gtkAdjustment.step_increment /= (double)n4;
            gtkAdjustment.page_increment /= (double)n4;
            this.climbRate /= (double)n4;
        }
        GTK.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_configure(this.handle, l, this.climbRate, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 < n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        double d = 1.0;
        for (int i = 0; i < n4; ++i) {
            d *= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        this.climbRate = 1.0 / d;
        long l = GTK.gtk_spin_button_get_adjustment(this.handle);
        GTK.gtk_spin_button_configure(this.handle, l, this.climbRate, n4);
        GTK.gtk_spin_button_set_range(this.handle, (double)n2 / d, (double)n3 / d);
        GTK.gtk_spin_button_set_increments(this.handle, (double)n5 / d, (double)n6 / d);
        GTK.gtk_spin_button_set_value(this.handle, (double)n / d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(long l) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l);
        } else {
            GDK.gdk_event_get_keyval(l, nArray);
        }
        switch (nArray[0]) {
            case 65293: 
            case 65421: {
                long l2 = this.imContext();
                if (l2 == 0L) break;
                long[] lArray = new long[1];
                GTK.gtk_im_context_get_preedit_string(l2, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n = C.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n == 0) break;
                return false;
            }
        }
        return super.translateTraversal(l);
    }

    String verifyText(String object, int n, int n2) {
        long l;
        double d;
        int n3;
        if (((String)object).length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = object;
        event.start = n;
        event.end = n2;
        long l2 = GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            n3 = GDK.gdk_event_get_event_type(l2);
            n3 = Spinner.fixGdkEventTypeValues(n3);
            switch (n3) {
                case 8: {
                    this.setKeyState(event, l2);
                }
            }
            this.gdk_event_free(l2);
        }
        n3 = 0;
        if (GTK.gtk_spin_button_get_digits(this.handle) > 0) {
            String string = this.getDecimalSeparator();
            n3 = ((String)object).indexOf(string);
            if (n3 != -1) {
                object = ((String)object).substring(0, n3) + ((String)object).substring(n3 + 1);
            }
            n3 = 0;
        }
        if (((String)object).length() > 0 && (d = GTK.gtk_adjustment_get_lower(l = GTK.gtk_spin_button_get_adjustment(this.handle))) < 0.0 && ((String)object).charAt(0) == '-') {
            ++n3;
        }
        while (n3 < ((String)object).length() && Character.isDigit(((String)object).charAt(n3))) {
            ++n3;
        }
        event.doit = n3 == ((String)object).length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

