/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.widgets.Display;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    static final int PNG_INTERLACE_METHOD_OFFSET = 28;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream inputStream) {
        if (inputStream == null) {
            SWT.error(4);
        }
        this.reset();
        ImageData[] imageDataArray = this.getImageDataArrayFromStream(inputStream);
        this.data = imageDataArray;
        return imageDataArray;
    }

    boolean isInterlacedPNG(byte[] byArray) {
        return byArray.length > 28 && byArray[28] != 0;
    }

    ImageData[] getImageDataArrayFromStream(InputStream inputStream) {
        long l = GDK.gdk_pixbuf_loader_new();
        ArrayList<ImageData> arrayList = new ArrayList<ImageData>();
        try {
            ImageData imageData;
            long l2;
            boolean bl;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream.transferTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                SWT.error(42);
            }
            long l3 = OS.g_malloc(byArray.length);
            C.memmove(l3, byArray, (long)byArray.length);
            long[] lArray = new long[1];
            GDK.gdk_pixbuf_loader_write(l, l3, byArray.length, lArray);
            if (lArray[0] != 0L) {
                if (OS.g_error_matches(lArray[0], OS.g_file_error_quark(), 21)) {
                    SWT.error(39, null, Display.extractFreeGError(lArray[0]));
                } else {
                    OS.g_error_free(lArray[0]);
                }
            }
            GDK.gdk_pixbuf_loader_close(l, null);
            long l4 = GDK.gdk_pixbuf_loader_get_animation(l);
            if (l4 == 0L) {
                SWT.error(40);
            }
            if (bl = GDK.gdk_pixbuf_animation_is_static_image(l4)) {
                l2 = GDK.gdk_pixbuf_animation_get_static_image(l4);
                imageData = ImageLoader.pixbufToImageData(l2);
                imageData.type = this.getImageFormat(l);
                arrayList.add(imageData);
            } else {
                l2 = OS.g_malloc(8L);
                OS.g_get_current_time(l2);
                long l5 = GDK.gdk_pixbuf_animation_get_iter(l4, l2);
                int n = 0;
                int n2 = 0;
                int n3 = 32;
                for (int i = 0; i < n3; ++i) {
                    n = GDK.gdk_pixbuf_animation_iter_get_delay_time(l5);
                    OS.g_time_val_add(l2, (n2 += n) * 1000);
                    boolean bl2 = GDK.gdk_pixbuf_animation_iter_advance(l5, l2);
                    if (!bl2) break;
                    long l6 = GDK.gdk_pixbuf_animation_iter_get_pixbuf(l5);
                    long l7 = GDK.gdk_pixbuf_copy(l6);
                    ImageData imageData2 = ImageLoader.pixbufToImageData(l7);
                    if (this.logicalScreenHeight == 0 && this.logicalScreenWidth == 0) {
                        this.logicalScreenHeight = imageData2.height;
                        this.logicalScreenWidth = imageData2.width;
                    }
                    OS.g_object_unref(l7);
                    imageData2.type = this.getImageFormat(l);
                    imageData2.delayTime = n;
                    arrayList.add(imageData2);
                }
            }
            ImageData[] imageDataArray = new ImageData[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                imageDataArray[i] = (ImageData)arrayList.get(i);
                imageData = (ImageData)imageDataArray[i].clone();
                if (!this.hasListeners() || imageDataArray == null) continue;
                if (imageData.type == 5 && this.isInterlacedPNG(byArray)) {
                    this.notifyListeners(new ImageLoaderEvent(this, imageData, i, true));
                    continue;
                }
                if (imageData.type == 5) continue;
                this.notifyListeners(new ImageLoaderEvent(this, imageData, i, true));
            }
            OS.g_free(l3);
            OS.g_object_unref(l);
            inputStream.close();
            return imageDataArray;
        }
        catch (IOException iOException) {
            SWT.error(39);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData[] load(String string) {
        if (string == null) {
            SWT.error(4);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            ImageData[] imageDataArray = this.load(fileInputStream);
            return imageDataArray;
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    ImageData[] loadFromFile(String string) {
        long l = ImageLoader.gdk_pixbuf_new_from_file(string);
        if (l == 0L) {
            return null;
        }
        ImageData imageData = ImageLoader.pixbufToImageData(l);
        this.data = new ImageData[]{imageData};
        return this.data;
    }

    int getImageFormat(long l) {
        long l2 = GDK.gdk_pixbuf_loader_get_format(l);
        long l3 = GDK.gdk_pixbuf_format_get_name(l2);
        String string = Converter.cCharPtrToJavaString(l3, false);
        OS.g_free(l3);
        switch (string) {
            case "bmp": {
                return 0;
            }
            case "gif": {
                return 2;
            }
            case "ico": {
                return 3;
            }
            case "jpeg": {
                return 4;
            }
            case "png": {
                return 5;
            }
            case "svg": {
                return 8;
            }
        }
        return -1;
    }

    static ImageData pixbufToImageData(long l) {
        boolean bl = GDK.gdk_pixbuf_get_has_alpha(l);
        int n = GDK.gdk_pixbuf_get_width(l);
        int n2 = GDK.gdk_pixbuf_get_height(l);
        int n3 = GDK.gdk_pixbuf_get_rowstride(l);
        int n4 = GDK.gdk_pixbuf_get_n_channels(l);
        int n5 = GDK.gdk_pixbuf_get_bits_per_sample(l);
        long l2 = GDK.gdk_pixbuf_get_pixels(l);
        int n6 = n * ((n4 * n5 + 7) / 8);
        byte[] byArray = new byte[n3 * n2];
        C.memmove(byArray, l2, (long)(n3 * (n2 - 1) + n6));
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, n5 * n4, paletteData, n3, byArray);
        if (bl) {
            imageData.alphaData = new byte[n * n2];
            byte[] byArray2 = imageData.alphaData;
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < n2; ++i) {
                int n9 = 0;
                while (n9 < n) {
                    byte by = byArray[n7 + 0];
                    byte by2 = byArray[n7 + 1];
                    byte by3 = byArray[n7 + 2];
                    byte by4 = byArray[n7 + 3];
                    byArray[n7 + 0] = 0;
                    byArray2[n8++] = by4;
                    if (by4 != 0) {
                        byArray[n7 + 1] = by;
                        byArray[n7 + 2] = by2;
                        byArray[n7 + 3] = by3;
                    }
                    ++n9;
                    n7 += n4;
                }
            }
        } else {
            int n10 = 0;
            for (int i = 0; i < n2; ++i) {
                int n11 = 0;
                while (n11 < n) {
                    byte by = byArray[n10 + 0];
                    byte by5 = byArray[n10 + 1];
                    byte by6 = byArray[n10 + 2];
                    byArray[n10 + 0] = by;
                    byArray[n10 + 1] = by5;
                    byArray[n10 + 2] = by6;
                    ++n11;
                    n10 += n4;
                }
            }
        }
        return imageData;
    }

    static long gdk_pixbuf_new_from_file(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        return GDK.gdk_pixbuf_new_from_file(byArray, null);
    }

    public void save(OutputStream outputStream, int n) {
        int n2;
        byte by;
        byte by2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (outputStream == null) {
            SWT.error(4);
        }
        if (n == -1) {
            SWT.error(42);
        }
        if (this.data == null) {
            SWT.error(4);
        }
        ImageData imageData = this.data[0];
        int n7 = 0;
        boolean bl = n == 6 || n == 5 || n == 3;
        boolean bl2 = imageData.alphaData != null && bl;
        int n8 = imageData.width;
        int n9 = imageData.height;
        int n10 = imageData.bytesPerLine / n8;
        if (!imageData.palette.isDirect || n10 < 3 || n10 > 4) {
            FileFormat.save(outputStream, n, this);
            return;
        }
        int n11 = 3;
        int n12 = 0;
        int n13 = 1;
        int n14 = 2;
        int n15 = 0;
        int n16 = 1;
        int n17 = 2;
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect && paletteData.blueShift < 0) {
            n15 = 2;
            n16 = 1;
            n17 = 0;
        }
        int n18 = 4;
        byte[] byArray = new byte[n8 * n9 * n18];
        int n19 = n6 = n10 == 4 ? 1 : 0;
        if (bl2) {
            int n20 = 0;
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < n9; ++n3) {
                int n21 = 0;
                while (n21 < n8) {
                    byte by3;
                    by2 = imageData.alphaData[n4++];
                    by = imageData.data[n20 + n6 + n15];
                    n2 = imageData.data[n20 + n6 + n16];
                    byArray[n5 + n14] = by3 = imageData.data[n20 + n6 + n17];
                    byArray[n5 + n13] = n2;
                    byArray[n5 + n12] = by;
                    byArray[n5 + n11] = by2;
                    ++n21;
                    n20 += n10;
                    n5 += n18;
                }
            }
        } else {
            int n22 = 0;
            n5 = 0;
            for (n3 = 0; n3 < n9; ++n3) {
                n4 = 0;
                while (n4 < n8) {
                    byte by4 = imageData.data[n22 + n6 + n15];
                    by2 = imageData.data[n22 + n6 + n16];
                    by = imageData.data[n22 + n6 + n17];
                    n2 = -1;
                    byArray[n5 + n14] = by;
                    byArray[n5 + n13] = by2;
                    byArray[n5 + n12] = by4;
                    byArray[n5 + n11] = n2;
                    ++n4;
                    n22 += n10;
                    n5 += n18;
                }
            }
        }
        long l = OS.g_malloc(byArray.length);
        C.memmove(l, byArray, (long)byArray.length);
        n5 = byArray.length / n9;
        long l2 = GDK.gdk_pixbuf_new_from_data(l, n7, true, 8, n8, n9, n5, 0L, 0L);
        if (l2 == 0L) {
            OS.g_free(l);
            SWT.error(4);
        }
        String string = "";
        switch (n) {
            case 1: {
                string = "bmp";
                break;
            }
            case 0: {
                string = "bmp";
                break;
            }
            case 2: {
                string = "gif";
                break;
            }
            case 3: {
                string = "ico";
                break;
            }
            case 4: {
                string = "jpeg";
                break;
            }
            case 5: {
                string = "png";
                break;
            }
            case 6: {
                string = "tiff";
                break;
            }
            case 8: {
                string = "svg";
            }
        }
        byte[] byArray2 = Converter.wcsToMbcs(string, true);
        long[] lArray = new long[1];
        if (byArray2 == null || string == "") {
            OS.g_free(l);
            SWT.error(42);
        }
        long[] lArray2 = new long[1];
        GDK.gdk_pixbuf_save_to_bufferv(l2, lArray, lArray2, byArray2, null, null, null);
        byte[] byArray3 = new byte[(int)lArray2[0]];
        C.memmove(byArray3, lArray[0], (long)byArray3.length);
        try {
            outputStream.write(byArray3);
        }
        catch (IOException iOException) {
            OS.g_free(l);
            SWT.error(39);
        }
        OS.g_free(l);
    }

    public void save(String string, int n) {
        if (string == null) {
            SWT.error(4);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.save(fileOutputStream, n);
        try {
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addImageLoaderListener(ImageLoaderListener imageLoaderListener) {
        if (imageLoaderListener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new ArrayList<ImageLoaderListener>();
        }
        this.imageLoaderListeners.add(imageLoaderListener);
    }

    public void removeImageLoaderListener(ImageLoaderListener imageLoaderListener) {
        if (imageLoaderListener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.remove(imageLoaderListener);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent imageLoaderEvent) {
        if (!this.hasListeners()) {
            return;
        }
        int n = this.imageLoaderListeners.size();
        for (int i = 0; i < n; ++i) {
            ImageLoaderListener imageLoaderListener = this.imageLoaderListeners.get(i);
            imageLoaderListener.imageDataLoaded(imageLoaderEvent);
        }
    }
}

