/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import com.fazecast.jSerialComm.SerialPort;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.FormatTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.io.DataParser;
import gde.io.LogViewReader;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import org.eclipse.swt.widgets.FileDialog;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsbException;

public class DeviceSerialPortSimulatorImpl
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = DeviceSerialPortSimulatorImpl.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    DataInputStream data_in;
    BufferedReader txt_in;
    int xferErrors = 0;
    int timeoutErrors = 0;
    boolean isConnected = false;
    String fileType = "*.lov";
    final IDevice device;
    final DataExplorer application;
    final Settings settings;
    final int sleepTime_ms;
    final boolean isTimeStepConstant;

    public DeviceSerialPortSimulatorImpl(IDevice currentDevice, DataExplorer currentApplication, boolean isTimeStepConstant, int timeStep_ms) {
        this.device = currentDevice;
        this.application = currentApplication;
        this.settings = Settings.getInstance();
        this.sleepTime_ms = timeStep_ms;
        this.isTimeStepConstant = isTimeStepConstant;
    }

    public SerialPort open() throws ApplicationConfigurationException, SerialPortException {
        try {
            if (this.application != null) {
                GDE.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String path;
                        if (DeviceSerialPortSimulatorImpl.this.application.isObjectoriented()) {
                            path = DeviceSerialPortSimulatorImpl.this.application.getObjectFilePath();
                        } else {
                            String devicePath = DeviceSerialPortSimulatorImpl.this.application.getActiveDevice() != null ? "/" + DeviceSerialPortSimulatorImpl.this.application.getActiveDevice().getName() : "";
                            String string = path = DeviceSerialPortSimulatorImpl.this.application.getActiveDevice() != null ? DeviceSerialPortSimulatorImpl.this.settings.getDataFilePath() + devicePath + "/" : DeviceSerialPortSimulatorImpl.this.settings.getDataFilePath();
                            if (!FileUtils.checkDirectoryAndCreate(path)) {
                                if (!FileUtils.checkDirectoryExist(path)) {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0056", new Object[]{path}));
                                } else {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0012", new Object[]{path}));
                                }
                            }
                        }
                        FileDialog openFileDialog = DeviceSerialPortSimulatorImpl.this.application.openFileOpenDialog("Open File used as simulation input", new String[]{"*.lov", "*.txt", "*.log"}, path, null, 4);
                        if (openFileDialog.getFileName().length() > 4) {
                            String openFilePath = (openFileDialog.getFilterPath() + "/" + openFileDialog.getFileName()).replace('\\', '/');
                            try {
                                if (openFilePath.toLowerCase().endsWith("osd")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.osd";
                                } else if (openFilePath.toLowerCase().endsWith("lov")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.lov";
                                    DeviceSerialPortSimulatorImpl.this.data_in = new DataInputStream(new FileInputStream(new File(openFilePath)));
                                    LogViewReader.readHeader(DeviceSerialPortSimulatorImpl.this.data_in);
                                    switch (DeviceSerialPortSimulatorImpl.this.application.getActiveDevice().getName()) {
                                        case "Robbe PowerPeak IV": {
                                            DeviceSerialPortSimulatorImpl.this.data_in.skip(6L);
                                            break;
                                        }
                                    }
                                } else if (openFilePath.toLowerCase().endsWith(".txt")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.txt";
                                    DeviceSerialPortSimulatorImpl.this.txt_in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(openFilePath), "ISO-8859-1"));
                                    DeviceSerialPortSimulatorImpl.this.txt_in.read();
                                } else if (openFilePath.toLowerCase().endsWith(".log")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.log";
                                    DeviceSerialPortSimulatorImpl.this.txt_in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(openFilePath), "ISO-8859-1"));
                                } else {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0008") + openFilePath);
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        DeviceSerialPortSimulatorImpl.this.isConnected = DeviceSerialPortSimulatorImpl.this.data_in != null || DeviceSerialPortSimulatorImpl.this.txt_in != null;
                        DeviceSerialPortSimulatorImpl.this.application.setPortConnected(DeviceSerialPortSimulatorImpl.this.isConnected);
                    }
                });
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.data_in != null) {
                this.data_in.close();
                this.data_in = null;
            }
            if (this.txt_in != null) {
                this.txt_in.close();
                this.txt_in = null;
            }
            if (this.isConnected) {
                this.isConnected = false;
            }
            if (this.application != null) {
                this.application.setPortConnected(false);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        try {
            this.wait4Bytes(timeout_msec);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (!this.isConnected) return readBuffer;
        if (this.data_in != null && this.fileType.equals("*.lov")) {
            if (this.data_in.read(readBuffer) <= 0) {
                readBuffer = new byte[]{};
                this.close();
                return readBuffer;
            }
            int size2Read = this.device.getLovDataByteSize() - Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
            if (this.data_in.read(new byte[size2Read]) != size2Read) {
                log.log(Level.WARNING, "expected byte size to  read does not macht really red size of bytes !");
            }
            if (!this.device.getName().toLowerCase().contains("4010duo")) return readBuffer;
            byte[] tmpBuffer = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
            System.arraycopy(readBuffer, 5, tmpBuffer, 0, tmpBuffer.length - 5);
            System.arraycopy(tmpBuffer, 0, readBuffer, 0, tmpBuffer.length);
            return readBuffer;
        }
        if (this.txt_in == null) return readBuffer;
        if (this.fileType.equals("*.txt")) {
            int value;
            StringBuffer sb = new StringBuffer();
            sb.append('\f');
            while ((value = this.txt_in.read()) != -1 && value != 12) {
                sb.append((char)value);
            }
            if (sb.length() > 1) {
                return sb.toString().getBytes();
            }
            this.close();
            return readBuffer;
        }
        if (!this.fileType.equals("*.log")) return readBuffer;
        String line = this.txt_in.readLine();
        if (line == null) {
            this.close();
            throw new EOFException();
        }
        while (!(line.contains("WARNING") || line.contains("Read") && line.length() > line.indexOf("Read") + 15 || (line = this.txt_in.readLine()) == null)) {
        }
        if (line != null && line.contains("Read")) {
            byte[] tmpData;
            boolean isQCdata = false;
            line = line.substring(line.indexOf("Read") + 15);
            StringTokenizer token = new StringTokenizer(line);
            StringBuffer sb = new StringBuffer();
            while (token.hasMoreElements()) {
                String nextByte = token.nextToken();
                if (nextByte.equals("02")) {
                    isQCdata = true;
                }
                sb.append(nextByte);
            }
            if (isQCdata) {
                sb.delete(0, sb.indexOf("02"));
                if (sb.length() > readBuffer.length * 2) {
                    sb.delete(readBuffer.length * 2, sb.length() - 1);
                } else if (sb.length() < readBuffer.length * 2) {
                    sb.append(StringHelper.byte2Hex2CharString(this.read(new byte[readBuffer.length - sb.length() / 2], 1000), readBuffer.length - sb.length() / 2));
                }
            }
            System.arraycopy(tmpData, 0, readBuffer, 0, (tmpData = StringHelper.convert2ByteArray(sb.toString())).length <= readBuffer.length ? tmpData.length : readBuffer.length);
            if (!log.isLoggable(Level.FINE)) return readBuffer;
            log.logp(java.util.logging.Level.FINER, $CLASS_NAME, "read", StringHelper.byte2FourDigitsIntegerString(readBuffer));
            log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBuffer.length));
            return readBuffer;
        }
        if (log.isLoggable(Level.TIME)) {
            log.logp(Level.TIME, $CLASS_NAME, "read()", "delay " + timeout_msec);
        }
        WaitTimer.delay(timeout_msec);
        throw new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        byte[] resultBuffer = new byte[]{};
        try {
            this.wait4Bytes(1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.isConnected) return readBuffer;
        if (!this.fileType.equals("*.txt")) return readBuffer;
        String line = this.txt_in.readLine();
        if (line == null) {
            this.close();
            return readBuffer;
        }
        while (!line.contains("[<]") && (line = this.txt_in.readLine()) != null) {
        }
        if (line != null && line.contains("[<]")) {
            line = line.substring(line.indexOf("[<]") + 19);
            StringTokenizer token = new StringTokenizer(line);
            StringBuffer sb = new StringBuffer();
            while (token.hasMoreElements()) {
                sb.append(token.nextToken());
            }
            System.arraycopy(resultBuffer, 0, readBuffer, 0, (resultBuffer = StringHelper.convert2ByteArray(sb.toString())).length < readBuffer.length ? resultBuffer.length : readBuffer.length);
            return readBuffer;
        }
        if (log.isLoggable(Level.TIME)) {
            log.logp(Level.TIME, $CLASS_NAME, "read()", "delay " + timeout_msec);
        }
        WaitTimer.delay(timeout_msec);
        throw new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        StringBuffer sb;
        String lastByte;
        boolean isDataEnd;
        String line;
        byte[] resultBuffer;
        block38: {
            block39: {
                Vector<Byte> tmpVector;
                boolean isNextGen;
                byte leader;
                block37: {
                    int size2Read;
                    byte[] tmpBuffer;
                    block36: {
                        byte tmpByte;
                        boolean isOF;
                        byte lastByte2;
                        byte[] lineEnding;
                        block35: {
                            resultBuffer = new byte[]{};
                            leader = (byte)this.device.getDataBlockLeader().charAt(0);
                            lineEnding = this.device.getDataBlockEnding();
                            isNextGen = this.device.getName().startsWith("next");
                            try {
                                this.waitForStableReceiveBuffer(readBuffer.length, timeout_msec, 100);
                            }
                            catch (InterruptedException e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                            if (!this.isConnected) {
                                throw new IOException("Connection closed by EOF");
                            }
                            if (this.data_in != null && this.fileType.equals("*.lov")) {
                                tmpVector = new Vector<Byte>();
                                lastByte2 = 0;
                                try {
                                    isOF = false;
                                    if (!isNextGen) break block35;
                                    while ((tmpByte = this.data_in.readByte()) != 255) {
                                        if (!isOF) {
                                            isOF = tmpByte == 58 && (lastByte2 == 49 || lastByte2 == 50);
                                        }
                                        tmpVector.add(tmpByte);
                                        if (!isOF || tmpByte != lineEnding[1] || lastByte2 != lineEnding[0]) {
                                            lastByte2 = tmpByte;
                                            continue;
                                        }
                                        break block36;
                                    }
                                    break block36;
                                }
                                catch (Exception e) {
                                    this.close();
                                    break block37;
                                }
                            }
                            if (this.txt_in == null) return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
                            if (!this.fileType.equals("*.txt")) {
                                if (!this.fileType.equals("*.log")) return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
                                line = this.txt_in.readLine();
                                if (line != null) {
                                    while (!line.contains("IRP_MJ_READ") && !line.contains("SUCCESS\tLength") && (line = this.txt_in.readLine()) != null) {
                                    }
                                    if (line != null && line.contains("IRP_MJ_READ") && line.contains("SUCCESS\tLength")) {
                                        isDataEnd = false;
                                        lastByte = "00";
                                        sb = new StringBuffer();
                                        break block38;
                                    } else {
                                        if (log.isLoggable(Level.TIME)) {
                                            log.logp(Level.TIME, $CLASS_NAME, "read()", "delay " + timeout_msec);
                                        }
                                        WaitTimer.delay(timeout_msec);
                                        throw new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
                                    }
                                }
                                this.close();
                                return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
                            }
                            break block39;
                        }
                        while ((tmpByte = this.data_in.readByte()) != 255) {
                            if (!isOF) {
                                isOF = tmpByte == leader;
                            }
                            tmpVector.add(tmpByte);
                            if (isOF && tmpByte == lineEnding[1] && lastByte2 == lineEnding[0]) break;
                            lastByte2 = tmpByte;
                        }
                    }
                    if (this.data_in.read(tmpBuffer = new byte[(size2Read = this.device.getLovDataByteSize() - Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))) > 0 ? size2Read : 0]) != size2Read) {
                        this.close();
                    } else {
                        for (byte tmp : tmpBuffer) {
                            tmpVector.add(tmp);
                        }
                    }
                }
                if (this.device.getDataBlockLeader().length() > 0) {
                    if (isNextGen) {
                        while (tmpVector.size() > 2 && ((Byte)tmpVector.get(0) != 49 || (Byte)tmpVector.get(0) != 50) && (Byte)tmpVector.get(1) != 58) {
                            tmpVector.remove(0);
                        }
                    } else {
                        while (tmpVector.size() > 2 && (Byte)tmpVector.get(0) != leader) {
                            tmpVector.remove(0);
                        }
                    }
                }
                if (tmpVector.size() != readBuffer.length) {
                    readBuffer = new byte[tmpVector.size()];
                    for (int i = 0; i < readBuffer.length; ++i) {
                        readBuffer[i] = (Byte)tmpVector.get(i);
                    }
                    return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
                } else {
                    for (int i = 0; i < readBuffer.length; ++i) {
                        readBuffer[i] = (Byte)tmpVector.get(i);
                    }
                }
                return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
            }
            while ((line = this.txt_in.readLine()) != null) {
                if (line.length() >= this.device.getDataBlockSize(FormatTypes.BYTE)) {
                    readBuffer = (line + "\r\n").getBytes();
                    return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
                }
                this.close();
            }
            return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
        }
        while (!isDataEnd && line != null) {
            line = line.substring(line.indexOf("SUCCESS\tLength") + 19);
            StringTokenizer token = new StringTokenizer(line);
            while (token.hasMoreElements() && !isDataEnd) {
                String nextByte = token.nextToken();
                if (lastByte.equals("0D") && nextByte.equals("0A")) {
                    isDataEnd = true;
                }
                lastByte = nextByte;
                sb.append(nextByte);
            }
            if (isDataEnd) continue;
            line = this.txt_in.readLine();
            while (!line.contains("IRP_MJ_READ") && !line.contains("SUCCESS\tLength") && (line = this.txt_in.readLine()) != null) {
            }
        }
        System.out.println(StringHelper.byte2CharString(sb.toString().getBytes(), sb.length()));
        readBuffer = StringHelper.convert2ByteArray(sb.toString());
        return resultBuffer.length <= readBuffer.length ? readBuffer : resultBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        try {
            this.wait4Bytes(readBuffer.length, timeout_msec);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (!this.isConnected) return readBuffer;
        if (this.data_in != null && this.fileType.equals("*.lov")) {
            if (this.data_in.read(readBuffer) > 0) {
                int size2Read = this.device.getLovDataByteSize() - Math.abs(this.device.getDataBlockSize(InputTypes.FILE_IO));
                if (this.data_in.read(new byte[size2Read]) == size2Read) return readBuffer;
                log.log(Level.WARNING, "expected byte size to  read does not macht really red size of bytes !");
                return readBuffer;
            } else {
                readBuffer = new byte[]{};
                this.close();
            }
            return readBuffer;
        } else {
            if (this.txt_in == null) return readBuffer;
            if (this.fileType.equals("*.txt")) {
                int value;
                StringBuffer sb = new StringBuffer();
                sb.append('\f');
                while ((value = this.txt_in.read()) != -1 && value != 12) {
                    sb.append((char)value);
                }
                if (sb.length() > 1) {
                    return sb.toString().getBytes();
                }
                this.close();
                return readBuffer;
            } else {
                if (!this.fileType.equals("*.log")) return readBuffer;
                String line = this.txt_in.readLine();
                if (line != null) {
                    while (!line.contains("WARNING") && !line.contains("Read  data:") && (line = this.txt_in.readLine()) != null) {
                    }
                    if (line != null && line.contains("Read  data:")) {
                        boolean isQCdata = false;
                        line = line.substring(line.indexOf("Read  data:") + 12);
                        StringTokenizer token = new StringTokenizer(line);
                        StringBuffer sb = new StringBuffer();
                        while (token.hasMoreElements()) {
                            String nextByte = token.nextToken();
                            if (nextByte.equals("02")) {
                                isQCdata = true;
                            }
                            sb.append(nextByte);
                        }
                        if (!isQCdata) return StringHelper.convert2ByteArray(sb.toString());
                        sb.delete(0, sb.indexOf("02"));
                        if (sb.length() > readBuffer.length * 2) {
                            sb.delete(readBuffer.length * 2, sb.length() - 1);
                            return StringHelper.convert2ByteArray(sb.toString());
                        } else {
                            if (sb.length() >= readBuffer.length * 2) return StringHelper.convert2ByteArray(sb.toString());
                            sb.append(StringHelper.byte2Hex2CharString(this.read(new byte[readBuffer.length - sb.length() / 2], 1000), readBuffer.length - sb.length() / 2));
                        }
                        return StringHelper.convert2ByteArray(sb.toString());
                    }
                    if (log.isLoggable(Level.TIME)) {
                        log.logp(Level.TIME, $CLASS_NAME, "read()", "delay " + timeout_msec);
                    }
                    WaitTimer.delay(timeout_msec);
                    throw new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
                }
                this.close();
            }
        }
        return readBuffer;
    }

    @Override
    public void write(byte[] writeBuffer) throws IOException {
    }

    @Override
    public synchronized void write(byte[] writeBuffer, long gap_ms) throws IOException {
        log.log(Level.WARNING, "write() not supported in simulation");
    }

    @Override
    public int cleanInputStream() throws IOException {
        log.log(Level.WARNING, "cleanInputStream() not supported in simulation");
        return 0;
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        WaitTimer.delay(this.getWaitTime());
        return 0L;
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        WaitTimer.delay(this.getWaitTime());
        return numBytes;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        WaitTimer.delay(this.getWaitTime());
        return expectedBytes;
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return this.isConnected ? 20 : 0;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public int getXferErrors() {
        return this.xferErrors;
    }

    @Override
    public void addXferError() {
        ++this.xferErrors;
    }

    @Override
    public int getTimeoutErrors() {
        return this.timeoutErrors;
    }

    @Override
    public void addTimeoutError() {
        ++this.timeoutErrors;
    }

    @Override
    public boolean isMatchAvailablePorts(String newSerialPortStr) {
        return true;
    }

    int getWaitTime() {
        int sleepTime = 0;
        Random randomGenerator = new Random(new Date().getTime());
        if (this.isTimeStepConstant) {
            sleepTime = this.sleepTime_ms;
        } else {
            while (sleepTime < this.sleepTime_ms / 2 || sleepTime > this.sleepTime_ms * 2) {
                sleepTime = randomGenerator.nextInt(this.sleepTime_ms);
            }
        }
        log.log(Level.TIME, "sleepTime : " + sleepTime + " ms");
        return sleepTime;
    }

    @Override
    public byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        return null;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        return 0;
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        return null;
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        return null;
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
    }

    @Override
    public UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        try {
            return (UsbInterface)this.open();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DeviceHandle openLibUsbPort(IDevice activeDevice) throws LibUsbException, UsbException {
        try {
            if (this.application != null) {
                GDE.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String path;
                        if (DeviceSerialPortSimulatorImpl.this.application.isObjectoriented()) {
                            path = DeviceSerialPortSimulatorImpl.this.application.getObjectFilePath();
                        } else {
                            String devicePath = DeviceSerialPortSimulatorImpl.this.application.getActiveDevice() != null ? "/" + DeviceSerialPortSimulatorImpl.this.application.getActiveDevice().getName() : "";
                            String string = path = DeviceSerialPortSimulatorImpl.this.application.getActiveDevice() != null ? DeviceSerialPortSimulatorImpl.this.settings.getDataFilePath() + devicePath + "/" : DeviceSerialPortSimulatorImpl.this.settings.getDataFilePath();
                            if (!FileUtils.checkDirectoryAndCreate(path)) {
                                if (!FileUtils.checkDirectoryExist(path)) {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0056", new Object[]{path}));
                                } else {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0012", new Object[]{path}));
                                }
                            }
                        }
                        FileDialog openFileDialog = DeviceSerialPortSimulatorImpl.this.application.openFileOpenDialog("Open File used as simulation input", new String[]{"*.lov", "*.txt", "*.log"}, path, null, 4);
                        if (openFileDialog.getFileName().length() > 4) {
                            String openFilePath = (openFileDialog.getFilterPath() + "/" + openFileDialog.getFileName()).replace('\\', '/');
                            try {
                                if (openFilePath.toLowerCase().endsWith("osd")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.osd";
                                } else if (openFilePath.toLowerCase().endsWith("lov")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.lov";
                                    DeviceSerialPortSimulatorImpl.this.data_in = new DataInputStream(new FileInputStream(new File(openFilePath)));
                                    LogViewReader.readHeader(DeviceSerialPortSimulatorImpl.this.data_in);
                                } else if (openFilePath.toLowerCase().endsWith(".txt")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.txt";
                                    DeviceSerialPortSimulatorImpl.this.txt_in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(openFilePath), "ISO-8859-1"));
                                    DeviceSerialPortSimulatorImpl.this.txt_in.read();
                                } else if (openFilePath.toLowerCase().endsWith(".log")) {
                                    DeviceSerialPortSimulatorImpl.this.fileType = "*.log";
                                    DeviceSerialPortSimulatorImpl.this.txt_in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(openFilePath), "ISO-8859-1"));
                                } else {
                                    DeviceSerialPortSimulatorImpl.this.application.openMessageDialog(Messages.getString("GDE_MSGI0008") + openFilePath);
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        DeviceSerialPortSimulatorImpl.this.isConnected = DeviceSerialPortSimulatorImpl.this.data_in != null || DeviceSerialPortSimulatorImpl.this.txt_in != null;
                        DeviceSerialPortSimulatorImpl.this.application.setPortConnected(DeviceSerialPortSimulatorImpl.this.isConnected);
                    }
                });
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
        this.close();
    }

    @Override
    public void closeLibUsbPort(DeviceHandle libUsbDeviceHanlde, boolean cacheSelectedUsbDevice) throws LibUsbException, UsbException {
        this.close();
    }

    @Override
    public int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        try {
            return this.read(data, timeout_msec).length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        try {
            this.wait4Bytes((int)timeout_ms);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        catch (TimeOutException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] readBuffer = new byte[data.length];
        if (this.isConnected) {
            try {
                if (this.data_in != null && this.fileType.equals("*.lov")) {
                    if (this.data_in.read(readBuffer) > 0) {
                        int size2Read = this.device.getLovDataByteSize() - Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
                        if (this.data_in.read(new byte[size2Read]) != size2Read) {
                            log.log(Level.WARNING, "expected byte size to  read does not macht really red size of bytes !");
                        }
                        if (this.device.getName().toLowerCase().contains("icharger")) {
                            byte[] tmpBuffer = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
                            System.arraycopy(readBuffer, 5, tmpBuffer, 0, tmpBuffer.length - 5);
                            System.arraycopy(tmpBuffer, 0, readBuffer, 0, tmpBuffer.length);
                            int timeStamp = DataParser.parse2Int(readBuffer, 3);
                            if (timeStamp % 5000 == 0) {
                                System.out.println(StringHelper.byte2Hex2CharString(readBuffer));
                                System.out.println("inject IR data");
                                byte[] irBuffer = new byte[57];
                                irBuffer[0] = -128;
                                irBuffer[1] = -12;
                                irBuffer[2] = 1;
                                irBuffer[3] = 101;
                                irBuffer[5] = 100;
                                irBuffer[7] = 99;
                                irBuffer[9] = 99;
                                irBuffer[11] = 101;
                                System.arraycopy(irBuffer, 0, readBuffer, 7, 57);
                                System.out.println(StringHelper.byte2Hex2CharString(readBuffer));
                            }
                        }
                    } else {
                        readBuffer = new byte[]{};
                        this.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.arraycopy(readBuffer, 0, data, 0, data.length);
        return readBuffer.length;
    }
}

