/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WebColorField;
import com.sun.javafx.scene.control.skin.InputFieldSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public class WebColorFieldSkin
extends InputFieldSkin {
    private InvalidationListener integerFieldValueListener = observable2 -> this.updateText();
    private boolean noChangeInValue = false;

    public WebColorFieldSkin(WebColorField webColorField) {
        super(webColorField);
        webColorField.valueProperty().addListener(this.integerFieldValueListener);
        this.getTextField().setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    @Override
    public WebColorField getSkinnable() {
        return (WebColorField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((WebColorField)this.control).valueProperty().removeListener(this.integerFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return string2.matches("#[a-fA-F0-9]{0,6}") || string2.matches("[a-fA-F0-9]{0,6}");
    }

    @Override
    protected void updateText() {
        Color color = ((WebColorField)this.control).getValue();
        if (color == null) {
            color = Color.BLACK;
        }
        this.getTextField().setText(Utils.formatHexString(color));
    }

    @Override
    protected void updateValue() {
        String string2;
        if (this.noChangeInValue) {
            return;
        }
        Color color = ((WebColorField)this.control).getValue();
        String string3 = string2 = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim().toUpperCase(Locale.ROOT);
        if (string2.matches("#[A-F0-9]{6}") || string2.matches("[A-F0-9]{6}")) {
            try {
                Color color2;
                Color color3 = color2 = string2.charAt(0) == '#' ? Color.web((String)string2) : Color.web((String)("#" + string2));
                if (!color2.equals((Object)color)) {
                    ((WebColorField)this.control).setValue(color2);
                } else {
                    this.noChangeInValue = true;
                    this.getTextField().setText(Utils.formatHexString(color2));
                    this.noChangeInValue = false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Failed to parse [" + string2 + "]");
            }
        }
    }
}

