/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;

public class StyleRange
extends TextStyle
implements Cloneable {
    public int start;
    public int length;
    public int fontStyle = 0;

    public StyleRange() {
    }

    public StyleRange(TextStyle textStyle) {
        super(textStyle);
    }

    public StyleRange(int n, int n2, Color color, Color color2) {
        super(null, color, color2);
        this.start = n;
        this.length = n2;
    }

    public StyleRange(int n, int n2, Color color, Color color2, int n3) {
        this(n, n2, color, color2);
        this.fontStyle = n3;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StyleRange) {
            StyleRange styleRange = (StyleRange)object;
            if (this.start != styleRange.start) {
                return false;
            }
            if (this.length != styleRange.length) {
                return false;
            }
            return this.similarTo(styleRange);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fontStyle;
    }

    boolean isVariableHeight() {
        return this.font != null || this.metrics != null && (this.metrics.ascent != 0 || this.metrics.descent != 0) || this.rise != 0;
    }

    public boolean isUnstyled() {
        if (this.font != null) {
            return false;
        }
        if (this.rise != 0) {
            return false;
        }
        if (this.metrics != null) {
            return false;
        }
        if (this.foreground != null) {
            return false;
        }
        if (this.background != null) {
            return false;
        }
        if (this.fontStyle != 0) {
            return false;
        }
        if (this.underline) {
            return false;
        }
        if (this.strikeout) {
            return false;
        }
        return this.borderStyle == 0;
    }

    public boolean similarTo(StyleRange styleRange) {
        if (!super.equals(styleRange)) {
            return false;
        }
        return this.fontStyle == styleRange.fontStyle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StyleRange {");
        stringBuilder.append(this.start);
        stringBuilder.append(", ");
        stringBuilder.append(this.length);
        stringBuilder.append(", fontStyle=");
        switch (this.fontStyle) {
            case 1: {
                stringBuilder.append("bold");
                break;
            }
            case 2: {
                stringBuilder.append("italic");
                break;
            }
            case 3: {
                stringBuilder.append("bold-italic");
                break;
            }
            default: {
                stringBuilder.append("normal");
            }
        }
        String string = super.toString();
        int n = string.indexOf(123);
        string = string.substring(n + 1);
        if (string.length() > 1) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

