/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextWriter;
import org.eclipse.swt.graphics.Color;

abstract class StyledTextWriterBase
extends TextWriter {
    final StyledText styledText;

    public StyledTextWriterBase(StyledText styledText, int n, int n2) {
        super(n, n2);
        this.styledText = styledText;
    }

    void writeEscaped(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        this.write(this.escapeText(string2));
    }

    @Override
    public void writeLine(String string, int n) {
        StyleRange[] styleRangeArray;
        int[] nArray;
        boolean bl;
        int n2;
        int n3;
        int n4;
        if (this.isClosed()) {
            SWT.error(39);
        }
        int n5 = this.styledText.content.getLineAtOffset(n);
        StyledTextEvent styledTextEvent = this.styledText.getLineStyleData(n, string);
        if (styledTextEvent != null) {
            n4 = styledTextEvent.verticalIndent;
            n3 = styledTextEvent.alignment;
            n2 = styledTextEvent.indent;
            bl = styledTextEvent.justify;
            nArray = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
        } else {
            n4 = this.styledText.renderer.getLineVerticalIndent(n5);
            n3 = this.styledText.renderer.getLineAlignment(n5, this.styledText.alignment);
            n2 = this.styledText.renderer.getLineIndent(n5, this.styledText.indent);
            bl = this.styledText.renderer.getLineJustify(n5, this.styledText.justify);
            nArray = this.styledText.renderer.getRanges(n, string.length());
            styleRangeArray = this.styledText.renderer.getStyleRanges(n, string.length(), false);
        }
        if (styleRangeArray == null) {
            styleRangeArray = new StyleRange[]{};
        }
        Color color = (styledTextEvent = this.styledText.getLineBackgroundData(n, string)) != null && styledTextEvent.lineBackground != null ? styledTextEvent.lineBackground : this.styledText.renderer.getLineBackground(n5, null);
        this.writeStyledLine(string, n, nArray, styleRangeArray, color, n2, n4, n3, bl);
    }

    void writeStyledLine(String string, int n, int[] nArray, StyleRange[] styleRangeArray, Color color, int n2, int n3, int n4, boolean bl) {
        int n5 = string.length();
        int n6 = this.getStart();
        int n7 = n6 - n;
        if (n7 >= n5) {
            return;
        }
        int n8 = Math.max(0, n7);
        String string2 = this.writeLineStart(color, n2, n3, n4, bl);
        int n9 = n6 + super.getCharCount();
        if (n >= n9) {
            return;
        }
        int n10 = Math.min(n5, n9 - n);
        int n11 = 0;
        for (int i = 0; i < styleRangeArray.length; ++i) {
            int n12;
            int n13;
            StyleRange styleRange = styleRangeArray[i];
            if (nArray != null) {
                n13 = nArray[i << 1] - n;
                n12 = n13 + nArray[(i << 1) + 1];
            } else {
                n13 = styleRange.start - n;
                n12 = n13 + styleRange.length;
            }
            if (n12 < n7) continue;
            if (n13 >= n10) break;
            if (n8 < n13) {
                this.writeEscaped(string, n8, n13);
                n11 += n13 - n8;
                n8 = n13;
            }
            String string3 = this.writeSpanStart(styleRange);
            int n14 = Math.min(n12, n10);
            n14 = Math.max(n14, n8);
            this.writeEscaped(string, n8, n14);
            n11 += n14 - n8;
            this.writeSpanEnd(string3);
            n8 = n14;
        }
        if (n8 < n10) {
            this.writeEscaped(string, n8, n10);
            n11 += n10 - n8;
        }
        if (n11 == 0) {
            this.writeEmptyLine();
        }
        this.writeLineEnd(string2);
    }

    abstract void writeHeader();

    abstract String escapeText(String var1);

    abstract String writeLineStart(Color var1, int var2, int var3, int var4, boolean var5);

    void writeLineEnd(String string) {
        this.write(string);
    }

    abstract void writeEmptyLine();

    abstract String writeSpanStart(StyleRange var1);

    void writeSpanEnd(String string) {
        this.write(string);
    }
}

