/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    boolean blink;
    boolean drawFlag;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, Canvas.checkStyle(n));
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    @Override
    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3;
        if (this.ime != null && (l3 = this.ime.gtk_button_press_event(l, l2)) != 0L) {
            return l3;
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_commit(long l, long l2) {
        long l3;
        if (this.ime != null && (l3 = this.ime.gtk_commit(l, l2)) != 0L) {
            return l3;
        }
        return super.gtk_commit(l, l2);
    }

    @Override
    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long l3 = super.gtk_draw(l, l2);
        this.drawCaretInFocus(l, l2);
        return l3;
    }

    void drawCaretInFocus(long l, long l2) {
        if (this.caret != null && this.blink && this.caret.isFocusCaret()) {
            this.drawCaret(l, l2);
            this.blink = false;
        }
    }

    private void drawCaret(long l, long l2) {
        if (this.isDisposed()) {
            return;
        }
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.drawFlag) {
            Cairo.cairo_save(l2);
            if (this.caret.image != null && !this.caret.image.isDisposed() && this.caret.image.mask == 0L) {
                Cairo.cairo_set_source_rgb(l2, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(l2, 23);
                long l3 = Cairo.cairo_get_target(l2);
                int n = 0;
                switch (Cairo.cairo_surface_get_type(l3)) {
                    case 0: {
                        n = Cairo.cairo_image_surface_get_width(l3);
                        break;
                    }
                    case 3: {
                        n = Cairo.cairo_xlib_surface_get_width(l3);
                    }
                }
                int n2 = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    n2 = this.getClientWidth() - n - n2;
                }
                Cairo.cairo_translate(l2, n2, this.caret.y);
                Cairo.cairo_set_source_surface(l2, this.caret.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(l2);
            } else {
                Cairo.cairo_set_source_rgb(l2, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(l2, 23);
                int n = this.caret.width;
                int n3 = this.caret.height;
                if (n <= 0) {
                    n = 1;
                }
                int n4 = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    n4 = this.getClientWidth() - n - n4;
                }
                Cairo.cairo_rectangle(l2, n4, this.caret.y, n, n3);
            }
            Cairo.cairo_fill(l2);
            Cairo.cairo_restore(l2);
            if (this.caret.embeddedInto == null) {
                this.drawFlag = false;
            }
        } else {
            this.drawFlag = true;
        }
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return l3;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return l3;
    }

    @Override
    long gtk_preedit_changed(long l) {
        long l2;
        if (this.ime != null && (l2 = this.ime.gtk_preedit_changed(l)) != 0L) {
            return l2;
        }
        return super.gtk_preedit_changed(l);
    }

    @Override
    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (GTK.GTK4) {
            return;
        }
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n3, n4, n5, n6));
        this.scrollInPixels(point.x, point.y, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void scrollInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Control control;
        boolean bl2;
        int n7;
        if ((this.style & 0x8000000) != 0) {
            n7 = this.getClientWidth();
            n3 = n7 - n5 - n3;
            n = n7 - n5 - n;
        }
        n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        long l = this.paintWindow();
        long l2 = GDK.gdk_window_get_visible_region(l);
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        cairo_rectangle_int_t2.x = n3;
        cairo_rectangle_int_t2.y = n4;
        long l3 = 0L;
        long l4 = 0L;
        if (GTK.GTK_IS_SCROLLED_WINDOW(this.scrolledHandle)) {
            l3 = GTK.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
            l4 = GTK.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        if (l3 != 0L) {
            this.gtk_widget_get_preferred_size(l3, gtkRequisition);
            if (gtkRequisition.height > 0) {
                cairo_rectangle_int_t2.y = n4 - gtkRequisition.height;
            }
        }
        if (l4 != 0L) {
            this.gtk_widget_get_preferred_size(l4, gtkRequisition);
            if (gtkRequisition.width > 0) {
                cairo_rectangle_int_t2.x = n3 - gtkRequisition.width;
            }
        }
        cairo_rectangle_int_t2.width = n5;
        cairo_rectangle_int_t2.height = n6;
        long l5 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
        Cairo.cairo_region_intersect(l5, l2);
        long l6 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
        Cairo.cairo_region_subtract(l6, l2);
        Cairo.cairo_region_translate(l6, n7, n8);
        cairo_rectangle_int_t cairo_rectangle_int_t3 = new cairo_rectangle_int_t();
        Cairo.cairo_region_get_extents(l5, cairo_rectangle_int_t3);
        if (cairo_rectangle_int_t3.width != 0 && cairo_rectangle_int_t3.height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            cairo_rectangle_int_t cairo_rectangle_int_t4;
            boolean bl4;
            long l7 = GDK.gdk_cairo_create(l);
            if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                GDK.gdk_cairo_set_source_window(l7, l, 0, 0);
            } else {
                Cairo.cairo_push_group(l7);
                GDK.gdk_cairo_set_source_window(l7, l, 0, 0);
                Cairo.cairo_paint(l7);
                Cairo.cairo_pop_group_to_source(l7);
            }
            object = new double[]{1.0, 0.0, 0.0, 1.0, -n7, -n8};
            Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(l7), (double[])object);
            Cairo.cairo_rectangle(l7, cairo_rectangle_int_t3.x + n7, cairo_rectangle_int_t3.y + n8, cairo_rectangle_int_t3.width, cairo_rectangle_int_t3.height);
            Cairo.cairo_clip(l7);
            Cairo.cairo_paint(l7);
            Cairo.cairo_destroy(l7);
            boolean bl5 = bl4 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2;
            if (bl4) {
                cairo_rectangle_int_t4 = new cairo_rectangle_int_t();
                cairo_rectangle_int_t4.x = n3;
                cairo_rectangle_int_t4.y = n4;
                cairo_rectangle_int_t4.width = n5;
                cairo_rectangle_int_t4.height = n6;
                Cairo.cairo_region_union_rectangle(l6, cairo_rectangle_int_t4);
            } else {
                int n9;
                cairo_rectangle_int_t4 = new cairo_rectangle_int_t();
                if (n7 != 0) {
                    n9 = n - n7;
                    if (n7 < 0) {
                        n9 = n + n5;
                    }
                    cairo_rectangle_int_t4.x = n9;
                    cairo_rectangle_int_t4.y = n4;
                    cairo_rectangle_int_t4.width = Math.abs(n7);
                    cairo_rectangle_int_t4.height = n6;
                    Cairo.cairo_region_union_rectangle(l6, cairo_rectangle_int_t4);
                }
                if (n8 != 0) {
                    n9 = n2 - n8;
                    if (n8 < 0) {
                        n9 = n2 + n6;
                    }
                    cairo_rectangle_int_t4.x = n3;
                    cairo_rectangle_int_t4.y = n9;
                    cairo_rectangle_int_t4.width = n5;
                    cairo_rectangle_int_t4.height = Math.abs(n8);
                    Cairo.cairo_region_union_rectangle(l6, cairo_rectangle_int_t4);
                }
            }
            GDK.gdk_window_invalidate_region(l, l6, bl);
        }
        Cairo.cairo_region_destroy(l2);
        Cairo.cairo_region_destroy(l5);
        Cairo.cairo_region_destroy(l6);
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                object = controlArray[i];
                Rectangle rectangle = ((Control)object).getBoundsInPixels();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) < Math.max(n3, rectangle.x) || Math.min(n4 + n6, rectangle.y + rectangle.height) < Math.max(n4, rectangle.y)) continue;
                ((Control)object).setLocationInPixels(rectangle.x + n7, rectangle.y + n8);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
        this.redraw(false);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return n5;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    void updateCaret() {
        long l = this.imHandle();
        if (l == 0L) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = this.caret.x;
        gdkRectangle.y = this.caret.y;
        gdkRectangle.width = this.caret.width;
        gdkRectangle.height = this.caret.height;
        GTK.gtk_im_context_set_cursor_location(l, gdkRectangle);
    }
}

