/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    long layoutText = 0L;
    long layoutMessage = 0L;
    long provider;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget(0);
        shell.addToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        int n;
        long l;
        if (GTK.GTK4) {
            System.err.println("SWT Error: ToolTip.java: ToolTip with style SWT.BALLOON not supported on GTK 4.");
            return;
        }
        GTK.gtk_widget_realize(this.handle);
        Point point = this.getLocation();
        GdkRectangle gdkRectangle = new GdkRectangle();
        long l2 = GDK.gdk_display_get_default();
        boolean bl = GTK.GTK4 ? OS.g_list_model_get_n_items(l = GDK.gdk_display_get_monitors(l2)) > 1 : GDK.gdk_display_get_n_monitors(l2) > 1;
        l = GDK.gdk_display_get_monitor_at_point(l2, point.x, point.y);
        GDK.gdk_monitor_get_geometry(l, gdkRectangle);
        point = this.getSize(gdkRectangle.width / 4);
        int n2 = point.x;
        int n3 = point.y;
        point = this.getLocation();
        int n4 = point.x;
        int n5 = point.y;
        GTK3.gtk_window_resize(this.handle, n2, n3 + 20);
        Rectangle rectangle = this.display.getBounds();
        int n6 = rectangle != null && GTK.GTK4 ? rectangle.width : GDK.gdk_screen_width();
        boolean bl2 = this.spikeAbove = gdkRectangle.height >= n5 + n3 + 20;
        if (gdkRectangle.width >= n4 + n2 || bl && n6 >= n4 + n2) {
            if (gdkRectangle.height >= n5 + n3 + 20) {
                n = 20;
                nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, 16, n, 16, 0, 35, n, n2 - 5, n, n2 - 5, 1 + n, n2 - 3, 1 + n, n2 - 1, 3 + n, n2 - 1, 5 + n, n2, 5 + n, n2, n3 - 5 + n, n2 - 1, n3 - 5 + n, n2 - 1, n3 - 3 + n, n2 - 2, n3 - 3 + n, n2 - 2, n3 - 2 + n, n2 - 3, n3 - 2 + n, n2 - 3, n3 - 1 + n, n2 - 5, n3 - 1 + n, n2 - 5, n3 + n, 5, n3 + n, 5, n3 - 1 + n, 3, n3 - 1 + n, 3, n3 - 2 + n, 2, n3 - 2 + n, 2, n3 - 3 + n, 1, n3 - 3 + n, 1, n3 - 5 + n, 0, n3 - 5 + n, 0, 5 + n};
                this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, 16, n, 16, 1, 35, n, n2 - 6, 0 + n, n2 - 5, 1 + n, n2 - 4, 1 + n, n2 - 2, 3 + n, n2 - 2, 4 + n, n2 - 1, 5 + n, n2 - 1, n3 - 6 + n, n2 - 2, n3 - 5 + n, n2 - 2, n3 - 4 + n, n2 - 4, n3 - 2 + n, n2 - 5, n3 - 2 + n, n2 - 6, n3 - 1 + n, 5, n3 - 1 + n, 4, n3 - 2 + n, 3, n3 - 2 + n, 1, n3 - 4 + n, 1, n3 - 5 + n, 0, n3 - 6 + n, 0, 5 + n};
                if ((this.parent.style & 0x8000000) != 0) {
                    n4 -= n2 - 36;
                    nArray[12] = n2 - 36;
                    nArray[14] = n2 - 16;
                    nArray[16] = n2 - 15;
                    this.borderPolygon[12] = n2 - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = n2 - 16;
                }
                GTK3.gtk_window_move(this.handle, Math.max(0, n4 - 17), n5);
            } else {
                nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n2 - 5, 0, n2 - 5, 1, n2 - 3, 1, n2 - 1, 3, n2 - 1, 5, n2, 5, n2, n3 - 5, n2 - 1, n3 - 5, n2 - 1, n3 - 3, n2 - 2, n3 - 3, n2 - 2, n3 - 2, n2 - 3, n3 - 2, n2 - 3, n3 - 1, n2 - 5, n3 - 1, n2 - 5, n3, 35, n3, 16, n3 + 20, 16, n3, 5, n3, 5, n3 - 1, 3, n3 - 1, 3, n3 - 2, 2, n3 - 2, 2, n3 - 3, 1, n3 - 3, 1, n3 - 5, 0, n3 - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n2 - 6, 0, n2 - 5, 1, n2 - 4, 1, n2 - 2, 3, n2 - 2, 4, n2 - 1, 5, n2 - 1, n3 - 6, n2 - 2, n3 - 5, n2 - 2, n3 - 4, n2 - 4, n3 - 2, n2 - 5, n3 - 2, n2 - 6, n3 - 1, 35, n3 - 1, 17, n3 + 20 - 2, 17, n3 - 1, 5, n3 - 1, 4, n3 - 2, 3, n3 - 2, 1, n3 - 4, 1, n3 - 5, 0, n3 - 6, 0, 5};
                if ((this.parent.style & 0x8000000) != 0) {
                    n4 -= n2 - 36;
                    nArray[42] = nArray[44] = n2 - 16;
                    nArray[46] = n2 - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = n2 - 17;
                    this.borderPolygon[40] = n2 - 35;
                }
                GTK3.gtk_window_move(this.handle, Math.max(0, n4 - 17), n5 - n3 - 20);
            }
        } else if (gdkRectangle.height >= n5 + n3 + 20) {
            n = 20;
            nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, n2 - 35, n, n2 - 16, 0, n2 - 16, n, n2 - 5, n, n2 - 5, 1 + n, n2 - 3, 1 + n, n2 - 1, 3 + n, n2 - 1, 5 + n, n2, 5 + n, n2, n3 - 5 + n, n2 - 1, n3 - 5 + n, n2 - 1, n3 - 3 + n, n2 - 2, n3 - 3 + n, n2 - 2, n3 - 2 + n, n2 - 3, n3 - 2 + n, n2 - 3, n3 - 1 + n, n2 - 5, n3 - 1 + n, n2 - 5, n3 + n, 5, n3 + n, 5, n3 - 1 + n, 3, n3 - 1 + n, 3, n3 - 2 + n, 2, n3 - 2 + n, 2, n3 - 3 + n, 1, n3 - 3 + n, 1, n3 - 5 + n, 0, n3 - 5 + n, 0, 5 + n};
            this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, n2 - 35, n, n2 - 17, 2, n2 - 17, n, n2 - 6, n, n2 - 5, 1 + n, n2 - 4, 1 + n, n2 - 2, 3 + n, n2 - 2, 4 + n, n2 - 1, 5 + n, n2 - 1, n3 - 6 + n, n2 - 2, n3 - 5 + n, n2 - 2, n3 - 4 + n, n2 - 4, n3 - 2 + n, n2 - 5, n3 - 2 + n, n2 - 6, n3 - 1 + n, 5, n3 - 1 + n, 4, n3 - 2 + n, 3, n3 - 2 + n, 1, n3 - 4 + n, 1, n3 - 5 + n, 0, n3 - 6 + n, 0, 5 + n};
            if ((this.parent.style & 0x8000000) != 0) {
                n4 += n2 - 35;
                nArray[14] = 16;
                nArray[12] = 16;
                nArray[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            GTK3.gtk_window_move(this.handle, Math.max(gdkRectangle.width - n2, n4 - n2 + 17), n5);
        } else {
            nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n2 - 5, 0, n2 - 5, 1, n2 - 3, 1, n2 - 1, 3, n2 - 1, 5, n2, 5, n2, n3 - 5, n2 - 1, n3 - 5, n2 - 1, n3 - 3, n2 - 2, n3 - 3, n2 - 2, n3 - 2, n2 - 3, n3 - 2, n2 - 3, n3 - 1, n2 - 5, n3 - 1, n2 - 5, n3, n2 - 16, n3, n2 - 16, n3 + 20, n2 - 35, n3, 5, n3, 5, n3 - 1, 3, n3 - 1, 3, n3 - 2, 2, n3 - 2, 2, n3 - 3, 1, n3 - 3, 1, n3 - 5, 0, n3 - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n2 - 6, 0, n2 - 5, 1, n2 - 4, 1, n2 - 2, 3, n2 - 2, 4, n2 - 1, 5, n2 - 1, n3 - 6, n2 - 2, n3 - 5, n2 - 2, n3 - 4, n2 - 4, n3 - 2, n2 - 5, n3 - 2, n2 - 6, n3 - 1, n2 - 17, n3 - 1, n2 - 17, n3 + 20 - 2, n2 - 36, n3 - 1, 5, n3 - 1, 4, n3 - 2, 3, n3 - 2, 1, n3 - 4, 1, n3 - 5, 0, n3 - 6, 0, 5};
            if ((this.parent.style & 0x8000000) != 0) {
                n4 += n2 - 35;
                nArray[42] = 35;
                nArray[46] = 16;
                nArray[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            GTK3.gtk_window_move(this.handle, Math.max(gdkRectangle.width - n2, n4 - n2 + 17), n5 - n3 - 20);
        }
        GTK.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(DPIUtil.autoScaleDown(nArray));
        GTK3.gtk_widget_shape_combine_region(this.handle, region.handle);
        region.dispose();
    }

    @Override
    void createHandle(int n) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            if (!GTK.GTK4) {
                this.handle = GTK3.gtk_window_new(1);
                Color color = this.display.getSystemColor(29);
                long l = GTK.gtk_widget_get_style_context(this.handle);
                GdkRGBA gdkRGBA = color.handle;
                String string = "window {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}";
                this.gtk_css_provider_load_from_css(l, string);
                GTK3.gtk_style_context_invalidate(l);
                GTK3.gtk_window_set_type_hint(this.handle, 10);
            }
        }
    }

    void gtk_css_provider_load_from_css(long l, String string) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(l, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(string, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(string, true), -1L, null);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    @Override
    void destroyWidget() {
        long l = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (l != 0L && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                if (GTK.GTK4) {
                    OS.g_object_unref(l);
                } else {
                    GTK3.gtk_widget_destroy(l);
                }
            } else {
                OS.g_object_unref(l);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int n = this.x;
        int n2 = this.y;
        if (this.item != null) {
            long l = this.item.handle;
            GdkRectangle gdkRectangle = new GdkRectangle();
            GTK3.gtk_status_icon_get_geometry(l, 0L, gdkRectangle, 0L);
            n = gdkRectangle.x + gdkRectangle.width / 2;
            n2 = gdkRectangle.y + gdkRectangle.height / 2;
        }
        if (n == -1 || n2 == -1) {
            if (GTK.GTK4) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                this.display.getPointerPosition(dArray, dArray2);
                n = (int)dArray[0];
                n2 = (int)dArray2[0];
            } else {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.display.getWindowPointerPosition(0L, nArray, nArray2, null);
                n = nArray[0];
                n2 = nArray2[0];
            }
        }
        return new Point(n, n2);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n2 = nArray[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n3 = nArray[0];
        }
        int n4 = 28;
        boolean bl = this.layoutText != 0L && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, (n - n5) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n7 = nArray2[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, (n - n4) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n8 = nArray2[0];
        }
        int n9 = 20 + n8;
        if (this.layoutText != 0L) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return GTK.gtk_widget_get_visible(this.handle);
        }
        return false;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0L;
    }

    void drawTooltip(long l) {
        int n;
        int n2;
        int n3 = 10;
        int n4 = 10;
        if (l == 0L) {
            this.error(2);
        }
        if ((n2 = this.borderPolygon.length / 2) != 0) {
            Cairo.cairo_set_line_width(l, 1.0);
            Cairo.cairo_move_to(l, this.borderPolygon[0], this.borderPolygon[1]);
            int n5 = 1;
            n = 2;
            while (n5 < n2) {
                Cairo.cairo_line_to(l, (double)this.borderPolygon[n] + 0.5, (double)this.borderPolygon[n + 1] + 0.5);
                ++n5;
                n += 2;
            }
            Cairo.cairo_close_path(l);
            Cairo.cairo_stroke(l);
        }
        if (this.spikeAbove) {
            n4 += 20;
        }
        if (this.layoutText != 0L) {
            byte[] byArray = null;
            n = this.style & 0xB;
            switch (n) {
                case 1: {
                    byArray = Converter.wcsToMbcs("dialog-error", true);
                    break;
                }
                case 2: {
                    byArray = Converter.wcsToMbcs("dialog-information", true);
                    break;
                }
                case 8: {
                    byArray = Converter.wcsToMbcs("dialog-warning", true);
                }
            }
            if (byArray != null) {
                long l2 = GTK.GTK4 ? GTK4.gtk_icon_theme_get_for_display(GDK.gdk_display_get_default()) : GTK3.gtk_icon_theme_get_default();
                long l3 = GTK3.gtk_icon_theme_load_icon(l2, byArray, 1, 0, 0L);
                GDK.gdk_cairo_set_source_pixbuf(l, l3, n3, n4);
                Cairo.cairo_paint(l);
                OS.g_object_unref(l3);
                n3 += 16;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            Color color = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(l, color.handle);
            Cairo.cairo_move_to(l, n3 += 4, n4);
            OS.pango_cairo_show_layout(l, this.layoutText);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n4 += 10 + Math.max(16, nArray2[0]);
        }
        if (this.layoutMessage != 0L) {
            n3 = 14;
            Color color = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(l, color.handle);
            Cairo.cairo_move_to(l, n3, n4);
            OS.pango_cairo_show_layout(l, this.layoutMessage);
        }
    }

    @Override
    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(l2);
        return 0L;
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        Point point = this.getLocation();
        int n = point.x;
        int n2 = point.y;
        GTK.gtk_widget_realize(l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        long l3 = GDK.gdk_display_get_default();
        long l4 = GDK.gdk_display_get_monitor_at_point(l3, n, n2);
        GDK.gdk_monitor_get_geometry(l4, gdkRectangle);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        if (gdkRectangle.height < n2 + n4) {
            n2 -= n4;
        }
        if (gdkRectangle.width < n + n3) {
            n -= n3;
        }
        GTK3.gtk_window_move(l, n, n2);
        return 0L;
    }

    @Override
    void hookEvents() {
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[19], 0, this.display.getClosure(19), true);
            if (GTK.GTK4) {
                long l = GTK4.gtk_gesture_click_new();
                GTK4.gtk_widget_add_controller(this.handle, l);
                OS.g_signal_connect(l, OS.pressed, this.display.gesturePressReleaseProc, 100L);
            } else {
                GTK3.gtk_widget_add_events(this.handle, 256);
                OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.getClosure(2), false);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setLocation(new Point(n, n2));
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        if ((this.style & 0x1000) != 0 && GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(point));
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocationInPixels(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.message.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(this.message, true);
            this.layoutMessage = GTK.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.text.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(this.text, true);
            this.layoutText = GTK.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            long l = OS.pango_attr_weight_new(700);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, l, (long)PangoAttribute.sizeof);
            pangoAttribute.start_index = 0;
            pangoAttribute.end_index = byArray.length;
            OS.memmove(l, pangoAttribute, (long)PangoAttribute.sizeof);
            long l2 = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(l2, l);
            OS.pango_layout_set_attributes(this.layoutText, l2);
            OS.pango_attr_list_unref(l2);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (bl) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                GTK.gtk_widget_show(this.handle);
            } else {
                long l = this.parent.vboxHandle;
                StringBuilder stringBuilder = new StringBuilder(this.text);
                if (this.text.length() > 0) {
                    stringBuilder.append("\n\n");
                }
                stringBuilder.append(this.message);
                byte[] byArray = Converter.wcsToMbcs(stringBuilder.toString(), true);
                GTK.gtk_widget_set_tooltip_text(l, byArray);
            }
            if (this.autohide) {
                this.timerId = GTK.GTK4 ? OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle) : GDK.gdk_threads_add_timeout(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            GTK.gtk_widget_hide(this.handle);
        } else {
            long l = this.parent.vboxHandle;
            byte[] byArray = Converter.wcsToMbcs("", true);
            GTK.gtk_widget_set_tooltip_text(l, byArray);
        }
    }

    @Override
    long timerProc(long l) {
        if ((this.style & 0x1000) != 0) {
            GTK.gtk_widget_hide(this.handle);
        }
        return 0L;
    }
}

