/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    long imageHandle;
    long tooltipsHandle;
    ImageList imageList;
    Image highlightImage;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        this.createWidget(tray.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.parent.createItem(this, n);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.handle = GTK3.gtk_status_icon_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        this.imageHandle = GTK.gtk_image_new();
        GTK3.gtk_status_icon_set_visible(this.handle, true);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long l) {
        this.sendSelectionEvent(13);
        long l2 = GDK.gdk_event_peek();
        if (l2 != 0L) {
            int n = GDK.GDK_EVENT_TYPE(l2);
            long l3 = GTK3.gtk_get_current_event();
            int n2 = 0;
            if (l3 != 0L) {
                n2 = GDK.GDK_EVENT_TYPE(l3);
                this.gdk_event_free(l3);
            }
            this.gdk_event_free(l2);
            n2 = Control.fixGdkEventTypeValues(n2);
            n = Control.fixGdkEventTypeValues(n);
            if (n2 == 4 && n == 5) {
                this.sendSelectionEvent(14);
            }
        }
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        int[] nArray = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        if (n == 6) {
            return 0L;
        }
        if (nArray[0] == 3 && n == 4) {
            this.sendEvent(35);
            return 0L;
        }
        if (n == 5) {
            this.sendSelectionEvent(14);
        } else {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        switch (n) {
            case 1: {
                int n2 = GDK.gdk_button_event_get_button(l2);
                if (n2 == 3) {
                    this.sendEvent(35);
                    break;
                }
                this.sendEvent(13);
                break;
            }
            case 2: {
                this.sendSelectionEvent(14);
                break;
            }
        }
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        return 0L;
    }

    @Override
    long gtk_status_icon_popup_menu(long l, long l2, long l3) {
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        return 0L;
    }

    @Override
    void hookEvents() {
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.popup_menu, this.display.getClosure(63), false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return GTK3.gtk_status_icon_get_visible(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_object_unref(this.handle);
        }
        this.imageHandle = 0L;
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        this.highlightImage = null;
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        if (image != null) {
            int n;
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((n = this.imageList.indexOf(image)) == -1) {
                n = this.imageList.add(image);
            } else {
                this.imageList.put(n, image);
            }
            long l = ImageList.createPixbuf(image);
            GTK3.gtk_status_icon_set_from_pixbuf(this.handle, l);
            GTK3.gtk_status_icon_set_visible(this.handle, true);
        } else {
            GTK.gtk_widget_set_size_request(this.handle, 1, 1);
            GTK3.gtk_status_icon_set_from_pixbuf(this.handle, 0L);
            GTK3.gtk_status_icon_set_visible(this.handle, false);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = Converter.wcsToMbcs(string, true);
        }
        GTK3.gtk_status_icon_set_tooltip_text(this.handle, byArray);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (GTK3.gtk_status_icon_get_visible(this.handle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            GTK3.gtk_status_icon_set_visible(this.handle, bl);
        } else {
            GTK3.gtk_status_icon_set_visible(this.handle, bl);
            this.sendEvent(23);
        }
    }
}

