/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    long headerButtonCSSProvider = 0L;
    long labelHandle;
    long imageHandle;
    long buttonHandle;
    Tree parent;
    int modelIndex;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    String toolTipText;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        this.createWidget(tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        this.createWidget(n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        return GTK.gtk_tree_view_column_get_fixed_width(this.handle);
    }

    @Override
    long gtk_clicked(long l) {
        boolean bl = false;
        long l2 = GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            int n = GDK.gdk_event_get_event_type(l2);
            int n2 = GDK.gdk_event_get_time(l2);
            if (n == 7) {
                int n3 = this.display.getDoubleClickTime();
                if (this.lastTime != 0 && Math.abs(this.lastTime - n2) <= n3) {
                    bl = true;
                }
                this.lastTime = n2 == 0 ? 1 : n2;
            }
            this.gdk_event_free(l2);
        }
        this.sendSelectionEvent(bl ? 14 : 13);
        return 0L;
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        boolean bl = n >= 2;
        this.sendSelectionEvent(bl ? 14 : 13);
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Control.fixGdkEventTypeValues(n);
        switch (n) {
            case 4: {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                }
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                if (nArray[0] != 3) break;
                this.parent.showMenu((int)dArray[0], (int)dArray2[0]);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.width;
        if (n != this.lastX) {
            this.lastX = n;
            this.sendEvent(10);
        }
        if (n2 != this.lastWidth) {
            this.lastWidth = n2;
            this.sendEvent(11);
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            long l = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.buttonHandle, l);
            GTK.gtk_event_controller_set_propagation_phase(l, 1);
            OS.g_signal_connect(l, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        }
        if (this.buttonHandle != 0L && !GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        Object object;
        int n;
        this.checkWidget();
        int n2 = 0;
        if (this.buttonHandle != 0L) {
            n = GTK.gtk_widget_get_visible(this.buttonHandle);
            if (n == 0) {
                GTK.gtk_widget_set_visible(this.buttonHandle, true);
            }
            object = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.buttonHandle, (GtkRequisition)object);
            n2 = ((GtkRequisition)object).width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            for (n = 0; n < this.parent.items.length; ++n) {
                object = this.parent.items[n];
                if (object == null || !((TreeItem)object).cached) continue;
                n2 = Math.max(n2, this.parent.calculateWidth(this.handle, ((TreeItem)object).handle, true));
            }
        } else {
            long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.parent.modelHandle, l)) {
                do {
                    n2 = Math.max(n2, this.parent.calculateWidth(this.handle, l, true));
                } while (GTK.gtk_tree_model_iter_next(this.parent.modelHandle, l));
            }
            OS.g_free(l);
        }
        this.setWidthInPixels(n2);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.buttonHandle = 0L;
        this.handle = 0L;
        this.modelIndex = -1;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, n2 == 0, this.style);
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.labelHandle, l);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.headerImageList;
            if (imageList == null) {
                imageList = this.parent.headerImageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            }
            if (GTK.GTK4) {
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(n));
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_image_clear(this.imageHandle);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_reorderable(this.handle, bl);
    }

    @Override
    void setOrientation(boolean bl) {
        if (!((this.parent.style & 0x4000000) == 0 && bl || this.buttonHandle == 0L)) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.buttonHandle, n);
            GTK3.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, n);
        }
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_resizable(this.handle, bl);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        } else {
            GTK.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.setToolTipText(this.buttonHandle, string);
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n));
    }

    void setWidthInPixels(int n) {
        long l;
        long l2;
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.lastWidth) {
            return;
        }
        if (n > 0) {
            GTK.gtk_tree_view_column_set_fixed_width(this.handle, n);
        }
        if (n != 0) {
            GTK.gtk_widget_realize(this.parent.handle);
        }
        GTK.gtk_tree_view_column_set_visible(this.handle, n != 0);
        this.lastWidth = n;
        if (n != 0 && this.buttonHandle != 0L && !GTK.GTK4 && (l2 = GTK.gtk_widget_get_parent_window(this.buttonHandle)) != 0L && (l = GDK.gdk_window_get_children(l2)) != 0L) {
            long l3 = l;
            long[] lArray = new long[1];
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                GDK.gdk_window_get_user_data(l4, lArray);
                if (lArray[0] == this.buttonHandle) {
                    GDK.gdk_window_lower(l4);
                    break;
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l);
        }
        this.sendEvent(11);
    }

    void setHeaderCSS(String string) {
        if (this.headerButtonCSSProvider == 0L) {
            this.headerButtonCSSProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(this.buttonHandle), this.headerButtonCSSProvider, 600);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.headerButtonCSSProvider, Converter.javaStringToCString(string), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.headerButtonCSSProvider, Converter.javaStringToCString(string), -1L, null);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.headerButtonCSSProvider != 0L) {
            OS.g_object_unref(this.headerButtonCSSProvider);
            this.headerButtonCSSProvider = 0L;
        }
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

