/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long clientHandle() {
        int n = GTK.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && this.items[n] != null) {
            return this.items[n].pageHandle;
        }
        return this.handle;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSizeInPixels(n, n2, bl);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        boolean bl2 = GTK.gtk_notebook_get_scrollable(this.handle);
        GTK.gtk_notebook_set_scrollable(this.handle, false);
        Point point2 = this.computeNativeSize(this.handle, n, n2, bl);
        GTK.gtk_notebook_set_scrollable(this.handle, bl2);
        int[] nArray = new int[1];
        point2.x += nArray[0] * 2;
        point.x = Math.max(point2.x, point.x);
        point.y = Math.max(point2.y, point.y);
        return point;
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        long l = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n5 = gtkAllocation.x;
        int n6 = gtkAllocation.y;
        n -= n5;
        n2 -= n6;
        n3 += n5 + n5;
        if ((this.style & 0x400) != 0) {
            int n7 = gtkAllocation.height;
            GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
            int n8 = gtkAllocation.height;
            n4 += n8 - n7;
        } else {
            n4 += n5 + n6;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rectangle = super.getClientAreaInPixels();
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_notebook_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_notebook_set_show_tabs(this.handle, true);
        GTK.gtk_notebook_set_scrollable(this.handle, true);
        if ((this.style & 0x400) != 0) {
            GTK.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TabItem[4];
    }

    void createItem(TabItem tabItem, int n) {
        long l;
        long l2;
        long l3;
        int n2 = 0;
        if (GTK.GTK4) {
            n2 = GTK.gtk_notebook_get_n_pages(this.handle);
        } else {
            l3 = GTK3.gtk_container_get_children(this.handle);
            if (l3 != 0L) {
                n2 = OS.g_list_length(l3);
                OS.g_list_free(l3);
            }
        }
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            TabItem[] tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if ((l3 = this.gtk_box_new(0, false, 0)) == 0L) {
            this.error(2);
        }
        if ((l2 = GTK.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_image_new()) == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(l3, l);
            GTK4.gtk_box_append(l3, l2);
        } else {
            GTK3.gtk_container_add(l3, l);
            GTK3.gtk_container_add(l3, l2);
        }
        long l4 = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (l4 == 0L) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_insert_page(this.handle, l4, l3, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        if (GTK.GTK4) {
            GTK.gtk_widget_hide(l);
        } else {
            GTK.gtk_widget_show(l3);
            GTK.gtk_widget_show(l2);
            GTK.gtk_widget_show(l4);
        }
        tabItem.state |= 8;
        tabItem.handle = l3;
        tabItem.labelHandle = l2;
        tabItem.imageHandle = l;
        tabItem.pageHandle = l4;
        System.arraycopy(this.items, n, this.items, n + 1, n2++ - n);
        this.items[n] = tabItem;
        if ((this.state & 0x1000) != 0) {
            tabItem.setForegroundGdkRGBA(tabItem.handle, this.getForegroundGdkRGBA());
        }
        if ((this.state & 0x4000) != 0) {
            long l5 = this.getFontDescription();
            tabItem.setFontDescription(l5);
            OS.pango_font_description_free(l5);
        }
        if (n2 == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            GTK.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, false);
        }
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2;
        int n3 = this.getItemCount();
        for (n2 = 0; n2 < n3 && this.items[n2] != tabItem; ++n2) {
        }
        if (n2 == n3) {
            this.error(15);
        }
        int n4 = GTK.gtk_notebook_get_current_page(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_remove_page(this.handle, n2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n2 == n4 && (n = GTK.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[n].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[n];
            this.sendSelectionEvent(13, event, true);
        }
    }

    @Override
    long eventHandle() {
        return this.handle;
    }

    @Override
    Control[] _getChildren() {
        Control[] controlArray;
        Control[] controlArray2 = super._getChildren();
        int n = controlArray2.length;
        int n2 = this.items == null ? 0 : this.items.length;
        Control[] controlArray3 = new Control[n2 + n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Widget widget;
            long l;
            TabItem tabItem = this.items[i];
            if (tabItem == null || tabItem.isDisposed()) continue;
            long l2 = tabItem.pageHandle;
            if (GTK.GTK4) {
                l = GTK4.gtk_widget_get_first_child(l2);
                while (l != 0L) {
                    Widget widget2 = this.display.getWidget(l);
                    if (widget2 != null && widget2 instanceof Control && widget2 != this) {
                        controlArray3[n3] = (Control)widget2;
                        ++n3;
                    }
                    l = GTK4.gtk_widget_get_next_sibling(l);
                }
                continue;
            }
            l = GTK3.gtk_container_get_children(l2);
            if (l == 0L) continue;
            long l3 = OS.g_list_data(l);
            if (l3 != 0L && (widget = this.display.getWidget(l3)) != null && widget != this && widget instanceof Control) {
                controlArray3[n3++] = (Control)widget;
            }
            OS.g_list_free(l);
        }
        if (n3 == n2 + n) {
            return controlArray3;
        }
        if (n3 == n2) {
            controlArray = controlArray3;
        } else {
            controlArray = new Control[n3 + n];
            System.arraycopy(controlArray3, 0, controlArray, 0, n3);
        }
        System.arraycopy(controlArray2, 0, controlArray, n3, n);
        return controlArray;
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        if (GTK.GTK4) {
            long l = GTK4.gtk_widget_get_first_child(this.handle);
            if (l == 0L) {
                this.error(8);
            }
        } else {
            long l = GTK3.gtk_container_get_children(this.handle);
            if (l == 0L) {
                this.error(8);
            }
            int n2 = OS.g_list_length(l);
            OS.g_list_free(l);
            if (0 > n || n >= n2) {
                this.error(8);
            }
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            Rectangle rectangle = tabItem.getBounds();
            if (!rectangle.contains(point)) continue;
            return tabItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = 0;
        if (GTK.GTK4) {
            n = GTK.gtk_notebook_get_n_pages(this.handle);
        } else {
            long l = GTK3.gtk_container_get_children(this.handle);
            if (l == 0L) {
                return 0;
            }
            n = OS.g_list_length(l);
            OS.g_list_free(l);
        }
        return n;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = GTK.gtk_notebook_get_current_page(this.handle);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_notebook_get_current_page(this.handle);
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 0L;
    }

    @Override
    long gtk_switch_page(long l, long l2, int n) {
        Object object;
        TabItem tabItem = this.items[n];
        if (GTK.GTK4) {
            object = tabItem.getControl();
            ((Control)object).setBoundsInPixels(this.getClientAreaInPixels());
        } else {
            Control control;
            int n2 = GTK.gtk_notebook_get_current_page(this.handle);
            if (n2 != -1) {
                control = this.items[n2].getControl();
                if (control != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
            } else {
                return 0L;
            }
            control = tabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
        }
        object = new Event();
        ((Event)object).item = tabItem;
        this.sendSelectionEvent(13, (Event)object, false);
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.switch_page, this.display.getClosure(49), false);
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = -1;
        int n2 = this.getItemCount();
        for (int i = 0; i < n2; ++i) {
            if (this.items[i] != tabItem) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            Serializable serializable;
            int n5;
            Control control = controlArray[i];
            int n6 = this.getItemCount();
            for (n5 = 0; n5 < n6 && this.items[n5].control != control; ++n5) {
            }
            if (n5 == n6) {
                serializable = DPIUtil.autoScaleUp(control.getBounds());
                n3 = Math.max(n3, serializable.x + serializable.width);
                n4 = Math.max(n4, serializable.y + serializable.height);
                continue;
            }
            serializable = DPIUtil.autoScaleUp(control.computeSize(DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), bl));
            n3 = Math.max(n3, ((Point)serializable).x);
            n4 = Math.max(n4, ((Point)serializable).y);
        }
        return new Point(n3, n4);
    }

    @Override
    boolean mnemonicHit(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            long l = this.items[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            long l = this.items[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = this.getItemCount();
            for (int i = 0; i < n2; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null) continue;
                tabItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        String string = "notebook header {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}";
        this.cssBackground = string;
        String string2 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string2);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n6 & 0x100) != 0 && (n5 = this.getSelectionIndex()) != -1) {
            TabItem tabItem = this.items[n5];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
            }
        }
        return n6;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setFontDescription(l);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setForegroundRGBA(gdkRGBA);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(bl);
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        if (n < 0) {
            return;
        }
        int n2 = GTK.gtk_notebook_get_current_page(this.handle);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_set_current_page(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        int n3 = GTK.gtk_notebook_get_current_page(this.handle);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    public void setSelection(TabItem tabItem) {
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            for (int i = tabItemArray.length - 1; i >= 0; --i) {
                int n = this.indexOf(tabItemArray[i]);
                if (n == -1) continue;
                this.setSelection(n, false);
            }
        }
    }

    @Override
    boolean traversePage(boolean bl) {
        if (bl) {
            GTK.gtk_notebook_next_page(this.handle);
        } else {
            GTK.gtk_notebook_prev_page(this.handle);
        }
        return true;
    }
}

