/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math3.distribution.MultivariateRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixtureMultivariateRealDistribution<T extends MultivariateRealDistribution>
extends AbstractMultivariateRealDistribution {
    private final double[] weight;
    private final List<T> distribution;

    public MixtureMultivariateRealDistribution(List<Pair<Double, T>> components) {
        this((RandomGenerator)new Well19937c(), components);
    }

    public MixtureMultivariateRealDistribution(RandomGenerator rng, List<Pair<Double, T>> components) {
        super(rng, ((MultivariateRealDistribution)components.get(0).getSecond()).getDimension());
        Pair<Double, T> comp;
        int i2;
        int numComp = components.size();
        int dim = this.getDimension();
        double weightSum = 0.0;
        for (i2 = 0; i2 < numComp; ++i2) {
            comp = components.get(i2);
            if (((MultivariateRealDistribution)comp.getSecond()).getDimension() != dim) {
                throw new DimensionMismatchException(((MultivariateRealDistribution)comp.getSecond()).getDimension(), dim);
            }
            if (comp.getFirst() < 0.0) {
                throw new NotPositiveException(comp.getFirst());
            }
            weightSum += comp.getFirst().doubleValue();
        }
        if (Double.isInfinite(weightSum)) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        this.distribution = new ArrayList<T>();
        this.weight = new double[numComp];
        for (i2 = 0; i2 < numComp; ++i2) {
            comp = components.get(i2);
            this.weight[i2] = comp.getFirst() / weightSum;
            this.distribution.add(comp.getSecond());
        }
    }

    @Override
    public double density(double[] values2) {
        double p = 0.0;
        for (int i2 = 0; i2 < this.weight.length; ++i2) {
            p += this.weight[i2] * ((MultivariateRealDistribution)this.distribution.get(i2)).density(values2);
        }
        return p;
    }

    @Override
    public double[] sample() {
        double[] vals = null;
        double randomValue = this.random.nextDouble();
        double sum = 0.0;
        for (int i2 = 0; i2 < this.weight.length; ++i2) {
            if (!(randomValue <= (sum += this.weight[i2]))) continue;
            vals = ((MultivariateRealDistribution)this.distribution.get(i2)).sample();
            break;
        }
        if (vals == null) {
            vals = ((MultivariateRealDistribution)this.distribution.get(this.weight.length - 1)).sample();
        }
        return vals;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        for (int i2 = 0; i2 < this.distribution.size(); ++i2) {
            ((MultivariateRealDistribution)this.distribution.get(i2)).reseedRandomGenerator((long)(i2 + 1) + seed);
        }
    }

    public List<Pair<Double, T>> getComponents() {
        ArrayList<Pair<Double, T>> list2 = new ArrayList<Pair<Double, T>>(this.weight.length);
        for (int i2 = 0; i2 < this.weight.length; ++i2) {
            list2.add(new Pair<Double, T>(this.weight[i2], this.distribution.get(i2)));
        }
        return list2;
    }
}

