/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import gde.GDE;
import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Logger;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TabAreaContextMenu {
    private static final String $CLASS_NAME = TabAreaContextMenu.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final DataExplorer application = DataExplorer.getInstance();
    private final Settings settings = Settings.getInstance();
    MenuItem curveSelectionItem;
    MenuItem displayGraphicsHeaderItem;
    MenuItem displayGridLine10Item;
    MenuItem displayGraphicsCommentItem;
    MenuItem displayGraphicsCurveSurvey;
    MenuItem separatorView;
    MenuItem copyTabItem;
    MenuItem copyPrintImageItem;
    MenuItem separatorCopy;
    MenuItem outherAreaColorItem;
    MenuItem innerAreaColorItem;
    MenuItem borderColorItem;
    MenuItem dateTimeItem;
    MenuItem partialTableItem;
    MenuItem editTableItem;
    MenuItem setDigitalFontItem;
    protected boolean isCreated = false;

    public void createMenu(final Menu popupMenu, final TabMenuType type) {
        popupMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                log.log(Level.FINEST, "menuShown action " + String.valueOf(e));
                if (type == TabMenuType.GRAPHICS) {
                    TabAreaContextMenu.this.curveSelectionItem.setSelection(TabAreaContextMenu.this.application.getMenuBar().getCurveSelectionMenuItem().getSelection());
                    TabAreaContextMenu.this.displayGraphicsHeaderItem.setSelection(TabAreaContextMenu.this.application.getMenuBar().getGraphicsHeaderMenuItem().getSelection());
                    TabAreaContextMenu.this.displayGraphicsCommentItem.setSelection(TabAreaContextMenu.this.application.getMenuBar().getRecordCommentMenuItem().getSelection());
                    TabAreaContextMenu.this.displayGridLine10Item.setSelection(TabAreaContextMenu.this.settings.isDraw10TicksPerRecord());
                }
                if (type == TabMenuType.TABLE && TabAreaContextMenu.this.editTableItem != null) {
                    TabAreaContextMenu.this.editTableItem.setSelection(Settings.getInstance().isDataTableEditable());
                }
                popupMenu.setData(TabMenuOnDemand.IS_CURSOR_IN_CANVAS.toString(), null);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        if (!this.isCreated) {
            if (type == TabMenuType.GRAPHICS) {
                this.curveSelectionItem = new MenuItem(popupMenu, 32);
                this.curveSelectionItem.setText(Messages.getString("GDE_MSGT0040"));
                this.curveSelectionItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "curveSelectionItem action performed! " + String.valueOf(e));
                        boolean selection = TabAreaContextMenu.this.curveSelectionItem.getSelection();
                        TabAreaContextMenu.this.application.enableCurveSelector(selection);
                        TabAreaContextMenu.this.application.getMenuBar().getCurveSelectionMenuItem().setSelection(selection);
                    }
                });
                this.displayGraphicsHeaderItem = new MenuItem(popupMenu, 32);
                this.displayGraphicsHeaderItem.setText(Messages.getString("GDE_MSGT0041"));
                this.displayGraphicsHeaderItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "toggleViewGraphicsHeaderItem action performed! " + String.valueOf(e));
                        boolean selection = TabAreaContextMenu.this.displayGraphicsHeaderItem.getSelection();
                        TabAreaContextMenu.this.application.getMenuBar().getGraphicsHeaderMenuItem().setSelection(selection);
                        TabAreaContextMenu.this.application.enableGraphicsHeader(selection);
                    }
                });
                this.displayGraphicsCommentItem = new MenuItem(popupMenu, 32);
                this.displayGraphicsCommentItem.setText(Messages.getString("GDE_MSGT0042"));
                if (!GDE.IS_OS_ARCH_ARM) {
                    this.displayGraphicsCommentItem.setToolTipText(Messages.getString("GDE_MSGT0878"));
                }
                this.displayGraphicsCommentItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "toggleViewGraphicsCommentItem action performed! " + String.valueOf(e));
                        boolean selection = TabAreaContextMenu.this.displayGraphicsCommentItem.getSelection();
                        TabAreaContextMenu.this.application.getMenuBar().getRecordCommentMenuItem().setSelection(selection);
                        TabAreaContextMenu.this.application.enableRecordSetComment(selection);
                        TabAreaContextMenu.this.application.updateGraphicsWindow();
                    }
                });
                this.separatorView = new MenuItem(popupMenu, 2);
                this.displayGridLine10Item = new MenuItem(popupMenu, 32);
                this.displayGridLine10Item.setText(Messages.getString("GDE_MSGT0968"));
                if (!GDE.IS_OS_ARCH_ARM) {
                    this.displayGridLine10Item.setToolTipText(Messages.getString("GDE_MSGT0969"));
                }
                this.displayGridLine10Item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "toggle displayGridLine10Item action performed! " + String.valueOf(e));
                        boolean selection = TabAreaContextMenu.this.displayGridLine10Item.getSelection();
                        TabAreaContextMenu.this.settings.setDraw10TicksPerRecord(selection);
                        if (TabAreaContextMenu.this.settings.isDraw10TicksPerRecord()) {
                            TabAreaContextMenu.this.application.updateAllTabs(false);
                        } else if (TabAreaContextMenu.this.application.getActiveRecordSet() != null) {
                            TabAreaContextMenu.this.application.getActiveChannel().applyTemplateScaleEndpoints(TabAreaContextMenu.this.application.getActiveRecordSet().getName());
                        }
                    }
                });
                this.separatorView = new MenuItem(popupMenu, 2);
            }
            this.copyTabItem = new MenuItem(popupMenu, 8);
            this.copyTabItem.setText(Messages.getString("GDE_MSGT0026").substring(0, Messages.getString("GDE_MSGT0026").lastIndexOf(9)));
            this.copyTabItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "copyTabItem action performed! " + String.valueOf(e));
                    TabAreaContextMenu.this.application.copyTabContentAsImage();
                }
            });
            if (type == TabMenuType.GRAPHICS || type == TabMenuType.COMPARE || type == TabMenuType.UTILITY) {
                this.copyPrintImageItem = new MenuItem(popupMenu, 8);
                this.copyPrintImageItem.setText(Messages.getString("GDE_MSGT0027").substring(0, Messages.getString("GDE_MSGT0027").lastIndexOf(9)));
                this.copyPrintImageItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "copyPrintImageItem action performed! " + String.valueOf(e));
                        TabAreaContextMenu.this.application.copyGraphicsPrintImage();
                    }
                });
            }
            if (type != TabMenuType.TABLE) {
                this.separatorCopy = new MenuItem(popupMenu, 2);
                this.outherAreaColorItem = new MenuItem(popupMenu, 8);
                this.outherAreaColorItem.setText(Messages.getString("GDE_MSGT0462"));
                this.outherAreaColorItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "outherAreaColorItem action performed! " + String.valueOf(e));
                        RGB rgb = TabAreaContextMenu.this.application.openColorDialog();
                        if (rgb != null) {
                            TabAreaContextMenu.this.application.setSurroundingBackground(TabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                        }
                    }
                });
                this.innerAreaColorItem = new MenuItem(popupMenu, 8);
                this.innerAreaColorItem.setText(Messages.getString("GDE_MSGT0463"));
                this.innerAreaColorItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "innerAreaColorItem action performed! " + String.valueOf(e));
                        RGB rgb = TabAreaContextMenu.this.application.openColorDialog();
                        if (rgb != null) {
                            TabAreaContextMenu.this.application.setInnerAreaBackground(TabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                        }
                    }
                });
            }
            if (type == TabMenuType.GRAPHICS || type == TabMenuType.COMPARE || type == TabMenuType.UTILITY) {
                this.borderColorItem = new MenuItem(popupMenu, 8);
                this.borderColorItem.setText(Messages.getString("GDE_MSGT0464"));
                this.borderColorItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "borderColorItem action performed! " + String.valueOf(e));
                        RGB rgb = TabAreaContextMenu.this.application.openColorDialog();
                        if (rgb != null) {
                            TabAreaContextMenu.this.application.setBorderColor(TabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                        }
                    }
                });
            }
            if (type == TabMenuType.TABLE) {
                this.dateTimeItem = new MenuItem(popupMenu, 32);
                this.dateTimeItem.setText(Messages.getString("GDE_MSGT0436"));
                this.dateTimeItem.setSelection(Settings.getInstance().isTimeFormatAbsolute());
                this.dateTimeItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "dateTimeItem action performed! " + String.valueOf(e));
                        TabAreaContextMenu.this.application.setAbsoluteDateTime(TabAreaContextMenu.this.dateTimeItem.getSelection());
                    }
                });
                this.editTableItem = new MenuItem(popupMenu, 32);
                this.editTableItem.setText(Messages.getString("GDE_MSGT0731"));
                this.editTableItem.setSelection(Settings.getInstance().isDataTableEditable());
                this.editTableItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "editTableItem action performed! " + String.valueOf(e));
                        Settings.getInstance().setDataTableEditable(TabAreaContextMenu.this.editTableItem.getSelection());
                    }
                });
                this.partialTableItem = new MenuItem(popupMenu, 32);
                this.partialTableItem.setText(Messages.getString("GDE_MSGT0704"));
                this.partialTableItem.setSelection(Settings.getInstance().isPartialDataTable());
                this.partialTableItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "partialTableItem action performed! " + String.valueOf(e));
                        Settings.getInstance().setPartialDataTable(TabAreaContextMenu.this.partialTableItem.getSelection());
                        TabAreaContextMenu.this.application.updateAllTabs(true, false);
                    }
                });
            }
            if (type == TabMenuType.DIGITAL) {
                this.setDigitalFontItem = new MenuItem(popupMenu, 8);
                this.setDigitalFontItem.setText(Messages.getString("GDE_MSGT0726"));
                this.setDigitalFontItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(Level.FINEST, "setDigitalFontItem action performed! " + String.valueOf(e));
                        int selectedFontSize = TabAreaContextMenu.this.application.openFontSizeDialog();
                        if (selectedFontSize != 0) {
                            TabAreaContextMenu.this.application.setTabFontSize(TabAreaContextMenu.this.application.getTabSelectionIndex(), selectedFontSize);
                        }
                    }
                });
            }
            this.isCreated = true;
        }
    }

    public static enum TabMenuType {
        GRAPHICS,
        COMPARE,
        UTILITY,
        SIMPLE,
        TABLE,
        DIGITAL;

    }

    public static enum TabMenuOnDemand {
        IS_CURSOR_IN_CANVAS;

    }
}

