/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantizationError
implements MapDataVisualization {
    private final DistanceMeasure distance;

    public QuantizationError(DistanceMeasure distance) {
        this.distance = distance;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map2, Iterable<double[]> data2) {
        int nR = map2.getNumberOfRows();
        int nC = map2.getNumberOfColumns();
        LocationFinder finder = new LocationFinder(map2);
        int[][] hit = new int[nR][nC];
        double[][] error2 = new double[nR][nC];
        for (double[] sample : data2) {
            Neuron best = MapUtils.findBest(sample, map2, this.distance);
            LocationFinder.Location loc = finder.getLocation(best);
            int row2 = loc.getRow();
            int col = loc.getColumn();
            int[] nArray = hit[row2];
            int n = col;
            nArray[n] = nArray[n] + 1;
            double[] dArray = error2[row2];
            int n2 = col;
            dArray[n2] = dArray[n2] + this.distance.compute(sample, best.getFeatures());
        }
        for (int r = 0; r < nR; ++r) {
            for (int c = 0; c < nC; ++c) {
                int count = hit[r][c];
                if (count == 0) continue;
                double[] dArray = error2[r];
                int n = c;
                dArray[n] = dArray[n] / (double)count;
            }
        }
        return error2;
    }
}

