/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.NoSuchPortException;
import gde.exception.PortInUseException;
import gde.exception.ReadWriteOutOfSyncException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsbException;

public class DeviceJavaSerialCommPortImpl
extends DeviceCommPort
implements IDeviceCommPort,
SerialPortPacketListener {
    static final String $CLASS_NAME = DeviceJavaSerialCommPortImpl.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final DeviceConfiguration jsDeviceConfig;
    protected final DataExplorer jsApplication;
    final Settings jsSettings;
    protected SerialPort serialPort = null;
    protected int xferErrors = 0;
    protected int queryErrors = 0;
    protected int timeoutErrors = 0;
    boolean isConnected = false;
    String serialPortStr = "";
    Thread closeThread;
    InputStream inputStream = null;
    OutputStream outputStream = null;

    public DeviceJavaSerialCommPortImpl(DeviceConfiguration currentDeviceConfig, DataExplorer currentApplication) {
        this.jsDeviceConfig = currentDeviceConfig;
        this.jsApplication = currentApplication;
        this.jsSettings = Settings.getInstance();
    }

    public DeviceJavaSerialCommPortImpl() {
        this.jsDeviceConfig = null;
        this.jsApplication = null;
        this.jsSettings = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TreeMap<String, String> listConfiguredSerialPorts(boolean doAvialabilityCheck, String portBlackList, Vector<String> portWhiteList) {
        String $METHOD_NAME = "listConfiguredSerialPorts";
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", "entry");
        }
        try {
            DeviceCommPort.availablePorts.clear();
            if (portWhiteList.size() > 0) {
                for (String serialPortDescriptor : portWhiteList) {
                    SerialPort commPortIdentifier = null;
                    for (SerialPort commPort : SerialPort.getCommPorts()) {
                        if (!commPort.getSystemPortName().equals(serialPortDescriptor)) continue;
                        commPortIdentifier = commPort;
                        break;
                    }
                    try {
                        if (commPortIdentifier == null) continue;
                        if (doAvialabilityCheck) {
                            boolean isOpen = commPortIdentifier.openPort(1);
                            if (isOpen) {
                                commPortIdentifier.closePort();
                            } else {
                                if (!commPortIdentifier.getDescriptivePortName().toLowerCase().contains("virtual")) throw new NoSuchPortException();
                                commPortIdentifier.setFlowControl(0);
                                commPortIdentifier.setComPortTimeouts(272, 1000, 1000);
                                commPortIdentifier.setComPortParameters(115200, 8, 1, 0);
                                commPortIdentifier.disablePortConfiguration();
                                isOpen = commPortIdentifier.openPort(1);
                                if (!isOpen) throw new NoSuchPortException();
                                commPortIdentifier.closePort();
                            }
                        }
                        DeviceCommPort.availablePorts.put(serialPortDescriptor, serialPortDescriptor + " - " + commPortIdentifier.getDescriptivePortName());
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found available port: " + serialPortDescriptor);
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found port, but in use: " + serialPortDescriptor);
                    }
                }
            } else {
                for (SerialPort commPort : SerialPort.getCommPorts()) {
                    String serialPortStr = commPort.getSystemPortName();
                    if (log.isLoggable(Level.FINER)) {
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found available port: " + serialPortStr + ": " + commPort.getDescriptivePortName() + " - " + commPort.getPortDescription());
                    }
                    if (portBlackList.contains(serialPortStr)) continue;
                    try {
                        if (doAvialabilityCheck) {
                            boolean isOpen = commPort.openPort(1);
                            if (isOpen) {
                                commPort.closePort();
                            } else if (commPort.getDescriptivePortName().toLowerCase().contains("virtual")) {
                                commPort.setFlowControl(0);
                                commPort.setComPortTimeouts(272, 1000, 1000);
                                commPort.setComPortParameters(115200, 8, 1, 0);
                                commPort.disablePortConfiguration();
                                isOpen = commPort.openPort(1);
                                if (!isOpen) throw new NoSuchPortException();
                                commPort.closePort();
                            } else {
                                new NoSuchPortException();
                            }
                        }
                        DeviceCommPort.availablePorts.put(serialPortStr, commPort.getSystemPortName() + " - " + commPort.getDescriptivePortName());
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found available port: " + serialPortStr);
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found port, but in use: " + serialPortStr);
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder().append("Available serial Ports : ");
                for (String comPort : DeviceCommPort.availablePorts.values()) {
                    sb.append(comPort).append(" ");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", sb.toString());
                }
            }
            if (GDE.IS_MAC) {
                Iterator<String> iterator = DeviceCommPort.availablePorts.keySet().iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().contains("cu.")) continue;
                    iterator.remove();
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.getMessage(), t);
        }
        if (!log.isLoggable(Level.FINE)) return DeviceCommPort.availablePorts;
        log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", "exit");
        return DeviceCommPort.availablePorts;
    }

    public static String[] prepareSerialPortList() {
        String[] serialPortList = new String[DeviceCommPort.availablePorts.size()];
        String[] tmpSerialPortList = DeviceCommPort.availablePorts.values().toArray(new String[DeviceCommPort.availablePorts.size()]);
        for (int i = 0; i < tmpSerialPortList.length; ++i) {
            serialPortList[i] = " " + tmpSerialPortList[i];
        }
        return serialPortList;
    }

    @Override
    public boolean isMatchAvailablePorts(String newSerialPortStr) {
        boolean match = false;
        if (DeviceCommPort.availablePorts.size() == 0 || this.serialPortStr != null && !DeviceCommPort.availablePorts.keySet().contains(this.serialPortStr)) {
            DeviceJavaSerialCommPortImpl.listConfiguredSerialPorts(false, this.jsSettings.isSerialPortBlackListEnabled() ? this.jsSettings.getSerialPortBlackList() : "", this.jsSettings.isSerialPortWhiteListEnabled() ? this.jsSettings.getSerialPortWhiteList() : new Vector<String>());
        }
        for (String availablePort : DeviceCommPort.availablePorts.keySet()) {
            if (!availablePort.equals(newSerialPortStr)) continue;
            match = true;
            break;
        }
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SerialPort open() throws ApplicationConfigurationException, SerialPortException {
        String $METHOD_NAME = "open";
        this.timeoutErrors = 0;
        this.xferErrors = 0;
        try {
            boolean isVirtual;
            this.serialPortStr = this.jsDeviceConfig.getPort();
            if (this.serialPortStr == null || this.serialPortStr.length() < 4 || !this.isMatchAvailablePorts(this.serialPortStr)) {
                if (DeviceCommPort.availablePorts.size() != 1 || this.serialPortStr == null || this.isMatchAvailablePorts(this.serialPortStr)) throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0010"));
                if (64 != this.jsApplication.openYesNoMessageDialogSync(Messages.getString("GDE_MSGE0010") + GDE.LINE_SEPARATOR + Messages.getString("GDE_MSGT0194", new String[]{this.serialPortStr = DeviceCommPort.availablePorts.firstKey()}))) throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0010"));
                this.serialPortStr = DeviceCommPort.availablePorts.firstKey();
                this.jsDeviceConfig.setPort(this.serialPortStr);
                this.jsDeviceConfig.storeDeviceProperties();
                this.jsApplication.updateTitleBar();
            }
            log.logp(Level.FINE, $CLASS_NAME, "open", String.format("serialPortString = %s; baudeRate = %d; dataBits = %s; stopBits = %s; parity = %s; flowControlMode = %s; RTS = %s; DTR = %s", new Object[]{this.serialPortStr, this.jsDeviceConfig.getBaudeRate(), this.jsDeviceConfig.getDataBits(), this.jsDeviceConfig.getStopBits(), this.jsDeviceConfig.getParity(), this.jsDeviceConfig.getFlowCtrlMode(), this.jsDeviceConfig.isRTS(), this.jsDeviceConfig.isDTR()}));
            for (SerialPort commPort : SerialPort.getCommPorts()) {
                if (!commPort.getSystemPortName().equals(this.serialPortStr)) continue;
                this.serialPort = commPort;
                break;
            }
            boolean bl = isVirtual = GDE.IS_WINDOWS && this.serialPort.getDescriptivePortName().toLowerCase().contains("virtual");
            if (isVirtual) {
                this.serialPort.setFlowControl(this.jsDeviceConfig.getFlowCtrlMode());
                this.serialPort.setComPortTimeouts(272, 2000, 2000);
                this.serialPort.setComPortParameters(115200, this.jsDeviceConfig.getDataBits().ordinal() + 5, this.jsDeviceConfig.getStopBits().ordinal() + 1, this.jsDeviceConfig.getParity().ordinal());
                this.serialPort.disablePortConfiguration();
            }
            if (!this.serialPort.openPort(100, 4096, 4096)) throw new PortInUseException();
            if (!isVirtual) {
                this.serialPort.setComPortParameters(this.jsDeviceConfig.getBaudeRate().intValue(), this.jsDeviceConfig.getDataBits().ordinal() + 5, this.jsDeviceConfig.getStopBits().ordinal() + 1, this.jsDeviceConfig.getParity().ordinal());
                this.serialPort.setFlowControl(this.jsDeviceConfig.getFlowCtrlMode());
                if (this.jsDeviceConfig.isRTS()) {
                    this.serialPort.setRTS();
                } else {
                    this.serialPort.clearRTS();
                }
                if (this.jsDeviceConfig.isDTR()) {
                    this.serialPort.setDTR();
                } else {
                    this.serialPort.clearDTR();
                }
            }
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.isConnected = true;
            if (this.jsApplication == null) return this.serialPort;
            this.jsApplication.setPortConnected(true);
            return this.serialPort;
        }
        catch (ApplicationConfigurationException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "open", e.getMessage(), e);
            if (this.serialPort == null) throw e;
            this.serialPort.closePort();
            throw e;
        }
        catch (PortInUseException e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.closePort();
            throw en;
        }
        catch (Throwable e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.closePort();
            throw en;
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialTxOn();
            }
            this.cleanInputStream();
            this.outputStream.write(writeBuffer);
            if (GDE.IS_LINUX && GDE.IS_ARCH_DATA_MODEL_64) {
                this.outputStream.flush();
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialTxOff();
            }
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer, long gap_ms) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialTxOn();
            }
            this.cleanInputStream();
            for (int i = 0; i < writeBuffer.length; ++i) {
                this.outputStream.write(writeBuffer[i]);
                WaitTimer.delay(gap_ms);
            }
            if (GDE.IS_LINUX && GDE.IS_ARCH_DATA_MODEL_64) {
                this.outputStream.flush();
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialTxOff();
            }
        }
    }

    @Override
    public int cleanInputStream() throws IOException {
        String $METHOD_NAME = "cleanInputStream";
        int num = 0;
        num = this.inputStream.available();
        if (num != 0) {
            this.inputStream.read(new byte[num]);
            log.logp(Level.WARNING, $CLASS_NAME, "cleanInputStream", "clean inputStream left bytes -> " + num);
        }
        return num;
    }

    public void serialEvent(SerialPortEvent event) {
        String $METHOD_NAME = "serialEvent";
        byte[] newData = event.getReceivedData();
        if (newData.length > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "serialEvent", "OUTPUT_BUFFER_EMPTY");
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "serialEvent", "DATA_AVAILABLE");
        }
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 2;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOn();
            }
            this.wait4Bytes(bytes, timeout_msec - timeout_msec / 5);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 10;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOn();
            }
            WaitTimer.delay(2L);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOn();
            }
            long startTime_ms = new Date().getTime();
            this.wait4Bytes(timeout_msec);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (bytes == (readBytes += this.inputStream.read(readBuffer, readBytes, bytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            long ms = new Date().getTime() - startTime_ms;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "waitTime = " + ms);
            }
            waitTimes.add(ms);
            log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        while (0 == this.inputStream.available()) {
            WaitTimer.delay(sleepTime);
            if (timeOutCounter-- > 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", e.getMessage(), e);
            throw e;
        }
        return System.currentTimeMillis();
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int resBytes = 0;
        while ((resBytes = this.inputStream.available()) < numBytes) {
            WaitTimer.delay(sleepTime);
            if (--timeOutCounter > 0) continue;
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", String.format("only %d of %d Bytes are available in %d msec", resBytes, numBytes, timeout_msec));
            break;
        }
        return resBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int numAvailableBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry");
        }
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOn();
            }
            if ((numAvailableBytes = this.waitForStableReceiveBuffer(numAvailableBytes, timeout_msec, stableIndex)) > readBuffer.length) {
                readBuffer = new byte[numAvailableBytes];
            }
            while (readBytes < numAvailableBytes && timeOutCounter-- > 0) {
                if (numAvailableBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, numAvailableBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{numAvailableBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int expectedBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOn();
            }
            expectedBytes = this.waitForStableReceiveBuffer(expectedBytes, timeout_msec, stableIndex, minCountBytes);
            while (readBytes < expectedBytes && timeOutCounter-- > 0) {
                if (expectedBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, expectedBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.jsApplication != null) {
                this.jsApplication.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", String.format("byteCounter = %d numBytesAvailable = %d", byteCounter, numBytesAvailable));
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            throw e;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        }
        return byteCounter;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > minCount) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", e.getMessage(), e);
            throw e;
        }
        log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        return byteCounter;
    }

    public void checkForLeftBytes() throws ReadWriteOutOfSyncException, IOException {
        String $METHOD_NAME = "checkForLeftBytes";
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "checkForLeftBytes", "inputStream available bytes = " + this.inputStream.available());
        }
        if (this.inputStream.available() != 0) {
            throw new ReadWriteOutOfSyncException(Messages.getString("GDE_MSGE0014"));
        }
    }

    @Override
    public synchronized void close() {
        String $METHOD_NAME = "close";
        if (this.isConnected && this.serialPort != null) {
            this.isConnected = false;
            this.closeThread = new Thread("closePort"){

                @Override
                public void run() {
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "entry");
                    try {
                        Thread.sleep(5L);
                        byte[] buf = new byte[DeviceJavaSerialCommPortImpl.this.getInputStream().available()];
                        if (buf.length > 0) {
                            DeviceJavaSerialCommPortImpl.this.getInputStream().read(buf);
                        }
                        DeviceJavaSerialCommPortImpl.this.getOutputStream().flush();
                        Thread.sleep(5L);
                    }
                    catch (Throwable e) {
                        log.logp(Level.WARNING, $CLASS_NAME, "close", e.getMessage(), e);
                    }
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "before close");
                    DeviceJavaSerialCommPortImpl.this.serialPort.closePort();
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "after close");
                    DeviceJavaSerialCommPortImpl.this.isConnected = false;
                    if (DeviceJavaSerialCommPortImpl.this.jsApplication != null) {
                        DeviceJavaSerialCommPortImpl.this.jsApplication.setPortConnected(false);
                    }
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "exit");
                }
            };
            try {
                this.closeThread.start();
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return this.inputStream.available();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public String getSerialPortStr() {
        return this.serialPortStr == null ? this.jsDeviceConfig.getPort() : this.serialPortStr;
    }

    @Override
    public int getXferErrors() {
        return this.xferErrors;
    }

    @Override
    public void addXferError() {
        ++this.xferErrors;
    }

    @Override
    public void addTimeoutError() {
        ++this.timeoutErrors;
    }

    @Override
    public int getTimeoutErrors() {
        return this.timeoutErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block10: {
            Logger logger = Logger.getLogger("");
            logger.setLevel(Level.OFF);
            byte[] buffer = new byte[1024];
            try (DeviceJavaSerialCommPortImpl impl = new DeviceJavaSerialCommPortImpl();){
                if (args.length <= 0 || !args[0].startsWith("COM")) break block10;
                impl.serialPort = SerialPort.getCommPort((String)args[0].trim());
                impl.serialPort.openPort(100);
                if (!impl.serialPort.isOpen()) break block10;
                impl.serialPort.setComPortParameters(19200, 8, 1, 0);
                impl.serialPort.setFlowControl(0);
                impl.inputStream = impl.serialPort.getInputStream();
                impl.outputStream = impl.serialPort.getOutputStream();
                impl.isConnected = true;
                if (args.length > 1 && args[1].equals("sender")) {
                    for (int i = 1; i < 126; ++i) {
                        impl.write(new byte[]{(byte)i});
                    }
                    impl.wait4Bytes(1000);
                    int numBytes = 0;
                    int redBytes = 0;
                    while ((numBytes = impl.inputStream.available()) != 0) {
                        byte[] readBuffer = new byte[numBytes];
                        impl.read(readBuffer, 1000);
                        System.arraycopy(readBuffer, 0, buffer, redBytes, numBytes);
                        redBytes += numBytes;
                    }
                    System.out.println(StringHelper.byte2CharString(buffer, redBytes));
                    impl.close();
                    break block10;
                }
                while (true) {
                    impl.wait4Bytes(1000);
                    int numBytes = 0;
                    int redBytes = 0;
                    while ((numBytes = impl.inputStream.available()) != 0) {
                        byte[] readBuffer = new byte[numBytes];
                        impl.read(readBuffer, 1000);
                        System.arraycopy(readBuffer, 0, buffer, redBytes, numBytes);
                        redBytes += numBytes;
                    }
                    System.out.println(StringHelper.byte2CharString(buffer, redBytes));
                }
            }
        }
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        return null;
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        return null;
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
    }

    @Override
    public UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        return null;
    }

    @Override
    public DeviceHandle openLibUsbPort(IDevice activeDevice) throws LibUsbException, UsbException {
        return null;
    }

    @Override
    public void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
    }

    @Override
    public void closeLibUsbPort(DeviceHandle libUsbDeviceHanlde, boolean cacheSelectedUsbDevice) throws LibUsbException, UsbException {
    }

    @Override
    public int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        return 0;
    }

    public int getListeningEvents() {
        return 0;
    }

    public int getPacketSize() {
        return 0;
    }
}

