/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.smmodellbau.LiPoWatch;
import gde.device.smmodellbau.LiPoWatchDialog;
import gde.device.smmodellbau.LiPoWatchSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class LiPoWatchLiveGatherer
extends Thread {
    static final Logger log = Logger.getLogger(LiPoWatchLiveGatherer.class.getName());
    final DataExplorer application;
    final LiPoWatchSerialPort serialPort;
    final LiPoWatch device;
    final LiPoWatchDialog dialog;
    final Channels channels;
    final Channel channel;
    final Integer channelNumber;
    final String configKey;
    int timeStep_ms;
    Timer timer;
    TimerTask timerTask;
    boolean isTimerRunning = false;
    boolean isPortOpenedByLiveGatherer = false;
    final int[] time_ms = new int[]{250, 500, 1000, 2000, 5000, 10000};
    boolean isSwitchedRecordSet = false;
    boolean isGatheredRecordSetVisible = true;
    final HashMap<String, Double> calcValues = new HashMap();

    public LiPoWatchLiveGatherer(DataExplorer currentApplication, LiPoWatch useDevice, LiPoWatchSerialPort useSerialPort, LiPoWatchDialog useDialog) throws Exception {
        super("liveDataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.dialog = useDialog;
        this.channels = Channels.getInstance();
        this.channelNumber = 1;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        this.configKey = this.device.getChannelNameReplacement(this.channelNumber);
        this.calcValues.put(LiPoWatch.A1_FACTOR, useDevice.getMeasurementFactor(this.channelNumber, 11));
        this.calcValues.put(LiPoWatch.A1_OFFSET, useDevice.getMeasurementOffset(this.channelNumber, 11));
    }

    @Override
    public void run() {
        this.isTimerRunning = true;
        try {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                this.isPortOpenedByLiveGatherer = true;
                WaitTimer.delay((long)100L);
            }
            byte[] readBuffer = this.serialPort.readConfiguration();
            this.dialog.updateConfigurationValues(readBuffer);
            int timeIntervalPosition = readBuffer[13] & 0xFF;
            this.timeStep_ms = this.time_ms[timeIntervalPosition];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "timeIntervalPosition = " + timeIntervalPosition + " timeStep_ms = " + this.timeStep_ms);
            }
        }
        catch (SerialPortException e) {
            this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
            return;
        }
        catch (ApplicationConfigurationException e) {
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LiPoWatchLiveGatherer.this.application.getDeviceSelectionDialog().open();
                }
            });
            return;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
            this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{t.getClass().getSimpleName() + " : " + t.getMessage()}));
            return;
        }
        this.channels.switchChannel(this.channel.getName());
        int delay = 0;
        int period = this.timeStep_ms;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "timer period = " + period + " ms");
        }
        final String recordSetKey = this.channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
        this.channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)this.channelNumber, (boolean)true, (boolean)false, (boolean)true));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, recordSetKey + " created for channel " + this.channel.getName());
        }
        final RecordSet recordSet = (RecordSet)this.channel.get((Object)recordSetKey);
        this.device.updateInitialRecordSetComment(recordSet);
        recordSet.setTimeStep_ms((double)this.timeStep_ms);
        this.updateActiveState(recordSet);
        final int[] points = new int[recordSet.size()];
        final LiPoWatch usedDevice = this.device;
        try {
            this.serialPort.checkConnectionStatus();
            this.serialPort.wait4LiveData(100);
        }
        catch (Throwable e) {
            String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()});
            this.cleanup(recordSetKey, message, e);
        }
        this.timer = new Timer();
        this.timerTask = new TimerTask(){
            int updateViewCounter = -5;

            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "====> entry");
                }
                try {
                    if (LiPoWatchLiveGatherer.this.isTimerRunning) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "recordSetKey = " + recordSetKey + " channelKonfigKey = " + recordSet.getChannelConfigName());
                        }
                        recordSet.addPoints(usedDevice.convertDataBytes(points, LiPoWatchLiveGatherer.this.serialPort.queryLiveData()));
                        if (!LiPoWatchLiveGatherer.this.isSwitchedRecordSet && LiPoWatchLiveGatherer.this.channel.getName().equals(LiPoWatchLiveGatherer.this.channels.getActiveChannel().getName())) {
                            LiPoWatchLiveGatherer.this.channel.applyTemplateBasics(recordSetKey);
                            LiPoWatchLiveGatherer.this.application.getMenuToolBar().addRecordSetName(recordSetKey);
                            LiPoWatchLiveGatherer.this.channels.getActiveChannel().switchRecordSet(recordSetKey);
                            LiPoWatchLiveGatherer.this.isSwitchedRecordSet = true;
                        }
                        if (this.updateViewCounter++ % 5 == 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "updateVisibilityStatus " + this.updateViewCounter);
                            }
                            usedDevice.updateVisibilityStatus(recordSet, true);
                        }
                        if (recordSet.isChildOfActiveChannel() && recordSet.equals((Object)LiPoWatchLiveGatherer.this.channels.getActiveChannel().getActiveRecordSet())) {
                            LiPoWatchLiveGatherer.this.application.updateAllTabs(false);
                        }
                    }
                }
                catch (DataInconsitsentException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    String message = Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
                    LiPoWatchLiveGatherer.this.cleanup(recordSetKey, message, e);
                }
                catch (TimeOutException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1602");
                    LiPoWatchLiveGatherer.this.cleanup(recordSetKey, message, e);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1602");
                    LiPoWatchLiveGatherer.this.cleanup(recordSetKey, message, e);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    String message = e.getClass().getSimpleName() + " - " + e.getMessage();
                    LiPoWatchLiveGatherer.this.cleanup(recordSetKey, message, e);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "======> exit");
                }
            }
        };
        this.timer.scheduleAtFixedRate(this.timerTask, delay, (long)period);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "exit");
        }
    }

    private void updateActiveState(RecordSet recordSet) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (record.isActive()) continue;
            record.setDisplayable(false);
            record.setVisible(false);
        }
    }

    public void finalizeRecordSet(String recordSetKey) {
        if (this.isPortOpenedByLiveGatherer) {
            this.serialPort.close();
        }
        RecordSet recordSet = (RecordSet)this.channel.get((Object)recordSetKey);
        this.device.updateVisibilityStatus(recordSet, true);
        this.device.makeInActiveDisplayable(recordSet);
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSetKey, false);
    }

    public void stopTimerThread() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.isTimerRunning = false;
    }

    void cleanup(String recordSetKey, String message, Throwable e) {
        this.stopTimerThread();
        if (this.isPortOpenedByLiveGatherer) {
            this.serialPort.close();
        }
        ((RecordSet)this.channel.get((Object)recordSetKey)).clear();
        this.channel.remove(recordSetKey);
        this.application.getMenuToolBar().updateRecordSetSelectCombo();
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSetKey, true);
        this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        this.device.getDialog().resetButtons();
        log.log(Level.SEVERE, e.getMessage(), e);
    }
}

