/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSData;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data2 = new TransferData[types.length];
        int i2 = 0;
        while (i2 < types.length) {
            data2[i2] = new TransferData();
            data2[i2].type = types[i2];
            ++i2;
        }
        return data2;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        int i2 = 0;
        while (i2 < types.length) {
            if (transferData.type == types[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) && !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] orig = (byte[])object;
        NSData data2 = NSData.dataWithBytes(orig, orig.length);
        transferData.data = data2;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data == null) {
            return null;
        }
        NSData data2 = (NSData)transferData.data;
        if (data2.length() == 0L) {
            return null;
        }
        byte[] bytes = new byte[(int)data2.length()];
        data2.getBytes(bytes);
        return bytes;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

