/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltInForNode;
import freemarker.core.BuiltInForNodeEx;
import freemarker.core.Environment;
import freemarker.ext.dom._ExtDomApi;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNodeModelEx;
import java.util.List;

class BuiltInsForNodes {
    private BuiltInsForNodes() {
    }

    static class AncestorSequence
    extends SimpleSequence
    implements TemplateMethodModel {
        private Environment env;

        AncestorSequence(Environment env) {
            this.env = env;
        }

        public Object exec(List names) throws TemplateModelException {
            if (names == null || names.isEmpty()) {
                return this;
            }
            AncestorSequence result2 = new AncestorSequence(this.env);
            block0: for (int i2 = 0; i2 < this.size(); ++i2) {
                TemplateNodeModel tnm = (TemplateNodeModel)this.get(i2);
                String nodeName = tnm.getNodeName();
                String nsURI = tnm.getNodeNamespace();
                if (nsURI == null) {
                    if (!names.contains(nodeName)) continue;
                    result2.add(tnm);
                    continue;
                }
                for (int j = 0; j < names.size(); ++j) {
                    if (!_ExtDomApi.matchesName((String)names.get(j), nodeName, nsURI, this.env)) continue;
                    result2.add(tnm);
                    continue block0;
                }
            }
            return result2;
        }
    }

    static class nextSiblingBI
    extends BuiltInForNodeEx {
        nextSiblingBI() {
        }

        TemplateModel calculateResult(TemplateNodeModelEx nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getNextSibling();
        }
    }

    static class previousSiblingBI
    extends BuiltInForNodeEx {
        previousSiblingBI() {
        }

        TemplateModel calculateResult(TemplateNodeModelEx nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getPreviousSibling();
        }
    }

    static class rootBI
    extends BuiltInForNode {
        rootBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            TemplateNodeModel result2 = nodeModel;
            TemplateNodeModel parent = nodeModel.getParentNode();
            while (parent != null) {
                result2 = parent;
                parent = result2.getParentNode();
            }
            return result2;
        }
    }

    static class parentBI
    extends BuiltInForNode {
        parentBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getParentNode();
        }
    }

    static class node_typeBI
    extends BuiltInForNode {
        node_typeBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeType());
        }
    }

    static class node_namespaceBI
    extends BuiltInForNode {
        node_namespaceBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            String nsURI = nodeModel.getNodeNamespace();
            return nsURI == null ? null : new SimpleScalar(nsURI);
        }
    }

    static class node_nameBI
    extends BuiltInForNode {
        node_nameBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeName());
        }
    }

    static class childrenBI
    extends BuiltInForNode {
        childrenBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getChildNodes();
        }
    }

    static class ancestorsBI
    extends BuiltInForNode {
        ancestorsBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            AncestorSequence result2 = new AncestorSequence(env);
            for (TemplateNodeModel parent = nodeModel.getParentNode(); parent != null; parent = parent.getParentNode()) {
                result2.add(parent);
            }
            return result2;
        }
    }
}

