/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private static final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private static final ImageLoaderFactory[] loaderFactories;
    private static final boolean isIOS;
    private static int maxSignatureLength;

    public static ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] imageFormatDescriptionArray = new ImageFormatDescription[loaderFactories.length];
        for (int j = 0; j < loaderFactories.length; ++j) {
            imageFormatDescriptionArray[j] = loaderFactories[j].getFormatDescription();
        }
        return imageFormatDescriptionArray;
    }

    public static int getNumBands(ImageType imageType) {
        int n = -1;
        switch (imageType) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                n = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                n = 2;
                break;
            }
            case RGB: {
                n = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                n = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + imageType);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImageLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        ImageFormatDescription imageFormatDescription = imageLoaderFactory.getFormatDescription();
        for (ImageFormatDescription.Signature signature2 : imageFormatDescription.getSignatures()) {
            loaderFactoriesBySignature.put(signature2, imageLoaderFactory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            maxSignatureLength = -1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ImageFrame[] loadAll(InputStream inputStream2, ImageLoadListener imageLoadListener, double d, double d2, boolean bl, float f, boolean bl2) throws ImageStorageException {
        ImageLoader imageLoader = null;
        try {
            imageLoader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(inputStream2) : ImageStorage.getLoaderBySignature(inputStream2, imageLoadListener);
        }
        catch (IOException iOException) {
            throw new ImageStorageException(iOException.getMessage(), iOException);
        }
        ImageFrame[] imageFrameArray = null;
        if (imageLoader == null) {
            throw new ImageStorageException("No loader for image data");
        }
        imageFrameArray = ImageStorage.loadAll(imageLoader, d, d2, bl, f, bl2);
        return imageFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFrame[] loadAll(String string2, ImageLoadListener imageLoadListener, double d, double d2, boolean bl, float f, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray;
        block16: {
            if (string2 == null || string2.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            imageFrameArray = null;
            InputStream inputStream2 = null;
            ImageLoader imageLoader = null;
            try {
                float f2 = 1.0f;
                try {
                    if (f >= 1.5f) {
                        try {
                            String string3 = ImageTools.getScaledImageName(string2);
                            inputStream2 = ImageTools.createInputStream(string3);
                            f2 = 2.0f;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (inputStream2 == null) {
                        inputStream2 = ImageTools.createInputStream(string2);
                    }
                    imageLoader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(inputStream2) : ImageStorage.getLoaderBySignature(inputStream2, imageLoadListener);
                }
                catch (IOException iOException) {
                    throw new ImageStorageException(iOException.getMessage(), iOException);
                }
                if (imageLoader != null) {
                    imageFrameArray = ImageStorage.loadAll(imageLoader, d, d2, bl, f2, bl2);
                    break block16;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return imageFrameArray;
    }

    private static synchronized int getMaxSignatureLength() {
        if (maxSignatureLength < 0) {
            maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature2 : loaderFactoriesBySignature.keySet()) {
                int n = signature2.getLength();
                if (maxSignatureLength >= n) continue;
                maxSignatureLength = n;
            }
        }
        return maxSignatureLength;
    }

    private static ImageFrame[] loadAll(ImageLoader imageLoader, double d, double d2, boolean bl, float f, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray = null;
        ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
        int n = 0;
        ImageFrame imageFrame = null;
        int n2 = (int)Math.round(d * (double)f);
        int n3 = (int)Math.round(d2 * (double)f);
        while (true) {
            try {
                imageFrame = imageLoader.load(n++, n2, n3, bl, bl2);
            }
            catch (Exception exception) {
                if (n > 1) break;
                throw new ImageStorageException(exception.getMessage(), exception);
            }
            if (imageFrame == null) break;
            imageFrame.setPixelScale(f);
            arrayList.add(imageFrame);
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            imageFrameArray = new ImageFrame[n4];
            arrayList.toArray(imageFrameArray);
        }
        return imageFrameArray;
    }

    private static ImageLoader getLoaderBySignature(InputStream inputStream2, ImageLoadListener imageLoadListener) throws IOException {
        byte[] byArray = new byte[ImageStorage.getMaxSignatureLength()];
        ImageTools.readFully(inputStream2, byArray);
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> entry : loaderFactoriesBySignature.entrySet()) {
            if (!entry.getKey().matches(byArray)) continue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
            ImageLoader imageLoader = entry.getValue().createImageLoader(sequenceInputStream);
            if (imageLoadListener != null) {
                imageLoader.addListener(imageLoadListener);
            }
            return imageLoader;
        }
        return null;
    }

    private ImageStorage() {
    }

    static {
        isIOS = PlatformUtil.isIOS();
        loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
        loaderFactoriesBySignature = new HashMap(loaderFactories.length);
        for (int j = 0; j < loaderFactories.length; ++j) {
            ImageStorage.addImageLoaderFactory(loaderFactories[j]);
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

