/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.collection;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.collection.PdfCollectionField;
import com.itextpdf.text.pdf.collection.PdfCollectionSchema;
import java.util.Calendar;

public class PdfCollectionItem
extends PdfDictionary {
    PdfCollectionSchema schema;

    public PdfCollectionItem(PdfCollectionSchema schema) {
        super(PdfName.COLLECTIONITEM);
        this.schema = schema;
    }

    public void addItem(String key2, String value) {
        PdfName fieldname = new PdfName(key2);
        PdfCollectionField field2 = (PdfCollectionField)this.schema.get(fieldname);
        this.put(fieldname, field2.getValue(value));
    }

    public void addItem(String key2, PdfString value) {
        PdfName fieldname = new PdfName(key2);
        PdfCollectionField field2 = (PdfCollectionField)this.schema.get(fieldname);
        if (field2.fieldType == 0) {
            this.put(fieldname, value);
        }
    }

    public void addItem(String key2, PdfDate d) {
        PdfName fieldname = new PdfName(key2);
        PdfCollectionField field2 = (PdfCollectionField)this.schema.get(fieldname);
        if (field2.fieldType == 1) {
            this.put(fieldname, d);
        }
    }

    public void addItem(String key2, PdfNumber n) {
        PdfName fieldname = new PdfName(key2);
        PdfCollectionField field2 = (PdfCollectionField)this.schema.get(fieldname);
        if (field2.fieldType == 2) {
            this.put(fieldname, n);
        }
    }

    public void addItem(String key2, Calendar c) {
        this.addItem(key2, new PdfDate(c));
    }

    public void addItem(String key2, int i2) {
        this.addItem(key2, new PdfNumber(i2));
    }

    public void addItem(String key2, float f) {
        this.addItem(key2, new PdfNumber(f));
    }

    public void addItem(String key2, double d) {
        this.addItem(key2, new PdfNumber(d));
    }

    public void setPrefix(String key2, String prefix) {
        PdfName fieldname = new PdfName(key2);
        PdfObject o = this.get(fieldname);
        if (o == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.must.set.a.value.before.adding.a.prefix", new Object[0]));
        }
        PdfDictionary dict = new PdfDictionary(PdfName.COLLECTIONSUBITEM);
        dict.put(PdfName.D, o);
        dict.put(PdfName.P, new PdfString(prefix, "UnicodeBig"));
        this.put(fieldname, dict);
    }
}

