/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario;

import com.sun.javafx.tk.Toolkit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.util.Callback;

public class Settings {
    private final Map<String, String> settings = new HashMap<String, String>(5);
    private final CopyOnWriteArrayList<Callback<String, Void>> listeners = new CopyOnWriteArrayList();
    private static final Object SETTINGS_KEY = new StringBuilder("SettingsKey");

    private static synchronized Settings getInstance() {
        Map<Object, Object> map2 = Toolkit.getToolkit().getContextMap();
        Settings settings2 = (Settings)map2.get(SETTINGS_KEY);
        if (settings2 == null) {
            settings2 = new Settings();
            map2.put(SETTINGS_KEY, settings2);
        }
        return settings2;
    }

    public static void set(String string2, String string3) {
        Settings.getInstance().setImpl(string2, string3);
    }

    private void setImpl(String string2, String string3) {
        this.checkKeyArg(string2);
        this.settings.put(string2, string3);
        for (Callback<String, Void> callback : this.listeners) {
            callback.call((Object)string2);
        }
    }

    public static String get(String string2) {
        return Settings.getInstance().getImpl(string2);
    }

    private String getImpl(String string2) {
        this.checkKeyArg(string2);
        String string3 = this.settings.get(string2);
        if (string3 == null) {
            try {
                string3 = System.getProperty(string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string3;
    }

    public static boolean getBoolean(String string2) {
        return Settings.getInstance().getBooleanImpl(string2);
    }

    private boolean getBooleanImpl(String string2) {
        String string3 = this.getImpl(string2);
        return "true".equals(string3);
    }

    public static boolean getBoolean(String string2, boolean bl) {
        return Settings.getInstance().getBooleanImpl(string2, bl);
    }

    private boolean getBooleanImpl(String string2, boolean bl) {
        String string3 = this.getImpl(string2);
        boolean bl2 = bl;
        if (string3 != null) {
            if ("false".equals(string3)) {
                bl2 = false;
            } else if ("true".equals(string3)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static int getInt(String string2, int n) {
        return Settings.getInstance().getIntImpl(string2, n);
    }

    private int getIntImpl(String string2, int n) {
        String string3 = this.getImpl(string2);
        int n2 = n;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static void addPropertyChangeListener(Callback<String, Void> callback) {
        Settings.getInstance().addPropertyChangeListenerImpl(callback);
    }

    private void addPropertyChangeListenerImpl(Callback<String, Void> callback) {
        this.listeners.add(callback);
    }

    public static void removePropertyChangeListener(Callback<String, Void> callback) {
        Settings.getInstance().removePropertyChangeListenerImpl(callback);
    }

    private void removePropertyChangeListenerImpl(Callback<String, Void> callback) {
        this.listeners.remove(callback);
    }

    private void checkKeyArg(String string2) {
        if (null == string2 || "".equals(string2)) {
            throw new IllegalArgumentException("null key not allowed");
        }
    }

    private Settings() {
    }
}

